/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.x509;

import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.x509.Attribute;

public class X509Attribute
extends ASN1Encodable {
    Attribute attr;

    X509Attribute(ASN1Encodable at) {
        this.attr = Attribute.getInstance(at);
    }

    public X509Attribute(String oid, ASN1Encodable value) {
        this.attr = new Attribute(new DERObjectIdentifier(oid), new DERSet(value));
    }

    public X509Attribute(String oid, ASN1EncodableVector value) {
        this.attr = new Attribute(new DERObjectIdentifier(oid), new DERSet(value));
    }

    public String getOID() {
        return this.attr.getAttrType().getId();
    }

    public ASN1Encodable[] getValues() {
        ASN1Set s2 = this.attr.getAttrValues();
        ASN1Encodable[] values = new ASN1Encodable[s2.size()];
        for (int i = 0; i != s2.size(); ++i) {
            values[i] = (ASN1Encodable)s2.getObjectAt(i);
        }
        return values;
    }

    @Override
    public DERObject toASN1Object() {
        return this.attr.toASN1Object();
    }
}

