/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.pkcs.ContentInfo;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.pkcs.SignedData;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.crypto.CryptoException;

public class P7bUtil {
    public static ArrayList getCertChainByP7(byte[] in) throws CryptoException, IOException {
        ArrayList<byte[]> certList = new ArrayList<byte[]>();
        X509CertificateStructure[] certChain = P7bUtil.getCertChain(in);
        int chainLen = certChain.length;
        for (int i = 0; i < chainLen; ++i) {
            certList.add(certChain[i].getEncoded());
        }
        return certList;
    }

    public static X509CertificateStructure[] getCertChain(byte[] in) throws CryptoException {
        DERObject pkcs;
        DERInputStream din = new DERInputStream(new ByteArrayInputStream(in));
        X509CertificateStructure[] certs = null;
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new CryptoException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new CryptoException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance(pkcs);
        if (!content.getContentType().equals(PKCSObjectIdentifiers.signedData)) {
            throw new CryptoException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance(content.getContent());
        ASN1Set certSet = data.getCertificates();
        if (certSet != null) {
            certs = new X509CertificateStructure[certSet.size()];
            Enumeration ec = ASN1Set.getInstance(data.getCertificates()).getObjects();
            int i = 0;
            try {
                while (ec.hasMoreElements()) {
                    certs[i] = X509CertificateStructure.getInstance(ec.nextElement());
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        X509CertificateStructure[] resultSortCerts = P7bUtil.sortCertificates(certs);
        return resultSortCerts;
    }

    public static X509CertificateStructure[] sortCertificates(X509CertificateStructure[] certs) {
        int certLen = certs.length;
        X509CertificateStructure[] certsSort = new X509CertificateStructure[certLen];
        X509CertificateStructure rootCert = null;
        for (int i = 0; i < certLen; ++i) {
            X509Name issuerDN;
            X509CertificateStructure cert = certs[i];
            X509Name subjectDN = cert.getSubject();
            if (!subjectDN.equals(issuerDN = cert.getIssuer())) continue;
            rootCert = cert;
            certs[i] = null;
            break;
        }
        certsSort[certLen - 1] = rootCert;
        X509CertificateStructure markCert = rootCert;
        block1: for (int j = 0; j < certLen - 1; ++j) {
            X509Name markSubjectDN = markCert.getSubject();
            for (int h2 = 0; h2 < certLen; ++h2) {
                X509CertificateStructure tempCert;
                X509Name tempIssuerDN;
                if (certs[h2] == null || !markSubjectDN.equals(tempIssuerDN = (tempCert = certs[h2]).getIssuer())) continue;
                markCert = tempCert;
                certsSort[certLen - j - 2] = tempCert;
                continue block1;
            }
        }
        return certsSort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFile(String file_path) {
        BufferedInputStream bins = null;
        byte[] bfile = null;
        String path = file_path;
        try {
            bins = new BufferedInputStream(new FileInputStream(path), 1024);
            if (bins.available() > 0) {
                bfile = new byte[bins.available()];
                bins.read(bfile);
            }
            bins.close();
        }
        catch (IOException e) {
            bfile = null;
            e.printStackTrace();
        }
        finally {
            try {
                bins.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return bfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(byte[] bContent, String filePath) {
        FilterOutputStream bouts = null;
        try {
            bouts = new BufferedOutputStream(new FileOutputStream(filePath), 1024);
            bouts.write(bContent);
            bouts.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bouts.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] arg) {
        try {
            P7bUtil p7U = new P7bUtil();
            byte[] p7 = p7U.readFile("C:\\Users\\wct\\Desktop\\SCCA2.p7b");
            X509CertificateStructure[] certList = P7bUtil.getCertChain(p7);
            System.out.println(certList.length);
            for (int i = 0; i < certList.length; ++i) {
                System.out.println("######");
                System.out.println(certList[i].getEncoded());
            }
            ArrayList certArrayList = P7bUtil.getCertChainByP7(p7);
            int len = certArrayList.size();
            for (int j = 0; j < len; ++j) {
                System.out.println(((byte[])certArrayList.get(j)).length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

