/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.ocsp;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERNull;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.ocsp.CertID;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.jce.PrincipalUtil;
import xjyb.org.bjca.jce.X509Principal;
import xjyb.org.bjca.ocsp.OCSPException;

public class CertificateID {
    public static final String HASH_SHA1 = "1.3.14.3.2.26";
    private CertID id;

    public CertificateID(CertID id) {
        this.id = id;
    }

    public CertificateID(String hashAlgorithm, X509Certificate issuerCert, BigInteger number, String provider) throws OCSPException {
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm, provider);
            AlgorithmIdentifier hashAlg = new AlgorithmIdentifier(new DERObjectIdentifier(hashAlgorithm), new DERNull());
            X509Principal issuerName = PrincipalUtil.getSubjectX509Principal(issuerCert);
            digest.update(issuerName.getEncoded());
            DEROctetString issuerNameHash = new DEROctetString(digest.digest());
            PublicKey issuerKey = issuerCert.getPublicKey();
            ASN1InputStream aIn = new ASN1InputStream(issuerKey.getEncoded());
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(aIn.readObject());
            digest.update(info.getPublicKeyData().getBytes());
            DEROctetString issuerKeyHash = new DEROctetString(digest.digest());
            DERInteger serialNumber = new DERInteger(number);
            this.id = new CertID(hashAlg, issuerNameHash, issuerKeyHash, serialNumber);
        }
        catch (Exception e) {
            throw new OCSPException("problem creating ID: " + e, e);
        }
    }

    public CertificateID(String hashAlgorithm, X509Certificate issuerCert, BigInteger number) throws OCSPException {
        this(hashAlgorithm, issuerCert, number, "BC");
    }

    public String getHashAlgOID() {
        return this.id.getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getIssuerNameHash() {
        return this.id.getIssuerNameHash().getOctets();
    }

    public byte[] getIssuerKeyHash() {
        return this.id.getIssuerKeyHash().getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.id.getSerialNumber().getValue();
    }

    public CertID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CertificateID)) {
            return false;
        }
        CertificateID obj = (CertificateID)o;
        return this.id.getDERObject().equals(obj.id.getDERObject());
    }

    public int hashCode() {
        return this.id.getDERObject().hashCode();
    }
}

