/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.ocsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import xjyb.org.bjca.asn1.ASN1OutputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.ocsp.BasicOCSPResponse;
import xjyb.org.bjca.asn1.ocsp.ResponseData;
import xjyb.org.bjca.asn1.ocsp.SingleResponse;
import xjyb.org.bjca.asn1.x509.X509Extension;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.ocsp.OCSPException;
import xjyb.org.bjca.ocsp.OCSPUtil;
import xjyb.org.bjca.ocsp.RespData;
import xjyb.org.bjca.ocsp.RespID;
import xjyb.org.bjca.ocsp.SingleResp;

public class BasicOCSPResp
implements java.security.cert.X509Extension {
    BasicOCSPResponse resp;
    ResponseData data;
    X509Certificate[] chain = null;

    public BasicOCSPResp(BasicOCSPResponse resp) {
        this.resp = resp;
        this.data = resp.getTbsResponseData();
    }

    public byte[] getTBSResponseData() throws OCSPException {
        try {
            return this.resp.getTbsResponseData().getEncoded();
        }
        catch (IOException e) {
            throw new OCSPException("problem encoding tbsResponseData", e);
        }
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        try {
            return this.data.getProducedAt().getDate();
        }
        catch (ParseException e) {
            throw new IllegalStateException("ParseException:" + e.getMessage());
        }
    }

    public SingleResp[] getResponses() {
        ASN1Sequence s2 = this.data.getResponses();
        SingleResp[] rs = new SingleResp[s2.size()];
        for (int i = 0; i != rs.length; ++i) {
            rs[i] = new SingleResp(SingleResponse.getInstance(s2.getObjectAt(i)));
        }
        return rs;
    }

    public X509Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        Set extns = this.getCriticalExtensionOIDs();
        return extns != null && !extns.isEmpty();
    }

    private Set getExtensionOIDs(boolean critical) {
        HashSet<String> set = new HashSet<String>();
        X509Extensions extensions = this.getResponseExtensions();
        if (extensions != null) {
            Enumeration e = extensions.oids();
            while (e.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)e.nextElement();
                X509Extension ext = extensions.getExtension(oid);
                if (critical != ext.isCritical()) continue;
                set.add(oid.getId());
            }
        }
        return set;
    }

    public Set getCriticalExtensionOIDs() {
        return this.getExtensionOIDs(true);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.getExtensionOIDs(false);
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        X509Extension ext;
        X509Extensions exts = this.getResponseExtensions();
        if (exts != null && (ext = exts.getExtension(new DERObjectIdentifier(oid))) != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            try {
                dOut.writeObject(ext.getValue());
                return bOut.toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException("error encoding " + e.toString());
            }
        }
        return null;
    }

    public String getSignatureAlgName() {
        return OCSPUtil.getAlgorithmName(this.resp.getSignatureAlgorithm().getObjectId());
    }

    public String getSignatureAlgOID() {
        return this.resp.getSignatureAlgorithm().getObjectId().getId();
    }

    public RespData getResponseData() {
        return new RespData(this.resp.getTbsResponseData());
    }

    public byte[] getSignature() {
        return this.resp.getSignature().getBytes();
    }

    private List getCertList(String provider) throws OCSPException, NoSuchProviderException {
        CertificateFactory cf;
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            cf = CertificateFactory.getInstance("X.509", provider);
        }
        catch (CertificateException ex) {
            throw new OCSPException("can't get certificate factory.", ex);
        }
        ASN1Sequence s2 = this.resp.getCerts();
        if (s2 != null) {
            Enumeration e = s2.getObjects();
            while (e.hasMoreElements()) {
                try {
                    aOut.writeObject(e.nextElement());
                    certs.add(cf.generateCertificate(new ByteArrayInputStream(bOut.toByteArray())));
                }
                catch (IOException ex) {
                    throw new OCSPException("can't re-encode certificate!", ex);
                }
                catch (CertificateException ex) {
                    throw new OCSPException("can't re-encode certificate!", ex);
                }
                bOut.reset();
            }
        }
        return certs;
    }

    public X509Certificate[] getCerts(String provider) throws OCSPException, NoSuchProviderException {
        List certs = this.getCertList(provider);
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    public CertStore getCertificates(String type, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, OCSPException {
        try {
            return CertStore.getInstance(type, (CertStoreParameters)new CollectionCertStoreParameters(this.getCertList(provider)), provider);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new OCSPException("can't setup the CertStore", e);
        }
    }

    public boolean verify(PublicKey key, String sigProvider) throws OCSPException, NoSuchProviderException {
        try {
            Signature signature = Signature.getInstance(this.getSignatureAlgName(), sigProvider);
            signature.initVerify(key);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream(bOut);
            dOut.writeObject(this.resp.getTbsResponseData());
            signature.update(bOut.toByteArray());
            return signature.verify(this.getSignature());
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCSPException("exception processing sig: " + e, e);
        }
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        aOut.writeObject(this.resp);
        return bOut.toByteArray();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicOCSPResp)) {
            return false;
        }
        BasicOCSPResp r = (BasicOCSPResp)o;
        return this.resp.equals(r.resp);
    }

    public int hashCode() {
        return this.resp.hashCode();
    }
}

