/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import xjyb.org.bjca.asn1.nist.NISTObjectIdentifiers;
import xjyb.org.bjca.jce.provider.BouncyCastleProvider;
import xjyb.org.bjca.jce.provider.test.BaseBlockCipherTest;
import xjyb.org.bjca.util.encoders.Hex;

public class AESTest
extends BaseBlockCipherTest {
    static String[] cipherTests = new String[]{"128", "000102030405060708090a0b0c0d0e0f", "00112233445566778899aabbccddeeff", "69c4e0d86a7b0430d8cdb78070b4c55a", "192", "000102030405060708090a0b0c0d0e0f1011121314151617", "00112233445566778899aabbccddeeff", "dda97ca4864cdfe06eaf70a0ec0d7191", "256", "000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f", "00112233445566778899aabbccddeeff", "8ea2b7ca516745bfeafc49904b496089"};

    public AESTest() {
        super("AES");
    }

    private void test(int strength, byte[] keyBytes, byte[] input, byte[] output) throws Exception {
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        Cipher in = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/ECB/NoPadding", "BC");
        try {
            out.init(1, key);
        }
        catch (Exception e) {
            this.fail("AES failed initialisation - " + e.toString(), e);
        }
        try {
            in.init(2, key);
        }
        catch (Exception e) {
            this.fail("AES failed initialisation - " + e.toString(), e);
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        CipherOutputStream cOut = new CipherOutputStream(bOut, out);
        try {
            for (int i = 0; i != input.length / 2; ++i) {
                cOut.write(input[i]);
            }
            cOut.write(input, input.length / 2, input.length - input.length / 2);
            cOut.close();
        }
        catch (IOException e) {
            this.fail("AES failed encryption - " + e.toString(), e);
        }
        byte[] bytes = bOut.toByteArray();
        if (!this.areEqual(bytes, output)) {
            this.fail("AES failed encryption - expected " + new String(Hex.encode(output)) + " got " + new String(Hex.encode(bytes)));
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        CipherInputStream cIn = new CipherInputStream(bIn, in);
        try {
            DataInputStream dIn = new DataInputStream(cIn);
            bytes = new byte[input.length];
            for (int i = 0; i != input.length / 2; ++i) {
                bytes[i] = (byte)dIn.read();
            }
            dIn.readFully(bytes, input.length / 2, bytes.length - input.length / 2);
        }
        catch (Exception e) {
            this.fail("AES failed encryption - " + e.toString(), e);
        }
        if (!this.areEqual(bytes, input)) {
            this.fail("AES failed decryption - expected " + new String(Hex.encode(input)) + " got " + new String(Hex.encode(bytes)));
        }
    }

    private void eaxTest() throws Exception {
        byte[] K2 = Hex.decode("233952DEE4D5ED5F9B9C6D6FF80FF478");
        byte[] N = Hex.decode("62EC67F9C3A4A407FCB2A8C49031A8B3");
        byte[] P = Hex.decode("68656c6c6f20776f726c642121");
        byte[] C2 = Hex.decode("2f9f76cb7659c70e4be11670a3e193ae1bc6b5762a");
        SecretKeySpec key = new SecretKeySpec(K2, "AES");
        Cipher in = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/EAX/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in EAX");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in EAX");
        }
        try {
            in = Cipher.getInstance("AES/EAX/PKCS5Padding", "BC");
            this.fail("bad padding missed in EAX");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    private void ccmTest() throws Exception {
        byte[] K2 = Hex.decode("404142434445464748494a4b4c4d4e4f");
        byte[] N = Hex.decode("10111213141516");
        byte[] P = Hex.decode("68656c6c6f20776f726c642121");
        byte[] C2 = Hex.decode("39264f148b54c456035de0a531c8344f46db12b388");
        SecretKeySpec key = new SecretKeySpec(K2, "AES");
        Cipher in = Cipher.getInstance("AES/CCM/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/CCM/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in CCM");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in CCM");
        }
        try {
            in = Cipher.getInstance("AES/CCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in CCM");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    private void gcmTest() throws Exception {
        byte[] K2 = Hex.decode("feffe9928665731c6d6a8f9467308308feffe9928665731c6d6a8f9467308308");
        byte[] P = Hex.decode("d9313225f88406e5a55909c5aff5269a86a7a9531534f7da2e4c303d8a318a721c3c0c95956809532fcf0e2449a6b525b16aedf5aa0de657ba637b391aafd255");
        byte[] N = Hex.decode("cafebabefacedbaddecaf888");
        String T = "b094dac5d93471bdec1a502270e3cc6c";
        byte[] C2 = Hex.decode("522dc1f099567d07f47f37a32a84427d643a8cdcbfe5c0c97598a2bd2555d1aa8cb08e48590dbb3da7b08b1056828838c5f61e6393ba7a0abcc9f662898015ad" + T);
        SecretKeySpec key = new SecretKeySpec(K2, "AES");
        Cipher in = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        Cipher out = Cipher.getInstance("AES/GCM/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in GCM");
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in GCM");
        }
        try {
            in = Cipher.getInstance("AES/GCM/PKCS5Padding", "BC");
            this.fail("bad padding missed in GCM");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    @Override
    public void performTest() throws Exception {
        for (int i = 0; i != cipherTests.length; i += 4) {
            this.test(Integer.parseInt(cipherTests[i]), Hex.decode(cipherTests[i + 1]), Hex.decode(cipherTests[i + 2]), Hex.decode(cipherTests[i + 3]));
        }
        byte[] kek1 = Hex.decode("000102030405060708090a0b0c0d0e0f");
        byte[] in1 = Hex.decode("00112233445566778899aabbccddeeff");
        byte[] out1 = Hex.decode("1fa68b0a8112b447aef34bd8fb5a7b829d3e862371d2cfe5");
        this.wrapTest(1, "AESWrap", kek1, in1, out1);
        String[] oids = new String[]{NISTObjectIdentifiers.id_aes128_ECB.getId(), NISTObjectIdentifiers.id_aes128_CBC.getId(), NISTObjectIdentifiers.id_aes128_OFB.getId(), NISTObjectIdentifiers.id_aes128_CFB.getId(), NISTObjectIdentifiers.id_aes192_ECB.getId(), NISTObjectIdentifiers.id_aes192_CBC.getId(), NISTObjectIdentifiers.id_aes192_OFB.getId(), NISTObjectIdentifiers.id_aes192_CFB.getId(), NISTObjectIdentifiers.id_aes256_ECB.getId(), NISTObjectIdentifiers.id_aes256_CBC.getId(), NISTObjectIdentifiers.id_aes256_OFB.getId(), NISTObjectIdentifiers.id_aes256_CFB.getId()};
        String[] names = new String[]{"AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding", "AES/ECB/PKCS7Padding", "AES/CBC/PKCS7Padding", "AES/OFB/PKCS7Padding", "AES/CFB/PKCS7Padding"};
        this.oidTest(oids, names, 4);
        String[] wrapOids = new String[]{NISTObjectIdentifiers.id_aes128_wrap.getId(), NISTObjectIdentifiers.id_aes192_wrap.getId(), NISTObjectIdentifiers.id_aes256_wrap.getId()};
        this.wrapOidTest(wrapOids, "AESWrap");
        this.eaxTest();
        this.ccmTest();
        this.gcmTest();
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        AESTest.runTest(new AESTest());
    }
}

