/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;
import xjyb.org.bjca.asn1.cryptopro.CryptoProObjectIdentifiers;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPair;
import xjyb.org.bjca.crypto.generators.DHBasicKeyPairGenerator;
import xjyb.org.bjca.crypto.generators.DHParametersGenerator;
import xjyb.org.bjca.crypto.generators.DSAKeyPairGenerator;
import xjyb.org.bjca.crypto.generators.DSAParametersGenerator;
import xjyb.org.bjca.crypto.generators.ECKeyPairGenerator;
import xjyb.org.bjca.crypto.generators.ElGamalKeyPairGenerator;
import xjyb.org.bjca.crypto.generators.ElGamalParametersGenerator;
import xjyb.org.bjca.crypto.generators.GOST3410KeyPairGenerator;
import xjyb.org.bjca.crypto.generators.RSAKeyPairGenerator;
import xjyb.org.bjca.crypto.params.DHKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.DHParameters;
import xjyb.org.bjca.crypto.params.DHPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.DHPublicKeyParameters;
import xjyb.org.bjca.crypto.params.DSAKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.DSAParameters;
import xjyb.org.bjca.crypto.params.DSAPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.DSAPublicKeyParameters;
import xjyb.org.bjca.crypto.params.ECDomainParameters;
import xjyb.org.bjca.crypto.params.ECKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.ECPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ECPublicKeyParameters;
import xjyb.org.bjca.crypto.params.ElGamalKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.ElGamalParameters;
import xjyb.org.bjca.crypto.params.ElGamalPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ElGamalPublicKeyParameters;
import xjyb.org.bjca.crypto.params.GOST3410KeyGenerationParameters;
import xjyb.org.bjca.crypto.params.GOST3410Parameters;
import xjyb.org.bjca.crypto.params.GOST3410PrivateKeyParameters;
import xjyb.org.bjca.crypto.params.GOST3410PublicKeyParameters;
import xjyb.org.bjca.crypto.params.RSAKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.jce.ECNamedCurveTable;
import xjyb.org.bjca.jce.provider.JCEDHPrivateKey;
import xjyb.org.bjca.jce.provider.JCEDHPublicKey;
import xjyb.org.bjca.jce.provider.JCEECPrivateKey;
import xjyb.org.bjca.jce.provider.JCEECPublicKey;
import xjyb.org.bjca.jce.provider.JCEElGamalPrivateKey;
import xjyb.org.bjca.jce.provider.JCEElGamalPublicKey;
import xjyb.org.bjca.jce.provider.JCERSAPrivateCrtKey;
import xjyb.org.bjca.jce.provider.JCERSAPublicKey;
import xjyb.org.bjca.jce.provider.JDKDSAPrivateKey;
import xjyb.org.bjca.jce.provider.JDKDSAPublicKey;
import xjyb.org.bjca.jce.provider.JDKGOST3410PrivateKey;
import xjyb.org.bjca.jce.provider.JDKGOST3410PublicKey;
import xjyb.org.bjca.jce.provider.ProviderUtil;
import xjyb.org.bjca.jce.spec.ECParameterSpec;
import xjyb.org.bjca.jce.spec.ElGamalParameterSpec;
import xjyb.org.bjca.jce.spec.GOST3410ParameterSpec;
import xjyb.org.bjca.jce.spec.GOST3410PublicKeyParameterSetSpec;

public abstract class JDKKeyPairGenerator
extends KeyPairGenerator {
    public JDKKeyPairGenerator(String algorithmName) {
        super(algorithmName);
    }

    @Override
    public abstract void initialize(int var1, SecureRandom var2);

    @Override
    public abstract KeyPair generateKeyPair();

    public static class ECDHC
    extends EC {
        public ECDHC() {
            super("ECDHC");
        }
    }

    public static class ECDH
    extends EC {
        public ECDH() {
            super("ECDH");
        }
    }

    public static class ECGOST3410
    extends EC {
        public ECGOST3410() {
            super("ECGOST3410");
        }
    }

    public static class ECDSA
    extends EC {
        public ECDSA() {
            super("ECDSA");
        }
    }

    public static class EC
    extends JDKKeyPairGenerator {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        ECParameterSpec ecParams = null;
        int strength = 239;
        int certainty = 50;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;
        String algorithm;
        private static Hashtable ecParameters = new Hashtable();

        public EC() {
            super("EC");
            this.algorithm = "EC";
        }

        public EC(String algorithm) {
            super(algorithm);
            this.algorithm = algorithm;
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
            this.ecParams = (ECParameterSpec)ecParameters.get(new Integer(strength));
            if (this.ecParams != null) {
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (params == null && ProviderUtil.getEcImplicitlyCa() != null) {
                ECParameterSpec p = ProviderUtil.getEcImplicitlyCa();
                this.ecParams = null;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(p.getCurve(), p.getG(), p.getN()), random);
                this.engine.init(this.param);
                this.initialised = true;
            } else {
                if (params == null && ProviderUtil.getEcImplicitlyCa() == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed by no implicitCA set");
                }
                if (!(params instanceof ECParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("parameter object not a ECParameterSpec");
                }
                this.ecParams = (ECParameterSpec)params;
                this.param = new ECKeyGenerationParameters(new ECDomainParameters(this.ecParams.getCurve(), this.ecParams.getG(), this.ecParams.getN()), random);
                this.engine.init(this.param);
            }
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                throw new IllegalStateException("EC Key Pair Generator not initialised");
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ECPublicKeyParameters pub = (ECPublicKeyParameters)pair.getPublic();
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)pair.getPrivate();
            if (this.ecParams == null) {
                return new KeyPair(new JCEECPublicKey(this.algorithm, pub), new JCEECPrivateKey(this.algorithm, priv));
            }
            ECParameterSpec p = this.ecParams;
            return new KeyPair(new JCEECPublicKey(this.algorithm, pub, p), new JCEECPrivateKey(this.algorithm, priv, p));
        }

        static {
            ecParameters.put(new Integer(192), ECNamedCurveTable.getParameterSpec("prime192v1"));
            ecParameters.put(new Integer(239), ECNamedCurveTable.getParameterSpec("prime239v1"));
            ecParameters.put(new Integer(256), ECNamedCurveTable.getParameterSpec("prime256v1"));
        }
    }

    public static class ElGamal
    extends JDKKeyPairGenerator {
        ElGamalKeyGenerationParameters param;
        ElGamalKeyPairGenerator engine = new ElGamalKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public ElGamal() {
            super("ElGamal");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof ElGamalParameterSpec) && !(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec or an ElGamalParameterSpec");
            }
            if (params instanceof ElGamalParameterSpec) {
                ElGamalParameterSpec elParams = (ElGamalParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(elParams.getP(), elParams.getG()));
            } else {
                DHParameterSpec dhParams = (DHParameterSpec)params;
                this.param = new ElGamalKeyGenerationParameters(random, new ElGamalParameters(dhParams.getP(), dhParams.getG(), dhParams.getL()));
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                ElGamalParametersGenerator pGen = new ElGamalParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new ElGamalKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            ElGamalPublicKeyParameters pub = (ElGamalPublicKeyParameters)pair.getPublic();
            ElGamalPrivateKeyParameters priv = (ElGamalPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEElGamalPublicKey(pub), new JCEElGamalPrivateKey(priv));
        }
    }

    public static class GOST3410
    extends JDKKeyPairGenerator {
        GOST3410KeyGenerationParameters param;
        GOST3410KeyPairGenerator engine = new GOST3410KeyPairGenerator();
        GOST3410ParameterSpec gost3410Params;
        int strength = 1024;
        SecureRandom random = null;
        boolean initialised = false;

        public GOST3410() {
            super("GOST3410");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        private void init(GOST3410ParameterSpec gParams, SecureRandom random) {
            GOST3410PublicKeyParameterSetSpec spec = gParams.getPublicKeyParameters();
            this.param = new GOST3410KeyGenerationParameters(random, new GOST3410Parameters(spec.getP(), spec.getQ(), spec.getA()));
            this.engine.init(this.param);
            this.gost3410Params = gParams;
            this.initialised = true;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof GOST3410ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a GOST3410ParameterSpec");
            }
            this.init((GOST3410ParameterSpec)params, random);
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.init(new GOST3410ParameterSpec(CryptoProObjectIdentifiers.gostR3410_94_CryptoPro_A.getId()), new SecureRandom());
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            GOST3410PublicKeyParameters pub = (GOST3410PublicKeyParameters)pair.getPublic();
            GOST3410PrivateKeyParameters priv = (GOST3410PrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKGOST3410PublicKey(pub, this.gost3410Params), new JDKGOST3410PrivateKey(priv, this.gost3410Params));
        }
    }

    public static class DSA
    extends JDKKeyPairGenerator {
        DSAKeyGenerationParameters param;
        DSAKeyPairGenerator engine = new DSAKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DSA() {
            super("DSA");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            if (strength < 512 || strength > 1024 || strength % 64 != 0) {
                throw new IllegalArgumentException("strength must be from 512 - 1024 and a multiple of 64");
            }
            this.strength = strength;
            this.random = random;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DSAParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DSAParameterSpec");
            }
            DSAParameterSpec dsaParams = (DSAParameterSpec)params;
            this.param = new DSAKeyGenerationParameters(random, new DSAParameters(dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                DSAParametersGenerator pGen = new DSAParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new DSAKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DSAPublicKeyParameters pub = (DSAPublicKeyParameters)pair.getPublic();
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JDKDSAPublicKey(pub), new JDKDSAPrivateKey(priv));
        }
    }

    public static class DH
    extends JDKKeyPairGenerator {
        DHKeyGenerationParameters param;
        DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
        int strength = 1024;
        int certainty = 20;
        SecureRandom random = new SecureRandom();
        boolean initialised = false;

        public DH() {
            super("DH");
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.strength = strength;
            this.random = random;
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
            }
            DHParameterSpec dhParams = (DHParameterSpec)params;
            this.param = new DHKeyGenerationParameters(random, new DHParameters(dhParams.getP(), dhParams.getG(), null, dhParams.getL()));
            this.engine.init(this.param);
            this.initialised = true;
        }

        @Override
        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                DHParametersGenerator pGen = new DHParametersGenerator();
                pGen.init(this.strength, this.certainty, this.random);
                this.param = new DHKeyGenerationParameters(this.random, pGen.generateParameters());
                this.engine.init(this.param);
                this.initialised = true;
            }
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            DHPublicKeyParameters pub = (DHPublicKeyParameters)pair.getPublic();
            DHPrivateKeyParameters priv = (DHPrivateKeyParameters)pair.getPrivate();
            return new KeyPair(new JCEDHPublicKey(pub), new JCEDHPrivateKey(priv));
        }
    }

    public static class RSA
    extends JDKKeyPairGenerator {
        static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
        static final int defaultTests = 12;
        RSAKeyGenerationParameters param;
        RSAKeyPairGenerator engine = new RSAKeyPairGenerator();

        public RSA() {
            super("RSA");
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), 2048, 12);
            this.engine.init(this.param);
        }

        @Override
        public void initialize(int strength, SecureRandom random) {
            this.param = new RSAKeyGenerationParameters(defaultPublicExponent, random, strength, 12);
            this.engine.init(this.param);
        }

        @Override
        public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
            if (!(params instanceof RSAKeyGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameter object not a RSAKeyGenParameterSpec");
            }
            RSAKeyGenParameterSpec rsaParams = (RSAKeyGenParameterSpec)params;
            this.param = new RSAKeyGenerationParameters(rsaParams.getPublicExponent(), random, rsaParams.getKeysize(), 12);
            this.engine.init(this.param);
        }

        @Override
        public KeyPair generateKeyPair() {
            AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
            RSAKeyParameters pub = (RSAKeyParameters)pair.getPublic();
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)pair.getPrivate();
            return new KeyPair(new JCERSAPublicKey(pub), new JCERSAPrivateCrtKey(priv));
        }
    }
}

