/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce.fastparser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.sm4soft.util.ByteUtil;

public class DerUtil {
    public static boolean debug = false;
    public static final byte[] OID_PKCS7 = new byte[]{42, -122, 72, -122, -9, 13, 1, 7};
    public static final byte[] OID_Data = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 1};
    public static final byte[] OID_SignedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 2};
    public static final byte[] OID_EnvelopedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 3};
    public static final byte[] OID_SignedAndEnvelopedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 4};
    public static final byte[] OID_DigestedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 5};
    public static final byte[] OID_EncryptedData = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 6};
    public static final byte[] OID_TSTInfoData = new byte[]{42, -122, 72, -122, -9, 13, 1, 9, 16, 1, 4};

    public static int toInt(byte[] input, int start, int length) {
        int value = 0;
        for (int i = 0; i < length; ++i) {
            value *= 256;
            value += input[i + start] & 0xFF;
        }
        return value;
    }

    public static void computeOffset(byte[] input, Item item, int offset, int pos) {
        int size = 0;
        int length = 0;
        int noffset = 0;
        if (pos + offset > input.length - 2) {
            return;
        }
        byte first = input[pos + 1 + offset];
        byte preFirst = input[pos + offset];
        if (((preFirst & 0xFF) == 0 || (preFirst & 0xFF) == 5) && (first & 0xFF) == 0) {
            item.offset = 2 + pos;
            item.length = 0;
            item.tagsize = 2;
            return;
        }
        if ((preFirst & 0xFF) == 0 && (first & 0xFF) != 0) {
            noffset = 1;
        }
        if (((first = input[pos + 1 + offset + noffset]) & 0x80) == 128 || (first & 0xFF) == 0) {
            size = first & 0xF;
            length = size == 0 && (first & 0xFF) != 0 ? input.length - pos - 1 - noffset : DerUtil.toInt(input, 2 + pos + offset + noffset, size);
        } else {
            size = 0;
            length = first & 0xFF;
        }
        item.offset = 2 + size + pos + noffset;
        if (length < 0 || length > input.length - item.offset) {
            if (debug) {
                System.out.println("length error! length=" + length);
            }
            length = input.length - item.offset - noffset;
        }
        item.length = length;
        item.tagsize = 2 + size;
        if (debug) {
            System.out.println("@computeOffset offset=" + item.offset + " ,length=" + item.length + ",tagsize=" + item.tagsize);
        }
    }

    public static boolean isEqual(byte[] src, int srcstart, byte[] dst, int dststart, int length) {
        if (src.length < srcstart + length || dst.length < dststart + length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (src[i + srcstart] == dst[dststart + i]) continue;
            return false;
        }
        return true;
    }

    public static void parseSequence(byte[] input, int offset, int length, List list) {
        int position = 0;
        Item tmpitem = new Item();
        if (debug) {
            System.out.println("=========parseSequence============");
            DerUtil.printBytes(input, offset, length, 16);
            System.out.println("==================================");
        }
        while (position < input.length - offset && position < length) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position += tmpitem.tagsize + tmpitem.length;
            tmpitem.offset += offset;
            list.add(new Item(tmpitem));
            if (!debug) continue;
            System.out.println("Parsed sequence " + list.size());
            DerUtil.printItemAndTag(input, tmpitem);
        }
    }

    public static void parseSequence(byte[] input, Item it, List list) {
        int position = 0;
        Item tmpitem = new Item();
        if (debug) {
            System.out.println("=========parseSequence============");
            DerUtil.printBytes(input, it.offset, it.length, 16);
            System.out.println("==================================");
        }
        while (position < input.length - it.offset && position < it.length) {
            DerUtil.computeOffset(input, tmpitem, it.offset, position);
            position += tmpitem.tagsize + tmpitem.length;
            tmpitem.offset += it.offset;
            list.add(new Item(tmpitem));
            if (!debug) continue;
            System.out.println("Parsed sequence " + list.size());
            DerUtil.printItem(input, tmpitem);
        }
    }

    public static int getContentType(byte[] input, int offset, int length) {
        if (length == 10 && input[offset + length - 1] == 3) {
            return 3;
        }
        if (length == 10 && input[offset + length - 1] == 2) {
            return 2;
        }
        int code = DerUtil.getContentType(input, offset);
        return code;
    }

    public static int getContentType(byte[] input, int offset) {
        int code = 0;
        if (offset + OID_PKCS7.length > input.length - 2) {
            return code;
        }
        if (debug) {
            DerUtil.printBytes(input, offset, OID_PKCS7.length + 1, 16);
        }
        for (int i = 0; i < OID_PKCS7.length; ++i) {
            if (input[i + offset] == OID_PKCS7[i]) continue;
            return code;
        }
        code = input[OID_PKCS7.length + offset] & 0xF;
        return code;
    }

    public static boolean isTimeStampContent(byte[] input, int offset) {
        for (int i = 0; i < OID_TSTInfoData.length; ++i) {
            if (input[i + offset] == OID_TSTInfoData[i]) continue;
            return false;
        }
        return true;
    }

    public static String toDERObjectIdentifier(byte[] bytes, int offset, int length) {
        Item tmpitem = new Item();
        DerUtil.computeOffset(bytes, tmpitem, offset, 0);
        StringBuffer objId = new StringBuffer();
        long value = 0L;
        BigInteger bigValue = null;
        boolean first = true;
        for (int i = 0; i != tmpitem.length && i + offset + tmpitem.offset < bytes.length; ++i) {
            int tmpbyte = bytes[i + offset + tmpitem.offset] & 0xFF;
            if (value < 0x80000000000000L) {
                value = value * 128L + (long)(tmpbyte & 0x7F);
                if ((tmpbyte & 0x80) != 0) continue;
                if (first) {
                    switch ((int)value / 40) {
                        case 0: {
                            objId.append('0');
                            break;
                        }
                        case 1: {
                            objId.append('1');
                            value -= 40L;
                            break;
                        }
                        default: {
                            objId.append('2');
                            value -= 80L;
                        }
                    }
                    first = false;
                }
                objId.append('.');
                objId.append(value);
                value = 0L;
                continue;
            }
            if (bigValue == null) {
                bigValue = BigInteger.valueOf(value);
            }
            bigValue = bigValue.shiftLeft(7);
            bigValue = bigValue.or(BigInteger.valueOf(tmpbyte & 0x7F));
            if ((tmpbyte & 0x80) != 0) continue;
            objId.append('.');
            objId.append(bigValue);
            bigValue = null;
            value = 0L;
        }
        return objId.toString();
    }

    public static void printBytes(byte[] input, int start, int length, int radix) {
        for (int i = 0; start + i < input.length && i < length; ++i) {
            if ((i + 1) % 17 == 0) {
                System.out.println();
            }
            int b = input[start + i] & 0xFF;
        }
    }

    public static void printBytes(byte[] input) {
        DerUtil.printBytes(input, 0, input.length, 16);
    }

    public static void printItem(byte[] input, Item it) {
        if (it == null) {
            return;
        }
        DerUtil.printBytes(input, it.offset, it.length, 16);
    }

    public static void printItemAndTag(byte[] input, Item it) {
        DerUtil.printBytes(input, it.offset, it.length, 16);
    }

    public static DERObject getDerObject(byte[] input) throws IOException {
        ByteArrayInputStream bai = new ByteArrayInputStream(input);
        ASN1InputStream ains = new ASN1InputStream(bai);
        return ains.readObject();
    }

    public static byte[] copyByteArray(byte[] source, Item item) {
        if (item == null || item.length == 0) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length];
        System.arraycopy(source, item.offset, bs, 0, item.length);
        return bs;
    }

    public static byte[] getItemData(byte[] source, Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length];
        System.arraycopy(source, item.offset, bs, 0, item.length);
        return bs;
    }

    public static byte[] getItemDataAndTag(byte[] source, Item item) {
        if (item == null) {
            return new byte[0];
        }
        byte[] bs = new byte[item.length + item.tagsize];
        System.arraycopy(source, item.offset - item.tagsize, bs, 0, item.length + item.tagsize);
        return bs;
    }

    public static ArrayList getLengthDer(int length) {
        ArrayList<String> lengthList = new ArrayList<String>();
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            lengthList.add("" + (size | 0x80));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                lengthList.add("" + (length >> i));
            }
        } else {
            lengthList.add("" + length);
        }
        return lengthList;
    }

    public static byte[] encapDerAddLen(byte[] der, int length) {
        byte[] encapDer = null;
        if (length <= 0) {
            return der;
        }
        if (der != null && der.length > 0) {
            byte tag = der[0];
            int contentLen = 0;
            byte[] addLenByte = null;
            byte lenTag = der[1];
            int lengthLenFlag = lenTag & 0x80;
            if (lengthLenFlag > 0) {
                int lengthLen = lenTag & 0xF;
                byte[] lenActByte = new byte[lengthLen];
                System.arraycopy(der, 2, lenActByte, 0, lengthLen);
                contentLen = der.length - lengthLen - 2;
            } else {
                contentLen = der.length - 2;
            }
            if (length > 127) {
                byte[] addActLenByte = ByteUtil.int2bytes(length);
                int addLenByteLen = 0;
                for (int i = 0; i < addActLenByte.length; ++i) {
                    if (addActLenByte[i] == 0) continue;
                    addLenByteLen = 4 - i;
                    break;
                }
                addLenByte = new byte[addLenByteLen + 1];
                addLenByte[0] = (byte)(0x80 | 0xF & ByteUtil.int2bytes(addLenByteLen)[3]);
                System.arraycopy(ByteUtil.int2bytes(length), 4 - addLenByteLen, addLenByte, 1, addLenByteLen);
            } else {
                addLenByte = new byte[]{contentLen == 0 ? (byte)0 : ByteUtil.int2bytes(length)[3]};
            }
            byte[] content = new byte[contentLen];
            System.arraycopy(der, der.length - contentLen, content, 0, contentLen);
            encapDer = new byte[1 + addLenByte.length + content.length];
            encapDer[0] = tag;
            System.arraycopy(addLenByte, 0, encapDer, 1, addLenByte.length);
            System.arraycopy(content, 0, encapDer, addLenByte.length + 1, content.length);
        }
        return encapDer;
    }

    public static byte[] getDerLength(int length) {
        byte[] lenByte = null;
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            lenByte = new byte[size + 1];
            lenByte[0] = (byte)(size | 0x80);
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                lenByte[size - i / 8] = (byte)(length >> i);
            }
        } else {
            lenByte = new byte[]{(byte)length};
        }
        return lenByte;
    }

    public static byte[] getDerLength(long length) {
        byte[] lenByte = null;
        if (length > 127L) {
            int size = 1;
            long val = length;
            while ((val >>>= 8) != 0L) {
                ++size;
            }
            lenByte = new byte[size + 1];
            lenByte[0] = (byte)(size | 0x80);
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                lenByte[size - i / 8] = (byte)(length >> i);
            }
        } else {
            lenByte = new byte[]{(byte)length};
        }
        return lenByte;
    }

    public static byte[] writeDERObjToBytes(DEREncodable obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        dos.writeObject(obj);
        byte[] bDerObj = bos.toByteArray();
        bos.close();
        return bDerObj;
    }

    public static DERObject writeBytesToDERObj(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ASN1InputStream dis = new ASN1InputStream(bis);
        DERObject derObj = null;
        derObj = dis.readObject();
        return derObj;
    }
}

