/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROctetString_;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERSet;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.exception.AlgorithmNotFoundException;
import xjyb.org.bjca.jce.exception.CertificateNotMatchException;
import xjyb.org.bjca.jce.exception.DecryptDataException;
import xjyb.org.bjca.jce.exception.DecryptKeyException;
import xjyb.org.bjca.jce.exception.EncryptAlgException;
import xjyb.org.bjca.jce.exception.EncryptDataException;
import xjyb.org.bjca.jce.exception.EncryptKeyException;
import xjyb.org.bjca.jce.exception.WriteEnvDataException;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.EncryptedContentInfo;
import xjyb.org.bjca.jce.fastparser.FastPkcs7;
import xjyb.org.bjca.jce.fastparser.IssuerAndSerialNumber;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.RecipientInfo;
import xjyb.org.bjca.jce.fastparser.SignedAndEnvelopedData;
import xjyb.org.bjca.jce.fastparser.SignerInfo;
import xjyb.org.bjca.jce.interfaces.P11Interface;
import xjyb.org.bjca.sm4soft.crypto.SM4Crypto;

public class PKCS7SignedAndEnvelopedData
implements PKCSObjectIdentifiers {
    private final String OID_RSA_ECB_PKCS1PADDING = "1.2.840.113549.1.1.1";
    private final String ID_PKCS7_SIGNED_AND_ENVELOPE_DATA = "1.2.840.113549.1.7.4";
    private static final String OID_ENCRYPTCONTENT = "1.2.840.113549.1.7.1";
    private static final String ID_SHA1 = "1.3.14.3.2.26";
    private static final int IV_LENGTH = 8;
    private X509Certificate signCert;
    private Collection certs;
    private Collection crls;
    private Set digestalgos;
    private FastPkcs7 fxPKCS7 = new FastPkcs7();

    public byte[] encrypt_sm2(byte[] privateKeyByte, X509CertificateStructure[] signCerts, CRL[] crlList, byte[] inData, X509CertificateStructure reciveCert) throws Exception {
        try {
            WrapCard wCard;
            DERInteger version = new DERInteger(0);
            DERInteger recpientver = new DERInteger(0);
            xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(reciveCert.getIssuer(), reciveCert.getSerialNumber());
            AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.301.3"), null);
            SecureRandom rand = new SecureRandom();
            byte[] keyData = new byte[16];
            rand.nextBytes(keyData);
            Object c = null;
            byte[] encKey = null;
            try {
                WrapCard wCard2 = new WrapCard();
                encKey = wCard2.sm2Encrypt(reciveCert, keyData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new EncryptKeyException("enc key exception ," + ex.getMessage());
            }
            DEROctetString derEncKey = new DEROctetString(encKey);
            DERConstructedSequence recipientInfo = new DERConstructedSequence();
            recipientInfo.addObject(recpientver);
            recipientInfo.addObject(isAndSN);
            recipientInfo.addObject(derAlgEncKey);
            recipientInfo.addObject(derEncKey);
            DERSet recipientInfos = new DERSet(recipientInfo);
            DERObjectIdentifier contentType = new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1");
            byte[] iv = new byte[16];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(iv);
            DEROctetString sIV = new DEROctetString(iv);
            AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.104"), sIV);
            DERObject derParam = (DERObject)algID.getParameters();
            IvParameterSpec param = null;
            if (derParam != null) {
                param = new IvParameterSpec(((DEROctetString)derParam).getOctets());
            }
            SM4Crypto sm4C = new SM4Crypto();
            byte[] encdata = sm4C.encrypt_pkcs5(2, keyData, iv, inData);
            DEROctetString_ encContent = new DEROctetString_(encdata);
            DERConstructedSequence cont = new DERConstructedSequence();
            cont.addObject(contentType);
            cont.addObject(algID);
            cont.addObject(encContent);
            DERConstructedSet algos = new DERConstructedSet();
            AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.401.2"), null);
            algos.addObject(a);
            DERConstructedSet dercertificates = new DERConstructedSet();
            DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(signCerts[0].getEncoded()));
            dercertificates.addObject(tempstream.readObject());
            byte[] publicKey = null;
            byte[] id = null;
            X509CertificateStructure strucCert = signCerts[0];
            if (strucCert != null) {
                SubjectPublicKeyInfo spki = strucCert.getSubjectPublicKeyInfo();
                byte[] bPubKey = spki.getPublicKeyData().getBytes();
                publicKey = new byte[64];
                System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
                id = "1234567812345678".getBytes();
            }
            byte[] hashedData = null;
            try {
                wCard = new WrapCard();
                hashedData = wCard.sm3(inData, publicKey, id);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new EncryptKeyException("enc key exception ," + e.getMessage());
            }
            wCard = new WrapCard();
            byte[] signedbuff = wCard.sm2SignWithHashedData(hashedData, privateKeyByte);
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(1));
            byte[] bsIssuer = strucCert.getIssuer().getDEREncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAnds = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(issuer), strucCert.getSerialNumber());
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.401.2"), null));
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.301.1"), null));
            signerinfo.addObject(new DEROctetString(signedbuff));
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            DERConstructedSequence env = new DERConstructedSequence();
            env.addObject(version);
            env.addObject(recipientInfos);
            env.addObject(algos);
            env.addObject(cont);
            env.addObject(new DERTaggedObject(false, 0, dercertificates));
            env.addObject(signerinfos);
            String envdatatype = "1.2.156.10197.6.1.4.2.4";
            DERConstructedSequence p7 = new DERConstructedSequence();
            p7.addObject(new DERObjectIdentifier(envdatatype));
            DERTaggedObject dtCont = new DERTaggedObject(true, 0, env);
            p7.addObject(dtCont);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(baos);
            try {
                dout.writeObject(p7);
            }
            catch (IOException ex) {
                throw new WriteEnvDataException("write Envelop Data Error!");
            }
            byte[] bs = baos.toByteArray();
            try {
                baos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new EncryptKeyException("enc key exception ," + e.getMessage());
            }
            return bs;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EncryptKeyException("enc key exception ," + e.getMessage());
        }
    }

    public byte[] encrypt(PrivateKey privKey, Certificate[] signCerts, CRL[] crlList, byte[] inData, Certificate reciveCert, PublicKey pubk) throws Exception {
        try {
            DERInteger version = new DERInteger(1);
            DERInteger recpientver = new DERInteger(0);
            xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(((Object)((X509Certificate)reciveCert).getIssuerDN()).toString()), new DERInteger(((X509Certificate)reciveCert).getSerialNumber()));
            AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
            KeyGenerator kg2 = null;
            try {
                kg2 = KeyGenerator.getInstance("DESede");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new EncryptAlgException("AlgException");
            }
            SecretKey key = kg2.generateKey();
            byte[] keyData = key.getEncoded();
            Cipher c = null;
            byte[] encKey = null;
            try {
                c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                c.init(1, pubk);
                encKey = c.doFinal(keyData);
            }
            catch (Exception ex) {
                throw new EncryptKeyException("enc key exception");
            }
            DEROctetString derEncKey = new DEROctetString(encKey);
            DERConstructedSequence recipientInfo = new DERConstructedSequence();
            recipientInfo.addObject(recpientver);
            recipientInfo.addObject(isAndSN);
            recipientInfo.addObject(derAlgEncKey);
            recipientInfo.addObject(derEncKey);
            DERSet recipientInfos = new DERSet(recipientInfo);
            Signature oSign = Signature.getInstance("SHA1withRSA");
            oSign.initSign(privKey);
            oSign.update(inData);
            byte[] signedBuf = oSign.sign();
            AlgorithmIdentifier derAlg_bjca = PKCS7SignedAndEnvelopedData.getAlgorithmIdentifier_bjca(12);
            DERObject derParam = (DERObject)derAlg_bjca.getParameters();
            IvParameterSpec param = null;
            if (derParam != null) {
                DERConstructedSequence ds = (DERConstructedSequence)derParam;
                param = new IvParameterSpec(((DEROctetString)ds.getObjectAt(0)).getOctets());
            }
            byte[] encSignedBuf = null;
            try {
                c = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c.init(1, (Key)key, param);
                encSignedBuf = c.doFinal(signedBuf);
            }
            catch (Exception ex) {
                throw new EncryptDataException("encrypt data error");
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(1));
            this.signCert = (X509Certificate)signCerts[0];
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            this.signCert = (X509Certificate)signCerts[0];
            xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAnds = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(ID_SHA1), null));
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null));
            signerinfo.addObject(new DEROctetString(signedBuf));
            signerinfos.addObject(signerinfo);
            byte[] encInDataBuf = null;
            try {
                c = Cipher.getInstance("DESede/CBC/PKCS5Padding");
                c.init(1, (Key)key, param);
                encInDataBuf = c.doFinal(inData);
            }
            catch (Exception ex) {
                throw new EncryptDataException("encrypt data error");
            }
            DERConstructedSequence encryptedContentInfo = new DERConstructedSequence();
            DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
            DEROctetString_ encContent = new DEROctetString_(encInDataBuf);
            encryptedContentInfo.addObject(contentType);
            encryptedContentInfo.addObject(derAlg_bjca);
            encryptedContentInfo.addObject(encContent);
            DERConstructedSequence body = new DERConstructedSequence();
            this.digestalgos = new HashSet();
            this.digestalgos.add(ID_SHA1);
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            body.addObject(version);
            body.addObject(recipientInfos);
            body.addObject(algos);
            body.addObject(encryptedContentInfo);
            this.certs = new ArrayList();
            this.crls = new ArrayList();
            this.signCert = (X509Certificate)signCerts[0];
            for (int i2 = 0; i2 < signCerts.length; ++i2) {
                this.certs.add(signCerts[i2]);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i3 = this.certs.iterator();
            while (i3.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i3.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            body.addObject(new DERTaggedObject(false, 0, dercertificates));
            if (crlList != null) {
                for (int i4 = 0; i4 < crlList.length; ++i4) {
                    this.crls.add(crlList[i4]);
                }
            }
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.4"));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }

    public byte[] encrypt(P11Interface p11Impl, String m_keyType, String m_container, Certificate[] signCerts, CRL[] crlList, byte[] inData, Certificate reciveCert, PublicKey pubk) throws Exception {
        DERInteger version = new DERInteger(1);
        DERInteger recpientver = new DERInteger(0);
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAndSN = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(((Object)((X509Certificate)reciveCert).getIssuerDN()).toString()), new DERInteger(((X509Certificate)reciveCert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null);
        KeyGenerator kg2 = null;
        try {
            kg2 = KeyGenerator.getInstance("DESede");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new EncryptAlgException("AlgException");
        }
        SecretKey key = kg2.generateKey();
        byte[] keyData = key.getEncoded();
        Cipher c = null;
        byte[] encKey = null;
        try {
            c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c.init(1, pubk);
            encKey = c.doFinal(keyData);
        }
        catch (Exception ex) {
            throw new EncryptKeyException("enc key exception");
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject(recpientver);
        recipientInfo.addObject(isAndSN);
        recipientInfo.addObject(derAlgEncKey);
        recipientInfo.addObject(derEncKey);
        DERSet recipientInfos = new DERSet(recipientInfo);
        byte[] signedBuf = p11Impl.signByRsaSha1(inData, m_container, Integer.parseInt(m_keyType));
        AlgorithmIdentifier derAlg_bjca = PKCS7SignedAndEnvelopedData.getAlgorithmIdentifier_bjca(12);
        DERObject derParam = (DERObject)derAlg_bjca.getParameters();
        IvParameterSpec param = null;
        if (derParam != null) {
            DERConstructedSequence ds = (DERConstructedSequence)derParam;
            param = new IvParameterSpec(((DEROctetString)ds.getObjectAt(0)).getOctets());
        }
        byte[] encSignedBuf = null;
        try {
            c = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            c.init(1, (Key)key, param);
            encSignedBuf = c.doFinal(signedBuf);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DERConstructedSet signerinfos = new DERConstructedSet();
        DERConstructedSequence signerinfo = new DERConstructedSequence();
        signerinfo.addObject(new DERInteger(1));
        this.signCert = (X509Certificate)signCerts[0];
        byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
        ASN1InputStream ans = new ASN1InputStream(bsIssuer);
        ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
        this.signCert = (X509Certificate)signCerts[0];
        xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber isAnds = new xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
        signerinfo.addObject(isAnds);
        signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(ID_SHA1), null));
        signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.1.1"), null));
        signerinfo.addObject(new DEROctetString(signedBuf));
        signerinfos.addObject(signerinfo);
        byte[] encInDataBuf = null;
        try {
            c = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            c.init(1, (Key)key, param);
            encInDataBuf = c.doFinal(inData);
        }
        catch (Exception ex) {
            throw new EncryptDataException("encrypt data error");
        }
        DERConstructedSequence encryptedContentInfo = new DERConstructedSequence();
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        DEROctetString_ encContent = new DEROctetString_(encInDataBuf);
        encryptedContentInfo.addObject(contentType);
        encryptedContentInfo.addObject(derAlg_bjca);
        encryptedContentInfo.addObject(encContent);
        DERConstructedSequence body = new DERConstructedSequence();
        this.digestalgos = new HashSet();
        this.digestalgos.add(ID_SHA1);
        DERConstructedSet algos = new DERConstructedSet();
        Iterator i = this.digestalgos.iterator();
        while (i.hasNext()) {
            AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
            algos.addObject(a);
        }
        body.addObject(version);
        body.addObject(recipientInfos);
        body.addObject(algos);
        body.addObject(encryptedContentInfo);
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.signCert = (X509Certificate)signCerts[0];
        for (int i2 = 0; i2 < signCerts.length; ++i2) {
            this.certs.add(signCerts[i2]);
        }
        DERConstructedSet dercertificates = new DERConstructedSet();
        Iterator i3 = this.certs.iterator();
        while (i3.hasNext()) {
            DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i3.next()).getEncoded()));
            dercertificates.addObject(tempstream.readObject());
        }
        body.addObject(new DERTaggedObject(false, 0, dercertificates));
        if (crlList != null) {
            for (int i4 = 0; i4 < crlList.length; ++i4) {
                this.crls.add(crlList[i4]);
            }
        }
        body.addObject(signerinfos);
        DERConstructedSequence whole = new DERConstructedSequence();
        whole.addObject(new DERObjectIdentifier("1.2.840.113549.1.7.4"));
        whole.addObject(new DERTaggedObject(0, body));
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(bOut);
        dout.writeObject(whole);
        dout.close();
        return bOut.toByteArray();
    }

    public byte[] decrypt_sm2(byte[] inData, X509CertificateStructure cert, byte[] privateKey) throws Exception {
        Item tmpitem = new Item();
        int position = 0;
        DerUtil.computeOffset(inData, tmpitem, 0, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(inData, tmpitem, 0, position);
        position = tmpitem.offset + tmpitem.length;
        DerUtil.computeOffset(inData, tmpitem, 0, position);
        Item contents = new Item(tmpitem);
        SignedAndEnvelopedData sed = new SignedAndEnvelopedData(inData, contents);
        if (sed == null) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + this.fxPKCS7.getContentType());
        }
        Vector receivers = sed.getRecipientInfo();
        RecipientInfo receiver = (RecipientInfo)receivers.get(0);
        Item item = receiver.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(inData, item);
        item = iasn.getIssuer();
        byte[] bs = new byte[item.length];
        bs = DerUtil.getItemDataAndTag(inData, item);
        ASN1InputStream in = new ASN1InputStream(bs);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Item signerInfoItem = sed.getSignerInfos();
        SignerInfo si = new SignerInfo(inData, signerInfoItem.offset, signerInfoItem.length);
        Item issAndSNItem = si.getIssuerAndSerialNumber();
        IssuerAndSerialNumber issAndSn = new IssuerAndSerialNumber(inData, issAndSNItem);
        Item issuerItem = issAndSn.getIssuer();
        byte[] issuerByte = new byte[issuerItem.length];
        issuerByte = DerUtil.getItemDataAndTag(inData, issuerItem);
        ASN1InputStream asn1Input = new ASN1InputStream(issuerByte);
        String signerIssuer = "";
        try {
            DERObject signerObj = asn1Input.readObject();
            ASN1Sequence signerSeq = ASN1Sequence.getInstance(signerObj);
            X509Name signerIssuerName = new X509Name(signerSeq);
            signerIssuer = signerIssuerName.toString();
            asn1Input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String signerSN = issAndSn.getSerialNumber().getSerialNumber().toString();
        String sn = iasn.getSerialNumber().getSerialNumber().toString(16);
        String certSN = cert.getSerialNumber().toString();
        if (!certSN.equals(signerSN)) {
            throw new CertificateNotMatchException("Certificate is not match, Cert SN should be " + certSN + ",but now is " + signerSN);
        }
        byte[] encKey = receiver.getEncKey();
        EncryptedContentInfo eci = sed.getEncryptedContentInfo();
        item = eci.getContentEncryptionAlgorithm();
        item = eci.getIvParameter();
        bs = DerUtil.getItemDataAndTag(inData, item);
        byte[] tmpIV = new byte[16];
        if (bs.length != 0 && (bs[0] != 5 || bs[1] != 0)) {
            System.arraycopy(bs, 2, tmpIV, 0, tmpIV.length);
        }
        item = eci.getEncryptedContent();
        byte[] encdata = new byte[item.length];
        System.arraycopy(inData, item.offset, encdata, 0, encdata.length);
        byte[] key = null;
        try {
            WrapCard wCard = new WrapCard();
            key = wCard.sm2Decrypt(privateKey, encKey);
        }
        catch (Exception ex) {
            throw new DecryptKeyException(ex.getMessage());
        }
        byte[] out = null;
        try {
            SM4Crypto sm4C = new SM4Crypto();
            out = sm4C.decrypt_pkcs5(2, key, tmpIV, encdata);
        }
        catch (Exception ex) {
            throw new DecryptDataException(ex.getMessage());
        }
        return out;
    }

    public byte[] decrypt_sm2ForJit(byte[] inData, X509CertificateStructure cert, byte[] privateKey) throws Exception {
        Item tmpitem = new Item();
        int position = 0;
        DerUtil.computeOffset(inData, tmpitem, 0, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(inData, tmpitem, 0, position);
        position = tmpitem.offset + tmpitem.length;
        DerUtil.computeOffset(inData, tmpitem, 0, position);
        Item contents = new Item(tmpitem);
        SignedAndEnvelopedData sed = new SignedAndEnvelopedData(inData, contents);
        if (sed == null) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + this.fxPKCS7.getContentType());
        }
        Vector receivers = sed.getRecipientInfo();
        RecipientInfo receiver = (RecipientInfo)receivers.get(0);
        Item item = receiver.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(inData, item);
        item = iasn.getIssuer();
        byte[] bs = new byte[item.length];
        bs = DerUtil.getItemDataAndTag(inData, item);
        ASN1InputStream in = new ASN1InputStream(bs);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString(10);
        String certSN = cert.getSerialNumber().toString();
        byte[] encKey = receiver.getEncKey();
        EncryptedContentInfo eci = sed.getEncryptedContentInfo();
        item = eci.getContentEncryptionAlgorithm();
        item = eci.getIvParameter();
        bs = DerUtil.getItemDataAndTag(inData, item);
        byte[] tmpIV = new byte[16];
        if (bs.length != 0 && (bs[0] != 5 || bs[1] != 0)) {
            System.arraycopy(bs, 2, tmpIV, 0, tmpIV.length);
        }
        item = eci.getEncryptedContent();
        byte[] encdata = new byte[item.length];
        System.arraycopy(inData, item.offset, encdata, 0, encdata.length);
        byte[] key = null;
        try {
            WrapCard wCard = new WrapCard();
            key = wCard.sm2Decrypt(privateKey, encKey);
        }
        catch (Exception ex) {
            throw new DecryptKeyException(ex.getMessage());
        }
        byte[] out = null;
        try {
            SM4Crypto sm4C = new SM4Crypto();
            out = sm4C.decrypt_pkcs5_forJit(1, key, tmpIV, encdata);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DecryptDataException(ex.getMessage());
        }
        return out;
    }

    public byte[] decrypt(byte[] inData, Certificate cert, PrivateKey prik) throws Exception {
        if (!this.fxPKCS7.pkcs7Data(inData)) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        SignedAndEnvelopedData sed = this.fxPKCS7.getSignedAndEnvelopedData();
        Vector receivers = sed.getRecipientInfo();
        RecipientInfo receiver = (RecipientInfo)receivers.get(0);
        Item receiverItem = receiver.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(inData, receiverItem);
        receiverItem = iasn.getIssuer();
        byte[] receiverIssuer = new byte[receiverItem.length];
        receiverIssuer = DerUtil.getItemDataAndTag(inData, receiverItem);
        ASN1InputStream in = new ASN1InputStream(receiverIssuer);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString(16);
        String certIssuer = ((Object)((X509Certificate)cert).getIssuerDN()).toString();
        String certSN = ((X509Certificate)cert).getSerialNumber().toString(16);
        byte[] encKey = receiver.getEncKey();
        byte[] key = null;
        try {
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            c.init(2, prik);
            key = c.doFinal(encKey);
        }
        catch (Exception ex) {
            throw new DecryptKeyException(ex.getMessage());
        }
        EncryptedContentInfo encConInfo = sed.getEncryptedContentInfo();
        Item algorithmItem = encConInfo.getContentEncryptionAlgorithm();
        byte[] algorithmByte = new byte[algorithmItem.length];
        System.arraycopy(inData, algorithmItem.offset, algorithmByte, 0, algorithmByte.length);
        in = new ASN1InputStream(algorithmByte);
        String algName = "";
        try {
            AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance(in.readObject());
            String algoid = alg.getObjectId().getId();
            algName = PKCS7SignedAndEnvelopedData.getAlgorithmNameByOid(algoid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Item ivItem = encConInfo.getIvParameter();
        byte[] bs = DerUtil.getItemDataAndTag(inData, ivItem);
        IvParameterSpec param = null;
        if (bs.length != 0 && (bs[2] != 5 || bs[3] != 0)) {
            byte[] tmp = new byte[bs[3]];
            System.arraycopy(bs, 4, tmp, 0, tmp.length);
            param = new IvParameterSpec(tmp);
        }
        Item encConInfoItem = encConInfo.getEncryptedContent();
        byte[] encdata = new byte[encConInfoItem.length];
        System.arraycopy(inData, encConInfoItem.offset, encdata, 0, encdata.length);
        byte[] out = null;
        try {
            Cipher cd2 = Cipher.getInstance(algName);
            SecretKeySpec sk = new SecretKeySpec(key, PKCS7SignedAndEnvelopedData.getAlgorithmFromAllName(algName));
            cd2.init(2, (Key)sk, param);
            out = cd2.doFinal(encdata);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DecryptDataException(ex.getMessage());
        }
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(out);
        byte[] digest = md.digest();
        Item certItem = sed.getCertificates();
        ArrayList certs = new ArrayList();
        DerUtil.parseSequence(inData, certItem, certs);
        Item signerCertItem = (Item)certs.get(0);
        byte[] certByte = new byte[signerCertItem.length];
        System.arraycopy(inData, signerCertItem.offset, certByte, 0, signerCertItem.length);
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(certByte);
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        String issuerName = oCert.getIssuerDN().getName();
        String serialNum = oCert.getSerialNumber().toString(16);
        Item crlItem = sed.getCrls();
        Item signerInfoItem = sed.getSignerInfos();
        SignerInfo si = new SignerInfo(inData, signerInfoItem.offset, signerInfoItem.length);
        Item issAndSNItem = si.getIssuerAndSerialNumber();
        IssuerAndSerialNumber issAndSn = new IssuerAndSerialNumber(inData, issAndSNItem);
        Item issuerItem = issAndSn.getIssuer();
        byte[] issuerByte = new byte[issuerItem.length];
        issuerByte = DerUtil.getItemDataAndTag(inData, issuerItem);
        ASN1InputStream asn1Input = new ASN1InputStream(issuerByte);
        String signerIssuer = "";
        try {
            DERObject signerObj = asn1Input.readObject();
            ASN1Sequence signerSeq = ASN1Sequence.getInstance(signerObj);
            X509Name signerIssuerName = new X509Name(signerSeq);
            signerIssuer = signerIssuerName.toString();
            asn1Input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String signerSN = issAndSn.getSerialNumber().getSerialNumber().toString(16);
        if (!signerSN.equals(serialNum) || !signerSN.equals(certSN)) {
            out = null;
            throw new CertificateNotMatchException("signer's Certificate is not match");
        }
        Item digestAlgorithmItem = si.getDigestAlgorithm();
        String digestAlgorithm = DerUtil.toDERObjectIdentifier(inData, digestAlgorithmItem.offset, digestAlgorithmItem.length);
        Item digestEncryAlgorithmItem = si.getDigestEncryptionAlgorithm();
        String digestEncryptionAlgorithm = DerUtil.toDERObjectIdentifier(inData, digestEncryAlgorithmItem.offset, digestEncryAlgorithmItem.length);
        Item digestItem = si.getEncryptedDigest();
        byte[] signedDigest = new byte[digestItem.length];
        System.arraycopy(inData, digestItem.offset, signedDigest, 0, digestItem.length);
        if ("SHA1".equals(PKCS7SignedAndEnvelopedData.getAlgorithmNameByOid(digestAlgorithm)) && "RSA".equals(PKCS7SignedAndEnvelopedData.getAlgorithmNameByOid(digestEncryptionAlgorithm))) {
            Signature oSign = Signature.getInstance("SHA1withRSA");
            oSign.initVerify(oCert);
            oSign.update(out);
            boolean isSigner = oSign.verify(signedDigest);
            if (!isSigner) {
                throw new Exception("signer's Certificate is not right !");
            }
        }
        return out;
    }

    public byte[] decrypt(byte[] inData, Certificate cert, P11Interface p11Impl, String m_keyType, String m_container) throws Exception {
        if (!this.fxPKCS7.pkcs7Data(inData)) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        SignedAndEnvelopedData sed = this.fxPKCS7.getSignedAndEnvelopedData();
        Vector receivers = sed.getRecipientInfo();
        RecipientInfo receiver = (RecipientInfo)receivers.get(0);
        Item receiverItem = receiver.getIssuerAndSerialNumber();
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(inData, receiverItem);
        receiverItem = iasn.getIssuer();
        byte[] receiverIssuer = new byte[receiverItem.length];
        receiverIssuer = DerUtil.getItemDataAndTag(inData, receiverItem);
        ASN1InputStream in = new ASN1InputStream(receiverIssuer);
        String issuer = "";
        try {
            DERObject obj = in.readObject();
            ASN1Sequence seq = ASN1Sequence.getInstance(obj);
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString(16);
        String certIssuer = ((Object)((X509Certificate)cert).getIssuerDN()).toString();
        String certSN = ((X509Certificate)cert).getSerialNumber().toString(16);
        if (!certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certification is not match");
        }
        byte[] encKey = receiver.getEncKey();
        byte[] key = null;
        key = p11Impl.priKeyDecryptByRsa(m_container, Integer.parseInt(m_keyType), encKey);
        EncryptedContentInfo encConInfo = sed.getEncryptedContentInfo();
        Item algorithmItem = encConInfo.getContentEncryptionAlgorithm();
        byte[] algorithmByte = new byte[algorithmItem.length];
        System.arraycopy(inData, algorithmItem.offset, algorithmByte, 0, algorithmByte.length);
        in = new ASN1InputStream(algorithmByte);
        String algName = "";
        try {
            AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance(in.readObject());
            String algoid = alg.getObjectId().getId();
            algName = PKCS7SignedAndEnvelopedData.getAlgorithmNameByOid(algoid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Item ivItem = encConInfo.getIvParameter();
        byte[] bs = DerUtil.getItemDataAndTag(inData, ivItem);
        IvParameterSpec param = null;
        if (bs.length != 0 && (bs[2] != 5 || bs[3] != 0)) {
            byte[] tmp = new byte[bs[3]];
            System.arraycopy(bs, 4, tmp, 0, tmp.length);
            param = new IvParameterSpec(tmp);
        }
        Item encConInfoItem = encConInfo.getEncryptedContent();
        byte[] encdata = new byte[encConInfoItem.length];
        System.arraycopy(inData, encConInfoItem.offset, encdata, 0, encdata.length);
        byte[] out = null;
        try {
            Cipher cd2 = Cipher.getInstance(algName);
            SecretKeySpec sk = new SecretKeySpec(key, PKCS7SignedAndEnvelopedData.getAlgorithmFromAllName(algName));
            cd2.init(2, (Key)sk, param);
            out = cd2.doFinal(encdata);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DecryptDataException(ex.getMessage());
        }
        MessageDigest md = MessageDigest.getInstance("SHA1");
        md.update(out);
        byte[] digest = md.digest();
        Item certItem = sed.getCertificates();
        ArrayList certs = new ArrayList();
        DerUtil.parseSequence(inData, certItem, certs);
        Item signerCertItem = (Item)certs.get(0);
        byte[] certByte = new byte[signerCertItem.length];
        System.arraycopy(inData, signerCertItem.offset, certByte, 0, signerCertItem.length);
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(certByte);
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        String issuerName = oCert.getIssuerDN().getName();
        String serialNum = oCert.getSerialNumber().toString(16);
        Item crlItem = sed.getCrls();
        Item signerInfoItem = sed.getSignerInfos();
        SignerInfo si = new SignerInfo(inData, signerInfoItem.offset, signerInfoItem.length);
        Item issAndSNItem = si.getIssuerAndSerialNumber();
        IssuerAndSerialNumber issAndSn = new IssuerAndSerialNumber(inData, issAndSNItem);
        Item issuerItem = issAndSn.getIssuer();
        byte[] issuerByte = new byte[issuerItem.length];
        issuerByte = DerUtil.getItemDataAndTag(inData, issuerItem);
        ASN1InputStream asn1Input = new ASN1InputStream(issuerByte);
        String signerIssuer = "";
        try {
            DERObject signerObj = asn1Input.readObject();
            ASN1Sequence signerSeq = ASN1Sequence.getInstance(signerObj);
            X509Name signerIssuerName = new X509Name(signerSeq);
            signerIssuer = signerIssuerName.toString();
            asn1Input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String signerSN = issAndSn.getSerialNumber().getSerialNumber().toString(16);
        if (!signerSN.equals(serialNum)) {
            out = null;
            throw new CertificateNotMatchException("signer's Certificate is not match");
        }
        Item digestAlgorithmItem = si.getDigestAlgorithm();
        String digestAlgorithm = DerUtil.toDERObjectIdentifier(inData, digestAlgorithmItem.offset, digestAlgorithmItem.length);
        Item digestEncryAlgorithmItem = si.getDigestEncryptionAlgorithm();
        String digestEncryptionAlgorithm = DerUtil.toDERObjectIdentifier(inData, digestEncryAlgorithmItem.offset, digestEncryAlgorithmItem.length);
        Item digestItem = si.getEncryptedDigest();
        byte[] signedDigest = new byte[digestItem.length];
        System.arraycopy(inData, digestItem.offset, signedDigest, 0, digestItem.length);
        if ("SHA1".equals(PKCS7SignedAndEnvelopedData.getAlgorithmNameByOid(digestAlgorithm)) && "RSA".equals(PKCS7SignedAndEnvelopedData.getAlgorithmNameByOid(digestEncryptionAlgorithm))) {
            Signature oSign = Signature.getInstance("SHA1withRSA");
            oSign.initVerify(oCert);
            oSign.update(out);
            boolean isSigner = oSign.verify(signedDigest);
            if (!isSigner) {
                throw new Exception("signer's Certificate is not right !");
            }
        }
        return out;
    }

    private static String getAlgorithmNameByOid(String oid) throws AlgorithmNotFoundException {
        if ((oid = oid.trim()).equals("1.2.840.113549.3.7")) {
            return "DESede/CBC/PKCS5Padding";
        }
        if (oid.equals("1.3.14.3.2.7")) {
            return "DES/CBC/PKCS5Padding";
        }
        if (oid.equals(ID_SHA1)) {
            return "SHA1";
        }
        if (oid.equals("1.2.840.113549.1.1.1")) {
            return "RSA";
        }
        throw new AlgorithmNotFoundException("\u6682\u65f6\u4e0d\u652f\u6301\u6b64\u79cd\u7b97\u6cd5 oid: " + oid);
    }

    private static AlgorithmIdentifier getAlgorithmIdentifier_bjca(int alg) {
        String oid = null;
        boolean hasIV = false;
        if (alg == 10) {
            oid = "1.2.840.113549.3.4";
            hasIV = false;
        } else if (alg == 13) {
            oid = "1.2.840.113549.3.2";
            hasIV = true;
        } else if (alg == 12) {
            oid = "1.2.840.113549.3.7";
            hasIV = true;
        } else if (alg == 11) {
            oid = "1.3.14.3.2.7";
            hasIV = true;
        } else if (alg == 14) {
            oid = "2.16.840.1.101.3.4.2";
            hasIV = true;
        }
        DEROctetString sIV = null;
        if (hasIV) {
            byte[] iv = new byte[8];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(iv);
            sIV = new DEROctetString(iv);
        }
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject(sIV);
        AlgorithmIdentifier algID = new AlgorithmIdentifier(new DERObjectIdentifier(oid), cont);
        return algID;
    }

    private static String getAlgorithmFromAllName(String allName) {
        int i = allName.indexOf("/");
        String algName = allName.substring(0, i);
        return algName;
    }
}

