/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import xjyb.org.bjca.asn1.x509.RSAPublicKeyStructure;
import xjyb.org.bjca.crypto.InvalidCipherTextException;
import xjyb.org.bjca.crypto.encodings.PKCS1Encoding;
import xjyb.org.bjca.crypto.engines.RSABlindedEngine;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.prng.ThreadedSeedGenerator;
import xjyb.org.bjca.crypto.tls.ByteQueue;
import xjyb.org.bjca.crypto.tls.Certificate;
import xjyb.org.bjca.crypto.tls.CertificateVerifyer;
import xjyb.org.bjca.crypto.tls.CombinedHash;
import xjyb.org.bjca.crypto.tls.RecordStream;
import xjyb.org.bjca.crypto.tls.TlsCipherSuite;
import xjyb.org.bjca.crypto.tls.TlsCipherSuiteManager;
import xjyb.org.bjca.crypto.tls.TlsInputStream;
import xjyb.org.bjca.crypto.tls.TlsOuputStream;
import xjyb.org.bjca.crypto.tls.TlsUtils;
import xjyb.org.bjca.util.BigIntegers;

public class TlsProtocolHandler {
    private static final short RL_CHANGE_CIPHER_SPEC = 20;
    private static final short RL_ALERT = 21;
    private static final short RL_HANDSHAKE = 22;
    private static final short RL_APPLICATION_DATA = 23;
    private static final short HP_HELLO_REQUEST = 0;
    private static final short HP_CLIENT_HELLO = 1;
    private static final short HP_SERVER_HELLO = 2;
    private static final short HP_CERTIFICATE = 11;
    private static final short HP_SERVER_KEY_EXCHANGE = 12;
    private static final short HP_CERTIFICATE_REQUEST = 13;
    private static final short HP_SERVER_HELLO_DONE = 14;
    private static final short HP_CERTIFICATE_VERIFY = 15;
    private static final short HP_CLIENT_KEY_EXCHANGE = 16;
    private static final short HP_FINISHED = 20;
    private static final short CS_CLIENT_HELLO_SEND = 1;
    private static final short CS_SERVER_HELLO_RECEIVED = 2;
    private static final short CS_SERVER_CERTIFICATE_RECEIVED = 3;
    private static final short CS_SERVER_KEY_EXCHANGE_RECEIVED = 4;
    private static final short CS_CERTIFICATE_REQUEST_RECEIVED = 5;
    private static final short CS_SERVER_HELLO_DONE_RECEIVED = 6;
    private static final short CS_CLIENT_KEY_EXCHANGE_SEND = 7;
    private static final short CS_CLIENT_CHANGE_CIPHER_SPEC_SEND = 8;
    private static final short CS_CLIENT_FINISHED_SEND = 9;
    private static final short CS_SERVER_CHANGE_CIPHER_SPEC_RECEIVED = 10;
    private static final short CS_DONE = 11;
    protected static final short AP_close_notify = 0;
    protected static final short AP_unexpected_message = 10;
    protected static final short AP_bad_record_mac = 20;
    protected static final short AP_decryption_failed = 21;
    protected static final short AP_record_overflow = 22;
    protected static final short AP_decompression_failure = 30;
    protected static final short AP_handshake_failure = 40;
    protected static final short AP_bad_certificate = 42;
    protected static final short AP_unsupported_certificate = 43;
    protected static final short AP_certificate_revoked = 44;
    protected static final short AP_certificate_expired = 45;
    protected static final short AP_certificate_unknown = 46;
    protected static final short AP_illegal_parameter = 47;
    protected static final short AP_unknown_ca = 48;
    protected static final short AP_access_denied = 49;
    protected static final short AP_decode_error = 50;
    protected static final short AP_decrypt_error = 51;
    protected static final short AP_export_restriction = 60;
    protected static final short AP_protocol_version = 70;
    protected static final short AP_insufficient_security = 71;
    protected static final short AP_internal_error = 80;
    protected static final short AP_user_canceled = 90;
    protected static final short AP_no_renegotiation = 100;
    protected static final short AL_warning = 1;
    protected static final short AL_fatal = 2;
    private static final byte[] emptybuf = new byte[0];
    private static final String TLS_ERROR_MESSAGE = "Internal TLS error, this could be an attack";
    private ByteQueue applicationDataQueue = new ByteQueue();
    private ByteQueue changeCipherSpecQueue = new ByteQueue();
    private ByteQueue alertQueue = new ByteQueue();
    private ByteQueue handshakeQueue = new ByteQueue();
    private RecordStream rs;
    private SecureRandom random;
    private RSAKeyParameters serverRsaKey = null;
    private TlsInputStream tlsInputStream = null;
    private TlsOuputStream tlsOutputStream = null;
    private boolean closed = false;
    private boolean failedWithError = false;
    private boolean appDataReady = false;
    private byte[] clientRandom;
    private byte[] serverRandom;
    private byte[] ms;
    private TlsCipherSuite chosenCipherSuite = null;
    private BigInteger Yc;
    private byte[] pms;
    private CertificateVerifyer verifyer = null;
    private short connection_state;

    public TlsProtocolHandler(InputStream is, OutputStream os) {
        ThreadedSeedGenerator tsg = new ThreadedSeedGenerator();
        this.random = new SecureRandom();
        this.random.setSeed(tsg.generateSeed(20, true));
        this.rs = new RecordStream(this, is, os);
    }

    public TlsProtocolHandler(InputStream is, OutputStream os, SecureRandom sr) {
        this.random = sr;
        this.rs = new RecordStream(this, is, os);
    }

    protected void processData(short protocol, byte[] buf, int offset, int len) throws IOException {
        switch (protocol) {
            case 20: {
                this.changeCipherSpecQueue.addData(buf, offset, len);
                this.processChangeCipherSpec();
                break;
            }
            case 21: {
                this.alertQueue.addData(buf, offset, len);
                this.processAlert();
                break;
            }
            case 22: {
                this.handshakeQueue.addData(buf, offset, len);
                this.processHandshake();
                break;
            }
            case 23: {
                if (!this.appDataReady) {
                    this.failWithError((short)2, (short)10);
                }
                this.applicationDataQueue.addData(buf, offset, len);
                this.processApplicationData();
                break;
            }
        }
    }

    private void processHandshake() throws IOException {
        boolean read;
        do {
            read = false;
            if (this.handshakeQueue.size() < 4) continue;
            byte[] beginning = new byte[4];
            this.handshakeQueue.read(beginning, 0, 4, 0);
            ByteArrayInputStream bis = new ByteArrayInputStream(beginning);
            short type = TlsUtils.readUint8(bis);
            int len = TlsUtils.readUint24(bis);
            if (this.handshakeQueue.size() < len + 4) continue;
            byte[] buf = new byte[len];
            this.handshakeQueue.read(buf, 0, len, 4);
            this.handshakeQueue.removeData(len + 4);
            if (type != 20) {
                this.rs.hash1.update(beginning, 0, 4);
                this.rs.hash2.update(beginning, 0, 4);
                this.rs.hash1.update(buf, 0, len);
                this.rs.hash2.update(buf, 0, len);
            }
            ByteArrayInputStream is = new ByteArrayInputStream(buf);
            block3 : switch (type) {
                case 11: {
                    switch (this.connection_state) {
                        case 2: {
                            Certificate cert = Certificate.parse(is);
                            this.assertEmpty(is);
                            if (!this.verifyer.isValid(cert.getCerts())) {
                                this.failWithError((short)2, (short)90);
                            }
                            RSAPublicKeyStructure rsaKey = null;
                            try {
                                rsaKey = RSAPublicKeyStructure.getInstance(cert.certs[0].getTBSCertificate().getSubjectPublicKeyInfo().getPublicKey());
                            }
                            catch (Exception e) {
                                this.failWithError((short)2, (short)43);
                            }
                            this.serverRsaKey = new RSAKeyParameters(false, rsaKey.getModulus(), rsaKey.getPublicExponent());
                            this.connection_state = (short)3;
                            read = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 20: {
                    switch (this.connection_state) {
                        case 10: {
                            byte[] receivedChecksum = new byte[12];
                            TlsUtils.readFully(receivedChecksum, is);
                            this.assertEmpty(is);
                            byte[] checksum = new byte[12];
                            byte[] md5andsha1 = new byte[36];
                            this.rs.hash2.doFinal(md5andsha1, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("server finished"), md5andsha1, checksum);
                            for (int i = 0; i < receivedChecksum.length; ++i) {
                                if (receivedChecksum[i] == checksum[i]) continue;
                                this.failWithError((short)2, (short)40);
                            }
                            this.connection_state = (short)11;
                            this.appDataReady = true;
                            read = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 2: {
                    switch (this.connection_state) {
                        case 1: {
                            TlsUtils.checkVersion(is, this);
                            this.serverRandom = new byte[32];
                            TlsUtils.readFully(this.serverRandom, is);
                            short sessionIdLength = TlsUtils.readUint8(is);
                            byte[] sessionId = new byte[sessionIdLength];
                            TlsUtils.readFully(sessionId, is);
                            this.chosenCipherSuite = TlsCipherSuiteManager.getCipherSuite(TlsUtils.readUint16(is), this);
                            short compressionMethod = TlsUtils.readUint8(is);
                            if (compressionMethod != 0) {
                                this.failWithError((short)2, (short)47);
                            }
                            this.assertEmpty(is);
                            this.connection_state = (short)2;
                            read = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 14: {
                    switch (this.connection_state) {
                        case 3: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 1) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 4: 
                        case 5: {
                            this.assertEmpty(is);
                            boolean isCertReq = this.connection_state == 5;
                            this.connection_state = (short)6;
                            if (isCertReq) {
                                this.sendClientCertificate();
                            }
                            short ke = this.chosenCipherSuite.getKeyExchangeAlgorithm();
                            switch (ke) {
                                case 1: {
                                    this.pms = new byte[48];
                                    this.pms[0] = 3;
                                    this.pms[1] = 1;
                                    for (int i = 2; i < 48; ++i) {
                                        this.pms[i] = (byte)this.random.nextInt();
                                    }
                                    RSABlindedEngine rsa = new RSABlindedEngine();
                                    PKCS1Encoding encoding = new PKCS1Encoding(rsa);
                                    encoding.init(true, new ParametersWithRandom(this.serverRsaKey, this.random));
                                    byte[] encrypted = null;
                                    try {
                                        encrypted = encoding.processBlock(this.pms, 0, this.pms.length);
                                    }
                                    catch (InvalidCipherTextException e) {
                                        this.failWithError((short)2, (short)80);
                                    }
                                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                                    TlsUtils.writeUint8((short)16, bos);
                                    TlsUtils.writeUint24(encrypted.length + 2, bos);
                                    TlsUtils.writeUint16(encrypted.length, bos);
                                    bos.write(encrypted);
                                    byte[] message = bos.toByteArray();
                                    this.rs.writeMessage((short)22, message, 0, message.length);
                                    break;
                                }
                                case 5: {
                                    byte[] YcByte = this.Yc.toByteArray();
                                    ByteArrayOutputStream DHbos = new ByteArrayOutputStream();
                                    TlsUtils.writeUint8((short)16, DHbos);
                                    TlsUtils.writeUint24(YcByte.length + 2, DHbos);
                                    TlsUtils.writeUint16(YcByte.length, DHbos);
                                    DHbos.write(YcByte);
                                    byte[] DHmessage = DHbos.toByteArray();
                                    this.rs.writeMessage((short)22, DHmessage, 0, DHmessage.length);
                                    break;
                                }
                                default: {
                                    this.failWithError((short)2, (short)10);
                                }
                            }
                            this.connection_state = (short)7;
                            byte[] cmessage = new byte[]{1};
                            this.rs.writeMessage((short)20, cmessage, 0, cmessage.length);
                            this.connection_state = (short)8;
                            this.ms = new byte[48];
                            byte[] random = new byte[this.clientRandom.length + this.serverRandom.length];
                            System.arraycopy(this.clientRandom, 0, random, 0, this.clientRandom.length);
                            System.arraycopy(this.serverRandom, 0, random, this.clientRandom.length, this.serverRandom.length);
                            TlsUtils.PRF(this.pms, TlsUtils.toByteArray("master secret"), random, this.ms);
                            this.rs.writeSuite = this.chosenCipherSuite;
                            this.rs.writeSuite.init(this.ms, this.clientRandom, this.serverRandom);
                            byte[] checksum = new byte[12];
                            byte[] md5andsha1 = new byte[36];
                            this.rs.hash1.doFinal(md5andsha1, 0);
                            TlsUtils.PRF(this.ms, TlsUtils.toByteArray("client finished"), md5andsha1, checksum);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            TlsUtils.writeUint8((short)20, bos);
                            TlsUtils.writeUint24(12, bos);
                            bos.write(checksum);
                            byte[] message = bos.toByteArray();
                            this.rs.writeMessage((short)22, message, 0, message.length);
                            this.connection_state = (short)9;
                            read = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)40);
                    break;
                }
                case 12: {
                    switch (this.connection_state) {
                        case 3: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 5) {
                                this.failWithError((short)2, (short)10);
                            }
                            int pLength = TlsUtils.readUint16(is);
                            byte[] pByte = new byte[pLength];
                            TlsUtils.readFully(pByte, is);
                            int gLength = TlsUtils.readUint16(is);
                            byte[] gByte = new byte[gLength];
                            TlsUtils.readFully(gByte, is);
                            int YsLength = TlsUtils.readUint16(is);
                            byte[] YsByte = new byte[YsLength];
                            TlsUtils.readFully(YsByte, is);
                            int sigLength = TlsUtils.readUint16(is);
                            byte[] sigByte = new byte[sigLength];
                            TlsUtils.readFully(sigByte, is);
                            this.assertEmpty(is);
                            CombinedHash sigDigest = new CombinedHash();
                            ByteArrayOutputStream signedData = new ByteArrayOutputStream();
                            TlsUtils.writeUint16(pLength, signedData);
                            signedData.write(pByte);
                            TlsUtils.writeUint16(gLength, signedData);
                            signedData.write(gByte);
                            TlsUtils.writeUint16(YsLength, signedData);
                            signedData.write(YsByte);
                            byte[] signed = signedData.toByteArray();
                            sigDigest.update(this.clientRandom, 0, this.clientRandom.length);
                            sigDigest.update(this.serverRandom, 0, this.serverRandom.length);
                            sigDigest.update(signed, 0, signed.length);
                            byte[] hash = new byte[sigDigest.getDigestSize()];
                            sigDigest.doFinal(hash, 0);
                            RSABlindedEngine rsa = new RSABlindedEngine();
                            PKCS1Encoding encoding = new PKCS1Encoding(rsa);
                            encoding.init(false, this.serverRsaKey);
                            byte[] sigHash = null;
                            try {
                                sigHash = encoding.processBlock(sigByte, 0, sigByte.length);
                            }
                            catch (InvalidCipherTextException e) {
                                this.failWithError((short)2, (short)42);
                            }
                            if (sigHash.length != hash.length) {
                                this.failWithError((short)2, (short)42);
                            }
                            for (int i = 0; i < sigHash.length; ++i) {
                                if (sigHash[i] == hash[i]) continue;
                                this.failWithError((short)2, (short)42);
                            }
                            BigInteger p = new BigInteger(1, pByte);
                            BigInteger g2 = new BigInteger(1, gByte);
                            BigInteger Ys = new BigInteger(1, YsByte);
                            BigInteger x = new BigInteger(p.bitLength() - 1, this.random);
                            this.Yc = g2.modPow(x, p);
                            this.pms = BigIntegers.asUnsignedByteArray(Ys.modPow(x, p));
                            this.connection_state = (short)4;
                            read = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                case 13: {
                    switch (this.connection_state) {
                        case 3: {
                            if (this.chosenCipherSuite.getKeyExchangeAlgorithm() != 1) {
                                this.failWithError((short)2, (short)10);
                            }
                        }
                        case 4: {
                            short typesLength = TlsUtils.readUint8(is);
                            byte[] types = new byte[typesLength];
                            TlsUtils.readFully(types, is);
                            int authsLength = TlsUtils.readUint16(is);
                            byte[] auths = new byte[authsLength];
                            TlsUtils.readFully(auths, is);
                            this.assertEmpty(is);
                            this.connection_state = (short)5;
                            read = true;
                            break block3;
                        }
                    }
                    this.failWithError((short)2, (short)10);
                    break;
                }
                default: {
                    this.failWithError((short)2, (short)10);
                }
            }
        } while (read);
    }

    private void processApplicationData() {
    }

    private void processAlert() throws IOException {
        while (this.alertQueue.size() >= 2) {
            byte[] tmp = new byte[2];
            this.alertQueue.read(tmp, 0, 2, 0);
            this.alertQueue.removeData(2);
            short level = tmp[0];
            short description = tmp[1];
            if (level == 2) {
                this.failedWithError = true;
                this.closed = true;
                try {
                    this.rs.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (description != 0) continue;
            this.failWithError((short)1, (short)0);
        }
    }

    private void processChangeCipherSpec() throws IOException {
        while (this.changeCipherSpecQueue.size() > 0) {
            byte[] b = new byte[1];
            this.changeCipherSpecQueue.read(b, 0, 1, 0);
            this.changeCipherSpecQueue.removeData(1);
            if (b[0] != 1) {
                this.failWithError((short)2, (short)10);
                continue;
            }
            if (this.connection_state == 9) {
                this.rs.readSuite = this.rs.writeSuite;
                this.connection_state = (short)10;
                continue;
            }
            this.failWithError((short)2, (short)40);
        }
    }

    private void sendClientCertificate() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)11, bos);
        TlsUtils.writeUint24(3, bos);
        TlsUtils.writeUint24(0, bos);
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
    }

    public void connect(CertificateVerifyer verifyer) throws IOException {
        this.verifyer = verifyer;
        this.clientRandom = new byte[32];
        int t = (int)(System.currentTimeMillis() / 1000L);
        this.clientRandom[0] = (byte)(t >> 24);
        this.clientRandom[1] = (byte)(t >> 16);
        this.clientRandom[2] = (byte)(t >> 8);
        this.clientRandom[3] = (byte)t;
        for (int i = 4; i < this.clientRandom.length; ++i) {
            this.clientRandom[i] = (byte)this.random.nextInt();
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TlsUtils.writeVersion(os);
        os.write(this.clientRandom);
        TlsUtils.writeUint8((short)0, os);
        TlsCipherSuiteManager.writeCipherSuites(os);
        byte[] compressionMethods = new byte[]{0};
        TlsUtils.writeUint8((short)compressionMethods.length, os);
        os.write(compressionMethods);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        TlsUtils.writeUint8((short)1, bos);
        TlsUtils.writeUint24(os.size(), bos);
        bos.write(os.toByteArray());
        byte[] message = bos.toByteArray();
        this.rs.writeMessage((short)22, message, 0, message.length);
        this.connection_state = 1;
        while (this.connection_state != 11) {
            this.rs.readData();
        }
        this.tlsInputStream = new TlsInputStream(this);
        this.tlsOutputStream = new TlsOuputStream(this);
    }

    protected int readApplicationData(byte[] buf, int offset, int len) throws IOException {
        while (this.applicationDataQueue.size() == 0) {
            if (this.failedWithError) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
            if (this.closed) {
                return -1;
            }
            try {
                this.rs.readData();
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
        }
        len = Math.min(len, this.applicationDataQueue.size());
        this.applicationDataQueue.read(buf, offset, len, 0);
        this.applicationDataQueue.removeData(len);
        return len;
    }

    protected void writeData(byte[] buf, int offset, int len) throws IOException {
        int toWrite;
        if (this.failedWithError) {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
        if (this.closed) {
            throw new IOException("Sorry, connection has been closed, you cannot write more data");
        }
        this.rs.writeMessage((short)23, emptybuf, 0, 0);
        do {
            toWrite = Math.min(len, 16384);
            try {
                this.rs.writeMessage((short)23, buf, offset, toWrite);
            }
            catch (IOException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.closed) {
                    this.failWithError((short)2, (short)80);
                }
                throw e;
            }
            offset += toWrite;
        } while ((len -= toWrite) > 0);
    }

    public TlsOuputStream getTlsOuputStream() {
        return this.tlsOutputStream;
    }

    public OutputStream getOutputStream() {
        return this.tlsOutputStream;
    }

    public TlsInputStream getTlsInputStream() {
        return this.tlsInputStream;
    }

    public InputStream getInputStream() {
        return this.tlsInputStream;
    }

    protected void failWithError(short alertLevel, short alertDescription) throws IOException {
        if (!this.closed) {
            byte[] error = new byte[]{(byte)alertLevel, (byte)alertDescription};
            this.closed = true;
            if (alertLevel == 2) {
                this.failedWithError = true;
            }
            this.rs.writeMessage((short)21, error, 0, 2);
            this.rs.close();
            if (alertLevel == 2) {
                throw new IOException(TLS_ERROR_MESSAGE);
            }
        } else {
            throw new IOException(TLS_ERROR_MESSAGE);
        }
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.failWithError((short)1, (short)0);
        }
    }

    protected void assertEmpty(ByteArrayInputStream is) throws IOException {
        if (is.available() > 0) {
            this.failWithError((short)2, (short)50);
        }
    }

    protected void flush() throws IOException {
        this.rs.flush();
    }
}

