/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.DSA;
import xjyb.org.bjca.crypto.params.DSAKeyParameters;
import xjyb.org.bjca.crypto.params.DSAParameters;
import xjyb.org.bjca.crypto.params.DSAPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.DSAPublicKeyParameters;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;

public class DSASigner
implements DSA {
    DSAKeyParameters key;
    SecureRandom random;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (DSAPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = new SecureRandom();
                this.key = (DSAPrivateKeyParameters)param;
            }
        } else {
            this.key = (DSAPublicKeyParameters)param;
        }
    }

    @Override
    public BigInteger[] generateSignature(byte[] message) {
        BigInteger k;
        DSAParameters params = this.key.getParameters();
        BigInteger m3 = this.calculateE(params.getQ(), message);
        int qBitLength = params.getQ().bitLength();
        while ((k = new BigInteger(qBitLength, this.random)).compareTo(params.getQ()) >= 0) {
        }
        BigInteger r = params.getG().modPow(k, params.getP()).mod(params.getQ());
        k = k.modInverse(params.getQ()).multiply(m3.add(((DSAPrivateKeyParameters)this.key).getX().multiply(r)));
        BigInteger s2 = k.mod(params.getQ());
        BigInteger[] res = new BigInteger[]{r, s2};
        return res;
    }

    @Override
    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s2) {
        DSAParameters params = this.key.getParameters();
        BigInteger m3 = this.calculateE(params.getQ(), message);
        BigInteger zero = BigInteger.valueOf(0L);
        if (zero.compareTo(r) >= 0 || params.getQ().compareTo(r) <= 0) {
            return false;
        }
        if (zero.compareTo(s2) >= 0 || params.getQ().compareTo(s2) <= 0) {
            return false;
        }
        BigInteger w = s2.modInverse(params.getQ());
        BigInteger u1 = m3.multiply(w).mod(params.getQ());
        BigInteger u2 = r.multiply(w).mod(params.getQ());
        u1 = params.getG().modPow(u1, params.getP());
        u2 = ((DSAPublicKeyParameters)this.key).getY().modPow(u2, params.getP());
        BigInteger v = u1.multiply(u2).mod(params.getP()).mod(params.getQ());
        return v.equals(r);
    }

    private BigInteger calculateE(BigInteger n, byte[] message) {
        if (n.bitLength() >= message.length * 8) {
            return new BigInteger(1, message);
        }
        byte[] trunc = new byte[n.bitLength() / 8];
        System.arraycopy(message, 0, trunc, 0, trunc.length);
        return new BigInteger(1, trunc);
    }
}

