/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;

public class RSABlindingFactorGenerator {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private static BigInteger ONE = BigInteger.valueOf(1L);
    private RSAKeyParameters key;
    private SecureRandom random;

    public void init(CipherParameters param) {
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = new SecureRandom();
        }
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            throw new IllegalArgumentException("generator requires RSA public key");
        }
    }

    public BigInteger generateBlindingFactor() {
        BigInteger gcd;
        BigInteger factor;
        if (this.key == null) {
            throw new IllegalStateException("generator not initialised");
        }
        BigInteger m3 = this.key.getModulus();
        int length = m3.bitLength() - 1;
        do {
            factor = new BigInteger(length, this.random);
            gcd = factor.gcd(m3);
        } while (factor.equals(ZERO) || factor.equals(ONE) || !gcd.equals(ONE));
        return factor;
    }
}

