/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import java.math.BigInteger;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPair;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPairGenerator;
import xjyb.org.bjca.crypto.KeyGenerationParameters;
import xjyb.org.bjca.crypto.generators.DHKeyGeneratorHelper;
import xjyb.org.bjca.crypto.params.ElGamalKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.ElGamalParameters;
import xjyb.org.bjca.crypto.params.ElGamalPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        ElGamalParameters elParams = this.param.getParameters();
        BigInteger p = elParams.getP();
        BigInteger x = this.helper.calculatePrivate(p, this.param.getRandom(), elParams.getL());
        BigInteger y = this.helper.calculatePublic(p, elParams.getG(), x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, elParams), new ElGamalPrivateKeyParameters(x, elParams));
    }
}

