/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPair;
import xjyb.org.bjca.crypto.AsymmetricCipherKeyPairGenerator;
import xjyb.org.bjca.crypto.KeyGenerationParameters;
import xjyb.org.bjca.crypto.params.DSAKeyGenerationParameters;
import xjyb.org.bjca.crypto.params.DSAParameters;
import xjyb.org.bjca.crypto.params.DSAPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.DSAPublicKeyParameters;

public class DSAKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private DSAKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DSAKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger x;
        DSAParameters dsaParams = this.param.getParameters();
        SecureRandom random = this.param.getRandom();
        BigInteger q = dsaParams.getQ();
        BigInteger p = dsaParams.getP();
        BigInteger g2 = dsaParams.getG();
        while ((x = new BigInteger(160, random)).equals(ZERO) || x.compareTo(q) >= 0) {
        }
        BigInteger y = g2.modPow(x, p);
        return new AsymmetricCipherKeyPair(new DSAPublicKeyParameters(y, dsaParams), new DSAPrivateKeyParameters(x, dsaParams));
    }
}

