/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.engines;

import java.math.BigInteger;
import java.security.SecureRandom;
import xjyb.org.bjca.crypto.AsymmetricBlockCipher;
import xjyb.org.bjca.crypto.CipherParameters;
import xjyb.org.bjca.crypto.engines.RSACoreEngine;
import xjyb.org.bjca.crypto.params.ParametersWithRandom;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;

public class RSABlindedEngine
implements AsymmetricBlockCipher {
    private static BigInteger ZERO = BigInteger.valueOf(0L);
    private RSACoreEngine core = new RSACoreEngine();
    private RSAKeyParameters key;
    private SecureRandom random;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.core.init(forEncryption, param);
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.key = (RSAKeyParameters)rParam.getParameters();
            this.random = rParam.getRandom();
        } else {
            this.key = (RSAKeyParameters)param;
            this.random = new SecureRandom();
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.core.getInputBlockSize();
    }

    @Override
    public int getOutputBlockSize() {
        return this.core.getOutputBlockSize();
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int inLen) {
        if (this.key == null) {
            throw new IllegalStateException("RSA engine not initialised");
        }
        if (this.key instanceof RSAPrivateCrtKeyParameters) {
            RSAPrivateCrtKeyParameters k = (RSAPrivateCrtKeyParameters)this.key;
            if (k.getPublicExponent() != null) {
                BigInteger input = this.core.convertInput(in, inOff, inLen);
                BigInteger m3 = k.getModulus();
                BigInteger r = this.calculateR(m3);
                BigInteger result = this.core.processBlock(r.modPow(k.getPublicExponent(), m3).multiply(input).mod(m3));
                return this.core.convertOutput(result.multiply(r.modInverse(m3)).mod(m3));
            }
            return this.core.convertOutput(this.core.processBlock(this.core.convertInput(in, inOff, inLen)));
        }
        return this.core.convertOutput(this.core.processBlock(this.core.convertInput(in, inOff, inLen)));
    }

    private BigInteger calculateR(BigInteger m3) {
        int max = m3.bitLength() - 1;
        int min2 = max / 2;
        int length = (this.random.nextInt() & 0xFF) * ((max - min2) / 255) + min2;
        BigInteger factor = new BigInteger(length, this.random);
        while (factor.equals(ZERO)) {
            factor = new BigInteger(length, this.random);
        }
        return factor;
    }
}

