/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.x9;

import java.math.BigInteger;
import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1OctetString;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.x9.X9IntegerConverter;
import xjyb.org.bjca.math.ec.ECFieldElement;

public class X9FieldElement
extends ASN1Encodable {
    protected ECFieldElement f;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    public X9FieldElement(ECFieldElement f) {
        this.f = f;
    }

    public X9FieldElement(BigInteger p, ASN1OctetString s2) {
        this(new ECFieldElement.Fp(p, new BigInteger(1, s2.getOctets())));
    }

    public X9FieldElement(int m3, int k1, int k2, int k3, ASN1OctetString s2) {
        this(new ECFieldElement.F2m(m3, k1, k2, k3, new BigInteger(1, s2.getOctets())));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    @Override
    public DERObject toASN1Object() {
        int byteCount = converter.getByteLength(this.f);
        byte[] paddedBigInteger = converter.integerToBytes(this.f.toBigInteger(), byteCount);
        return new DEROctetString(paddedBigInteger);
    }
}

