/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1.pkcs;

import xjyb.org.bjca.asn1.ASN1Encodable;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERNull;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.oiw.OIWObjectIdentifiers;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;

public class RSASSAPSSparams
extends ASN1Encodable {
    private AlgorithmIdentifier hashAlgorithm;
    private AlgorithmIdentifier maskGenAlgorithm;
    private DERInteger saltLength;
    private DERInteger trailerField;
    public static final AlgorithmIdentifier DEFAULT_HASH_ALGORITHM = new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1, new DERNull());
    public static final AlgorithmIdentifier DEFAULT_MASK_GEN_FUNCTION = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, DEFAULT_HASH_ALGORITHM);
    public static final DERInteger DEFAULT_SALT_LENGTH = new DERInteger(20);
    public static final DERInteger DEFAULT_TRAILER_FIELD = new DERInteger(1);

    public static RSASSAPSSparams getInstance(Object obj) {
        if (obj == null || obj instanceof RSASSAPSSparams) {
            return (RSASSAPSSparams)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new RSASSAPSSparams((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public RSASSAPSSparams() {
        this.hashAlgorithm = DEFAULT_HASH_ALGORITHM;
        this.maskGenAlgorithm = DEFAULT_MASK_GEN_FUNCTION;
        this.saltLength = DEFAULT_SALT_LENGTH;
        this.trailerField = DEFAULT_TRAILER_FIELD;
    }

    public RSASSAPSSparams(AlgorithmIdentifier hashAlgorithm, AlgorithmIdentifier maskGenAlgorithm, DERInteger saltLength, DERInteger trailerField) {
        this.hashAlgorithm = hashAlgorithm;
        this.maskGenAlgorithm = maskGenAlgorithm;
        this.saltLength = saltLength;
        this.trailerField = trailerField;
    }

    public RSASSAPSSparams(ASN1Sequence seq) {
        this.hashAlgorithm = DEFAULT_HASH_ALGORITHM;
        this.maskGenAlgorithm = DEFAULT_MASK_GEN_FUNCTION;
        this.saltLength = DEFAULT_SALT_LENGTH;
        this.trailerField = DEFAULT_TRAILER_FIELD;
        block6: for (int i = 0; i != seq.size(); ++i) {
            ASN1TaggedObject o = (ASN1TaggedObject)seq.getObjectAt(i);
            switch (o.getTagNo()) {
                case 0: {
                    this.hashAlgorithm = AlgorithmIdentifier.getInstance(o, true);
                    continue block6;
                }
                case 1: {
                    this.maskGenAlgorithm = AlgorithmIdentifier.getInstance(o, true);
                    continue block6;
                }
                case 2: {
                    this.saltLength = DERInteger.getInstance(o, true);
                    continue block6;
                }
                case 3: {
                    this.trailerField = DERInteger.getInstance(o, true);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("unknown tag");
                }
            }
        }
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public AlgorithmIdentifier getMaskGenAlgorithm() {
        return this.maskGenAlgorithm;
    }

    public DERInteger getSaltLength() {
        return this.saltLength;
    }

    public DERInteger getTrailerField() {
        return this.trailerField;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (!this.hashAlgorithm.equals(DEFAULT_HASH_ALGORITHM)) {
            v.add(new DERTaggedObject(true, 0, this.hashAlgorithm));
        }
        if (!this.maskGenAlgorithm.equals(DEFAULT_MASK_GEN_FUNCTION)) {
            v.add(new DERTaggedObject(true, 1, this.maskGenAlgorithm));
        }
        if (!this.saltLength.equals(DEFAULT_SALT_LENGTH)) {
            v.add(new DERTaggedObject(true, 2, this.saltLength));
        }
        if (!this.trailerField.equals(DEFAULT_TRAILER_FIELD)) {
            v.add(new DERTaggedObject(true, 3, this.trailerField));
        }
        return new DERSequence(v);
    }
}

