/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import xjyb.org.bjca.asn1.LimitedInputStream;
import xjyb.org.bjca.util.io.Streams;

class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private int _length;

    DefiniteLengthInputStream(InputStream in, int length) {
        super(in);
        if (length < 0) {
            throw new IllegalArgumentException("negative lengths not allowed");
        }
        this._length = length;
    }

    @Override
    public int read() throws IOException {
        if (this._length > 0) {
            int b = this._in.read();
            if (b < 0) {
                throw new EOFException();
            }
            --this._length;
            return b;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this._length > 0) {
            int toRead = Math.min(len, this._length);
            int numRead = this._in.read(buf, off, toRead);
            if (numRead < 0) {
                throw new EOFException();
            }
            this._length -= numRead;
            return numRead;
        }
        this.setParentEofDetect(true);
        return -1;
    }

    byte[] toByteArray() throws IOException {
        byte[] bytes;
        if (this._length > 0) {
            bytes = new byte[this._length];
            if (Streams.readFully(this._in, bytes) < this._length) {
                throw new EOFException();
            }
            this._length = 0;
        } else {
            bytes = EMPTY_BYTES;
        }
        this.setParentEofDetect(true);
        return bytes;
    }
}

