/*
 * Decompiled with CFR 0.152.
 */
package xjyb.com.sansec.device.local;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import javax.crypto.Cipher;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.com.sansec.device.local.Card;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1Set;
import xjyb.org.bjca.asn1.BERSet;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERPrintableString;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.pkcs.CertificationRequest;
import xjyb.org.bjca.asn1.pkcs.CertificationRequestInfo;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X5094JitEntryConverter;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.asn1.x9.X9ObjectIdentifiers;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.digests.SHA256Digest;
import xjyb.org.bjca.crypto.digests.SHA512Digest;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.crypto.signers.BJCASigner;
import xjyb.org.bjca.crypto.signers.SM2Signer;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.valuebean.DeviceKeyPair;
import xjyb.org.bjca.sm2soft.SM2Algorithm;
import xjyb.org.bjca.sm2soft.SM2JavaAlgorithm;
import xjyb.org.bjca.util.BigIntegers;
import xjyb.org.bjca.util.ByteArrayUtil;
import xjyb.org.bjca.util.MathUtil;
import xjyb.org.bjca.util.encoders.Base64;

public class WrapCard {
    private Card device = null;

    public WrapCard(int initmodel) {
        this.device = initmodel == 4 || initmodel == 8 ? SM2Algorithm.getInstance() : (initmodel == 6 || initmodel == 7 ? Card.getInstance() : (initmodel == 9 ? SM2JavaAlgorithm.getInstance() : SM2Algorithm.getInstance()));
    }

    public WrapCard() {
        this.device = SM2JavaAlgorithm.getInstance();
    }

    public byte[] sm3WithSM2Sign(byte[] src, X509CertificateStructure strucCert, byte[] bPriKey) throws IOException {
        SubjectPublicKeyInfo spki = strucCert.getSubjectPublicKeyInfo();
        byte[] bPubKey = spki.getPublicKeyData().getBytes();
        byte[] publicKey = new byte[64];
        System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
        byte[] id = "1234567812345678".getBytes();
        int rv = 0;
        byte[] buffer = this.device.sm3Hash(src, publicKey, id);
        rv = MathUtil.byte2int(buffer, 0);
        byte[] hash = null;
        if (rv != 0) {
            return null;
        }
        hash = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, hash, 0, hash.length);
        int algId = 257;
        buffer = this.device.sm2ExternalSign(algId, hash, bPriKey);
        rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            return null;
        }
        byte[] r = new byte[32];
        byte[] s2 = new byte[32];
        System.arraycopy(buffer, 4, r, 0, 32);
        System.arraycopy(buffer, 36, s2, 0, 32);
        DERInteger derR = new DERInteger(new BigInteger(1, r));
        DERInteger derS = new DERInteger(new BigInteger(1, s2));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(derR);
        v.add(derS);
        DERSequence seq = new DERSequence(v);
        byte[] derSign = WrapCard.writeDERObj2Bytes(seq);
        return derSign;
    }

    public byte[] sm3WithSM2SignUtil(byte[] src, byte[] publicKey, byte[] privateKey) throws SignatureException {
        byte[] derSign;
        byte[] id = "1234567812345678".getBytes();
        int rv = 0;
        byte[] buffer = this.device.sm3Hash(src, publicKey, id);
        rv = MathUtil.byte2int(buffer, 0);
        byte[] hash = null;
        if (rv != 0) {
            throw new SignatureException("sm3 failed, rv[0x" + Integer.toHexString(rv) + "]");
        }
        hash = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, hash, 0, hash.length);
        int algId = 257;
        buffer = this.device.sm2ExternalSign(algId, hash, privateKey);
        rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            throw new SignatureException("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
        }
        byte[] r = new byte[32];
        byte[] s2 = new byte[32];
        System.arraycopy(buffer, 4, r, 0, 32);
        System.arraycopy(buffer, 36, s2, 0, 32);
        DERInteger derR = new DERInteger(new BigInteger(1, r));
        DERInteger derS = new DERInteger(new BigInteger(1, s2));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(derR);
        v.add(derS);
        DERSequence seq = new DERSequence(v);
        try {
            derSign = WrapCard.writeDERObj2Bytes(seq);
        }
        catch (IOException e) {
            throw new SignatureException(e.getMessage());
        }
        return derSign;
    }

    public byte[] sm3(byte[] inData, byte[] publicKey, byte[] id) throws IOException {
        int rv = 0;
        byte[] buffer = null;
        buffer = this.device.sm3Hash(inData, publicKey, id);
        rv = MathUtil.byte2int(buffer, 0);
        byte[] hash = null;
        if (rv != 0) {
            return null;
        }
        hash = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, hash, 0, hash.length);
        return hash;
    }

    public byte[] sm2SignWithHashedData(byte[] hashedData, byte[] bPriKey) throws IOException {
        int algId = 257;
        byte[] buffer = this.device.sm2ExternalSign(algId, hashedData, bPriKey);
        int rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            return null;
        }
        byte[] r = new byte[32];
        byte[] s2 = new byte[32];
        System.arraycopy(buffer, 4, r, 0, 32);
        System.arraycopy(buffer, 36, s2, 0, 32);
        DERInteger derR = new DERInteger(new BigInteger(1, r));
        DERInteger derS = new DERInteger(new BigInteger(1, s2));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(derR);
        v.add(derS);
        DERSequence seq = new DERSequence(v);
        byte[] derSign = WrapCard.writeDERObj2Bytes(seq);
        return derSign;
    }

    public byte[] sm2SignWithHashedDataNoDER(byte[] hashedData, byte[] bPriKey) throws IOException {
        int algId = 257;
        byte[] buffer = this.device.sm2ExternalSign(algId, hashedData, bPriKey);
        int rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            LoggerUtil.errorlog("external sign failed, rv[0x" + Integer.toHexString(rv) + "]", "\n");
            return null;
        }
        byte[] signDataNoDER = new byte[64];
        System.arraycopy(buffer, 4, signDataNoDER, 0, 64);
        return signDataNoDER;
    }

    public boolean vefiySM3WithSM2Sign(byte[] src, X509CertificateStructure strcCert, byte[] signedData) throws IOException {
        SubjectPublicKeyInfo spki = strcCert.getSubjectPublicKeyInfo();
        byte[] bPubKey = spki.getPublicKeyData().getBytes();
        byte[] publicKey = new byte[64];
        System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
        byte[] id = "1234567812345678".getBytes();
        int rv = 0;
        byte[] buffer = this.device.sm3Hash(src, publicKey, id);
        rv = MathUtil.byte2int(buffer, 0);
        byte[] hash = null;
        if (rv != 0) {
            return false;
        }
        hash = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, hash, 0, hash.length);
        int algId = 257;
        ASN1Sequence seqSign = (ASN1Sequence)DerUtil.writeBytesToDERObj(signedData);
        DERInteger derR = (DERInteger)seqSign.getObjectAt(0);
        DERInteger derS = (DERInteger)seqSign.getObjectAt(1);
        byte[] r = BigIntegers.asUnsignedByteArray(derR.getValue());
        byte[] s2 = BigIntegers.asUnsignedByteArray(derS.getValue());
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 32 - r.length, r.length);
        System.arraycopy(s2, 0, signature, 64 - s2.length, s2.length);
        buffer = this.device.sm2ExternalVerify(algId, hash, signature, publicKey);
        rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            System.err.println("external verify failed, rv[0x" + Integer.toHexString(rv) + "]");
            return false;
        }
        return true;
    }

    public boolean vefiySM3WithSM2SignByHashedDataNoDER(byte[] hashBytes, X509CertificateStructure strcCert, byte[] signedData) throws IOException {
        SubjectPublicKeyInfo spki = strcCert.getSubjectPublicKeyInfo();
        byte[] bPubKey = spki.getPublicKeyData().getBytes();
        byte[] publicKey = new byte[64];
        System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
        int rv = 0;
        int algId = 257;
        byte[] buffer = this.device.sm2ExternalVerify(algId, hashBytes, signedData, publicKey);
        rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            System.err.println("external verify failed, rv[0x" + Integer.toHexString(rv) + "]");
            LoggerUtil.errorlog("external verify failed, rv[0x" + Integer.toHexString(rv) + "]", "\n");
            return false;
        }
        return true;
    }

    public boolean vefiySM3WithSM2SignNoDER(byte[] src, X509CertificateStructure strcCert, byte[] signedData) throws IOException {
        SubjectPublicKeyInfo spki = strcCert.getSubjectPublicKeyInfo();
        byte[] bPubKey = spki.getPublicKeyData().getBytes();
        byte[] publicKey = new byte[64];
        System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
        byte[] id = "1234567812345678".getBytes();
        int rv = 0;
        byte[] buffer = this.device.sm3Hash(src, publicKey, id);
        rv = MathUtil.byte2int(buffer, 0);
        byte[] hash = null;
        if (rv != 0) {
            LoggerUtil.errorlog("sm3 failed, rv[0x" + Integer.toHexString(rv) + "]", "\n");
            return false;
        }
        hash = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, hash, 0, hash.length);
        int algId = 257;
        buffer = this.device.sm2ExternalVerify(algId, hash, signedData, publicKey);
        rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            System.err.println("external verify failed, rv[0x" + Integer.toHexString(rv) + "]");
            LoggerUtil.errorlog("external verify failed, rv[0x" + Integer.toHexString(rv) + "]", "\n");
            return false;
        }
        return true;
    }

    public boolean vefiySM3WithSM2Sign(byte[] src, byte[] publicKey, byte[] signedData) throws IOException {
        byte[] id = "1234567812345678".getBytes();
        int rv = 0;
        byte[] buffer = this.device.sm3Hash(src, publicKey, id);
        rv = MathUtil.byte2int(buffer, 0);
        byte[] hash = null;
        if (rv != 0) {
            return false;
        }
        hash = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, hash, 0, hash.length);
        int algId = 257;
        ASN1Sequence seqSign = (ASN1Sequence)DerUtil.writeBytesToDERObj(signedData);
        DERInteger derR = (DERInteger)seqSign.getObjectAt(0);
        DERInteger derS = (DERInteger)seqSign.getObjectAt(1);
        byte[] r = BigIntegers.asUnsignedByteArray(derR.getValue());
        byte[] s2 = BigIntegers.asUnsignedByteArray(derS.getValue());
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 32 - r.length, r.length);
        System.arraycopy(s2, 0, signature, 64 - s2.length, s2.length);
        buffer = this.device.sm2ExternalVerify(algId, hash, signature, publicKey);
        rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            System.err.println("external verify failed, rv[0x" + Integer.toHexString(rv) + "]");
            return false;
        }
        return true;
    }

    public boolean vefiySm2SignWithHashedData(byte[] hashedData, X509CertificateStructure strcCert, byte[] signedData) throws IOException {
        SubjectPublicKeyInfo spki = strcCert.getSubjectPublicKeyInfo();
        byte[] bPubKey = spki.getPublicKeyData().getBytes();
        byte[] publicKey = new byte[64];
        System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
        int algId = 257;
        ASN1Sequence seqSign = (ASN1Sequence)DerUtil.writeBytesToDERObj(signedData);
        DERInteger derR = (DERInteger)seqSign.getObjectAt(0);
        DERInteger derS = (DERInteger)seqSign.getObjectAt(1);
        byte[] r = BigIntegers.asUnsignedByteArray(derR.getValue());
        byte[] s2 = BigIntegers.asUnsignedByteArray(derS.getValue());
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 32 - r.length, r.length);
        System.arraycopy(s2, 0, signature, 64 - s2.length, s2.length);
        byte[] buffer = this.device.sm2ExternalVerify(algId, hashedData, signature, publicKey);
        int rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            System.err.println("external verify failed, rv[0x" + Integer.toHexString(rv) + "]");
            return false;
        }
        return true;
    }

    public boolean vefiySm2SignWithHashedData(byte[] hashedData, byte[] publicKey, byte[] signedData) throws IOException {
        int algId = 257;
        ASN1Sequence seqSign = (ASN1Sequence)DerUtil.writeBytesToDERObj(signedData);
        DERInteger derR = (DERInteger)seqSign.getObjectAt(0);
        DERInteger derS = (DERInteger)seqSign.getObjectAt(1);
        byte[] r = BigIntegers.asUnsignedByteArray(derR.getValue());
        byte[] s2 = BigIntegers.asUnsignedByteArray(derS.getValue());
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 32 - r.length, r.length);
        System.arraycopy(s2, 0, signature, 64 - s2.length, s2.length);
        byte[] buffer = this.device.sm2ExternalVerify(algId, hashedData, signature, publicKey);
        int rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            System.err.println("external verify failed, rv[0x" + Integer.toHexString(rv) + "]");
            return false;
        }
        return true;
    }

    public byte[] sm2Encrypt(X509CertificateStructure strcCert, byte[] bMessage) {
        SubjectPublicKeyInfo spki = strcCert.getSubjectPublicKeyInfo();
        byte[] bPubKey = spki.getPublicKeyData().getBytes();
        byte[] publicKey = new byte[64];
        System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
        byte[] buffer = this.device.sm2ExternalEncrypt(publicKey, bMessage);
        int rv = MathUtil.byte2int(buffer, 0);
        byte[] enData = null;
        if (rv != 0) {
            return null;
        }
        enData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, enData, 0, enData.length);
        return enData;
    }

    public byte[] sm2Decrypt(byte[] privateKey, byte[] encryptedData) {
        byte[] buffer = this.device.sm2ExternalDecrypt(privateKey, encryptedData);
        int rv = MathUtil.byte2int(buffer, 0);
        byte[] deData = null;
        if (rv != 0) {
            return null;
        }
        deData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, deData, 0, deData.length);
        return deData;
    }

    public byte[] sm2DecryptForCFCA(byte[] privateKey, byte[] encryptedData) throws IOException {
        ASN1InputStream asn1InputStream = new ASN1InputStream(encryptedData);
        DERObject derObject = asn1InputStream.readObject();
        ASN1Sequence asn1Sequence = ASN1Sequence.getInstance(derObject);
        DERObject bXObj = asn1Sequence.getObjectAt(1).getDERObject();
        DEROctetString x = (DEROctetString)bXObj;
        byte[] encryptedDataTem = x.getEncoded();
        byte[] cfcaByte = new byte[encryptedDataTem.length - 3];
        System.arraycopy(encryptedDataTem, 3, cfcaByte, 0, cfcaByte.length);
        byte[] bX = new byte[32];
        byte[] bY = new byte[32];
        byte[] bM = new byte[32];
        byte[] bC = new byte[cfcaByte.length - 96];
        System.arraycopy(cfcaByte, 0, bX, 0, 32);
        System.arraycopy(cfcaByte, 32, bY, 0, 32);
        System.arraycopy(cfcaByte, 64, bM, 0, 32);
        System.arraycopy(cfcaByte, 96, bC, 0, bC.length);
        SM2Signer sm2Signer = new SM2Signer();
        byte[] buffer = sm2Signer.decrypt(privateKey, bX, bY, bM, bC);
        return buffer;
    }

    public byte[] sm4Encrypt(int algId, boolean forPKCS5Padding, byte[] key, byte[] iv, byte[] dataInput) {
        byte[] buffer = this.device.encrypt(algId, forPKCS5Padding, key, iv, dataInput);
        int rv = MathUtil.byte2int(buffer, 0);
        byte[] enData = null;
        if (rv != 0) {
            return null;
        }
        enData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, enData, 0, enData.length);
        return enData;
    }

    public byte[] sm4Decrypt(int algId, boolean forPKCS5Padding, byte[] key, byte[] iv, byte[] dataInput) {
        byte[] buffer = this.device.decrypt(algId, forPKCS5Padding, key, iv, dataInput);
        int rv = MathUtil.byte2int(buffer, 0);
        byte[] enData = null;
        if (rv != 0) {
            return null;
        }
        enData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, enData, 0, enData.length);
        return enData;
    }

    public byte[] des3Encrypt(int algId, boolean forPKCS5Padding, byte[] key, byte[] iv, byte[] dataInput) {
        if (algId == 1021) {
            algId = 8193;
        } else if (algId == 1022) {
            algId = 8194;
        } else {
            return null;
        }
        byte[] buffer = this.device.encrypt(algId, forPKCS5Padding, key, iv, dataInput);
        int rv = MathUtil.byte2int(buffer, 0);
        byte[] enData = null;
        if (rv != 0) {
            return null;
        }
        enData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, enData, 0, enData.length);
        return enData;
    }

    public byte[] des3Decrypt(int algId, boolean forPKCS5Padding, byte[] key, byte[] iv, byte[] dataInput) {
        if (algId == 1021) {
            algId = 8193;
        } else if (algId == 1022) {
            algId = 8194;
        } else {
            return null;
        }
        byte[] buffer = this.device.decrypt(algId, forPKCS5Padding, key, iv, dataInput);
        int rv = MathUtil.byte2int(buffer, 0);
        byte[] enData = null;
        if (rv != 0) {
            return null;
        }
        enData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, enData, 0, enData.length);
        return enData;
    }

    public String p10GeneratorString_SM2(String dn, DeviceKeyPair keyPair) throws Exception {
        byte[] privateKey = keyPair.getPrivateKey();
        byte[] publicKey = keyPair.getPublicKey();
        byte[] bPubKey = new byte[publicKey.length + 1];
        System.arraycopy(new byte[]{4}, 0, bPubKey, 0, 1);
        System.arraycopy(publicKey, 0, bPubKey, 1, publicKey.length);
        AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new DERObjectIdentifier("1.2.156.10197.1.301"));
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, bPubKey);
        X509Name subject = new X509Name(dn);
        CertificationRequestInfo certReqInfo = new CertificationRequestInfo(subject, spki, null);
        byte[] bReqInfo = WrapCard.writeDERObj2Bytes(certReqInfo.getDERObject());
        byte[] derSign = this.sm3WithSM2SignUtil(bReqInfo, publicKey, privateKey);
        AlgorithmIdentifier signAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.501"));
        CertificationRequest certReq = new CertificationRequest(certReqInfo, signAlg, new DERBitString(derSign));
        byte[] bP10 = WrapCard.writeDERObj2Bytes(certReq.getDERObject());
        String strBase64P10 = new String(Base64.encode(bP10));
        return strBase64P10;
    }

    public String p10GeneratorString_SM2ForDZHT(String dn, ASN1Set extension, DeviceKeyPair keyPair) throws Exception {
        byte[] privateKey = keyPair.getPrivateKey();
        byte[] publicKey = keyPair.getPublicKey();
        byte[] bPubKey = new byte[publicKey.length + 1];
        System.arraycopy(new byte[]{4}, 0, bPubKey, 0, 1);
        System.arraycopy(publicKey, 0, bPubKey, 1, publicKey.length);
        AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new DERObjectIdentifier("1.2.156.10197.1.301"));
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, bPubKey);
        X509Name subject = new X509Name(dn);
        CertificationRequestInfo certReqInfo = new CertificationRequestInfo(subject, spki, extension);
        byte[] bReqInfo = WrapCard.writeDERObj2Bytes(certReqInfo.getDERObject());
        byte[] derSign = this.sm3WithSM2SignUtil(bReqInfo, publicKey, privateKey);
        AlgorithmIdentifier signAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.501"));
        CertificationRequest certReq = new CertificationRequest(certReqInfo, signAlg, new DERBitString(derSign));
        byte[] bP10 = WrapCard.writeDERObj2Bytes(certReq.getDERObject());
        String strBase64P10 = new String(Base64.encode(bP10));
        return strBase64P10;
    }

    public String p10GeneratorString_SM2ForJit(String dn, DeviceKeyPair keyPair) throws Exception {
        byte[] privateKey = keyPair.getPrivateKey();
        byte[] publicKey = keyPair.getPublicKey();
        byte[] bPubKey = new byte[publicKey.length + 1];
        System.arraycopy(new byte[]{4}, 0, bPubKey, 0, 1);
        System.arraycopy(publicKey, 0, bPubKey, 1, publicKey.length);
        AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new DERObjectIdentifier("1.2.156.10197.1.301"));
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, bPubKey);
        X509Name subject = new X509Name(dn, new X5094JitEntryConverter());
        CertificationRequestInfo certReqInfo = new CertificationRequestInfo(subject, spki, null);
        byte[] bReqInfo = WrapCard.writeDERObj2Bytes(certReqInfo.getDERObject());
        byte[] derSign = this.sm3WithSM2SignUtil(bReqInfo, publicKey, privateKey);
        AlgorithmIdentifier signAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.501"), null);
        CertificationRequest certReq = new CertificationRequest(certReqInfo, signAlg, new DERBitString(derSign));
        byte[] bP10 = WrapCard.writeDERObj2Bytes(certReq.getDERObject());
        String strBase64P10 = new String(Base64.encode(bP10));
        return strBase64P10;
    }

    public String p10GeneratorString_SM21(String dn, DeviceKeyPair keyPair, FileOutputStream fOutputStream) throws Exception {
        byte[] privateKey = keyPair.getPrivateKey();
        byte[] publicKey = keyPair.getPublicKey();
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append("publicKey: " + Base64.encode_str(publicKey) + "\n");
        sBuffer.append("privateKey: " + Base64.encode_str(privateKey) + "\n");
        byte[] bPubKey = new byte[publicKey.length + 1];
        System.arraycopy(new byte[]{4}, 0, bPubKey, 0, 1);
        System.arraycopy(publicKey, 0, bPubKey, 1, publicKey.length);
        sBuffer.append("publicKey: " + Base64.encode_str(publicKey) + "\n");
        AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new DERObjectIdentifier("1.2.156.10197.1.301"));
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, bPubKey);
        X509Name subject = new X509Name(dn);
        CertificationRequestInfo certReqInfo = new CertificationRequestInfo(subject, spki, null);
        byte[] bReqInfo = WrapCard.writeDERObj2Bytes(certReqInfo.getDERObject());
        sBuffer.append("bReqInfo: " + Base64.encode_str(bReqInfo) + "\n");
        byte[] derSign = this.sm3WithSM2SignUtilsb(bReqInfo, publicKey, privateKey, sBuffer);
        sBuffer.append("derSign: " + Base64.encode_str(derSign) + "\n");
        AlgorithmIdentifier signAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.501"));
        CertificationRequest certReq = new CertificationRequest(certReqInfo, signAlg, new DERBitString(derSign));
        sBuffer.append("certReq: " + certReq + "\n");
        byte[] bP10 = WrapCard.writeDERObj2Bytes(certReq.getDERObject());
        sBuffer.append("bP10: " + Base64.encode_str(bP10) + "\n");
        String strBase64P10 = new String(Base64.encode(bP10));
        fOutputStream.write(sBuffer.toString().getBytes());
        return strBase64P10;
    }

    public String p10GeneratorString_SM2ForCFCA(String dn, DeviceKeyPair keyPair, byte[] tempPublicKey) throws Exception {
        byte[] privateKey = keyPair.getPrivateKey();
        byte[] publicKey = keyPair.getPublicKey();
        byte[] bPubKey = new byte[publicKey.length + 1];
        System.arraycopy(new byte[]{4}, 0, bPubKey, 0, 1);
        System.arraycopy(publicKey, 0, bPubKey, 1, publicKey.length);
        AlgorithmIdentifier keyAlg = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, new DERObjectIdentifier("1.2.156.10197.1.301"));
        SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo(keyAlg, bPubKey);
        X509Name subject = new X509Name(dn);
        DERObjectIdentifier chanllegPasswordOID = new DERObjectIdentifier("1.2.840.113549.1.9.7");
        DERPrintableString password = new DERPrintableString("111111");
        ASN1EncodableVector v1 = new ASN1EncodableVector();
        v1.add(chanllegPasswordOID);
        v1.add(password);
        DERObjectIdentifier tempPublicKeyOID = new DERObjectIdentifier("1.2.840.113549.1.9.63");
        byte[] byte2 = new byte[]{48, -127, -114, 2, 1, 1, 4, -127, -120};
        byte[] byte1 = new byte[]{0, -76, 0, 0, 0, 1, 0, 0};
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        System.arraycopy(tempPublicKey, 0, x, 0, 32);
        System.arraycopy(tempPublicKey, 32, y, 0, 32);
        byte[] extendBytes = new byte[32];
        for (int i = 0; i < 32; ++i) {
            extendBytes[i] = 0;
        }
        byte[] tempPublicKeyData = new byte[145];
        System.arraycopy(byte2, 0, tempPublicKeyData, 0, 9);
        System.arraycopy(byte1, 0, tempPublicKeyData, 9, 8);
        System.arraycopy(x, 0, tempPublicKeyData, 17, 32);
        System.arraycopy(extendBytes, 0, tempPublicKeyData, 49, 32);
        System.arraycopy(y, 0, tempPublicKeyData, 81, 32);
        System.arraycopy(extendBytes, 0, tempPublicKeyData, 113, 32);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(tempPublicKeyOID);
        v2.add(new DEROctetString(tempPublicKeyData));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERSequence(v1));
        v.add(new DERSequence(v2));
        BERSet attrSet = new BERSet(v);
        CertificationRequestInfo certReqInfo = new CertificationRequestInfo(subject, spki, attrSet);
        byte[] bReqInfo = WrapCard.writeDERObj2Bytes(certReqInfo.getDERObject());
        byte[] derSign = this.sm3WithSM2SignUtil(bReqInfo, publicKey, privateKey);
        AlgorithmIdentifier signAlg = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.501"));
        CertificationRequest certReq = new CertificationRequest(certReqInfo, signAlg, new DERBitString(derSign));
        byte[] bP10 = WrapCard.writeDERObj2Bytes(certReq.getDERObject());
        String strBase64P10 = new String(Base64.encode(bP10));
        return strBase64P10;
    }

    public byte[] sm3WithSM2SignUtilsb(byte[] src, byte[] publicKey, byte[] privateKey, StringBuffer sBuffer) throws SignatureException {
        byte[] derSign;
        byte[] id = "1234567812345678".getBytes();
        int rv = 0;
        byte[] buffer = this.device.sm3Hash(src, publicKey, id);
        sBuffer.append("in sign,buffer: " + Base64.encode_str(buffer) + "\n");
        rv = MathUtil.byte2int(buffer, 0);
        byte[] hash = null;
        if (rv != 0) {
            throw new SignatureException("sm3 failed, rv[0x" + Integer.toHexString(rv) + "]");
        }
        hash = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, hash, 0, hash.length);
        sBuffer.append("in sign,hash: " + Base64.encode_str(hash) + "\n");
        int algId = 257;
        buffer = this.device.sm2ExternalSign(algId, hash, privateKey);
        sBuffer.append("in sign,sign: " + Base64.encode_str(buffer) + "\n");
        rv = MathUtil.byte2int(buffer, 0);
        if (rv != 0) {
            throw new SignatureException("external sign failed, rv[0x" + Integer.toHexString(rv) + "]");
        }
        byte[] r = new byte[32];
        byte[] s2 = new byte[32];
        System.arraycopy(buffer, 4, r, 0, 32);
        System.arraycopy(buffer, 36, s2, 0, 32);
        sBuffer.append("in sign,r: " + Base64.encode_str(r) + "\n");
        sBuffer.append("in sign,s: " + Base64.encode_str(s2) + "\n");
        DERInteger derR = new DERInteger(new BigInteger(1, r));
        DERInteger derS = new DERInteger(new BigInteger(1, s2));
        sBuffer.append("in sign,derR: " + derR + "\n");
        sBuffer.append("in sign,derS: " + derS + "\n");
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(derR);
        v.add(derS);
        sBuffer.append("in sign,v: " + v + "\n");
        DERSequence seq = new DERSequence(v);
        sBuffer.append("in sign,seq: " + seq + "\n");
        try {
            derSign = WrapCard.writeDERObj2Bytes(seq);
            sBuffer.append("in sign,derSign: " + Base64.encode_str(derSign) + "\n");
        }
        catch (IOException e) {
            throw new SignatureException(e.getMessage());
        }
        return derSign;
    }

    public DeviceKeyPair genSm2Keypair() {
        DeviceKeyPair keyPair = new DeviceKeyPair();
        byte[] publicKey = new byte[64];
        byte[] privateKey = new byte[32];
        byte[] buffer = this.device.sm2GenKeyPair();
        int rv = ByteArrayUtil.getFirstIntFromByteArray(buffer, 0);
        if (rv != 0) {
            System.err.println("sm2GenKeyPair failed, rv[0x" + Integer.toHexString(rv) + "]");
            return null;
        }
        System.arraycopy(buffer, 4, publicKey, 0, 64);
        System.arraycopy(buffer, 68, privateKey, 0, 32);
        keyPair.setPrivateKey(privateKey);
        keyPair.setPublicKey(publicKey);
        return keyPair;
    }

    public static byte[] writeDERObj2Bytes(DEREncodable obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DEROutputStream dos = new DEROutputStream(bos);
        dos.writeObject(obj);
        byte[] bDerObj = bos.toByteArray();
        bos.close();
        return bDerObj;
    }

    public byte[] genRandom(int n) {
        if (this.device.getClass().isAssignableFrom(Card.class)) {
            byte[] buffer = this.device.generateRandom(n);
            int rv = MathUtil.byte2int(buffer, 0);
            byte[] random = null;
            if (rv != 0) {
                LoggerUtil.errorlog("genRandom failed, rv[0x" + Integer.toHexString(rv) + "]", "\n");
                return null;
            }
            random = new byte[buffer.length - 4];
            System.arraycopy(buffer, 4, random, 0, random.length);
            return random;
        }
        SecureRandom rand = new SecureRandom();
        byte[] newRan = new byte[n];
        rand.nextBytes(newRan);
        return newRan;
    }

    public byte[] genRSAKeyPair(int keyLen) {
        return this.device.rsaGenKeyPair(keyLen);
    }

    public byte[] rsaExternalDecrypt(PrivateKey privateKey, byte[] cipher) {
        try {
            Cipher cpher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cpher.init(2, privateKey);
            return cpher.doFinal(cipher);
        }
        catch (Exception e) {
            LoggerUtil.errorlog("rsaExternalDecrypt exception", e.getMessage());
            return null;
        }
    }

    public byte[] externalSign(RSAPrivateCrtKeyParameters privateCrtKey, byte[] hash, byte[] privateKey) {
        byte[] signedData = null;
        byte[] buffer = null;
        if (this.device.getClass().isAssignableFrom(Card.class)) {
            buffer = this.device.externalSign(1, hash, privateKey);
        } else if (this.device.getClass().isAssignableFrom(SM2Algorithm.class)) {
            if (hash != null && hash.length == 20) {
                buffer = this.device.externalSign(1, hash, privateKey);
            } else if (hash != null && hash.length == 32) {
                buffer = this.device.externalSign(2, hash, privateKey);
            } else if (hash != null && hash.length == 64) {
                buffer = this.device.externalSign(3, hash, privateKey);
            }
        } else if (this.device.getClass().isAssignableFrom(SM2JavaAlgorithm.class)) {
            BJCASigner bjcaSigner = null;
            if (hash != null && hash.length == 20) {
                bjcaSigner = new BJCASigner(new SHA1Digest());
            } else if (hash != null && hash.length == 32) {
                bjcaSigner = new BJCASigner(new SHA256Digest());
            } else if (hash != null && hash.length == 64) {
                bjcaSigner = new BJCASigner(new SHA512Digest());
            }
            bjcaSigner.init(true, privateCrtKey);
            bjcaSigner.update(hash, 0, hash.length);
            try {
                signedData = bjcaSigner.generateSignature();
            }
            catch (Exception e) {
                LoggerUtil.errorlog("externalSign exception", e.getMessage());
                return null;
            }
            return signedData;
        }
        int rv = ByteArrayUtil.getFirstIntFromByteArray(buffer, 0);
        if (rv != 0) {
            LoggerUtil.errorlog("external sign failed, rv[0x" + Integer.toHexString(rv) + "]", "\n");
            return null;
        }
        signedData = new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, signedData, 0, buffer.length - 4);
        return signedData;
    }

    public static void main(String[] arg) throws Exception {
        try {
            WrapCard wrapCard = new WrapCard();
            DeviceKeyPair deviceKeyPair = wrapCard.genSm2Keypair();
            String p10 = wrapCard.p10GeneratorString_SM2("c=cn,cn=song", deviceKeyPair);
            System.out.println(p10);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

