/*
 * Decompiled with CFR 0.152.
 */
package xjyb.com.bjca.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import sun.misc.BASE64Decoder;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.jni.security.SecurityEngine;
import xjyb.cn.org.bjca.jni.utils.CryptoUtil;
import xjyb.cn.org.bjca.jni.utils.FileUtil;
import xjyb.cn.org.bjca.jni.utils.HashUtil;
import xjyb.cn.org.bjca.jni.utils.Pkcs7Util;
import xjyb.cn.org.bjca.jni.utils.RsaUtil;
import xjyb.cn.org.bjca.jni.utils.TsUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.com.bjca.security.SecurityEngineDeal;
import xjyb.com.bjca.security.exception.SecurityEngineException;
import xjyb.com.bjca.security.exception.VerifyException;

public class SecurityEngineDeal_oldJni
extends SecurityEngineDeal {
    private SecurityEngine safeEng = null;
    private BjcaApiEngine apiEngine;
    ArrayList fileList = new ArrayList();
    ArrayList stringList = new ArrayList();
    private static Hashtable listApp = new Hashtable();
    private static long Alg_Enc = 106L;

    public SecurityEngineDeal_oldJni(String appName) throws FileNotFoundException, JDOMException, IOException, InitException {
        this.safeEng = new SecurityEngine(appName);
        this.apiEngine = this.safeEng.initialApp(appName);
        this.safeEng.loginApp();
    }

    public SecurityEngine getSafeEng() throws InitException {
        if (this.safeEng == null) {
            throw new InitException("\u521d\u59cb\u5316\u672a\u5b8c\u6210\uff01");
        }
        return this.safeEng;
    }

    @Override
    public String getApplicationName() {
        return applicationName;
    }

    @Override
    public void setDebug(boolean isDebug) throws InitException {
        if (applicationName == null) {
            LoggerUtil.errorlog(applicationName, "\u6ca1\u6709\u521d\u59cb\u5316\uff01");
            LoggerUtil.debuglog(applicationName, "\u6ca1\u6709\u521d\u59cb\u5316\uff01");
            throw new InitException("\u6ca1\u6709\u521d\u59cb\u5316\uff01");
        }
        if (isDebug) {
            LoggerUtil.setDebug(applicationName, "true");
        } else {
            LoggerUtil.setDebug(applicationName, "false");
        }
    }

    @Override
    public void initAppValue() {
        this.safeEng.setAppValue(applicationName);
    }

    @Override
    public void initP7Cert() {
        boolean isSuccess = this.safeEng.initP7Cert();
        if (isSuccess) {
            LoggerUtil.systemlog(applicationName, "\u518d\u6b21\u66f4\u65b0\u6839\u8bc1\u4e66\u6210\u529f\uff01");
        } else {
            LoggerUtil.systemlog(applicationName, "\u518d\u6b21\u66f4\u65b0\u6839\u8bc1\u4e66\u5931\u8d25\uff01");
        }
    }

    @Override
    public void verifyCRL() {
    }

    @Override
    public boolean finalizeBjapi() {
        return false;
    }

    @Override
    public boolean SetContainer(String container) {
        return false;
    }

    @Override
    public boolean ChangePin(String oldPin, String newPin) {
        return false;
    }

    @Override
    public String GetServerCertificate() throws Base64Exception {
        return this.safeEng.getEncryptCertString();
    }

    @Override
    public byte[] GetServerCertificateBytes() {
        return this.safeEng.getEncryptCertBytes();
    }

    @Override
    public String GetSignCertificate() throws Base64Exception {
        String cert = this.safeEng.getSignCertString();
        return cert;
    }

    @Override
    public byte[] GetSignCertificateBytes() {
        byte[] cert = this.safeEng.getSignCertBytes();
        return cert;
    }

    @Override
    public String GetRandom() throws RandomNumberException, Base64Exception {
        return this.safeEng.getRandomString();
    }

    @Override
    public String GetRandom(int len) throws RandomNumberException, Base64Exception {
        return this.safeEng.getRandomString(len);
    }

    @Override
    public byte[] GetRandomBytes(int len) throws RandomNumberException {
        byte[] random = this.safeEng.getRandomByte(len);
        return random;
    }

    private long getNumFromString(String str) throws AlgorithmNotFoundException {
        if ("RSA-SHA1".equals(str)) {
            return 3L;
        }
        if ("RSA-MD5".equals(str)) {
            return 2L;
        }
        if ("RSA-MD2".equals(str)) {
            return 1L;
        }
        if ("DES".equals(str)) {
            return 100L;
        }
        if ("T-DES2KEY".equals(str)) {
            return 101L;
        }
        if ("T-DES".equals(str)) {
            return 102L;
        }
        if ("SSF33".equals(str)) {
            return 103L;
        }
        if ("AES-128".equals(str)) {
            return 108L;
        }
        if ("AES-192".equals(str)) {
            return 107L;
        }
        if ("AES-256".equals(str)) {
            return 106L;
        }
        throw new AlgorithmNotFoundException("\u6b64\u7b97\u6cd5\u65e0\u6548\uff01");
    }

    @Override
    public boolean SymmEncrypt_SetAlg(String Alg2) {
        try {
            if (Alg2.equalsIgnoreCase("AES-256")) {
                Alg_Enc = 106L;
            } else if (Alg2.equalsIgnoreCase("AES-128")) {
                Alg_Enc = 108L;
            } else if (Alg2.equalsIgnoreCase("AES-192")) {
                Alg_Enc = 107L;
            } else if (Alg2.equalsIgnoreCase("T-DES")) {
                Alg_Enc = 102L;
            } else if (Alg2.equalsIgnoreCase("T-DES2KEY")) {
                Alg_Enc = 101L;
            } else if (Alg2.equalsIgnoreCase("DES")) {
                Alg_Enc = 100L;
            } else {
                throw new SecurityEngineException(-7L);
            }
            return true;
        }
        catch (SecurityEngineException see) {
            System.err.println("\u51fa\u73b0\u9519\u8bef\uff1a" + see.getExcptionDetail());
            see.printStackTrace();
            return false;
        }
    }

    @Override
    public String SymmEncrypt_Encrypt(String toBeEncryptedBlob, byte[] key) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        String sdata = "";
        try {
            sdata = cryptoUtil.BJS_SymmEncrypt(this.apiEngine, 101L, 2L, key, key.length, iv, toBeEncryptedBlob.getBytes());
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (EncryptDataException e) {
            e.printStackTrace();
            return null;
        }
        return sdata;
    }

    @Override
    public boolean SymmEncrypt_File(String srcfile, String destfile, String key, long EncAlg) {
        Base64Util base64Util = new Base64Util(applicationName);
        FileUtil fileUtil = new FileUtil(applicationName);
        try {
            byte[] keybuf = base64Util.BJS_DecodeBase64(key);
            boolean rv = fileUtil.BJS_SymmEncFile(this.apiEngine, srcfile, destfile, keybuf, EncAlg, 2L);
            return rv;
        }
        catch (EncryptDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SymmEncrypt_File(String srcfile, String destfile, byte[] key, long EncAlg) {
        FileUtil fileUtil = new FileUtil(applicationName);
        try {
            boolean rv = fileUtil.BJS_SymmEncFile(this.apiEngine, srcfile, destfile, key, EncAlg, 2L);
            return rv;
        }
        catch (EncryptDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SymmDecrypt_File(String srcfile, String destfile, String key, long EncAlg) {
        Base64Util base64Util = new Base64Util(applicationName);
        FileUtil fileUtil = new FileUtil(applicationName);
        try {
            byte[] keybuf = base64Util.BJS_DecodeBase64(key);
            boolean rv = fileUtil.BJS_SymmDecFile(this.apiEngine, srcfile, destfile, keybuf, EncAlg, 2L);
            return rv;
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SymmDecrypt_File(String srcfile, String destfile, byte[] key, long EncAlg) {
        FileUtil fileUtil = new FileUtil(applicationName);
        try {
            boolean rv = fileUtil.BJS_SymmDecFile(this.apiEngine, srcfile, destfile, key, EncAlg, 2L);
            return rv;
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String SymmEncrypt_Encrypt(long ALGID, String toBeEncryptedBlob, byte[] key) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            String sdata = cryptoUtil.BJS_SymmEncrypt(this.apiEngine, ALGID, 2L, key, key.length, iv, toBeEncryptedBlob.getBytes());
            return sdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (EncryptDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SymmEncrypt_Encrypt(String toBeEncryptedBlob, String key) {
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        try {
            sKey = new BASE64Decoder().decodeBuffer(key);
            CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
            String sdata = cryptoUtil.BJS_SymmEncrypt(this.apiEngine, Alg_Enc, 2L, sKey, sKey.length, iv, toBeEncryptedBlob.getBytes());
            return sdata;
        }
        catch (Exception e) {
            try {
                throw new SecurityEngineException(-201L);
            }
            catch (SecurityEngineException see) {
                System.err.println("\u51fa\u73b0\u9519\u8bef\uff1a" + see.getExcptionDetail());
                see.printStackTrace();
                return null;
            }
        }
    }

    @Override
    public byte[] SymmEncrypt_Decrypt(String beEncryptedBlob, byte[] key) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            byte[] sdata = cryptoUtil.BJS_SymmDecrypt(this.apiEngine, 101L, 2L, key, key.length, iv, beEncryptedBlob);
            return sdata;
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] SymmEncrypt_Decrypt(long ALGID, String beEncryptedBlob, byte[] key) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            byte[] sdata = cryptoUtil.BJS_SymmDecrypt(this.apiEngine, ALGID, 2L, key, key.length, iv, beEncryptedBlob);
            return sdata;
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] SymmEncrypt_Decrypt(String beEncryptedBlob, String key) {
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            sKey = new BASE64Decoder().decodeBuffer(key);
            byte[] sdata = cryptoUtil.BJS_SymmDecrypt(this.apiEngine, Alg_Enc, 2L, sKey, sKey.length, iv, beEncryptedBlob);
            return sdata;
        }
        catch (Exception e) {
            try {
                throw new SecurityEngineException(-201L);
            }
            catch (SecurityEngineException see) {
                System.err.println("\u51fa\u73b0\u9519\u8bef\uff1a" + see.getExcptionDetail());
                see.printStackTrace();
                return null;
            }
        }
    }

    @Override
    public String EncryptedData_Encrypt(String toBeEncryptedBlob, String cert) {
        Base64Util base64Util = new Base64Util(applicationName);
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        try {
            byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
            byte[] sdata = rsaUtil.BJK_RsaEncrypt(this.apiEngine, toBeEncryptedBlob.getBytes(), certbuf);
            return base64Util.BJS_EncodeBase64(sdata);
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaEncryptException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EncryptedData_Encrypt(String toBeEncryptedBlob, byte[] cert) {
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        Base64Util base64U = new Base64Util(applicationName);
        try {
            byte[] sdata = rsaUtil.BJK_RsaEncrypt(this.apiEngine, toBeEncryptedBlob.getBytes(), cert);
            return base64U.BJS_EncodeBase64(sdata);
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaEncryptException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EncryptedData_Decrypt(String encryptedBlob) {
        try {
            String sdata = this.safeEng.priKeyDecrypt(encryptedBlob);
            return sdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaDecryptException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EnvelopedData_Encrypt(String toBeEncryptedBlob, String cert) {
        Base64Util base64Util = new Base64Util(applicationName);
        Pkcs7Util pkcs7Util = new Pkcs7Util(applicationName);
        try {
            byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
            String p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelope(this.apiEngine, toBeEncryptedBlob, certbuf, 100L);
            return p7envdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7EncodeException e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7EncodeEnvelopeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EnvelopedData_Encrypt(String toBeEncryptedBlob, byte[] cert) {
        Pkcs7Util pkcs7Util = new Pkcs7Util(applicationName);
        try {
            String p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelope(this.apiEngine, toBeEncryptedBlob, cert, 100L);
            return p7envdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7EncodeException e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7EncodeEnvelopeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EnvelopedData_Decrypt(String beEncryptedBlob) {
        try {
            String p7envdata = this.safeEng.decodeP7EnvelopedData(beEncryptedBlob);
            return p7envdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7DecodeEnvelopeException e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7DecodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EnvelopedDataEx_Encrypt(String toBeEncryptedBlob, String cert) {
        Base64Util base64Util = new Base64Util(applicationName);
        Pkcs7Util pkcs7Util = new Pkcs7Util(applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
        String p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelopeEx(this.apiEngine, toBeEncryptedBlob, certbuf);
        return p7envdata;
    }

    @Override
    public String EnvelopedDataEx_Encrypt(String toBeEncryptedBlob, byte[] cert) {
        Pkcs7Util pkcs7Util = new Pkcs7Util(applicationName);
        String p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelopeEx(this.apiEngine, toBeEncryptedBlob, cert);
        return p7envdata;
    }

    @Override
    public String EnvelopedDataEx_Decrypt(String beEncryptedBlob) {
        String p7envdata = this.safeEng.decodeP7EnvelopedExData(beEncryptedBlob);
        return p7envdata;
    }

    @Override
    public String SignedDataByP7_Sign(String Content2) {
        try {
            String p7signdata = this.safeEng.signDataPkcs7Base64(Content2, 3L);
            return p7signdata;
        }
        catch (Pkcs7SignException e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7EncodeException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SignedDataByP7_Verify(String content, String signature) throws SecurityEngineException, VerifyException {
        try {
            String signcert = this.safeEng.verifySignedDataPkcs7_cert(signature);
            return signcert;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7VerifySignException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SignedData_Sign(String Content2) {
        try {
            String signdata = this.safeEng.signDataPkcs1(Content2, 3L);
            return signdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaSignException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SignedFile_Sign(String filename) {
        try {
            String signdata = this.safeEng.signFile(filename, 3L);
            return signdata;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaSignException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean SignedData_Verify(String Content2, String signature, String cert) throws SecurityEngineException, VerifyException {
        try {
            boolean ret = this.safeEng.verifySignedDataPkcs1(Content2, signature, cert, 3L);
            return ret;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (HashException e) {
            e.printStackTrace();
            return false;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
        catch (VerifySignDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SignedData_Verify(String Content2, String signature, byte[] cert) throws SecurityEngineException, VerifyException {
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        try {
            boolean ret = rsaUtil.BJK_RsaVerify(this.apiEngine, Content2.getBytes(), signature, cert, 3L);
            return ret;
        }
        catch (HashException e) {
            e.printStackTrace();
            return false;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (VerifySignDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SignedData_Verify(byte[] Content2, int Length2, String signature, String cert) throws SecurityEngineException, VerifyException {
        byte[] conbuf = new byte[Length2];
        System.arraycopy(Content2, 0, conbuf, 0, Length2);
        Base64Util base64Util = new Base64Util(applicationName);
        try {
            byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
            RsaUtil rsaUtil = new RsaUtil(applicationName);
            boolean ret = rsaUtil.BJK_RsaVerify(this.apiEngine, conbuf, signature, certbuf, 3L);
            return ret;
        }
        catch (HashException e) {
            e.printStackTrace();
            return false;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (VerifySignDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SignedFile_Verify(String filepath, String signature, String cert) throws SecurityEngineException, VerifyException {
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        try {
            boolean ret = rsaUtil.BJK_RsaVerify_File(this.apiEngine, filepath, signature, cert, 3L);
            return ret;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (HashException e) {
            e.printStackTrace();
            return false;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
        catch (VerifySignDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean Certificate_IsValid(String cert) throws SecurityEngineException, VerifyException {
        boolean isValidate = false;
        try {
            int result = this.safeEng.validateCert(cert);
            if (result == 1) {
                isValidate = true;
            } else {
                if (result == 0) {
                    throw new VerifyException("\u7a0b\u5e8f\u51fa\u9519");
                }
                if (result == -1) {
                    throw new VerifyException("\u8bc1\u4e66\u4e0d\u88ab\u4fe1\u4efb");
                }
                if (result == -2) {
                    throw new VerifyException("\u8bc1\u4e66\u5df2\u8fc7\u671f\uff01");
                }
                if (result == -3) {
                    throw new VerifyException("\u8bc1\u4e66\u5df2\u88ab\u540a\u9500\uff01");
                }
            }
            return isValidate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int Certificate_CheckValidaty(String usrCert, String sDate) {
        Base64Util base64Util = new Base64Util(applicationName);
        byte[] certbuf = base64Util.BJS_DecodeBase64(usrCert);
        int iday = this.safeEng.BJC_CheckCertValidaty(certbuf, sDate);
        return iday;
    }

    @Override
    public String Certificate_GetUniqIdOidByCAId(String caId) {
        String uniqIdOid = this.safeEng.BJC_GetUniqIdOidByCAId(caId);
        return uniqIdOid;
    }

    @Override
    public String Certificate_GetInfo(String cert, long infoType) {
        try {
            String info = this.safeEng.getCertInfo(cert, (int)infoType);
            return info;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String Certificate_GetExtInfo(String cert, String infoType) {
        String info = null;
        try {
            String deptinfo;
            info = infoType != null && infoType.equals("2.16.840.1.113732.2") ? ((deptinfo = this.safeEng.getCertInfoByOid(cert, "1.2.86.11.7.1.8")) != null && !deptinfo.equals("") ? deptinfo : this.safeEng.getCertInfoByOid(cert, infoType)) : this.safeEng.getCertInfoByOid(cert, infoType);
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return null;
        }
        return info;
    }

    @Override
    public String EncodedData_EncodeBase64(byte[] bData) {
        Base64Util base64Util = new Base64Util(applicationName);
        String sdata = base64Util.BJS_EncodeBase64(bData);
        return sdata;
    }

    @Override
    public byte[] EncodedData_DecodeBase64(String sData) {
        Base64Util base64Util = new Base64Util(applicationName);
        byte[] bdata = base64Util.BJS_DecodeBase64(sData);
        return bdata;
    }

    @Override
    public String HashData(long ALGID, byte[] bData) {
        HashUtil hashUtil = new HashUtil(applicationName);
        try {
            String sdata = hashUtil.BJS_Hash(this.apiEngine, ALGID, bData, bData.length);
            return sdata;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String TimeStamp_Request(byte[] bData, long ALGID) {
        TsUtil tsUtil = new TsUtil(applicationName);
        try {
            String sdata = tsUtil.BJT_TSRequest(this.apiEngine, bData, bData.length, ALGID);
            return sdata;
        }
        catch (TsException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String TimeStamp_Response(String Content2) {
        try {
            String p7tsdata = this.safeEng.createTimeStampResponse(Content2);
            return p7tsdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (TsException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String TimeStamp_GetInfo(String timereponse, int type) {
        try {
            String info = this.safeEng.getTimeStampInfo(timereponse, type);
            return info;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (TsException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String TimeStamp_Verify(String content, String tsResponseData) throws SecurityEngineException, VerifyException {
        TsUtil tsUtil = new TsUtil(applicationName);
        try {
            String signcert = tsUtil.BJT_TSVerify_cert(this.apiEngine, content, tsResponseData, 3L);
            return signcert;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (TsException e) {
            e.printStackTrace();
            return null;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SignedDataXML_Sign(String xmlsrc) {
        try {
            String ret = this.safeEng.signDataXML(xmlsrc, 3L);
            return ret;
        }
        catch (XmlSignException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean SignedDataXML_Verify(String xmlsign) {
        try {
            boolean ret = this.safeEng.verifySignedDataXML(xmlsign, 3L);
            return ret;
        }
        catch (XmlVerifySignException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getXMLSignatureInfo(String xmlsign, int type) throws JDOMException {
        try {
            String ret = this.safeEng.getXMLSignatureInfo(xmlsign, (short)type);
            return ret;
        }
        catch (GetXMLSignInfoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String GetPlainInPut(String serverRand, String inputString) {
        try {
            int i;
            Base64Util base64Util = new Base64Util(applicationName);
            HashUtil hashUtil = new HashUtil(applicationName);
            CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
            byte[] rand1 = base64Util.BJS_DecodeBase64(serverRand);
            byte[] inputBlob = base64Util.BJS_DecodeBase64(inputString);
            for (i = 0; i < 8; ++i) {
                byte index = inputBlob[7 - i];
                byte tmp = inputBlob[16 + index];
                inputBlob[16 + index] = inputBlob[15 - i];
                inputBlob[15 - i] = tmp;
            }
            byte[] data2Hash = new byte[128];
            for (i = 0; i < 8; ++i) {
                data2Hash[i] = rand1[i];
                data2Hash[8 + i] = inputBlob[8 + i];
            }
            String sbjca = "www.bjca.org.cn";
            byte[] byteBjca = sbjca.getBytes();
            for (i = 0; i < sbjca.getBytes().length; ++i) {
                data2Hash[16 + i] = byteBjca[i];
            }
            byte[] rand3 = hashUtil.BJS_HashBytes(this.apiEngine, 2L, data2Hash, 16 + sbjca.getBytes().length);
            byte[] data2Dec = new byte[inputBlob.length - 16];
            for (i = 0; i < inputBlob.length - 16; ++i) {
                data2Dec[i] = inputBlob[16 + i];
            }
            String encbuf = base64Util.BJS_EncodeBase64(data2Dec);
            byte[] ret = cryptoUtil.BJS_SymmDecrypt(this.apiEngine, 100L, 1L, rand3, 8L, rand3, encbuf);
            return new String(ret);
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String GetPlainInPut2(String PassEncstr, String sRand) {
        try {
            byte[] pass = this.safeEng.BJ_GetPlainInPut2(PassEncstr, sRand);
            if (pass == null) {
                return null;
            }
            return new String(pass);
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SecertSegment(String Secert, int n, int d, int MustNum) {
        try {
            String secret = this.safeEng.secretSegment(Secert, n, d, MustNum);
            return secret;
        }
        catch (SecretSegmentException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SecertRecovery(String sIndata) {
        try {
            String secret = this.safeEng.secretRecovery(sIndata);
            return secret;
        }
        catch (SecretRecoveryException e) {
            e.printStackTrace();
            return null;
        }
    }
}

