/*
 * Decompiled with CFR 0.152.
 */
package xjyb.com.bjca.security;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.ArrayList;
import sun.misc.BASE64Decoder;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.java.security.SecurityEngine;
import xjyb.cn.org.bjca.java.utils.CryptoUtil;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.java.utils.Pkcs7Util;
import xjyb.cn.org.bjca.java.utils.RsaUtil;
import xjyb.cn.org.bjca.java.utils.TsUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.CertificateUtil;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.com.bjca.security.SecurityEngineDeal;
import xjyb.com.bjca.security.exception.SecurityEngineException;
import xjyb.com.bjca.security.exception.VerifyException;

public class SecurityEngineDeal_oldJava
extends SecurityEngineDeal {
    private SecurityEngine safeEng = null;
    ArrayList fileList = new ArrayList();
    ArrayList stringList = new ArrayList();
    private static long Alg_Enc = 106L;

    public SecurityEngineDeal_oldJava(String appName) throws FileNotFoundException, KeyStoreException, NoSuchAlgorithmException, CertificateException, JDOMException, IOException, InitException {
        LoggerUtil.systemlog(appName, "\u751f\u6210 <" + appName + "> \u5e94\u7528\u7684 SecurityEngineDeal \u5b9e\u4f8b\uff01");
        this.safeEng = new SecurityEngine(appName);
        boolean isSuccess = this.safeEng.initialApp(appName);
        if (!isSuccess) {
            return;
        }
        LoggerUtil.systemlog(appName, "<" + appName + "> \u5e94\u7528\u7684\u5b9e\u4f8b\uff0c\u521d\u59cb\u5316\u5b8c\u6210>\uff01");
    }

    @Override
    public void initAppValue() {
        this.safeEng.setAppValue(applicationName);
    }

    @Override
    public void initP7Cert() {
        boolean isSuccess = this.safeEng.initP7Cert();
        if (isSuccess) {
            LoggerUtil.systemlog(applicationName, "\u518d\u6b21\u66f4\u65b0\u6839\u8bc1\u4e66\u6210\u529f\uff01");
        } else {
            LoggerUtil.systemlog(applicationName, "\u518d\u6b21\u66f4\u65b0\u6839\u8bc1\u4e66\u5931\u8d25\uff01");
        }
    }

    @Override
    public void verifyCRL() {
        try {
            this.safeEng.verifyCRL();
        }
        catch (Exception e) {
            LoggerUtil.debuglog(applicationName, "Verfy crl error !");
            LoggerUtil.errorlog(applicationName, "Verfy crl error !");
            e.printStackTrace();
        }
    }

    public SecurityEngine getSafeEng() throws InitException {
        if (this.safeEng == null) {
            LoggerUtil.debuglog(applicationName, "\u521d\u59cb\u5316\u672a\u5b8c\u6210\uff01");
            LoggerUtil.errorlog(applicationName, "\u521d\u59cb\u5316\u672a\u5b8c\u6210\uff01");
            throw new InitException("\u521d\u59cb\u5316\u672a\u5b8c\u6210\uff01");
        }
        return this.safeEng;
    }

    @Override
    public String getApplicationName() {
        return applicationName;
    }

    @Override
    public void setDebug(boolean isDebug) throws InitException {
        if (applicationName == null) {
            throw new InitException("\u6ca1\u6709\u521d\u59cb\u5316\uff01");
        }
        if (isDebug) {
            LoggerUtil.setDebug(applicationName, "true");
        } else {
            LoggerUtil.setDebug(applicationName, "false");
        }
    }

    @Override
    public boolean finalizeBjapi() {
        return false;
    }

    @Override
    public boolean SetContainer(String container) {
        return false;
    }

    @Override
    public boolean ChangePin(String oldPin, String newPin) {
        return false;
    }

    @Override
    public String GetServerCertificate() throws Base64Exception {
        return this.safeEng.getEncryptCertString();
    }

    @Override
    public byte[] GetServerCertificateBytes() {
        return this.safeEng.getEncryptCertBytes();
    }

    @Override
    public String GetSignCertificate() throws Base64Exception {
        String cert = this.safeEng.getSignCertString();
        return cert;
    }

    @Override
    public byte[] GetSignCertificateBytes() {
        byte[] cert = this.safeEng.getSignCertBytes();
        return cert;
    }

    @Override
    public String GetRandom() throws RandomNumberException, Base64Exception {
        return this.safeEng.getRandomString();
    }

    @Override
    public String GetRandom(int len) throws RandomNumberException, Base64Exception {
        return this.safeEng.getRandomString(len);
    }

    @Override
    public byte[] GetRandomBytes(int len) throws RandomNumberException {
        byte[] random = this.safeEng.getRandomByte(len);
        return random;
    }

    private long getNumFromString(String str) throws AlgorithmNotFoundException {
        if ("RSA-SHA1".equals(str)) {
            return 3L;
        }
        if ("RSA-MD5".equals(str)) {
            return 2L;
        }
        if ("RSA-MD2".equals(str)) {
            return 1L;
        }
        if ("DES".equals(str)) {
            return 100L;
        }
        if ("T-DES2KEY".equals(str)) {
            return 101L;
        }
        if ("T-DES".equals(str)) {
            return 102L;
        }
        if ("SSF33".equals(str)) {
            return 103L;
        }
        if ("AES-128".equals(str)) {
            return 108L;
        }
        if ("AES-192".equals(str)) {
            return 107L;
        }
        if ("AES-256".equals(str)) {
            return 106L;
        }
        throw new AlgorithmNotFoundException("\u6b64\u7b97\u6cd5\u65e0\u6548\uff01");
    }

    @Override
    public boolean SymmEncrypt_SetAlg(String Alg2) {
        try {
            if (Alg2.equalsIgnoreCase("AES-256")) {
                Alg_Enc = 106L;
            } else if (Alg2.equalsIgnoreCase("AES-128")) {
                Alg_Enc = 108L;
            } else if (Alg2.equalsIgnoreCase("AES-192")) {
                Alg_Enc = 107L;
            } else if (Alg2.equalsIgnoreCase("T-DES")) {
                Alg_Enc = 102L;
            } else if (Alg2.equalsIgnoreCase("T-DES2KEY")) {
                Alg_Enc = 101L;
            } else if (Alg2.equalsIgnoreCase("DES")) {
                Alg_Enc = 100L;
            } else {
                throw new SecurityEngineException(-7L);
            }
            return true;
        }
        catch (SecurityEngineException see) {
            System.err.println("\u51fa\u73b0\u9519\u8bef\uff1a" + see.getExcptionDetail());
            see.printStackTrace();
            return false;
        }
    }

    @Override
    public String SymmEncrypt_Encrypt(String toBeEncryptedBlob, byte[] key) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        Base64Util base64Util = new Base64Util(applicationName);
        byte[] sdata = null;
        sdata = cryptoUtil.encryptData_3des_cbc(iv, key, toBeEncryptedBlob.getBytes());
        String outData = null;
        outData = base64Util.BJS_EncodeBase64(sdata);
        return outData;
    }

    @Override
    public boolean SymmEncrypt_File(String srcfile, String destfile, String key, long EncAlg) {
        Base64Util base64Util = new Base64Util(applicationName);
        FileUtil fileUtil = new FileUtil(applicationName);
        byte[] keybuf = base64Util.BJS_DecodeBase64(key);
        boolean rv = fileUtil.BJS_SymmEncFile(srcfile, destfile, keybuf, EncAlg, 2L);
        return rv;
    }

    @Override
    public boolean SymmEncrypt_File(String srcfile, String destfile, byte[] key, long EncAlg) {
        FileUtil fileUtil = new FileUtil(applicationName);
        boolean rv = fileUtil.BJS_SymmEncFile(srcfile, destfile, key, EncAlg, 2L);
        return rv;
    }

    @Override
    public boolean SymmDecrypt_File(String srcfile, String destfile, String key, long EncAlg) {
        Base64Util base64Util = new Base64Util(applicationName);
        FileUtil fileUtil = new FileUtil(applicationName);
        try {
            byte[] keybuf = base64Util.BJS_DecodeBase64(key);
            boolean rv = fileUtil.BJS_SymmDecFile(srcfile, destfile, keybuf, EncAlg, 2L);
            return rv;
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SymmDecrypt_File(String srcfile, String destfile, byte[] key, long EncAlg) {
        FileUtil fileUtil = new FileUtil(applicationName);
        try {
            boolean rv = fileUtil.BJS_SymmDecFile(srcfile, destfile, key, EncAlg, 2L);
            return rv;
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String SymmEncrypt_Encrypt(long ALGID, String toBeEncryptedBlob, byte[] key) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            String sdata = cryptoUtil.encryptData_des_ecb(102L, 2L, key, iv, toBeEncryptedBlob.getBytes());
            return sdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (EncryptDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SymmEncrypt_Encrypt(String toBeEncryptedBlob, String key) {
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        try {
            sKey = new BASE64Decoder().decodeBuffer(key);
            CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
            String sdata = cryptoUtil.encryptData_des_ecb(102L, 2L, sKey, iv, toBeEncryptedBlob.getBytes());
            return sdata;
        }
        catch (Exception e) {
            try {
                throw new SecurityEngineException(-201L);
            }
            catch (SecurityEngineException see) {
                System.err.println("\u51fa\u73b0\u9519\u8bef\uff1a" + see.getExcptionDetail());
                see.printStackTrace();
                return null;
            }
        }
    }

    @Override
    public byte[] SymmEncrypt_Decrypt(String beEncryptedBlob, byte[] key) {
        Base64Util base64Util = new Base64Util(applicationName);
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            byte[] sdata = cryptoUtil.decryptData_3des_cbc(key, iv, base64Util.BJS_DecodeBase64(beEncryptedBlob));
            return sdata;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] SymmEncrypt_Decrypt(long ALGID, String beEncryptedBlob, byte[] key) {
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            byte[] sdata = cryptoUtil.decryptData_des_ecb(ALGID, 2L, key, iv, beEncryptedBlob);
            return sdata;
        }
        catch (DecryptDataException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public byte[] SymmEncrypt_Decrypt(String beEncryptedBlob, String key) {
        byte[] sKey = null;
        byte[] iv = new byte[8];
        for (int i = 0; i < 8; ++i) {
            iv[i] = (byte)(i + 2);
        }
        CryptoUtil cryptoUtil = new CryptoUtil(applicationName);
        try {
            sKey = new BASE64Decoder().decodeBuffer(key);
            byte[] sdata = cryptoUtil.decryptData_des_ecb(Alg_Enc, 2L, sKey, iv, beEncryptedBlob);
            return sdata;
        }
        catch (Exception e) {
            try {
                throw new SecurityEngineException(-201L);
            }
            catch (SecurityEngineException see) {
                System.err.println("\u51fa\u73b0\u9519\u8bef\uff1a" + see.getExcptionDetail());
                see.printStackTrace();
                return null;
            }
        }
    }

    @Override
    public String EncryptedData_Encrypt(String toBeEncryptedBlob, String cert) {
        Base64Util base64Util = new Base64Util(applicationName);
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        try {
            byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
            byte[] enData = rsaUtil.BJK_RsaEncrypt(toBeEncryptedBlob.getBytes(), certbuf);
            return base64Util.BJS_EncodeBase64(enData);
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaEncryptException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EncryptedData_Encrypt(String toBeEncryptedBlob, byte[] cert) {
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        Base64Util base64Util = new Base64Util(applicationName);
        try {
            byte[] enData = rsaUtil.BJK_RsaEncrypt(toBeEncryptedBlob.getBytes(), cert);
            return base64Util.BJS_EncodeBase64(enData);
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaEncryptException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EncryptedData_Decrypt(String encryptedBlob) {
        Base64Util base64U = new Base64Util(applicationName);
        try {
            byte[] sdata = this.safeEng.priKeyDecrypt(base64U.BJS_DecodeBase64(encryptedBlob));
            return new String(sdata);
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaDecryptException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EnvelopedData_Encrypt(String toBeEncryptedBlob, String cert) {
        Base64Util base64Util = new Base64Util(applicationName);
        Pkcs7Util pkcs7Util = new Pkcs7Util(applicationName);
        try {
            byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
            byte[] p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelope(toBeEncryptedBlob.getBytes(), certbuf, 100L);
            return base64Util.BJS_EncodeBase64(p7envdata);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String EnvelopedData_Encrypt(String toBeEncryptedBlob, byte[] cert) {
        Pkcs7Util pkcs7Util = new Pkcs7Util(applicationName);
        Base64Util base64U = new Base64Util(applicationName);
        try {
            byte[] p7envdata = pkcs7Util.BJE_Pkcs7EncodeEnvelope(toBeEncryptedBlob.getBytes(), cert, 100L);
            return base64U.BJS_EncodeBase64(p7envdata);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EnvelopedData_Decrypt(String beEncryptedBlob) {
        Base64Util base64U = new Base64Util(applicationName);
        try {
            byte[] enByte = base64U.BJS_DecodeBase64(beEncryptedBlob);
            byte[] p7envdata = this.safeEng.decodeP7EnvelopedData(enByte);
            return new String(p7envdata);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String EnvelopedDataEx_Encrypt(String toBeEncryptedBlob, String cert) {
        return null;
    }

    @Override
    public String EnvelopedDataEx_Encrypt(String toBeEncryptedBlob, byte[] cert) {
        return null;
    }

    @Override
    public String EnvelopedDataEx_Decrypt(String beEncryptedBlob) {
        return null;
    }

    @Override
    public String SignedDataByP7_Sign(String Content2) {
        try {
            String p7signdata = this.safeEng.signDataPkcs7Base64(Content2, 3L);
            return p7signdata;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SignedDataByP7_Verify(String content, String signature) throws SecurityEngineException, VerifyException {
        String returnStr = null;
        try {
            boolean verifyRes = this.safeEng.verifySignedDataPkcs7(signature);
            String inData = this.safeEng.getP7SignDataInfo(signature, 1);
            Base64Util base64Util = new Base64Util("");
            byte[] contentByte = base64Util.BJS_DecodeBase64(content);
            if (contentByte != null && !inData.equals(new String(contentByte))) {
                throw new VerifyException("content is not match");
            }
            if (verifyRes) {
                returnStr = this.safeEng.getP7SignDataInfo(signature, 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return returnStr;
    }

    @Override
    public String SignedData_Sign(String Content2) {
        try {
            byte[] signedData = this.safeEng.signData(Content2.getBytes(), 3L);
            Base64Util base64Util = new Base64Util(applicationName);
            String base64SignedData = base64Util.BJS_EncodeBase64(signedData);
            return base64SignedData;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaSignException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SignedFile_Sign(String filename) {
        try {
            String signdata = this.safeEng.signFile(filename, 3L);
            return signdata;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
        catch (RsaSignException e) {
            e.printStackTrace();
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean SignedData_Verify(String Content2, String signature, String cert) throws SecurityEngineException, VerifyException {
        try {
            Base64Util base64Util = new Base64Util(applicationName);
            byte[] signatureByte = base64Util.BJS_DecodeBase64(signature);
            boolean ret = this.safeEng.verifySignedData(Content2.getBytes(), signatureByte, cert, 3L);
            return ret;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (HashException e) {
            e.printStackTrace();
            return false;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
        catch (VerifySignDataException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SignedData_Verify(String Content2, String signature, byte[] cert) throws SecurityEngineException, VerifyException {
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        Base64Util base64U = new Base64Util(applicationName);
        try {
            byte[] signatureByte = base64U.BJS_DecodeBase64(signature);
            boolean ret = rsaUtil.BJK_RsaVerifyNoHash(Content2.getBytes(), signatureByte, cert, 3L);
            return ret;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SignedData_Verify(byte[] Content2, int Length2, String signature, String cert) throws SecurityEngineException, VerifyException {
        byte[] conbuf = new byte[Length2];
        System.arraycopy(Content2, 0, conbuf, 0, Length2);
        Base64Util base64Util = new Base64Util(applicationName);
        try {
            byte[] certbuf = base64Util.BJS_DecodeBase64(cert);
            byte[] signatureByte = base64Util.BJS_DecodeBase64(signature);
            RsaUtil rsaUtil = new RsaUtil(applicationName);
            boolean ret = rsaUtil.BJK_RsaVerifyNoHash(conbuf, signatureByte, certbuf, 3L);
            return ret;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean SignedFile_Verify(String filepath, String signature, String cert) throws SecurityEngineException, VerifyException {
        RsaUtil rsaUtil = new RsaUtil(applicationName);
        try {
            boolean ret = rsaUtil.BJK_RsaVerify_File(filepath, signature, cert, 3L);
            return ret;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return false;
        }
        catch (HashException e) {
            e.printStackTrace();
            return false;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean Certificate_IsValid(String cert) throws SecurityEngineException, VerifyException {
        boolean isValidate = false;
        try {
            int result = this.safeEng.validateCert(cert);
            if (result == 1) {
                isValidate = true;
            } else {
                if (result == 0) {
                    throw new VerifyException("\u7a0b\u5e8f\u51fa\u9519");
                }
                if (result == -1) {
                    throw new VerifyException("\u8bc1\u4e66\u4e0d\u88ab\u4fe1\u4efb");
                }
                if (result == -2) {
                    throw new VerifyException("\u8bc1\u4e66\u5df2\u8fc7\u671f\uff01");
                }
                if (result == -3) {
                    throw new VerifyException("\u8bc1\u4e66\u5df2\u88ab\u540a\u9500\uff01");
                }
                if (result == -4) {
                    throw new VerifyException("\u5df2\u52a0\u5165\u9ed1\u540d\u5355\uff01");
                }
                if (result == -5) {
                    throw new VerifyException("\u8bc1\u4e66\u672a\u751f\u6548\uff01");
                }
            }
            return isValidate;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int Certificate_CheckValidaty(String usrCert, String sDate) {
        Base64Util base64Util = new Base64Util(applicationName);
        CertificateUtil certUtil = new CertificateUtil(applicationName);
        try {
            byte[] certbuf = base64Util.BJS_DecodeBase64(usrCert);
            int iday = certUtil.BJC_CheckCertValidity(certbuf, sDate);
            return iday;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public String Certificate_GetUniqIdOidByCAId(String caId) {
        String uniqIdOid = this.safeEng.BJC_GetUniqIdOidByCAId(caId);
        return uniqIdOid;
    }

    @Override
    public String Certificate_GetInfo(String cert, long infoType) {
        try {
            String info = this.safeEng.getCertInfo(cert, (int)infoType);
            return info;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String Certificate_GetExtInfo(String cert, String infoType) {
        try {
            return this.safeEng.getCertInfoByOid(cert, infoType);
        }
        catch (Base64Exception e) {
            e.printStackTrace();
        }
        catch (GetCertInfoException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String EncodedData_EncodeBase64(byte[] bData) {
        Base64Util base64Util = new Base64Util(applicationName);
        String sdata = base64Util.BJS_EncodeBase64(bData);
        return sdata;
    }

    @Override
    public byte[] EncodedData_DecodeBase64(String sData) {
        Base64Util base64Util = new Base64Util(applicationName);
        byte[] bdata = base64Util.BJS_DecodeBase64(sData);
        return bdata;
    }

    @Override
    public String HashData(long ALGID, byte[] bData) {
        HashUtil hashUtil = new HashUtil(applicationName);
        Base64Util base64U = new Base64Util(applicationName);
        try {
            byte[] hashedData = hashUtil.BJS_HashBytes(ALGID, bData);
            return base64U.BJS_EncodeBase64(hashedData);
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String TimeStamp_Request(byte[] bData, long ALGID) {
        TsUtil tsUtil = new TsUtil(applicationName);
        try {
            return this.safeEng.createTimeStampRequest(bData, 3L);
        }
        catch (TsException e) {
            e.printStackTrace();
        }
        catch (Base64Exception e) {
            e.printStackTrace();
        }
        catch (HashException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String TimeStamp_Response(String Content2) {
        try {
            String p7tsdata = this.safeEng.createTimeStampResponse(Content2, true);
            return p7tsdata;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (TsException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String TimeStamp_GetInfo(String timereponse, int type) {
        try {
            String info = this.safeEng.getTimeStampInfo(timereponse, type);
            return info;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (TsException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7DecodeException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String TimeStamp_Verify(String content, String tsResponseData) throws SecurityEngineException, VerifyException {
        try {
            boolean isSuccess = this.safeEng.verifyTimeStamp(content, tsResponseData, null, 3L);
            if (isSuccess) {
                return this.safeEng.getTimeStampInfo(tsResponseData, 3);
            }
            return null;
        }
        catch (Base64Exception e) {
            e.printStackTrace();
            return null;
        }
        catch (TsException e) {
            e.printStackTrace();
            return null;
        }
        catch (HashException e) {
            e.printStackTrace();
            return null;
        }
        catch (Pkcs7DecodeException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SignedDataXML_Sign(String xmlsrc) {
        try {
            String ret = this.safeEng.signDataXML(xmlsrc, 3L);
            return ret;
        }
        catch (XmlSignException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean SignedDataXML_Verify(String xmlsign) {
        try {
            boolean ret = this.safeEng.verifySignedDataXML(xmlsign, 3L);
            return ret;
        }
        catch (XmlVerifySignException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public String getXMLSignatureInfo(String xmlsign, int type) {
        try {
            String ret = this.safeEng.getXMLSignatureInfo(xmlsign, (short)type);
            return ret;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SecertSegment(String Secert, int n, int d, int MustNum) {
        try {
            String secret = this.safeEng.secretSegment(Secert, n, d, MustNum);
            return secret;
        }
        catch (SecretSegmentException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String SecertRecovery(String sIndata) {
        try {
            String secret = this.safeEng.secretRecovery(sIndata);
            return secret;
        }
        catch (SecretRecoveryException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String GetPlainInPut(String serverRand, String inputString) {
        return null;
    }

    @Override
    public String GetPlainInPut2(String PassEncstr, String rand) {
        return null;
    }
}

