/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.jni.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.ArrayList;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.bjcasafeapi.BjcaApiEngine;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.ParameterNotSupportException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RandomNumberException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.RsaVerifySignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.jni.security.SecurityEngine;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.HashUtil;

public class SecurityEngineDeal_jni
extends SecurityEngineDeal {
    private SecurityEngine safeEng = null;
    private String signMethod = "RSA-SHA1";
    private long signMethodNum = 3L;
    private String encryptMethod = "T-DES";
    private long encryptMethodNum = 102L;
    ArrayList fileList = new ArrayList();
    ArrayList stringList = new ArrayList();
    private String applicationName;

    public SecurityEngineDeal_jni(String appName) throws JDOMException, IOException, InitException {
        LoggerUtil.systemlog(appName, "Generating <" + appName + "> application's SecurityEngineDeal instance !");
        this.safeEng = new SecurityEngine(appName);
        this.applicationName = appName;
        BjcaApiEngine apiEng = this.safeEng.initialApp(appName);
        boolean isLoginSuccess = this.safeEng.loginApp();
        if (apiEng == null || !isLoginSuccess) {
            return;
        }
        LoggerUtil.systemlog(appName, "<" + appName + "> application's instance initComplete !");
    }

    public SecurityEngine getSafeEng() throws InitException {
        if (this.safeEng == null) {
            LoggerUtil.errorlog(this.applicationName, "SecurityEngine failed to initialize!");
            LoggerUtil.debuglog(this.applicationName, "SecurityEngine failed to initialize!");
            throw new InitException("SecurityEngine failed to initialize!");
        }
        return this.safeEng;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void setDebug(boolean isDebug) throws InitException {
        if (this.applicationName == null) {
            LoggerUtil.errorlog(this.applicationName, "Application failed to initialize!");
            LoggerUtil.debuglog(this.applicationName, "Application failed to initialize!");
            throw new InitException("Application failed to initialize!");
        }
        if (isDebug) {
            LoggerUtil.setDebug(this.applicationName, "true");
        } else {
            LoggerUtil.setDebug(this.applicationName, "false");
        }
    }

    @Override
    public void initAppValue() {
        this.safeEng.setAppValue(this.applicationName);
    }

    @Override
    public void initP7Cert() {
        boolean isSuccess = this.safeEng.initP7Cert();
        if (isSuccess) {
            LoggerUtil.systemlog(this.applicationName, "Reload p7 cert success!");
        } else {
            LoggerUtil.systemlog(this.applicationName, "Reload p7 cert failed!");
        }
    }

    @Override
    public void verifyCRL() {
        try {
            this.safeEng.verifyCRL();
        }
        catch (Exception e) {
            LoggerUtil.debuglog(this.applicationName, "\u9a8c\u8bc1CRL\u5931\u8d25", e);
            LoggerUtil.errorlog(this.applicationName, "\u9a8c\u8bc1CRL\u5931\u8d25", e);
        }
    }

    @Override
    public void setSignMethod(String method) throws AlgorithmNotFoundException {
        this.signMethod = method;
        this.signMethodNum = this.getNumFromString(method);
    }

    @Override
    public String getSignMethod() {
        return this.signMethod;
    }

    public void setEncryptMethod(String method) throws AlgorithmNotFoundException {
        this.encryptMethod = method;
        this.encryptMethodNum = this.getNumFromString(method);
    }

    @Override
    public String getEncryptMethod() {
        return this.encryptMethod;
    }

    @Override
    public String getServerCertificate() throws Base64Exception {
        String signCert = this.safeEng.getSignCertString();
        if (signCert != null && !"".equals(signCert)) {
            return signCert;
        }
        return this.safeEng.getEncryptCertString();
    }

    @Override
    public String getServerCertificate(int certUsage) throws Base64Exception {
        if (certUsage == 1) {
            return this.safeEng.getEncryptCertString();
        }
        if (certUsage == 2) {
            return this.safeEng.getSignCertString();
        }
        return null;
    }

    @Override
    public String genRandom() throws RandomNumberException, Base64Exception {
        return this.safeEng.getRandomString();
    }

    @Override
    public String genRandom(int len) throws RandomNumberException, Base64Exception {
        return this.safeEng.getRandomString(len);
    }

    @Override
    public String getCertInfo(String base64EncodeCert, int type) throws Base64Exception, GetCertInfoException {
        return this.safeEng.getCertInfo(base64EncodeCert, type);
    }

    @Override
    public String getCertInfoByOid(String base64EncodeCert, String oid) throws Base64Exception, GetCertInfoException {
        return this.safeEng.getCertInfoByOid(base64EncodeCert, oid);
    }

    @Override
    public int validateCert(String base64EncodeCert) throws CertificateException, Base64Exception, ValidateCertException, GetCertInfoException {
        return this.safeEng.validateCert(base64EncodeCert);
    }

    @Override
    public String signData(String inData) throws Base64Exception, HashException, RsaSignException {
        return this.safeEng.signDataPkcs1(inData, this.signMethodNum);
    }

    @Override
    public String signData(byte[] inData) throws Base64Exception, HashException, RsaSignException {
        return this.safeEng.signDataPkcs1(inData, this.signMethodNum);
    }

    @Override
    public String signDataWithoutZ(String inData) throws Base64Exception, HashException {
        return this.signDataWithoutZ(inData.getBytes());
    }

    @Override
    public String signDataWithoutZ(byte[] inDataBytes) throws Base64Exception, HashException {
        LoggerUtil.errorlog("error", "Jni\u672a\u5b9e\u73b0\u65b9\u6cd5signDataWithoutZ(String inData)\uff01");
        return null;
    }

    @Override
    public boolean verifySignedDataWithoutZ(byte[] certBytes, byte[] inDataBytes, byte[] signedDataBytes) throws VerifySignDataException, HashException {
        LoggerUtil.errorlog("error", "Jni\u672a\u5b9e\u73b0\u65b9\u6cd5verifySignedDataWithoutZ(byte[] certBytes, byte[] inDataBytes, byte[] signedDataBytes)\uff01");
        return false;
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, String inData, String signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return this.safeEng.verifySignedDataPkcs1(inData, signValue, base64EncodeCert, this.signMethodNum);
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, byte[] inData, String signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return this.safeEng.verifySignedDataPkcs1(inData, signValue, base64EncodeCert, this.signMethodNum);
    }

    @Override
    public String signFile(String inFile) throws HashException, RsaSignException, Base64Exception {
        return this.safeEng.signFile(inFile, this.signMethodNum);
    }

    @Override
    public String hash_file(String inFile) throws HashException, RsaSignException, Base64Exception {
        return this.safeEng.hashFile(inFile, this.signMethodNum);
    }

    @Override
    public boolean verifySignedFile(String base64EncodeCert, String inFile, String signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return this.safeEng.verifySignedFile(base64EncodeCert, inFile, signValue, this.signMethodNum);
    }

    @Override
    public String secretSegment(String secert, int m3, int n, int k) throws SecretSegmentException {
        return this.safeEng.secretSegment(secert, m3, n, k);
    }

    @Override
    public String secretRecovery(String seg) throws SecretRecoveryException {
        return this.safeEng.secretRecovery(seg);
    }

    @Override
    public String encryptData(String key, String inData) throws EncryptDataException, IOException, Base64Exception {
        return this.safeEng.encryptData(key, inData, this.encryptMethodNum);
    }

    @Override
    public String decryptData(String key, String inData) throws DecryptDataException, Base64Exception, IOException {
        return this.safeEng.decryptData(key, inData, this.encryptMethodNum);
    }

    @Override
    public boolean encryptFile(String key, String inFile, String outFile) throws Base64Exception, EncryptDataException {
        return this.safeEng.encryptFile(key, inFile, outFile, this.encryptMethodNum);
    }

    @Override
    public boolean decryptFile(String key, String inFile, String outFile) throws Base64Exception, DecryptDataException {
        return this.safeEng.decryptFile(key, inFile, outFile, this.encryptMethodNum);
    }

    @Override
    public String pubKeyEncrypt(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        return this.safeEng.pubKeyEncrypt(base64EncodeCert, inData);
    }

    @Override
    public byte[] pubKeyEncrypt(String base64EncodeCert, byte[] inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        return this.safeEng.pubKeyEncrypt(base64EncodeCert, inData);
    }

    @Override
    public String priKeyDecrypt(String inData) throws Base64Exception, RsaDecryptException {
        return this.safeEng.priKeyDecrypt(inData);
    }

    @Override
    public boolean addSignFile(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return false;
        }
        this.fileList.add(filePath);
        return true;
    }

    @Override
    public boolean addSignString(String inData) {
        if (inData == null || "".equals(inData)) {
            return false;
        }
        this.stringList.add(inData);
        return true;
    }

    @Override
    public void clearAllSignData() {
        this.fileList.clear();
        this.stringList.clear();
    }

    public String signAll() throws RsaSignException, Base64Exception {
        return this.safeEng.signAll(this.fileList, this.stringList, this.signMethodNum);
    }

    @Override
    public boolean verifySignAll(String base64EncodeCert, String signValue) throws Base64Exception, GetCertInfoException, VerifySignDataException {
        return this.safeEng.verifySignAll(this.fileList, this.stringList, base64EncodeCert, signValue, this.signMethodNum);
    }

    @Override
    public String getTotalTsReq() throws TsException, Base64Exception {
        return this.safeEng.getTotalTsReq(this.fileList, this.stringList, this.signMethodNum);
    }

    @Override
    public String signDataPkcs7(String inData) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        return this.safeEng.signDataPkcs7(inData, this.signMethodNum);
    }

    @Override
    public boolean verifySignedDataPkcs7(String pkcs7SignData) throws Base64Exception, Pkcs7VerifySignException {
        return this.safeEng.verifySignedDataPkcs7(pkcs7SignData);
    }

    @Override
    public String getP7SignDataInfo(String pkcs7SignData, int type) throws Base64Exception, Pkcs7DecodeException {
        return this.safeEng.getP7SignDataInfo(pkcs7SignData, type);
    }

    @Override
    public String encodeP7EnvelopedData(String base64EncodeCert, String inData) throws Base64Exception, Pkcs7EncodeException, Pkcs7EncodeEnvelopeException {
        return this.safeEng.encodeP7EnvelopedData(base64EncodeCert, inData, this.encryptMethodNum);
    }

    @Override
    public String decodeP7EnvelopedData(String inData) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        return this.safeEng.decodeP7EnvelopedData(inData);
    }

    @Override
    public String encodeP7SignAndEnvelopData(String base64EncodeCert, String inData) throws Base64Exception, Pkcs7EncodeException, Pkcs7EncodeEnvelopeException {
        return this.safeEng.encodeSignAndEnvelopeData(base64EncodeCert, inData);
    }

    @Override
    public String decodeP7SignAndEnvelopData(String inData) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        return this.safeEng.decodeSignAndEnvelopeData(inData);
    }

    @Override
    public String signDataXML(String inData) throws XmlSignException {
        return this.safeEng.signDataXML(inData, this.signMethodNum);
    }

    @Override
    public boolean verifySignedDataXML(String inData) throws XmlVerifySignException {
        return this.safeEng.verifySignedDataXML(inData, this.signMethodNum);
    }

    @Override
    public String getXMLSignatureInfo(String XMLSignedData, int type) throws GetXMLSignInfoException, JDOMException {
        return this.safeEng.getXMLSignatureInfo(XMLSignedData, type);
    }

    @Override
    public String createTimeStampRequest(String inData) throws HashException, TsException, Base64Exception {
        return this.safeEng.createTimeStampRequest(inData, this.signMethodNum);
    }

    @Override
    public String createTimeStamp(String inData) throws Base64Exception, TsException {
        return this.safeEng.createTimeStampResponse(inData);
    }

    @Override
    public boolean verifyTimeStamp(String content, String tsResponseData) throws Base64Exception, TsException, HashException {
        return this.safeEng.verifyTimeStamp(content, tsResponseData, this.signMethodNum);
    }

    @Override
    public String getTimeStampInfo(String tsResponseData, int type) throws Base64Exception, TsException, ParseException {
        return this.safeEng.getTimeStampInfo(tsResponseData, type);
    }

    @Override
    public String base64Encode(byte[] inData) throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        return base64Util.BJS_EncodeBase64(inData);
    }

    @Override
    public byte[] base64Decode(String inData) throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        return base64Util.BJS_DecodeBase64(inData);
    }

    @Override
    public String hash_string(String inData) throws HashException, Base64Exception {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        Base64Util base64U = new Base64Util(this.applicationName);
        byte[] hashedData = hashUtil.BJS_HashBytes(0L, inData.getBytes());
        return base64U.BJS_EncodeBase64(hashedData);
    }

    private long getNumFromString(String str) throws AlgorithmNotFoundException {
        if ("RSA-SHA1".equals(str)) {
            return 3L;
        }
        if ("RSA-MD5".equals(str)) {
            return 2L;
        }
        if ("RSA-MD2".equals(str)) {
            return 1L;
        }
        if ("DES".equals(str)) {
            return 100L;
        }
        if ("T-DES2KEY".equals(str)) {
            return 101L;
        }
        if ("T-DES".equals(str)) {
            return 102L;
        }
        if ("SSF33".equals(str)) {
            return 103L;
        }
        if ("AES-128".equals(str)) {
            return 108L;
        }
        if ("AES-192".equals(str)) {
            return 107L;
        }
        if ("AES-256".equals(str)) {
            return 106L;
        }
        throw new AlgorithmNotFoundException("\u6b64\u7b97\u6cd5\u65e0\u6548\uff01");
    }

    @Override
    public String priKeyDecrypt_OAEP(String InData) throws Base64Exception, RsaDecryptException {
        return null;
    }

    @Override
    public String pubKeyEncrypt_OAEP(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        return null;
    }

    @Override
    public String pubKeyEncrypt_OAEP(String base64EncodeCert, byte[] inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        return null;
    }

    @Override
    public String signData(InputStream inputStream) throws HashException, RsaSignException, Base64Exception {
        return null;
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, InputStream inputStream, String signedValue) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        return false;
    }

    @Override
    public String getAllP7b() {
        return this.safeEng.getAllP7b();
    }

    @Override
    public boolean decryptData(String key, InputStream inData, OutputStream outData) throws DecryptDataException, IOException {
        return false;
    }

    @Override
    public boolean encryptData(String key, InputStream inData, OutputStream outData) throws EncryptDataException, IOException {
        return false;
    }

    @Override
    public byte[] signHashedData(byte[] hashedData) {
        return null;
    }

    @Override
    public byte[] hash_byte(byte[] inData) throws HashException {
        return null;
    }

    @Override
    public boolean verifySignatureByHashedData(String base64EncodeCert, byte[] hashedData, byte[] signedValue) throws VerifySignDataException {
        return false;
    }

    @Override
    public String createTSByOriginalData(String inData) throws Base64Exception, TsException {
        return null;
    }

    @Override
    public byte[] genRandomByte(int len) {
        return null;
    }

    @Override
    public byte[] decryptData(byte[] key, byte[] inData) throws Base64Exception {
        return null;
    }

    @Override
    public byte[] encryptData(byte[] key, byte[] inData) throws Base64Exception {
        return null;
    }

    @Override
    public String signDataPkcs7(byte[] inData) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        return null;
    }

    @Override
    public byte[] priKeyDecrypt(byte[] inData) throws Base64Exception, RsaDecryptException {
        return null;
    }

    @Override
    public String createTimeStampRequest(byte[] inData) throws HashException, TsException, Base64Exception {
        return null;
    }

    @Override
    public String createTSByOriginalData(byte[] inData) throws Base64Exception, TsException {
        return null;
    }

    @Override
    public String signDataPkcs7_detach(byte[] inData) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        return null;
    }

    @Override
    public String verifySignedDataPkcs7_detach(byte[] inData, String pkcs7SignedData) throws Base64Exception, Pkcs7VerifySignException {
        return null;
    }

    @Override
    public byte[] signDataReByte(byte[] inData) throws Base64Exception, HashException, RsaSignException {
        return null;
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, byte[] inData, byte[] signedValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return false;
    }

    @Override
    public String signDataPkcs7_file_detach(String filePath) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        return null;
    }

    @Override
    public boolean verifySignedDataPkcs7_file_detach(String filePath, String pkcs7SignedData) throws Base64Exception, Pkcs7VerifySignException {
        return false;
    }

    @Override
    public byte[] getP7SignDataInfo(byte[] pkcs7SignedData, int type) throws Pkcs7DecodeException, Base64Exception {
        return null;
    }

    @Override
    public String createTimeStampNoCert(String inData) throws Base64Exception, TsException {
        return null;
    }

    @Override
    public boolean verifyTimeStampByCert(String tsResponseData, byte[] cert) throws Base64Exception, TsException, HashException {
        return false;
    }

    @Override
    public byte[] signHashedDataPkcs7_detach(byte[] inData) throws Pkcs7SignException {
        return null;
    }

    @Override
    public String verifySignedDataPkcs7_detach_hash(byte[] hashedData, String pkcs7SignedData) throws Pkcs7VerifySignException {
        return null;
    }

    @Override
    public byte[] decodeP7EnvelopedData(byte[] inData) throws Pkcs7DecodeEnvelopeException {
        return null;
    }

    @Override
    public byte[] encodeP7EnvelopedData(String base64EncodeCert, byte[] inData) throws Base64Exception, Pkcs7EncodeEnvelopeException {
        return null;
    }

    @Override
    public byte[] createP7DetachedAndTimeStampedData(byte[] hashedOriginalData) throws GeneralSecurityException {
        return null;
    }

    @Override
    public int verifyP7DetachedAndTimeStampedData(byte[] byte1) {
        return 0;
    }

    @Override
    public byte[] createTimeStamp(byte[] tsRequest) throws TsException {
        return null;
    }

    @Override
    public byte[] createTimeStampRequest(byte[] inData, boolean isAttachCert) throws HashException {
        return null;
    }

    @Override
    public String getTimeStampInfo(byte[] timeStamp, int type) throws TsException {
        return null;
    }

    @Override
    public boolean verifyTimeStamp(byte[] timeStamp) throws TsException {
        return false;
    }

    @Override
    public boolean verifyTimeStampByCert(byte[] timeStamp, byte[] cert) throws TsException {
        return false;
    }

    @Override
    public String getP7DetachedAndTimeStampedDataInfo(byte[] byte1, int type) throws CertificateEncodingException, IOException {
        return null;
    }

    @Override
    public boolean verifySignedData(byte[] publicKey, byte[] inData, byte[] signedValue) throws VerifySignDataException {
        return false;
    }

    @Override
    public Object[] generatorKeyPair(int type, int length) throws IOException {
        return null;
    }

    @Override
    public byte[] signHashedDataPkcs7_detach(byte[] inData, boolean isAttribute) throws Pkcs7SignException {
        return null;
    }

    @Override
    public byte[] createP7DetachedAndTimeStampedData(byte[] p7sign, byte[] hashedOriginalData) throws GeneralSecurityException {
        return null;
    }

    @Override
    public byte[] generateP7DetachedByP7AndTimeStampedData(byte[] p7sign, byte[] timeStamp) throws GeneralSecurityException {
        return null;
    }

    @Override
    public byte[] decryptData(byte[] key, byte[] inData, int algorithm) {
        return null;
    }

    @Override
    public byte[] encryptData(byte[] key, byte[] inData, int algorithm) {
        return null;
    }

    @Override
    public byte[] hash_byte(byte[] inData, String cert) throws HashException {
        return null;
    }

    @Override
    public byte[] generatP7CounterSign(byte[] signData) throws IOException {
        return null;
    }

    @Override
    public String verifyP7CounterSign(byte[] counterSignData) throws CertificateException, Pkcs7DecodeException, Base64Exception, ValidateCertException, GetCertInfoException, HashException {
        return null;
    }

    @Override
    public byte[] createTimeStampRequestByHashedData(byte[] inData, boolean isAttachCert) throws TsException {
        return null;
    }

    @Override
    public byte[] createTimeStampRequestByFile(String filePath, boolean isAttachCert) throws TsException {
        return null;
    }

    @Override
    public int verifyTimeStampByFile(byte[] timeStamp, String inFile) throws TsException {
        return 0;
    }

    @Override
    public byte[] createTimeStampRequestByLargebinary(byte[] inData, boolean isAttachCert) throws TsException {
        return null;
    }

    @Override
    public int verifyTimeStampByLargebinary(byte[] timeStamp, byte[] inData) throws TsException {
        return 0;
    }

    @Override
    public byte[] generatP7CounterSignYbq(byte[] signData, String oids) throws IOException, Pkcs7SignException, Pkcs7DecodeException, HashException, InvalidKeyException, CertificateException, SecurityException, NoSuchProviderException, NoSuchAlgorithmException, GeneralSecurityException {
        return null;
    }

    @Override
    public String verifyP7CounterSignYbq(byte[] p7SignData, byte[] counterSignData) throws CertificateException, Pkcs7DecodeException, Base64Exception, ValidateCertException, GetCertInfoException, HashException, IOException, ParseException {
        return null;
    }

    @Override
    public boolean verifySignatureByHashedData(byte[] base64EncodeCert, byte[] hashedData, byte[] signedValue) throws VerifySignDataException, Base64Exception {
        return false;
    }

    @Override
    public byte[] getOriDateByTsRequest(byte[] tsRequest) throws TsException {
        return null;
    }

    @Override
    public Object[] generatorKeyPairForDZHT(int type, int length) throws IOException, ParameterNotSupportException {
        return null;
    }

    @Override
    public byte[] decryptPriForDZHT(byte[] enPri) throws IOException {
        return null;
    }

    @Override
    public String verifySignedDataPkcs7_detach_hash(byte[] hashedData, byte[] pkcs7SignedData) throws Pkcs7VerifySignException {
        return null;
    }

    @Override
    public byte[] hashByteByAlg(byte[] inData, String hashAlg) throws HashException {
        return null;
    }

    @Override
    public byte[] signDataNoDER(byte[] inData) throws Base64Exception, HashException, RsaSignException {
        return null;
    }

    @Override
    public boolean verifySignedDataNoDER(String base64EncodeCert, byte[] inData, byte[] signedValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return false;
    }

    @Override
    public byte[] decodeP7SignAndEnvelopData(byte[] prikey, String inData) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        return null;
    }

    @Override
    public String encodeP7SignAndEnvelopData(String receiveCert, byte[] inData) throws Base64Exception, Pkcs7EncodeEnvelopeException, Pkcs7EncodeException {
        return null;
    }

    @Override
    public byte[] decodeP7SignAndEnvelopData(byte[] inData) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        return null;
    }

    @Override
    public String signDataPkcs7ForJit(byte[] inData) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        return null;
    }

    @Override
    public String signDataPkcs7ForJit_detach(byte[] inData) throws Pkcs7SignException, Pkcs7EncodeException, Base64Exception {
        return null;
    }

    @Override
    public byte[] encodeP7EnvelopedData4Jit(String base64EncodeCert, byte[] inData) throws Base64Exception, Pkcs7EncodeEnvelopeException {
        return null;
    }

    @Override
    public byte[] decodeP7EnvelopedData4Jit(byte[] inData) throws Pkcs7DecodeEnvelopeException {
        return null;
    }

    @Override
    public byte[] createTimeStamp0033(byte[] tsRequest) throws TsException {
        return null;
    }

    @Override
    public boolean verifyTimeStamp0033(byte[] timeStamp) throws TsException {
        return false;
    }

    @Override
    public String getTimeStampInfo0033(byte[] timeStamp, int type) throws TsException {
        return null;
    }

    @Override
    public boolean verifyTimeStampByCert0033(byte[] timeStamp, byte[] cert) throws TsException {
        return false;
    }

    @Override
    public byte[] encryptData(byte[] key, byte[] inData, int algorithm, byte[] iv, boolean isPkcs5Padding) {
        return null;
    }

    @Override
    public byte[] decryptData(byte[] key, byte[] inData, int algorithm, byte[] iv, boolean isPkcs5Padding) {
        return null;
    }

    @Override
    public String verifySignedDataPkcs7_detach_hash_ForCPIC(byte[] hashedData, byte[] pkcs7SignedData) throws Pkcs7VerifySignException {
        return null;
    }

    @Override
    public String verifySignedDataPkcs7_detach_ForJit(byte[] inData, String pkcs7SignedData) throws Base64Exception, Pkcs7VerifySignException {
        return null;
    }

    @Override
    public String getCertInfo0020(String base64EncodeCert, int type) throws Base64Exception, GetCertInfoException {
        return null;
    }

    @Override
    public String signDataXML0020(String inData) throws XmlSignException {
        return null;
    }

    @Override
    public boolean verifySignedDataXML0020(String inData) throws XmlVerifySignException {
        return false;
    }

    @Override
    public boolean verifySignedDataPkcs7(byte[] pkcs7SignedData) throws Base64Exception, Pkcs7VerifySignException {
        return false;
    }
}

