/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import xjyb.bjca.org.jdom.Element;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.jdom.input.SAXBuilder;
import xjyb.bjca.org.jdom.output.Format;
import xjyb.bjca.org.jdom.output.XMLOutputter;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.security.SecurityEngine;
import xjyb.cn.org.bjca.java.utils.RsaUtil;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.interfaces.P11Interface;

public class XMLSignUtil
extends SuperUtil {
    DocumentBuilder db;

    public XMLSignUtil(String appName) {
        super(appName);
    }

    private String CreateSignStr(String digVal) {
        String outstr = "<SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"><CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></CanonicalizationMethod>";
        outstr = outstr + "<SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#rsa-sha1\"></SignatureMethod>";
        outstr = outstr + "<Reference URI=\"#TheFirstObjcet\">";
        outstr = outstr + "<Transforms><Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments\"></Transform></Transforms>";
        outstr = outstr + "<DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\"></DigestMethod>";
        outstr = outstr + "<DigestValue>";
        outstr = outstr + digVal + "</DigestValue>";
        outstr = outstr + "</Reference></SignedInfo>";
        return outstr;
    }

    private String CreateSignStr0020(String digVal) {
        String outstr = "<SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"><CanonicalizationMethod Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315\"></CanonicalizationMethod>";
        outstr = outstr + "<SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#SM2-SM3\"></SignatureMethod>";
        outstr = outstr + "<Reference URI=\"#TheFirstObjcet\">";
        outstr = outstr + "<Transforms><Transform Algorithm=\"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments\"></Transform></Transforms>";
        outstr = outstr + "<DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#SM3\"></DigestMethod>";
        outstr = outstr + "<DigestValue>";
        outstr = outstr + digVal + "</DigestValue>";
        outstr = outstr + "</Reference></SignedInfo>";
        return outstr;
    }

    public static String jDomToXmlStr(xjyb.bjca.org.jdom.Document icDoc) throws Exception {
        StringWriter lcOut = new StringWriter();
        try {
            new XMLOutputter().output(icDoc, (Writer)lcOut);
            return lcOut.toString();
        }
        catch (Exception e) {
            throw new Exception(new StringBuffer("JDom convert to XML string fail").append(e.getMessage()).toString());
        }
    }

    public static String jDomToXmlStr_noHead(xjyb.bjca.org.jdom.Document icDoc) throws Exception {
        StringWriter lcOut = new StringWriter();
        try {
            new XMLOutputter().output(icDoc, (Writer)lcOut);
            String originalData = lcOut.toString();
            originalData = originalData.substring(originalData.indexOf(">"));
            String noHeadData = originalData = originalData.substring(originalData.indexOf("<"));
            return noHeadData;
        }
        catch (Exception e) {
            throw new Exception(new StringBuffer("JDom convert to XML string fail").append(e.getMessage()).toString());
        }
    }

    public String BJX_SignedDataXML_Sign(SecurityEngine safeEng, String xmlsrc, long signMethod, int m_Iinitmodel, byte[] m_signPfx, String m_keyType, String m_container, RSAPrivateCrtKeyParameters privateCrtKey, PrivateKey privateKey, P11Interface p11Impl, byte[] privateKeyByte, byte[] purePrivateKey) throws XmlSignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        try {
            String org_xml = xmlsrc.substring(xmlsrc.indexOf(">"));
            String xmlStr = org_xml = org_xml.substring(org_xml.indexOf("<"));
            if (org_xml.indexOf("http://www.w3.org/2000/09/xmldsig#") == -1) {
                xjyb.bjca.org.jdom.Document node_tmp = this.getDocumentFromString(org_xml.getBytes("UTF-8"));
                xmlStr = this.getXMLTextByElement_noFormat(node_tmp.getRootElement());
                this.debuglog("Formate the xml content before signature ,formate result == ");
                this.debuglog(xmlStr);
            }
            String digxml = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + xmlStr + "</Object>";
            byte[] tmpbyte = digxml.getBytes();
            byte[] hashedData = hashUtil.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), tmpbyte);
            String digval = base64Util.BJS_EncodeBase64(hashedData);
            String sInfo = this.CreateSignStr(digval);
            byte[] hashedContent = hashUtil.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), sInfo.getBytes());
            byte[] sValByte = rsaUtil.signHashedData(hashedContent, m_Iinitmodel, m_keyType, m_container, privateCrtKey, p11Impl, privateKeyByte);
            String sVal = base64Util.BJS_EncodeBase64(sValByte);
            if (sVal == null) {
                throw new Exception("Exception in signature by rsa,xml signature!");
            }
            String out = "<?xml version=\"1.0\" encoding=\"GB18030\"?>\n<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">";
            out = out + sInfo;
            out = out + "<SignatureValue>";
            out = out + sVal + "</SignatureValue>";
            String cert = safeEng.getSignCertString();
            if (cert == null) {
                throw new Exception("Signature certificate is inexistence!");
            }
            out = out + "<KeyInfo><X509Data><X509Certificate>";
            out = out + cert + "</X509Certificate></X509Data></KeyInfo>";
            out = out + "<Object id=\"TheFirstObjcet\">";
            out = out + xmlStr + "</Object></Signature>";
            return out;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing the xml,xml signature!", e);
            this.debuglog("Exception in signing the xml,xml signature!");
            throw new XmlSignException("Exception in signature,xml signature!");
        }
    }

    public String BJX_SignedDataXML_Sign0020(SecurityEngine safeEng, String xmlsrc, long signMethod, int m_Iinitmodel, byte[] m_signPfx, String m_keyType, String m_container, RSAPrivateCrtKeyParameters privateCrtKey, PrivateKey privateKey, P11Interface p11Impl, byte[] privateKeyByte, byte[] purePrivateKey) throws XmlSignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        try {
            String org_xml = xmlsrc.substring(xmlsrc.indexOf(">"));
            String xmlStr = org_xml = org_xml.substring(org_xml.indexOf("<"));
            if (org_xml.indexOf("http://www.w3.org/2000/09/xmldsig#") == -1) {
                xjyb.bjca.org.jdom.Document node_tmp = this.getDocumentFromString(org_xml.getBytes("UTF-8"));
                xmlStr = this.getXMLTextByElement_noFormat(node_tmp.getRootElement());
                this.debuglog("Formate the xml content before signature ,formate result == ");
                this.debuglog(xmlStr);
            }
            String digxml = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + xmlStr + "</Object>";
            byte[] tmpbyte = digxml.getBytes();
            String cert = safeEng.getSignCertString();
            byte[] derCert = base64Util.BJS_DecodeBase64(cert);
            X509CertificateStructure signcert = new X509CertificateStructure((ASN1Sequence)DerUtil.writeBytesToDERObj(derCert));
            byte[] hashedData = HashUtil.hash("SM3", tmpbyte, null);
            String digval = base64Util.BJS_EncodeBase64(hashedData);
            String sInfo = this.CreateSignStr0020(digval);
            WrapCard wCard = new WrapCard(m_Iinitmodel);
            byte[] hashedContent = HashUtil.hash("SM3", sInfo.getBytes(), signcert);
            byte[] sValByte = wCard.sm2SignWithHashedData(hashedContent, privateKeyByte);
            String sVal = base64Util.BJS_EncodeBase64(sValByte);
            if (sVal == null) {
                throw new Exception("Exception in signature by rsa,xml signature!");
            }
            String out = "<?xml version=\"1.0\" encoding=\"GB18030\"?>\n<Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">";
            out = out + sInfo;
            out = out + "<SignatureValue>";
            out = out + sVal + "</SignatureValue>";
            if (cert == null) {
                throw new Exception("Signature certificate is inexistence!");
            }
            out = out + "<KeyInfo><X509Data><X509Certificate>";
            out = out + cert + "</X509Certificate></X509Data></KeyInfo>";
            out = out + "<Object id=\"TheFirstObjcet\">";
            out = out + xmlStr + "</Object></Signature>";
            return out;
        }
        catch (Exception e) {
            this.errorlog("Exception in signing the xml,xml signature!", e);
            this.debuglog("Exception in signing the xml,xml signature!");
            throw new XmlSignException("Exception in signature,xml signature!");
        }
    }

    public boolean BJX_SignedDataXML_Verify(String xmlSign, long signMethod) throws XmlVerifySignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        try {
            Element node_tmp;
            String srcDigVal;
            xjyb.bjca.org.jdom.Document doc = this.getDocumentFromString(xmlSign.getBytes());
            Element rootElement = doc.getRootElement();
            Element nodeElement = this.SelectNode(rootElement, "Object");
            String objStr = this.getNodeText_noFormatContent(nodeElement);
            if (xmlSign.indexOf("http://www.w3.org/2000/09/xmldsig#") != -1) {
                int start = xmlSign.indexOf("<Object id=\"TheFirstObjcet\">");
                int end = xmlSign.lastIndexOf("</Object>");
                objStr = xmlSign.substring(start + 28, end);
                this.debuglog("Deal with original xml before verfying xmlSignValue,result == ");
                this.debuglog(objStr);
            }
            objStr = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + objStr + "</Object>";
            byte[] tmpbyte = objStr.getBytes();
            byte[] hashedData = hashUtil.BJS_HashBytes(HashUtil.getHashAlgLong(this.applicationName), tmpbyte);
            String digval = base64Util.BJS_EncodeBase64(hashedData);
            if (digval.compareToIgnoreCase(srcDigVal = this.getNodeText(node_tmp = this.SelectNode(rootElement, "SignedInfo/Reference/DigestValue"))) != 0) {
                long hashAlgLong = HashUtil.getHashAlgLong(this.applicationName) == 1L ? 2L : 1L;
                hashedData = hashUtil.BJS_HashBytes(hashAlgLong, tmpbyte);
                digval = base64Util.BJS_EncodeBase64(hashedData);
                if (digval.compareToIgnoreCase(srcDigVal) != 0) {
                    this.debuglog("hash error.new hash is " + digval);
                    this.debuglog("old hash is " + srcDigVal);
                    return false;
                }
            }
            node_tmp = this.SelectNode(rootElement, "SignedInfo");
            String signStr = this.getXMLTextByElement(node_tmp);
            node_tmp = this.SelectNode(rootElement, "KeyInfo/X509Data/X509Certificate");
            String certStr = this.getNodeText(node_tmp);
            node_tmp = this.SelectNode(rootElement, "SignatureValue");
            String signCode = this.getNodeText(node_tmp);
            byte[] certbuf = base64Util.BJS_DecodeBase64(certStr);
            byte[] signatureByte = base64Util.BJS_DecodeBase64(signCode);
            boolean flag = rsaUtil.BJK_RsaVerifyNoHash(signStr.getBytes(), signatureByte, certbuf, signMethod);
            return flag;
        }
        catch (Exception e) {
            this.errorlog("Exception in verfying the signature of xml,xml signature!", e);
            this.debuglog("Exception in verfying the signature of xml,xml signature!");
            throw new XmlVerifySignException("Exception in verfying the signature of xml,xml signature!");
        }
    }

    public boolean BJX_SignedDataXML_Verify0020(SecurityEngine safeEng, String xmlSign, long signMethod) throws XmlVerifySignException {
        HashUtil hashUtil = new HashUtil(this.applicationName);
        Base64Util base64Util = new Base64Util(this.applicationName);
        RsaUtil rsaUtil = new RsaUtil(this.applicationName);
        try {
            Element node_tmp;
            String srcDigVal;
            xjyb.bjca.org.jdom.Document doc = this.getDocumentFromString(xmlSign.getBytes());
            Element rootElement = doc.getRootElement();
            Element nodeElement = this.SelectNode(rootElement, "Object");
            String objStr = this.getNodeText_noFormatContent(nodeElement);
            if (xmlSign.indexOf("http://www.w3.org/2000/09/xmldsig#") != -1) {
                int start = xmlSign.indexOf("<Object id=\"TheFirstObjcet\">");
                int end = xmlSign.lastIndexOf("</Object>");
                objStr = xmlSign.substring(start + 28, end);
                this.debuglog("Deal with original xml before verfying xmlSignValue,result == ");
                this.debuglog(objStr);
            }
            objStr = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + objStr + "</Object>";
            byte[] tmpbyte = objStr.getBytes();
            String cert = safeEng.getSignCertString();
            byte[] derCert = base64Util.BJS_DecodeBase64(cert);
            X509CertificateStructure signcert = new X509CertificateStructure((ASN1Sequence)DerUtil.writeBytesToDERObj(derCert));
            byte[] hashedData = HashUtil.hash("SM3", tmpbyte, null);
            String digval = base64Util.BJS_EncodeBase64(hashedData);
            if (digval.compareToIgnoreCase(srcDigVal = this.getNodeText(node_tmp = this.SelectNode(rootElement, "SignedInfo/Reference/DigestValue"))) != 0) {
                return false;
            }
            node_tmp = this.SelectNode(rootElement, "SignedInfo");
            String signStr = this.getXMLTextByElement(node_tmp);
            node_tmp = this.SelectNode(rootElement, "KeyInfo/X509Data/X509Certificate");
            String certStr = this.getNodeText(node_tmp);
            node_tmp = this.SelectNode(rootElement, "SignatureValue");
            String signCode = this.getNodeText(node_tmp);
            byte[] certbuf = base64Util.BJS_DecodeBase64(certStr);
            byte[] signatureByte = base64Util.BJS_DecodeBase64(signCode);
            X509CertificateStructure vcert = new X509CertificateStructure((ASN1Sequence)DerUtil.writeBytesToDERObj(certbuf));
            WrapCard wCard = new WrapCard();
            boolean flag = wCard.vefiySM3WithSM2Sign(signStr.getBytes(), vcert, signatureByte);
            return flag;
        }
        catch (Exception e) {
            this.errorlog("Exception in verfying the signature of xml,xml signature!", e);
            this.debuglog("Exception in verfying the signature of xml,xml signature!");
            throw new XmlVerifySignException("Exception in verfying the signature of xml,xml signature!");
        }
    }

    public boolean signedDataXML_Verify_old(String XmlSign) {
        try {
            HashUtil hashUtil = new HashUtil(this.applicationName);
            RsaUtil rsaUtil = new RsaUtil(this.applicationName);
            Base64Util base64Util = new Base64Util(this.applicationName);
            ByteArrayInputStream bips = new ByteArrayInputStream(XmlSign.getBytes("GBK"));
            Document doc = this.db.parse(bips);
            Node node_tmp = this.selectNode_old(doc, "Signature/Object");
            String objStr = this.getOriginalData_old(XmlSign);
            objStr = "<Object xmlns=\"http://www.w3.org/2000/09/xmldsig#\" id=\"TheFirstObjcet\">" + objStr + "</Object>";
            byte[] hashedData = hashUtil.BJS_HashBytes(1L, objStr.getBytes());
            String digval = base64Util.BJS_EncodeBase64(hashedData);
            if (digval == null) {
                this.errorlog("Exception in verifying xml signature of hash operation, old interface");
                this.debuglog("Exception in verifying xml signature of hash operation, old interface");
                return false;
            }
            node_tmp = this.selectNode_old(doc, "Signature/SignedInfo/Reference/DigestValue");
            String srcDigVal = this.getNodeText_old(node_tmp);
            if (digval.compareToIgnoreCase(srcDigVal) != 0) {
                this.debuglog("hash error.new hash is " + digval);
                this.debuglog("old hash is " + srcDigVal);
                this.debuglog("xml is " + objStr);
                System.out.println("hash error.new hash is " + digval);
                System.out.println("old hash is " + srcDigVal);
                System.out.println("xml is " + objStr);
                return false;
            }
            node_tmp = this.selectNode_old(doc, "Signature/SignedInfo");
            String signStr = this.getXMLText_old(node_tmp);
            node_tmp = this.selectNode_old(doc, "Signature/KeyInfo/X509Data/X509Certificate");
            String certStr = this.getNodeText_old(node_tmp);
            node_tmp = this.selectNode_old(doc, "Signature/SignatureValue");
            String signCode = this.getNodeText_old(node_tmp);
            byte[] certbuf = base64Util.BJS_DecodeBase64(certStr);
            byte[] signatureByte = base64Util.BJS_DecodeBase64(signCode);
            boolean flag = rsaUtil.BJK_RsaVerifyNoHash(signStr.getBytes(), signatureByte, certbuf, 1L);
            return flag;
        }
        catch (Exception e) {
            this.errorlog("Exception in verifying xml signature, old interface", e);
            this.debuglog("Exception in verifying xml signature, old interface");
            return false;
        }
    }

    private String getNodeText_old(Node objnode) {
        ByteArrayOutputStream baops = new ByteArrayOutputStream(10240);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("encoding", "GB2312");
            t.transform(new DOMSource(objnode), new StreamResult(baops));
        }
        catch (Exception e) {
            this.errorlog("Exception in return character string without endpoint node , xml signature", e);
            this.debuglog("Exception in return character string without endpoint node , xml signature");
        }
        String ret = baops.toString();
        int ind = ret.indexOf(62);
        ret = ret.substring(ind + 1);
        ind = ret.indexOf(62);
        int end = ret.lastIndexOf(60);
        ret = ret.substring(ind + 1, end);
        String out = this.zryTrans(ret);
        return out;
    }

    private String getXMLText_old(Node objnode) {
        ByteArrayOutputStream baops = new ByteArrayOutputStream(10240);
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("encoding", "GB2312");
            t.transform(new DOMSource(objnode), new StreamResult(baops));
        }
        catch (Exception e) {
            this.errorlog("Exception in getXMLText_old XMLSignUtil", e);
            this.debuglog("Exception in getXMLText_old XMLSignUtil");
        }
        String ret = baops.toString();
        int ind = ret.indexOf(62);
        ret = ret.substring(ind);
        ret = ret.substring(ret.indexOf(60));
        String out = this.zryTrans(ret);
        return out;
    }

    private String getOriginalData_old(String ori) {
        int beginIndex = ori.indexOf("<Object id=\"TheFirstObjcet\">");
        int endIndex = ori.lastIndexOf("</Object>");
        String out = ori.substring(beginIndex + 28, endIndex);
        return out;
    }

    private Node selectNode_old(Node parentNode, String xpath) {
        String[] nodepath = xpath.split("/");
        Node tmpNode = parentNode;
        for (int i = 0; i < nodepath.length; ++i) {
            int j;
            NodeList nlist = tmpNode.getChildNodes();
            for (j = 0; j < nlist.getLength(); ++j) {
                if (nlist.item(j).getNodeName().compareToIgnoreCase(nodepath[i]) != 0) continue;
                tmpNode = nlist.item(j);
                break;
            }
            if (j != nlist.getLength()) continue;
            return null;
        }
        return tmpNode;
    }

    private Element SelectNode(Element parentNode, String xpath) {
        String[] nodepath = xpath.split("/");
        Element tmpNode = parentNode;
        for (int i = 0; i < nodepath.length; ++i) {
            int j;
            List nlist = tmpNode.getChildren();
            for (j = 0; j < nlist.size(); ++j) {
                if (((Element)nlist.get(j)).getName().compareToIgnoreCase(nodepath[i]) != 0) continue;
                tmpNode = (Element)nlist.get(j);
                break;
            }
            if (j != nlist.size()) continue;
            return null;
        }
        return tmpNode;
    }

    private String getNodeText(Element objnode) {
        String ret = "";
        try {
            Format format = Format.getCompactFormat();
            XMLOutputter XMLOut = new XMLOutputter(format);
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("Exception in getNodeText ", e);
            this.debuglog("Exception in getNodeText");
        }
        int ind = ret.indexOf(62);
        ret = ret.substring(ind + 1);
        int end = ret.lastIndexOf(60);
        ret = ret.substring(0, end);
        String out = this.zryTrans(ret);
        return out;
    }

    private String getNodeText_noFormatContent(Element objnode) {
        String ret = "";
        try {
            XMLOutputter XMLOut = new XMLOutputter();
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("Exception in getNodeText_noFormatContent XMLSignUtil", e);
            this.debuglog("Exception in getNodeText_noFormatContent XMLSignUtil");
        }
        int ind = ret.indexOf(62);
        ret = ret.substring(ind + 1);
        int end = ret.lastIndexOf(60);
        ret = ret.substring(0, end);
        String out = this.zryTrans(ret);
        return out;
    }

    private String getXMLTextByElement(Element objnode) {
        String ret = "";
        try {
            Format format = Format.getCompactFormat();
            XMLOutputter XMLOut = new XMLOutputter(format);
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("Exception in getXMLTextByElement XMLSignUtil", e);
            this.debuglog("Exception in getXMLTextByElement XMLSignUtil");
        }
        String out = this.zryTrans(ret);
        return out;
    }

    private String getXMLTextByElement_noFormat(Element objnode) {
        String ret = "";
        try {
            XMLOutputter XMLOut = new XMLOutputter();
            ret = XMLOut.outputString(objnode);
        }
        catch (Exception e) {
            this.errorlog("Exception in getXMLTextByElement_noFormat XMLSignUtil", e);
            this.debuglog("Exception in getXMLTextByElement_noFormat XMLSignUtil");
        }
        String out = this.zryTrans(ret);
        return out;
    }

    private String getAttributeText(Element objnode, String attName) {
        String ret = objnode.getAttributeValue(attName);
        return ret;
    }

    private String zryTrans(String srcstr) {
        String tmpstr = srcstr;
        String nodestr = "";
        int endlen = 0;
        while (true) {
            if ((endlen = tmpstr.indexOf("/>", endlen)) < 1) {
                tmpstr = tmpstr.replaceAll(" >", ">");
                tmpstr = tmpstr.replaceAll(" >", ">");
                tmpstr = tmpstr.replaceAll(" >", ">");
                return tmpstr;
            }
            int startlen = tmpstr.lastIndexOf(60, endlen);
            int spacelen = tmpstr.indexOf(32, startlen);
            nodestr = spacelen < endlen && spacelen > 0 ? tmpstr.substring(startlen + 1, spacelen) : tmpstr.substring(startlen + 1, endlen);
            tmpstr = tmpstr.replaceFirst("/>", "></" + nodestr + ">");
        }
    }

    public String BJX_getXMLSignatureInfo(String xmlSign, int type) throws GetXMLSignInfoException, JDOMException {
        try {
            String ret = "";
            xjyb.bjca.org.jdom.Document doc = this.getDocumentFromString(xmlSign.getBytes());
            Element rootElement = doc.getRootElement();
            switch (type) {
                case 1: {
                    if (xmlSign.indexOf("http://www.w3.org/2000/09/xmldsig#") != -1) {
                        int start = xmlSign.indexOf("<Object id=\"TheFirstObjcet\">");
                        int end = xmlSign.lastIndexOf("</Object>");
                        ret = xmlSign.substring(start + 28, end);
                        break;
                    }
                    Element node_obj = this.SelectNode(rootElement, "Object");
                    ret = this.getNodeText(node_obj);
                    this.debuglog("Get XMLSignature infomation, original text == ");
                    this.debuglog(ret);
                    break;
                }
                case 2: {
                    Element node_obj = this.SelectNode(rootElement, "SignedInfo/Reference/DigestValue");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 3: {
                    Element node_obj = this.SelectNode(rootElement, "SignatureValue");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 4: {
                    Element node_obj = this.SelectNode(rootElement, "KeyInfo/X509Data/X509Certificate");
                    ret = this.getNodeText(node_obj);
                    break;
                }
                case 5: {
                    Element node_obj = this.SelectNode(rootElement, "SignedInfo/Reference/DigestMethod");
                    ret = this.getAttributeText(node_obj, "Algorithm");
                    break;
                }
                case 6: {
                    Element node_obj = this.SelectNode(rootElement, "SignedInfo/SignatureMethod");
                    ret = this.getAttributeText(node_obj, "Algorithm");
                    break;
                }
                default: {
                    ret = null;
                }
            }
            return ret;
        }
        catch (IOException e) {
            this.errorlog("IOException in get xml signature infomation!", e);
            this.debuglog("IOException in get xml signature infomation!");
            throw new GetXMLSignInfoException("IOException in get xml signature infomation!");
        }
    }

    public xjyb.bjca.org.jdom.Document getDocumentFromString(byte[] xml) throws JDOMException, IOException {
        ByteArrayInputStream bips = new ByteArrayInputStream(xml);
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        xjyb.bjca.org.jdom.Document doc = builder.build((InputStream)bips);
        return doc;
    }

    public Document getDocumentFromString_old(byte[] xml) throws SAXException, IOException {
        ByteArrayInputStream bips = new ByteArrayInputStream(xml);
        Document doc = this.db.parse(bips);
        return doc;
    }

    public static void main(String[] arg) {
        try {
            SecurityEngineDeal sed = SecurityEngineDeal.getInstance("purejava");
            String signData2 = sed.signDataXML("<sss><a>\u65fb\u73fa\u73a5\u5f22\u52bc\u749f\u7424\u8d5f\u5586\u5803\u7fc0\u74a0\u7526\u8653\u794e\u97e1\u8283\u6fdb\u6607</a>");
            System.out.println(signData2);
            boolean isSuccess = sed.verifySignedDataXML(signData2);
            System.out.println(isSuccess);
            for (int i = 1; i < 7; ++i) {
                System.out.println(sed.getXMLSignatureInfo(signData2, i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

