/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.ArrayList;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.exception.Base64Exception;
import xjyb.cn.org.bjca.exception.DecryptDataException;
import xjyb.cn.org.bjca.exception.EncryptDataException;
import xjyb.cn.org.bjca.exception.GetCertInfoException;
import xjyb.cn.org.bjca.exception.GetXMLSignInfoException;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.InitException;
import xjyb.cn.org.bjca.exception.ParameterNotSupportException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7DecodeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeEnvelopeException;
import xjyb.cn.org.bjca.exception.Pkcs7EncodeException;
import xjyb.cn.org.bjca.exception.Pkcs7SignException;
import xjyb.cn.org.bjca.exception.Pkcs7VerifySignException;
import xjyb.cn.org.bjca.exception.RsaDecryptException;
import xjyb.cn.org.bjca.exception.RsaEncryptException;
import xjyb.cn.org.bjca.exception.RsaSignException;
import xjyb.cn.org.bjca.exception.RsaVerifySignException;
import xjyb.cn.org.bjca.exception.SecretRecoveryException;
import xjyb.cn.org.bjca.exception.SecretSegmentException;
import xjyb.cn.org.bjca.exception.TsException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.exception.XmlSignException;
import xjyb.cn.org.bjca.exception.XmlVerifySignException;
import xjyb.cn.org.bjca.java.security.SecurityEngine;
import xjyb.cn.org.bjca.security.SecurityEngineDeal;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.jce.fastparser.DerUtil;

public class SecurityEngineDeal_java
extends SecurityEngineDeal {
    private SecurityEngine safeEng = null;
    private String signMethod = "RSA-SHA1";
    private long signMethodNum = 3L;
    private String encryptMethod = "T-DES";
    private int encryptMethodNum = 102;
    ArrayList fileList = new ArrayList();
    ArrayList stringList = new ArrayList();
    private String applicationName;

    public SecurityEngineDeal_java(String appName) throws JDOMException, IOException, InitException {
        LoggerUtil.systemlog(appName, "Generating <" + appName + "> application's SecurityEngineDeal instance\uff01");
        this.safeEng = new SecurityEngine(appName);
        this.applicationName = appName;
        boolean isSuccess = this.safeEng.initialApp(appName);
        if (!isSuccess) {
            throw new InitException("Initialize application error !");
        }
        LoggerUtil.systemlog(appName, "<" + appName + "> application's instance initComplete !");
    }

    @Override
    public void initAppValue() {
        this.safeEng.setAppValue(this.applicationName);
    }

    @Override
    public void initP7Cert() {
        boolean isSuccess = this.safeEng.initP7Cert();
        if (isSuccess) {
            LoggerUtil.systemlog(this.applicationName, "Reload p7 cert success !");
        } else {
            LoggerUtil.systemlog(this.applicationName, "Reload p7 cert failed !");
        }
    }

    @Override
    public void verifyCRL() {
        try {
            this.safeEng.verifyCRL();
        }
        catch (Exception e) {
            LoggerUtil.debuglog(this.applicationName, "Exception in verfying CRL certificate\uff01", e);
            LoggerUtil.errorlog(this.applicationName, "Exception in verfying CRL certificate!", e);
        }
    }

    public SecurityEngine getSafeEng() throws InitException {
        if (this.safeEng == null) {
            LoggerUtil.debuglog(this.applicationName, "SecurityEngine failed to initialize!");
            LoggerUtil.errorlog(this.applicationName, "SecurityEngine failed to initialize!");
            throw new InitException("Failed to initialize\uff01");
        }
        return this.safeEng;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void setDebug(boolean isDebug) throws InitException {
        if (this.applicationName == null) {
            LoggerUtil.errorlog(this.applicationName, "Application failed to initialize!");
            LoggerUtil.debuglog(this.applicationName, "Application failed to initialize!");
            throw new InitException("Application failed to initialize!");
        }
        if (isDebug) {
            LoggerUtil.setDebug(this.applicationName, "true");
        } else {
            LoggerUtil.setDebug(this.applicationName, "false");
        }
    }

    @Override
    public void setSignMethod(String method) throws AlgorithmNotFoundException {
        this.signMethod = method;
        this.signMethodNum = this.getNumFromString(method);
    }

    @Override
    public String getSignMethod() {
        return this.signMethod;
    }

    @Override
    public String getEncryptMethod() {
        return this.encryptMethod;
    }

    @Override
    public String getServerCertificate() throws Base64Exception {
        String signCert = this.safeEng.getSignCertString();
        if (signCert != null && !"".equals(signCert)) {
            return signCert;
        }
        return this.safeEng.getEncryptCertString();
    }

    @Override
    public String getServerCertificate(int certUsage) throws Base64Exception {
        if (certUsage == 1) {
            return this.safeEng.getEncryptCertString();
        }
        if (certUsage == 2) {
            return this.safeEng.getSignCertString();
        }
        return null;
    }

    @Override
    public String genRandom() throws Base64Exception {
        return this.safeEng.getRandomString();
    }

    @Override
    public String genRandom(int len) throws Base64Exception {
        return this.safeEng.getRandomString(len);
    }

    @Override
    public byte[] genRandomByte(int len) {
        return this.safeEng.getRandomByte(len);
    }

    @Override
    public String getCertInfo(String base64EncodeCert, int type) throws Base64Exception, GetCertInfoException {
        return this.safeEng.getCertInfo(base64EncodeCert, type);
    }

    @Override
    public String getCertInfo0020(String base64EncodeCert, int type) throws Base64Exception, GetCertInfoException {
        return this.safeEng.getCertInfo0020(base64EncodeCert, type);
    }

    @Override
    public String getCertInfoByOid(String base64EncodeCert, String oid) throws Base64Exception, GetCertInfoException {
        return this.safeEng.getCertInfoByOid(base64EncodeCert, oid);
    }

    @Override
    public int validateCert(String base64EncodeCert) throws CertificateException, Base64Exception, ValidateCertException, GetCertInfoException {
        return this.safeEng.validateCert(base64EncodeCert);
    }

    @Override
    public String signData(String inData) throws Base64Exception, HashException, RsaSignException {
        byte[] signedData = this.safeEng.signData(inData.getBytes(), this.signMethodNum);
        Base64Util base64Util = new Base64Util(this.applicationName);
        String base64SignedData = base64Util.BJS_EncodeBase64(signedData);
        return base64SignedData;
    }

    @Override
    public String signData(byte[] inData) throws Base64Exception, HashException, RsaSignException {
        byte[] signedData = this.safeEng.signData(inData, this.signMethodNum);
        Base64Util base64Util = new Base64Util(this.applicationName);
        String base64SignedData = base64Util.BJS_EncodeBase64(signedData);
        return base64SignedData;
    }

    @Override
    public String signDataWithoutZ(String inData) throws Base64Exception, HashException {
        return this.signDataWithoutZ(inData.getBytes());
    }

    @Override
    public String signDataWithoutZ(byte[] inDataBytes) throws Base64Exception, HashException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] signedData = this.safeEng.signDataWithoutZ(inDataBytes, this.signMethodNum);
        String base64SignedData = base64Util.BJS_EncodeBase64(signedData);
        return base64SignedData;
    }

    @Override
    public boolean verifySignedDataWithoutZ(byte[] certBytes, byte[] inDataBytes, byte[] signedDataBytes) throws VerifySignDataException, HashException {
        return this.safeEng.verifySignedDataWithoutZ(certBytes, inDataBytes, signedDataBytes);
    }

    @Override
    public byte[] signDataReByte(byte[] inData) throws Base64Exception, HashException, RsaSignException {
        return this.safeEng.signData(inData, this.signMethodNum);
    }

    @Override
    public byte[] signDataNoDER(byte[] inData) throws Base64Exception, HashException, RsaSignException {
        return this.safeEng.signDataNoDER(inData, this.signMethodNum);
    }

    @Override
    public byte[] signHashedData(byte[] hashedData) {
        return this.safeEng.signHashDataPkcs1(hashedData);
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, String inData, String signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] signatureByte = base64Util.BJS_DecodeBase64(signValue);
        return this.safeEng.verifySignedData(inData.getBytes(), signatureByte, base64EncodeCert, this.signMethodNum);
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, byte[] inData, String signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] signatureByte = base64Util.BJS_DecodeBase64(signValue);
        return this.safeEng.verifySignedData(inData, signatureByte, base64EncodeCert, this.signMethodNum);
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, byte[] inData, byte[] signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return this.safeEng.verifySignedData(inData, signValue, base64EncodeCert, this.signMethodNum);
    }

    @Override
    public boolean verifySignedDataNoDER(String base64EncodeCert, byte[] inData, byte[] signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return this.safeEng.verifySignedDataNoDER(inData, signValue, base64EncodeCert, this.signMethodNum);
    }

    @Override
    public boolean verifySignedData(byte[] publicKey, byte[] content, byte[] signature) throws VerifySignDataException {
        return this.safeEng.verifySignedData(content, signature, publicKey);
    }

    @Override
    public boolean verifySignatureByHashedData(String base64EncodeCert, byte[] hashedData, byte[] signedValue) throws VerifySignDataException {
        boolean isSuccess = this.safeEng.verifySignatureByHashedData(base64EncodeCert, hashedData, signedValue);
        return isSuccess;
    }

    @Override
    public String signFile(String inFile) throws HashException, RsaSignException, Base64Exception {
        return this.safeEng.signFile(inFile, this.signMethodNum);
    }

    @Override
    public boolean verifySignedFile(String base64EncodeCert, String inFile, String signValue) throws Base64Exception, HashException, GetCertInfoException, VerifySignDataException {
        return this.safeEng.verifySignedFile(base64EncodeCert, inFile, signValue, this.signMethodNum);
    }

    @Override
    public String signData(InputStream inputStream) throws HashException, RsaSignException, Base64Exception {
        return this.safeEng.signFile(inputStream, this.signMethodNum);
    }

    @Override
    public boolean verifySignedData(String base64EncodeCert, InputStream inputStream, String signValue) throws Base64Exception, HashException, GetCertInfoException, RsaVerifySignException {
        return this.safeEng.verifySignedFile(base64EncodeCert, inputStream, signValue, this.signMethodNum);
    }

    @Override
    public String secretSegment(String secert, int m3, int n, int k) throws SecretSegmentException {
        return this.safeEng.secretSegment(secert, m3, n, k);
    }

    @Override
    public String secretRecovery(String seg) throws SecretRecoveryException {
        return this.safeEng.secretRecovery(seg);
    }

    @Override
    public String encryptData(String key, String inData) throws EncryptDataException, IOException, Base64Exception {
        return this.safeEng.encryptDataStringKey(key, inData, this.encryptMethodNum);
    }

    @Override
    public byte[] encryptData(byte[] key, byte[] inData) {
        return this.safeEng.encryptDataReByte(key, inData, this.encryptMethodNum, null);
    }

    @Override
    public byte[] encryptData(byte[] key, byte[] inData, int algorithm) {
        return this.safeEng.encryptDataReByte(key, inData, algorithm, null);
    }

    @Override
    public byte[] encryptData(byte[] key, byte[] inData, int algorithm, byte[] iv, boolean isPkcs5Padding) {
        return this.safeEng.encryptDataReByte(key, inData, algorithm, iv, isPkcs5Padding);
    }

    @Override
    public String decryptData(String key, String inData) throws DecryptDataException, Base64Exception, IOException {
        return this.safeEng.decryptData(key, inData, this.encryptMethodNum);
    }

    @Override
    public byte[] decryptData(byte[] key, byte[] inData) throws Base64Exception {
        return this.safeEng.decryptData(key, inData, this.encryptMethodNum, null);
    }

    @Override
    public byte[] decryptData(byte[] key, byte[] inData, int algorithm) {
        return this.safeEng.decryptData(key, inData, algorithm, null);
    }

    @Override
    public byte[] decryptData(byte[] key, byte[] inData, int algorithm, byte[] iv, boolean isPkcs5Padding) {
        return this.safeEng.decryptData(key, inData, algorithm, iv, isPkcs5Padding);
    }

    @Override
    public boolean encryptFile(String key, String inFile, String outFile) throws Base64Exception, EncryptDataException {
        return this.safeEng.encryptFile(key, inFile, outFile, this.encryptMethodNum);
    }

    @Override
    public boolean decryptFile(String key, String inFile, String outFile) throws Base64Exception, DecryptDataException {
        return this.safeEng.decryptFile(key, inFile, outFile, this.encryptMethodNum);
    }

    @Override
    public String pubKeyEncrypt(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        Base64Util base64U = new Base64Util(this.applicationName);
        byte[] certByte = base64U.BJS_DecodeBase64(base64EncodeCert);
        byte[] enData = this.safeEng.pubKeyEncrypt(certByte, inData.getBytes());
        String base64EnData = base64U.BJS_EncodeBase64(enData);
        return base64EnData;
    }

    @Override
    public String pubKeyEncrypt_OAEP(String base64EncodeCert, String inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        return this.safeEng.pubKeyEncrypt_OAEP(base64EncodeCert, inData);
    }

    @Override
    public String pubKeyEncrypt_OAEP(String base64EncodeCert, byte[] inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        return this.safeEng.pubKeyEncrypt_OAEP(base64EncodeCert, inData);
    }

    @Override
    public byte[] pubKeyEncrypt(String base64EncodeCert, byte[] inData) throws Base64Exception, GetCertInfoException, RsaEncryptException {
        Base64Util base64U = new Base64Util(this.applicationName);
        byte[] certByte = base64U.BJS_DecodeBase64(base64EncodeCert);
        byte[] enData = this.safeEng.pubKeyEncrypt(certByte, inData);
        return enData;
    }

    @Override
    public String priKeyDecrypt(String inData) throws Base64Exception, RsaDecryptException {
        Base64Util base64U = new Base64Util(this.applicationName);
        byte[] origialByte = this.safeEng.priKeyDecrypt(base64U.BJS_DecodeBase64(inData));
        return new String(origialByte);
    }

    @Override
    public byte[] priKeyDecrypt(byte[] inData) throws Base64Exception, RsaDecryptException {
        byte[] origialByte = this.safeEng.priKeyDecrypt(inData);
        return origialByte;
    }

    @Override
    public String priKeyDecrypt_OAEP(String InData) throws Base64Exception, RsaDecryptException {
        return this.safeEng.priKeyDecrypt_OAEP(InData);
    }

    @Override
    public boolean addSignFile(String filePath) {
        if (filePath == null || "".equals(filePath)) {
            return false;
        }
        this.fileList.add(filePath);
        return true;
    }

    @Override
    public boolean addSignString(String inData) {
        if (inData == null || "".equals(inData)) {
            return false;
        }
        this.stringList.add(inData);
        return true;
    }

    @Override
    public void clearAllSignData() {
        this.fileList.clear();
        this.stringList.clear();
    }

    @Override
    public boolean verifySignAll(String base64EncodeCert, String signValue) throws Base64Exception, GetCertInfoException, VerifySignDataException, NoSuchAlgorithmException {
        return this.safeEng.verifySignAll(this.fileList, this.stringList, base64EncodeCert, signValue, this.signMethodNum);
    }

    @Override
    public String getTotalTsReq() throws TsException, Base64Exception, NoSuchAlgorithmException {
        return this.safeEng.getTotalTsReq(this.fileList, this.stringList, this.signMethodNum);
    }

    @Override
    public String signDataPkcs7(String inData) throws Pkcs7SignException {
        return this.safeEng.signDataPkcs7(inData.getBytes(), this.signMethodNum);
    }

    @Override
    public String signDataPkcs7(byte[] inData) throws Pkcs7SignException {
        return this.safeEng.signDataPkcs7(inData, this.signMethodNum);
    }

    @Override
    public String signDataPkcs7ForJit(byte[] inData) throws Pkcs7SignException {
        return this.safeEng.signDataPkcs7ForJit(inData, this.signMethodNum, true);
    }

    @Override
    public String signDataPkcs7ForJit_detach(byte[] inData) throws Pkcs7SignException {
        return this.safeEng.signDataPkcs7ForJit(inData, this.signMethodNum, false);
    }

    @Override
    public byte[] signHashedDataPkcs7_detach(byte[] inData) throws Pkcs7SignException {
        return this.safeEng.signHashedDataPkcs7_detach(inData, this.signMethodNum);
    }

    @Override
    public String signDataPkcs7_detach(byte[] inData) throws Pkcs7SignException {
        return this.safeEng.signDataPkcs7_detach(inData, this.signMethodNum);
    }

    @Override
    public String signDataPkcs7_file_detach(String sFilePath) throws Pkcs7SignException {
        return this.safeEng.signDataPkcs7_file_detach(sFilePath, this.signMethodNum);
    }

    @Override
    public boolean verifySignedDataPkcs7(String pkcs7SignData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedDataPkcs7(pkcs7SignData);
    }

    @Override
    public boolean verifySignedDataPkcs7(byte[] pkcs7SignData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedDataPkcs7(pkcs7SignData);
    }

    @Override
    public String verifySignedDataPkcs7_detach(byte[] inData, String pkcs7SignData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedP7Data_detach(inData, pkcs7SignData);
    }

    @Override
    public String verifySignedDataPkcs7_detach_ForJit(byte[] inData, String pkcs7SignData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedDataPkcs7_detach_ForJit(inData, pkcs7SignData);
    }

    @Override
    public String verifySignedDataPkcs7_detach_hash(byte[] inData, String pkcs7SignData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedP7Data_detach_hash(inData, pkcs7SignData);
    }

    @Override
    public String verifySignedDataPkcs7_detach_hash(byte[] hashedData, byte[] pkcs7SignedData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedP7Data_detach_hash(hashedData, pkcs7SignedData);
    }

    @Override
    public String verifySignedDataPkcs7_detach_hash_ForCPIC(byte[] hashedData, byte[] pkcs7SignedData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedDataPkcs7_detach_hash_ForCPIC(hashedData, pkcs7SignedData);
    }

    @Override
    public boolean verifySignedDataPkcs7_file_detach(String sFilePath, String pkcs7SignData) throws Pkcs7VerifySignException {
        return this.safeEng.verifySignedP7Data_file_detach(sFilePath, pkcs7SignData);
    }

    @Override
    public String getP7SignDataInfo(String pkcs7SignData, int type) throws Pkcs7DecodeException {
        return this.safeEng.getP7SignDataInfo(pkcs7SignData, type);
    }

    @Override
    public byte[] getP7SignDataInfo(byte[] pkcs7SignedData, int type) throws Pkcs7DecodeException {
        return this.safeEng.getP7SignDataInfo(pkcs7SignedData, type);
    }

    @Override
    public String encodeP7EnvelopedData(String base64EncodeCert, String inData) throws Pkcs7EncodeEnvelopeException {
        Base64Util base64U = new Base64Util(this.applicationName);
        byte[] p7EnData = this.safeEng.encodeP7EnvelopedData(base64EncodeCert, inData.getBytes(), this.encryptMethodNum);
        return base64U.BJS_EncodeBase64(p7EnData);
    }

    @Override
    public byte[] encodeP7EnvelopedData(String base64EncodeCert, byte[] inData) throws Pkcs7EncodeEnvelopeException {
        return this.safeEng.encodeP7EnvelopedData(base64EncodeCert, inData, this.encryptMethodNum);
    }

    @Override
    public byte[] encodeP7EnvelopedData4Jit(String base64EncodeCert, byte[] inData) throws Pkcs7EncodeEnvelopeException {
        return this.safeEng.encodeP7EnvelopedData4Jit(base64EncodeCert, inData, this.encryptMethodNum);
    }

    @Override
    public String decodeP7EnvelopedData(String inData) throws Pkcs7DecodeEnvelopeException {
        Base64Util base64U = new Base64Util(this.applicationName);
        byte[] inDataByte = base64U.BJS_DecodeBase64(inData);
        byte[] outData = this.safeEng.decodeP7EnvelopedData(inDataByte);
        return new String(outData);
    }

    @Override
    public byte[] decodeP7EnvelopedData(byte[] inData) throws Pkcs7DecodeEnvelopeException {
        byte[] outData = this.safeEng.decodeP7EnvelopedData(inData);
        return outData;
    }

    @Override
    public byte[] decodeP7EnvelopedData4Jit(byte[] inData) throws Pkcs7DecodeEnvelopeException {
        byte[] outData = this.safeEng.decodeP7EnvelopedData4Jit(inData);
        return outData;
    }

    @Override
    public String encodeP7SignAndEnvelopData(String receiveCert, String inData) throws Base64Exception, Pkcs7EncodeException {
        byte[] inDataByte = inData.getBytes();
        return this.safeEng.encodeP7SignAndEnvelopData(receiveCert, inDataByte);
    }

    @Override
    public String encodeP7SignAndEnvelopData(String receiveCert, byte[] inData) throws Base64Exception, Pkcs7EncodeException {
        return this.safeEng.encodeP7SignAndEnvelopData(receiveCert, inData);
    }

    @Override
    public String decodeP7SignAndEnvelopData(String inData) throws Pkcs7DecodeException {
        byte[] oriData = this.safeEng.decodeP7SignAndEnvelopeData(inData);
        return new String(oriData);
    }

    @Override
    public byte[] decodeP7SignAndEnvelopData(byte[] inData) throws Base64Exception, Pkcs7DecodeEnvelopeException, Pkcs7DecodeException {
        Base64Util base64U = new Base64Util(this.applicationName);
        String inDataStr = base64U.BJS_EncodeBase64(inData);
        byte[] oriData = this.safeEng.decodeP7SignAndEnvelopeData(inDataStr);
        return oriData;
    }

    @Override
    public byte[] decodeP7SignAndEnvelopData(byte[] prikey, String inData) throws Pkcs7DecodeException {
        return this.safeEng.decodeP7SignAndEnvelopeData(prikey, inData);
    }

    @Override
    public String signDataXML(String inData) throws XmlSignException {
        return this.safeEng.signDataXML(inData, this.signMethodNum);
    }

    @Override
    public String signDataXML0020(String inData) throws XmlSignException {
        return this.safeEng.signDataXML0020(inData, this.signMethodNum);
    }

    @Override
    public boolean verifySignedDataXML(String inData) throws XmlVerifySignException {
        return this.safeEng.verifySignedDataXML(inData, this.signMethodNum);
    }

    @Override
    public boolean verifySignedDataXML0020(String inData) throws XmlVerifySignException {
        return this.safeEng.verifySignedDataXML0020(inData, this.signMethodNum);
    }

    @Override
    public String getXMLSignatureInfo(String XMLSignedData, int type) throws GetXMLSignInfoException, JDOMException {
        return this.safeEng.getXMLSignatureInfo(XMLSignedData, type);
    }

    @Override
    public String createTimeStampRequest(String inData) throws HashException, TsException, Base64Exception {
        return this.safeEng.createTimeStampRequest(inData.getBytes(), this.signMethodNum);
    }

    @Override
    public byte[] createTimeStampRequest(byte[] inData, boolean isAttachCert) throws HashException {
        return this.safeEng.createTimeStampRequest(inData, isAttachCert);
    }

    @Override
    public String createTimeStampRequest(byte[] inData) throws HashException, TsException, Base64Exception {
        return this.safeEng.createTimeStampRequest(inData, this.signMethodNum);
    }

    @Override
    public String createTimeStamp(String inData) throws Base64Exception, TsException {
        return this.safeEng.createTimeStampResponse(inData, true);
    }

    @Override
    public byte[] createTimeStamp(byte[] tsRequest) throws TsException {
        return this.safeEng.createTimeStamp(tsRequest);
    }

    @Override
    public byte[] createTimeStamp0033(byte[] tsRequest) throws TsException {
        return this.safeEng.createTimeStamp0033(tsRequest);
    }

    @Override
    public String createTimeStampNoCert(String inData) throws Base64Exception, TsException {
        return this.safeEng.createTimeStampResponse(inData, false);
    }

    @Override
    public String createTSByOriginalData(String inData) throws Base64Exception, TsException {
        return this.safeEng.createTsRespByOriginalData(inData.getBytes(), true);
    }

    public String createTSByOriginalDataNotAttCert(String inData) throws Base64Exception, TsException {
        return this.safeEng.createTsRespByOriginalData(inData.getBytes(), false);
    }

    @Override
    public String createTSByOriginalData(byte[] inData) throws Base64Exception, TsException {
        return this.safeEng.createTsRespByOriginalData(inData, true);
    }

    public String createTSByOriginalDataNotAttCert(byte[] inData) throws Base64Exception, TsException {
        return this.safeEng.createTsRespByOriginalData(inData, false);
    }

    @Override
    public boolean verifyTimeStamp(String content, String tsResponseData) throws Base64Exception, TsException, HashException {
        return this.safeEng.verifyTimeStamp(content, tsResponseData, null, this.signMethodNum);
    }

    @Override
    public boolean verifyTimeStamp(byte[] timeStamp) throws TsException {
        return this.safeEng.verifyTimeStamp(timeStamp, null);
    }

    @Override
    public boolean verifyTimeStamp0033(byte[] timeStamp) throws TsException {
        return this.safeEng.verifyTimeStamp0033(timeStamp, null);
    }

    @Override
    public boolean verifyTimeStampByCert0033(byte[] timeStamp, byte[] cert) throws TsException {
        return this.safeEng.verifyTimeStamp0033(timeStamp, cert);
    }

    @Override
    public boolean verifyTimeStampByCert(byte[] timeStamp, byte[] cert) throws TsException {
        return this.safeEng.verifyTimeStamp(timeStamp, cert);
    }

    @Override
    public boolean verifyTimeStampByCert(String tsResponseData, byte[] cert) throws Base64Exception, TsException, HashException {
        return this.safeEng.verifyTimeStamp(null, tsResponseData, cert, this.signMethodNum);
    }

    @Override
    public String getTimeStampInfo(String tsResponseData, int type) throws Base64Exception, TsException, ParseException, Pkcs7DecodeException {
        return this.safeEng.getTimeStampInfo(tsResponseData, type);
    }

    @Override
    public String getTimeStampInfo(byte[] timeStamp, int type) throws TsException {
        return this.safeEng.getTimeStampInfo(timeStamp, type);
    }

    @Override
    public String getTimeStampInfo0033(byte[] timeStamp, int type) throws TsException {
        return this.safeEng.getTimeStampInfo0033(timeStamp, type);
    }

    @Override
    public byte[] createP7DetachedAndTimeStampedData(byte[] hashedOriginalData) throws GeneralSecurityException {
        return this.safeEng.createP7DetachedAndTimeStampedData(hashedOriginalData);
    }

    @Override
    public int verifyP7DetachedAndTimeStampedData(byte[] p7Byte) {
        return this.safeEng.verifyP7DetachedAndTimeStampedData(p7Byte);
    }

    @Override
    public String getP7DetachedAndTimeStampedDataInfo(byte[] p7Byte, int type) throws CertificateEncodingException, IOException {
        return this.safeEng.getP7DetachedAndTimeStampedDataInfo(p7Byte, type);
    }

    @Override
    public String base64Encode(byte[] inData) throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        return base64Util.BJS_EncodeBase64(inData);
    }

    @Override
    public byte[] base64Decode(String inData) throws Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        return base64Util.BJS_DecodeBase64(inData);
    }

    @Override
    public String hash_string(String inData) throws HashException, Base64Exception {
        Base64Util base64Util = new Base64Util(this.applicationName);
        byte[] hashedData = this.safeEng.hash_byte(inData.getBytes(), null);
        String base64HashedData = base64Util.BJS_EncodeBase64(hashedData);
        return base64HashedData;
    }

    @Override
    public byte[] hash_byte(byte[] inData) throws HashException {
        byte[] signedData = this.safeEng.hash_byte(inData, null);
        return signedData;
    }

    @Override
    public byte[] hashByteByAlg(byte[] inData, String hashAlg) throws HashException {
        byte[] signedData = this.safeEng.hashByteByAlg(inData, hashAlg, null);
        return signedData;
    }

    @Override
    public byte[] hash_byte(byte[] inData, String cert) throws HashException {
        byte[] signedData = null;
        if (cert != null && !cert.equals("")) {
            try {
                X509CertificateStructure certX509 = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(this.base64Decode(cert)));
                signedData = this.safeEng.hash_byte(inData, certX509);
            }
            catch (Exception e) {
                throw new HashException("get PublicKey exception" + e);
            }
        } else {
            signedData = this.safeEng.hash_byte(inData, null);
        }
        return signedData;
    }

    private long getNumFromString(String str) throws AlgorithmNotFoundException {
        if ("RSA-SHA1".equals(str)) {
            return 3L;
        }
        if ("RSA-MD5".equals(str)) {
            return 2L;
        }
        if ("RSA-MD2".equals(str)) {
            return 1L;
        }
        if ("DES".equals(str)) {
            return 100L;
        }
        if ("T-DES2KEY".equals(str)) {
            return 101L;
        }
        if ("T-DES".equals(str)) {
            return 102L;
        }
        if ("SSF33".equals(str)) {
            return 103L;
        }
        if ("AES-128".equals(str)) {
            return 108L;
        }
        if ("AES-192".equals(str)) {
            return 107L;
        }
        if ("AES-256".equals(str)) {
            return 106L;
        }
        throw new AlgorithmNotFoundException("\u6b64\u7b97\u6cd5\u65e0\u6548\uff01");
    }

    @Override
    public String hash_file(String inFile) throws HashException, RsaSignException, Base64Exception {
        return this.safeEng.hashFile(inFile, this.signMethodNum);
    }

    @Override
    public String getAllP7b() {
        return this.safeEng.getAllP7b();
    }

    @Override
    public boolean encryptData(String key, InputStream inData, OutputStream outData) throws EncryptDataException, IOException {
        boolean isSuccess = this.safeEng.encryptDataStringKey(key, inData, outData, 0L);
        return isSuccess;
    }

    @Override
    public boolean decryptData(String key, InputStream inData, OutputStream outData) throws DecryptDataException, IOException {
        boolean isSuccess = this.safeEng.decryptData(key, inData, outData, 0L);
        return isSuccess;
    }

    @Override
    public Object[] generatorKeyPair(int type, int length) throws IOException {
        return this.safeEng.generatorKeyPair(type, length);
    }

    @Override
    public byte[] signHashedDataPkcs7_detach(byte[] inData, boolean isAttribute) throws Pkcs7SignException {
        if (isAttribute) {
            return this.safeEng.signAttributePkcs7(inData, this.signMethodNum);
        }
        return this.safeEng.signHashedDataPkcs7_detach(inData, this.signMethodNum);
    }

    @Override
    public byte[] createP7DetachedAndTimeStampedData(byte[] p7sign, byte[] hashedOriginalData) throws GeneralSecurityException {
        return this.safeEng.createP7DetachedAndTimeStampedData(p7sign, hashedOriginalData);
    }

    @Override
    public byte[] generateP7DetachedByP7AndTimeStampedData(byte[] p7sign, byte[] timeStamp) throws GeneralSecurityException {
        return this.safeEng.generateP7DetachedByP7AndTimeStampedData(p7sign, timeStamp);
    }

    @Override
    public byte[] generatP7CounterSign(byte[] signData) throws IOException, Pkcs7SignException, Pkcs7DecodeException, HashException, InvalidKeyException, CertificateException, SecurityException, NoSuchProviderException, NoSuchAlgorithmException {
        return this.safeEng.generatP7CounterSign(signData);
    }

    @Override
    public String verifyP7CounterSign(byte[] counterSignData) throws CertificateException, Pkcs7DecodeException, Base64Exception, ValidateCertException, GetCertInfoException, HashException, IOException, ParseException {
        return this.safeEng.verifyP7CounterSign(counterSignData);
    }

    @Override
    public byte[] createTimeStampRequestByHashedData(byte[] inData, boolean isAttachCert) throws TsException {
        return this.safeEng.createTimeStampRequestByHashedData(inData, isAttachCert);
    }

    @Override
    public byte[] createTimeStampRequestByFile(String filePath, boolean isAttachCert) throws TsException {
        byte[] tsReqBytes = this.safeEng.createTimeStampRequestByFile(filePath, isAttachCert);
        return tsReqBytes;
    }

    @Override
    public int verifyTimeStampByFile(byte[] timeStamp, String inFile) throws TsException, ParseException {
        return this.safeEng.verifyTimeStampByFile(timeStamp, inFile);
    }

    @Override
    public byte[] createTimeStampRequestByLargebinary(byte[] inData, boolean isAttachCert) throws TsException, IOException {
        return this.safeEng.createTimeStampRequestByLargebinary(inData, isAttachCert);
    }

    @Override
    public int verifyTimeStampByLargebinary(byte[] timeStamp, byte[] inData) throws TsException, IOException {
        return this.safeEng.verifyTimeStampByLargebinary(timeStamp, inData);
    }

    @Override
    public byte[] generatP7CounterSignYbq(byte[] signData, String oids) throws IOException, Pkcs7SignException, Pkcs7DecodeException, HashException, InvalidKeyException, CertificateException, SecurityException, NoSuchProviderException, NoSuchAlgorithmException, GeneralSecurityException {
        return this.safeEng.generatP7CounterSignYbq(signData, oids);
    }

    @Override
    public String verifyP7CounterSignYbq(byte[] p7SignData, byte[] counterSignData) throws CertificateException, Pkcs7DecodeException, Base64Exception, ValidateCertException, GetCertInfoException, HashException, IOException, ParseException, Pkcs7VerifySignException {
        return this.safeEng.verifyP7CounterSignYbq(p7SignData, counterSignData);
    }

    @Override
    public boolean verifySignatureByHashedData(byte[] cert, byte[] hashedData, byte[] signedValue) throws VerifySignDataException, Base64Exception {
        boolean isSuccess = this.safeEng.verifySignatureByHashedData(cert, hashedData, signedValue);
        return isSuccess;
    }

    @Override
    public byte[] getOriDateByTsRequest(byte[] tsRequest) throws TsException {
        return this.safeEng.getOriDateByTsRequest(tsRequest);
    }

    @Override
    public Object[] generatorKeyPairForDZHT(int type, int length) throws IOException, ParameterNotSupportException {
        return this.safeEng.generatorKeyPairForDZHT(type, length);
    }

    @Override
    public byte[] decryptPriForDZHT(byte[] enPri) throws IOException {
        return this.safeEng.decryptPriForDZHT(enPri);
    }
}

