/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import xjyb.bjca.org.jdom.Document;
import xjyb.bjca.org.jdom.Element;
import xjyb.bjca.org.jdom.JDOMException;
import xjyb.bjca.org.jdom.input.SAXBuilder;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.cn.org.bjca.framework.Log;
import xjyb.cn.org.bjca.java.utils.FileUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;

public class XmlConfig
extends Log {
    private static Hashtable listDevices = new Hashtable();
    private static Hashtable listTrustcerts = new Hashtable();
    private static Hashtable listCerts = new Hashtable();
    private static Hashtable listWebapps = new Hashtable();
    private static Hashtable listWebappsProhibits = new Hashtable();
    private static Hashtable listWebappsDeviceType = new Hashtable();
    public static String version = null;
    public static Element root = null;

    public XmlConfig(String appName) {
        super(appName);
    }

    public static void loadConfig() throws JDOMException, IOException {
        FileUtil fu = new FileUtil("");
        LoggerUtil.systemlog("all", "Reload xml configue file, path == " + GetPathUtil.getXMLConfigue());
        byte[] xmlFileByte = fu.readFile(GetPathUtil.getXMLConfigue());
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(xmlFileByte);
        SAXBuilder builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
        Document doc = builder.build((InputStream)byteInStream);
        root = doc.getRootElement();
        Element eVersion = root.getChild("version");
        version = eVersion.getTextTrim();
        Element eDevices = root.getChild("devices");
        Element eTrustcerts = root.getChild("trustcerts");
        Element eCerts = root.getChild("certs");
        Element eWebapps = root.getChild("webapps");
        XmlConfig.setDevices(eDevices);
        XmlConfig.setTrustcerts(eTrustcerts);
        XmlConfig.setCerts(eCerts);
        XmlConfig.setWebapps(eWebapps);
        XmlConfig.setWebappsDeviceType();
    }

    private static void setDevices(Element eDevices) {
        List listDevice = eDevices.getChildren("device");
        Iterator iterDevices = listDevice.iterator();
        while (iterDevices.hasNext()) {
            Properties device = new Properties();
            Element eDevice = (Element)iterDevices.next();
            String name = eDevice.getChildText("name");
            String providertype = eDevice.getChildText("providertype");
            String provider = eDevice.getChildText("provider");
            String privatedll = eDevice.getChildText("privatedll");
            device.put("name", name);
            device.put("providertype", providertype);
            device.put("provider", provider);
            device.put("privatedll", privatedll);
            listDevices.put(name, device);
        }
    }

    private static void setTrustcerts(Element eTrustcerts) {
        List listTrustcert = eTrustcerts.getChildren("trustcert");
        Iterator iterTrustcerts = listTrustcert.iterator();
        while (iterTrustcerts.hasNext()) {
            Properties trustcert = new Properties();
            Element eTrustcert = (Element)iterTrustcerts.next();
            String alias = eTrustcert.getChildText("alias");
            String subjec = eTrustcert.getChildText("subjec");
            String uniqidoid = eTrustcert.getChildText("uniqidoid");
            Element crldistributionpoin = eTrustcert.getChild("crldistributionpoin");
            String url = "";
            url = crldistributionpoin.getChildText("url");
            String localpath = "";
            localpath = crldistributionpoin.getChildText("localpath");
            trustcert.put("alias", alias);
            trustcert.put("subjec", subjec);
            trustcert.put("uniqidoid", uniqidoid);
            trustcert.put("url", url);
            trustcert.put("localpath", localpath);
            listTrustcerts.put(alias, trustcert);
        }
    }

    private static void setCerts(Element eCerts) {
        List listCert = eCerts.getChildren("cert");
        Iterator iterCert = listCert.iterator();
        while (iterCert.hasNext()) {
            Properties cert = new Properties();
            Element eCert = (Element)iterCert.next();
            String container = eCert.getChildText("container");
            String uniqid = eCert.getChildText("uniqid");
            String uniqidoid = eCert.getChildText("uniqidoid");
            String subjectname = eCert.getChildText("subjectname");
            String dept = eCert.getChildText("dept");
            String issueName = eCert.getChildText("issueName");
            String avail = eCert.getChildText("avail");
            String tradetype = eCert.getChildText("tradetype");
            String devicename = eCert.getChildText("devicename");
            String trustcert = eCert.getChildText("trustcert");
            String password = eCert.getChildText("password");
            String keytype = eCert.getChildText("keytype");
            Element keynode = eCert.getChild("keynode");
            Element signature = keynode.getChild("signature");
            String signatureSerialnum = signature.getChildText("serialnum");
            Element exchange = keynode.getChild("exchange");
            String exchangeSerialnum = exchange.getChildText("serialnum");
            cert.put("container", container);
            cert.put("uniqid", uniqid);
            cert.put("uniqidoid", uniqidoid);
            cert.put("subjectname", subjectname);
            cert.put("dept", dept);
            cert.put("issueName", issueName);
            cert.put("avail", avail);
            cert.put("tradetype", tradetype);
            cert.put("devicename", devicename);
            cert.put("trustcert", trustcert);
            cert.put("password", password);
            cert.put("keytype", keytype);
            cert.put("signatureSerialnum", signatureSerialnum);
            cert.put("exchangeSerialnum", exchangeSerialnum);
            listCerts.put(container, cert);
        }
    }

    private static void setWebapps(Element eWebapps) {
        List listWebapp = eWebapps.getChildren("webapp");
        Iterator iterWebapp = listWebapp.iterator();
        while (iterWebapp.hasNext()) {
            Properties webapp = new Properties();
            Properties prohibit = new Properties();
            Element eWebapp = (Element)iterWebapp.next();
            String name = eWebapp.getChildText("name");
            String container = eWebapp.getChildText("container");
            String hashType = eWebapp.getChildText("hashtype");
            String uniqidoid = eWebapp.getChildText("uniqidoid");
            String debug = eWebapp.getChildText("debug");
            Element certverify = eWebapp.getChild("certverify");
            String catype = certverify.getChildText("catype");
            String policytype = certverify.getChildText("policytype");
            String verifytime = certverify.getChildText("verifytime");
            webapp.put("name", name);
            webapp.put("uniqidoid", uniqidoid);
            webapp.put("debug", debug);
            webapp.put("container", container);
            if (null != hashType) {
                webapp.put("hashtype", hashType);
            }
            webapp.put("catype", catype);
            webapp.put("policytype", policytype);
            webapp.put("verifytime", verifytime);
            listWebapps.put(name, webapp);
            Element prohibitlist = certverify.getChild("prohibitlist");
            ArrayList<String> listUniqid = new ArrayList<String>();
            ArrayList<String> listSerialnum = new ArrayList<String>();
            List uniqids = prohibitlist.getChildren("uniqid");
            for (Element eUniqid : uniqids) {
                String uniqid = eUniqid.getTextTrim();
                listUniqid.add(uniqid);
            }
            List serialnums = prohibitlist.getChildren("serialnum");
            for (Element eSerialnum : serialnums) {
                String serialnum = eSerialnum.getTextTrim();
                listSerialnum.add(serialnum.toUpperCase());
            }
            prohibit.put("uniqid", listUniqid);
            prohibit.put("serialnum", listSerialnum);
            listWebappsProhibits.put(name, prohibit);
        }
    }

    private static void setWebappsDeviceType() {
        Set webappNameSet = listWebapps.keySet();
        int webappLength = webappNameSet.size();
        for (String webName : webappNameSet) {
            Properties webapp = (Properties)listWebapps.get(webName);
            String container = webapp.getProperty("container");
            Properties cert = (Properties)listCerts.get(container);
            String deviceName = cert.getProperty("devicename");
            Properties device = (Properties)listDevices.get(deviceName);
            String deviceType = device.getProperty("providertype");
            listWebappsDeviceType.put(webName, deviceType);
        }
    }

    public static int getWebappsDeviceType(String appName) {
        String deviceType = (String)listWebappsDeviceType.get(appName);
        if (null == deviceType) {
            int deviceTypeNum = 0;
            return deviceTypeNum;
        }
        int deviceTypeNum = Integer.parseInt(deviceType);
        return deviceTypeNum;
    }

    public static String getVersion() {
        return version;
    }

    public static Hashtable getListDevices() {
        return listDevices;
    }

    public static Hashtable getListTrustcerts() {
        return listTrustcerts;
    }

    public static Hashtable getListCerts() {
        return listCerts;
    }

    public static Hashtable getListWebapps() {
        return listWebapps;
    }

    public static Hashtable getListWebappsProhibits() {
        return listWebappsProhibits;
    }
}

