/*
 * Decompiled with CFR 0.152.
 */
package xjyb.bjca.org.multi.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Hashtable;
import xjyb.bjca.org.multi.util.GetPathUtil;
import xjyb.bjca.org.multi.util.exceptions.LoggerException;
import xjyb.bjca.org.multi.util.log.AccessLogger;
import xjyb.bjca.org.multi.util.log.DebugLogger;
import xjyb.bjca.org.multi.util.log.ErrorLogger;
import xjyb.bjca.org.multi.util.log.LoggerRes;
import xjyb.bjca.org.multi.util.log.ManageLogger;
import xjyb.bjca.org.multi.util.log.SystemLogger;

public class LoggerUtil {
    private static Hashtable debugSwitchList = new Hashtable();
    private static Hashtable listDebugLog = new Hashtable();
    private static Hashtable listSystemLog = new Hashtable();
    private static Hashtable listErrorLog = new Hashtable();
    private static ManageLogger manageLog = null;
    private static AccessLogger accessLog = null;
    private static String logPath = "";
    private static String maxDebugLogFileSize;
    private static int maxDebugLogFileNumber;
    private static String maxManageLogFileSize;
    private static int maxManageLogFileNumber;
    private static String maxSystemLogFileSize;
    private static int maxSystemLogFileNumber;
    private static String maxErrorLogFileSize;
    private static int maxErrorLogFileNumber;
    private static String maxAccessLogFileSize;
    private static int maxAccessLogFileNumber;
    private static Object objLockDebug;
    private static Object objLockSystem;
    private static Object objLockError;
    private static Object objLockAccess;

    static {
        String separator = GetPathUtil.getOsFileSeparator();
        String rootPath = GetPathUtil.getConfigPath();
        logPath = String.valueOf(rootPath) + separator + "logs" + separator;
        maxDebugLogFileSize = "10000kb";
        maxDebugLogFileNumber = 100;
        maxManageLogFileSize = "10000kb";
        maxManageLogFileNumber = 100;
        maxSystemLogFileSize = "10000kb";
        maxSystemLogFileNumber = 100;
        maxErrorLogFileSize = "10000kb";
        maxErrorLogFileNumber = 100;
        maxAccessLogFileSize = "10000kb";
        maxAccessLogFileNumber = 100;
        objLockDebug = new Object();
        objLockSystem = new Object();
        objLockError = new Object();
        objLockAccess = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debuglog(String debugFlag, String info) {
        String flag = (String)debugSwitchList.get(debugFlag);
        if (!"true".equals(flag)) {
            return;
        }
        DebugLogger debugLog = (DebugLogger)listDebugLog.get(debugFlag);
        if (debugLog == null) {
            Object object = objLockDebug;
            synchronized (object) {
                LoggerRes res = new LoggerRes();
                res.setLogFile(String.valueOf(LoggerUtil.getLogPath()) + "debug_" + debugFlag + ".log");
                res.setLoggerName("debug");
                res.setMaxFileSize(maxDebugLogFileSize);
                res.setMaxBackupIndex(maxDebugLogFileNumber);
                try {
                    debugLog = new DebugLogger(res);
                    listDebugLog.put(debugFlag, debugLog);
                }
                catch (LoggerException e) {
                    e.printStackTrace();
                }
            }
        }
        if (debugLog != null) {
            debugLog.Log(info);
        }
    }

    public static void debuglog(String debugFlag, String log, Throwable tr) {
        String flag = (String)debugSwitchList.get(debugFlag);
        if (!"true".equals(flag)) {
            return;
        }
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bao);
        tr.printStackTrace(out);
        LoggerUtil.debuglog(debugFlag, log);
        LoggerUtil.debuglog(debugFlag, bao.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void systemlog(String systemFlag, String s2) {
        SystemLogger systemLog = (SystemLogger)listSystemLog.get(systemFlag);
        if (systemLog == null) {
            Object object = objLockSystem;
            synchronized (object) {
                LoggerRes res = new LoggerRes();
                res.setLogFile(String.valueOf(LoggerUtil.getLogPath()) + "system_" + systemFlag + ".log");
                res.setLoggerName("system");
                res.setMaxFileSize(maxSystemLogFileSize);
                res.setMaxBackupIndex(maxSystemLogFileNumber);
                res.setHeader("");
                try {
                    systemLog = new SystemLogger(res);
                    listSystemLog.put(systemFlag, systemLog);
                }
                catch (LoggerException e) {
                    e.printStackTrace();
                }
            }
        }
        if (systemLog != null) {
            systemLog.Log(s2);
        }
    }

    public static void systemlog(String debugFlag, String log, Throwable tr) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bao);
        tr.printStackTrace(out);
        LoggerUtil.systemlog(debugFlag, log);
        LoggerUtil.systemlog(debugFlag, bao.toString());
    }

    public static void errorlog(String errorFlag, String log, Throwable tr) {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bao);
        tr.printStackTrace(out);
        LoggerUtil.errorlog(errorFlag, log);
        LoggerUtil.errorlog(errorFlag, bao.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void errorlog(String errorFlag, String s2) {
        ErrorLogger errorLog = (ErrorLogger)listErrorLog.get(errorFlag);
        if (errorLog == null) {
            Object object = objLockError;
            synchronized (object) {
                LoggerRes res = new LoggerRes();
                res.setLogFile(String.valueOf(LoggerUtil.getLogPath()) + "error_" + errorFlag + ".log");
                res.setLoggerName("error");
                res.setMaxFileSize(maxErrorLogFileSize);
                res.setMaxBackupIndex(maxErrorLogFileNumber);
                res.setHeader("");
                try {
                    errorLog = new ErrorLogger(res);
                    listErrorLog.put(errorFlag, errorLog);
                }
                catch (LoggerException e) {
                    e.printStackTrace();
                }
            }
        }
        errorLog.Log(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void accesslog(String s2) {
        if (accessLog == null) {
            Object object = objLockAccess;
            synchronized (object) {
                LoggerRes res = new LoggerRes();
                res.setLogFile(String.valueOf(LoggerUtil.getLogPath()) + "access.log");
                res.setLoggerName("access");
                res.setMaxFileSize(maxAccessLogFileSize);
                res.setMaxBackupIndex(maxAccessLogFileNumber);
                res.setHeader("");
                try {
                    accessLog = new AccessLogger(res);
                }
                catch (LoggerException e) {
                    e.printStackTrace();
                }
            }
        }
        accessLog.Log(s2);
    }

    public static void managelog(String s2) {
        if (manageLog == null) {
            LoggerRes res = new LoggerRes();
            res.setLogFile(String.valueOf(LoggerUtil.getLogPath()) + "manage.log");
            res.setLoggerName("manage");
            res.setMaxFileSize(maxManageLogFileSize);
            res.setMaxBackupIndex(maxManageLogFileNumber);
            res.setHeader("");
            try {
                manageLog = new ManageLogger(res);
            }
            catch (LoggerException e) {
                e.printStackTrace();
                return;
            }
        }
        manageLog.Log(s2);
    }

    public static String isDebug(String debugFlag) {
        String flag = (String)debugSwitchList.get(debugFlag);
        return flag;
    }

    public static void setDebug(String debugFlag, String isDebug) {
        debugSwitchList.put(debugFlag, isDebug);
    }

    public static String getLogPath() {
        File f = new File(logPath);
        if (!f.exists()) {
            f.mkdir();
        }
        return logPath;
    }

    public static void setLogPath(String logPath) {
        LoggerUtil.logPath = logPath;
    }

    public static int getMaxAccessLogFileNumber() {
        return maxAccessLogFileNumber;
    }

    public static void setMaxAccessLogFileNumber(int maxAccessLogFileNumber) {
        LoggerUtil.maxAccessLogFileNumber = maxAccessLogFileNumber;
    }

    public static String getMaxAccessLogFileSize() {
        return maxAccessLogFileSize;
    }

    public static void setMaxAccessLogFileSize(String maxAccessLogFileSize) {
        LoggerUtil.maxAccessLogFileSize = maxAccessLogFileSize;
    }

    public static int getMaxDebugLogFileNumber() {
        return maxDebugLogFileNumber;
    }

    public static void setMaxDebugLogFileNumber(int maxDebugLogFileNumber) {
        LoggerUtil.maxDebugLogFileNumber = maxDebugLogFileNumber;
    }

    public static String getMaxDebugLogFileSize() {
        return maxDebugLogFileSize;
    }

    public static void setMaxDebugLogFileSize(String maxDebugLogFileSize) {
        LoggerUtil.maxDebugLogFileSize = maxDebugLogFileSize;
    }

    public static int getMaxErrorLogFileNumber() {
        return maxErrorLogFileNumber;
    }

    public static void setMaxErrorLogFileNumber(int maxErrorLogFileNumber) {
        LoggerUtil.maxErrorLogFileNumber = maxErrorLogFileNumber;
    }

    public static String getMaxErrorLogFileSize() {
        return maxErrorLogFileSize;
    }

    public static void setMaxErrorLogFileSize(String maxErrorLogFileSize) {
        LoggerUtil.maxErrorLogFileSize = maxErrorLogFileSize;
    }

    public static int getMaxManageLogFileNumber() {
        return maxManageLogFileNumber;
    }

    public static void setMaxManageLogFileNumber(int maxManageLogFileNumber) {
        LoggerUtil.maxManageLogFileNumber = maxManageLogFileNumber;
    }

    public static String getMaxManageLogFileSize() {
        return maxManageLogFileSize;
    }

    public static void setMaxManageLogFileSize(String maxManageLogFileSize) {
        LoggerUtil.maxManageLogFileSize = maxManageLogFileSize;
    }

    public static int getMaxSystemLogFileNumber() {
        return maxSystemLogFileNumber;
    }

    public static void setMaxSystemLogFileNumber(int maxSystemLogFileNumber) {
        LoggerUtil.maxSystemLogFileNumber = maxSystemLogFileNumber;
    }

    public static String getMaxSystemLogFileSize() {
        return maxSystemLogFileSize;
    }

    public static void setMaxSystemLogFileSize(String maxSystemLogFileSize) {
        LoggerUtil.maxSystemLogFileSize = maxSystemLogFileSize;
    }
}

