/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.impl.service;

import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.util.encoders.Base64;
import com.uccs.CertUtils;
import com.uccs.Certservice;
import com.ygsoft.abc.mapp.ygca.algorithm.common.PKCS7SignedData;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.HashCalculateRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.ResponseVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignInfoVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignTimeRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.SignVerifyRespDataVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.X509CertVO;
import com.ygsoft.abc.mapp.ygca.gwcw.service.ISignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.TransIdUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.ZipUtil;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import xjyb.com.alibaba.fastjson.JSONObject;
import xjyb.org.bjca.sm4soft.util.ByteUtil;

public class GwcaSignatureService
implements ISignatureService {
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    @Override
    public boolean verify(String source, String signedBase64) {
        if (source == null) {
            throw new RuntimeException("\u539f\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        if (signedBase64 == null) {
            throw new RuntimeException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        byte[] sourceData = source.getBytes(UTF_8);
        return this.verify(sourceData, signedBase64);
    }

    @Override
    public boolean verify(byte[] sourceData, String signedBase64) {
        if (sourceData == null) {
            throw new RuntimeException("\u539f\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        if (signedBase64 == null) {
            throw new RuntimeException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        VerifyResultVO result = this.verifyWithSignInfo(sourceData, signedBase64);
        return result.getSuccessed().isYes();
    }

    private ResponseVO checkRespResult(String json) {
        if (StringUtil.isBlank(json)) {
            throw new RuntimeException("\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        ResponseVO resp = JSONObject.parseObject(json, ResponseVO.class);
        if (!resp.successed()) {
            throw new RuntimeException(resp.getMessage());
        }
        return resp;
    }

    @Override
    public VerifyResultVO verifyWithSignInfo(byte[] sourceData, String signedBase64) {
        if (sourceData == null) {
            throw new RuntimeException("\u539f\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        if (signedBase64 == null) {
            throw new RuntimeException("\u7b7e\u540d\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        VerifyResultVO resultVO = new VerifyResultVO();
        try {
            PKCS7SignedData pkcs7SignedData = new PKCS7SignedData();
            pkcs7SignedData.loadBase64(signedBase64.getBytes());
            Certificate cert = pkcs7SignedData.getSignerX509Cert();
            System.out.println(cert.getIssuer().toString());
            String transId = TransIdUtil.next();
            String serviceCode = "";
            String reqDocHash = this.hashBase64(sourceData, Base64.toBase64String(cert.getEncoded()));
            String signValue = signedBase64;
            String signCert = "";
            String json = Certservice.getInstance().hashSignVerify(transId, "", reqDocHash, signValue, "");
            System.out.println("--->hashSignVerify:" + json);
            ResponseVO respEntity = this.checkRespResult(json);
            if (respEntity.getData() == null) {
                throw new RuntimeException("\u9a8c\u7b7e\u6570\u636e\u4e3a\u7a7a\u3002");
            }
            SignVerifyRespDataVO respData = JSONObject.parseObject(respEntity.getData(), SignVerifyRespDataVO.class);
            resultVO.setSuccessed(respData.successed() ? YesnoEnum.YES : YesnoEnum.NO);
            SignInfoVO signInfo = new SignInfoVO();
            signInfo.setSignTime(this.parseSignTime(signedBase64));
            signInfo.setCertInfo(this.convert(cert));
            resultVO.setSignInfo(signInfo);
        }
        catch (Exception e) {
            throw new RuntimeException("\u89e3\u6790PKCS7\u683c\u5f0f\u5931\u8d25\u3002", e);
        }
        return resultVO;
    }

    private String hashBase64(byte[] data, String cert) {
        String reqDoc = Base64.toBase64String(data);
        return this.hashCalc(reqDoc, cert).getHash();
    }

    private HashCalculateRespDataVO hashCalc(String reqDoc, String cert) {
        if (StringUtil.isBlank(reqDoc)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1areqDoc\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isBlank(cert)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1acert\u4e3a\u7a7a\u3002");
        }
        String json = CertUtils.getInstance().hashCalc(reqDoc, cert);
        System.out.println("--->hashCalc:" + json);
        this.checkRespResult(json);
        ResponseVO respEntity = JSONObject.parseObject(json, ResponseVO.class);
        if (respEntity.getData() != null) {
            return JSONObject.parseObject(respEntity.getData(), HashCalculateRespDataVO.class);
        }
        return null;
    }

    private Date parseSignTime(String signValue) {
        SignTimeRespDataVO respData = this.getSignTime(signValue);
        return respData.convertSignTime();
    }

    private SignTimeRespDataVO getSignTime(String signValue) {
        String json = CertUtils.getInstance().getSignTime(signValue);
        System.out.println("--->getSignTime:" + json);
        ResponseVO respEntity = JSONObject.parseObject(json, ResponseVO.class);
        if (respEntity.getData() != null) {
            return JSONObject.parseObject(respEntity.getData(), SignTimeRespDataVO.class);
        }
        return null;
    }

    private X509CertVO convert(Certificate cert) {
        X509CertVO x509Cert = new X509CertVO();
        x509Cert.setSerialNumber(this.toHexString(cert.getSerialNumber()));
        x509Cert.setSubject(cert.getSubject().toString());
        x509Cert.setIssuer(cert.getIssuer().toString());
        x509Cert.setBeginDate(cert.getStartDate().getDate());
        x509Cert.setEndDate(cert.getEndDate().getDate());
        return x509Cert;
    }

    private String toHexString(ASN1Integer asn1) {
        try {
            String certSN = ByteUtil.bytes2hex(asn1.getEncoded()).toLowerCase();
            return certSN.substring(4);
        }
        catch (Exception e) {
            System.out.println("ASN1Integer\u8f6cHex\u5931\u8d25\u3002");
            e.printStackTrace();
            return asn1.toString();
        }
    }

    public boolean verifyZip(String zipBase64) {
        if (StringUtil.isBlank(zipBase64)) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1azipBase64\u4e3a\u7a7a\u3002");
        }
        byte[] zipData = Base64.decode(zipBase64);
        Map<String, byte[]> map = ZipUtil.unzipFile(zipData);
        byte[] sourceData = this.getSourceData(map);
        byte[] signedData = this.getSignedData(map);
        String signedBase64 = new String(signedData);
        return this.verify(sourceData, signedBase64);
    }

    @Override
    public boolean verifyZip(byte[] zipData) {
        if (zipData == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1azipData\u4e3a\u7a7a\u3002");
        }
        Map<String, byte[]> map = ZipUtil.unzipFile(zipData);
        byte[] sourceData = this.getSourceData(map);
        byte[] signedData = this.getSignedData(map);
        String signedBase64 = new String(signedData);
        return this.verify(sourceData, signedBase64);
    }

    @Override
    public VerifyResultVO verifyZipWithSignInfo(byte[] zipData) {
        if (zipData == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff1azipData\u4e3a\u7a7a\u3002");
        }
        Map<String, byte[]> map = ZipUtil.unzipFile(zipData);
        byte[] sourceData = this.getSourceData(map);
        byte[] signedData = this.getSignedData(map);
        String signedBase64 = new String(signedData);
        return this.verifyWithSignInfo(sourceData, signedBase64);
    }

    private byte[] getSourceData(Map<String, byte[]> map) {
        if (map.containsKey(".xbrl")) {
            return map.get(".xbrl");
        }
        if (map.containsKey(".xml")) {
            return map.get(".xml");
        }
        throw new RuntimeException("\u539f\u6570\u636e\u4e0d\u5b58\u5728\u3002");
    }

    private byte[] getSignedData(Map<String, byte[]> map) {
        if (map.containsKey(".sign")) {
            return map.get(".sign");
        }
        throw new RuntimeException("\u7b7e\u540d\u6570\u636e\u4e0d\u5b58\u5728\u3002");
    }
}

