/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.ASN1Set;
import cn.org.bjca.gaia.asn1.cms.Attribute;
import cn.org.bjca.gaia.asn1.cms.AttributeTable;
import cn.org.bjca.gaia.asn1.cms.CMSAttributes;
import cn.org.bjca.gaia.asn1.cms.Time;
import cn.org.bjca.gaia.asn1.pkcs.ContentInfo;
import cn.org.bjca.gaia.asn1.pkcs.SignedData;
import cn.org.bjca.gaia.asn1.pkcs.SignerInfo;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.util.encoders.Base64;
import com.ygsoft.abc.mapp.ygca.asn1.parser.ASN1Parser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;

public class PKCS7SignedData {
    private SignedData signedData = null;

    public void loadDERData(byte[] data) {
        ASN1Sequence seq;
        if (data != null && data.length != 0) {
            if (!ASN1Parser.isDERSequence(data)) {
                throw new RuntimeException("PKCS7SignedData encoding required DERSequence");
            }
            try {
                seq = ASN1Sequence.getInstance(data);
            }
            catch (Exception var4) {
                throw new RuntimeException("PKCS7SignedData decoding failure", var4);
            }
        } else {
            throw new RuntimeException("PKCS7SignedData encoding required not  be null");
        }
        this.load(seq);
    }

    public void loadBase64(byte[] data) {
        ASN1Sequence seq;
        if (data != null && data.length != 0) {
            byte[] encoding = null;
            if (ASN1Parser.isDERSequence(data)) {
                encoding = data;
            } else {
                try {
                    encoding = Base64.decode(data);
                }
                catch (Exception var6) {
                    throw new RuntimeException("PKCS7SignedData encoding required base64", var6);
                }
            }
            try {
                seq = ASN1Sequence.getInstance(encoding);
            }
            catch (Exception var5) {
                throw new RuntimeException("PKCS7SignedData decoding failure", var5);
            }
        }
        throw new RuntimeException("PKCS7SignedData encoding required not  be null");
        this.load(seq);
    }

    private final void load(ASN1Sequence seq) {
        SignedData sd = null;
        try {
            ContentInfo contentInfo = ContentInfo.getInstance(seq);
            sd = SignedData.getInstance(contentInfo.getContent());
        }
        catch (Exception var4) {
            throw new RuntimeException("PKCS7SignedData decoding failure", var4);
        }
        this.signedData = sd;
    }

    public SignedData getSignedData() {
        return this.signedData;
    }

    public Certificate getSignerX509Cert() {
        ASN1Set certSet = this.signedData.getCertificates();
        Certificate certStru = Certificate.getInstance(certSet.getObjectAt(0));
        return certStru;
    }

    public final String getSignTime() {
        ASN1Set signerInfos;
        String signTimeText = null;
        if (this.signedData != null && (signerInfos = this.signedData.getSignerInfos()) != null) {
            AttributeTable attributeTable;
            Attribute signTimeAttr;
            boolean hasSignTimeAttr;
            Enumeration signerEnumer = signerInfos.getObjects();
            if (!signerEnumer.hasMoreElements()) {
                throw new RuntimeException("getSignTime failed: can not get SignerInfo");
            }
            SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
            ASN1Set signedAttributeSet = signerInfo.getAuthenticatedAttributes();
            if (signedAttributeSet != null && (hasSignTimeAttr = this.hasSignTime(signTimeAttr = (attributeTable = new AttributeTable(signedAttributeSet)).get(CMSAttributes.signingTime)))) {
                Time time = Time.getInstance(signTimeAttr.getAttrValues().getObjectAt(0).toASN1Primitive());
                Date signTimeDate = time.getDate();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                signTimeText = format.format(signTimeDate);
            }
        }
        return signTimeText;
    }

    private final boolean hasSignTime(Attribute signTimeAttr) {
        boolean hasSignTime = false;
        if (signTimeAttr != null) {
            hasSignTime = signTimeAttr.getAttrValues() != null && signTimeAttr.getAttrValues().size() > 0;
        }
        return hasSignTime;
    }
}

