/*
 * Decompiled with CFR 0.152.
 */
package com.xjyb.core.poll;

import com.xjyb.config.PasswordServiceConfig;
import com.xjyb.core.poll.IdleConnectionMonitor;
import xjyb.org.apache.http.client.config.RequestConfig;
import xjyb.org.apache.http.config.Registry;
import xjyb.org.apache.http.config.RegistryBuilder;
import xjyb.org.apache.http.config.SocketConfig;
import xjyb.org.apache.http.conn.socket.ConnectionSocketFactory;
import xjyb.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import xjyb.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import xjyb.org.apache.http.impl.client.CloseableHttpClient;
import xjyb.org.apache.http.impl.client.HttpClientBuilder;
import xjyb.org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import xjyb.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class PooledHTTPClientFactory {
    private static CloseableHttpClient httpClient;
    private static IdleConnectionMonitor monitor;

    PooledHTTPClientFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient getHttpClient() {
        Class<PooledHTTPClientFactory> clazz = PooledHTTPClientFactory.class;
        synchronized (PooledHTTPClientFactory.class) {
            if (httpClient == null) {
                httpClient = PooledHTTPClientFactory.createHttpClient();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    private static CloseableHttpClient createHttpClient() {
        PasswordServiceConfig config = PasswordServiceConfig.getInstance();
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)SSLConnectionSocketFactory.getSocketFactory())).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(config.getMaxTotal());
        connectionManager.setDefaultMaxPerRoute(config.getDefaultMaxPerRoute());
        connectionManager.setValidateAfterInactivity(config.getValidateAfterInactivity());
        SocketConfig socketConfig = SocketConfig.custom().setRcvBufSize(262144).setSndBufSize(262144).build();
        connectionManager.setDefaultSocketConfig(socketConfig);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(config.getSocketTimeout()).setConnectTimeout(config.getConnectTimeout()).setConnectionRequestTimeout(config.getConnectionRequestTimeout()).build();
        StandardHttpRequestRetryHandler retryHandler = new StandardHttpRequestRetryHandler(2, false);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager(connectionManager).setRetryHandler(retryHandler).build();
        monitor = new IdleConnectionMonitor(connectionManager, config);
        new Thread(monitor).start();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownHttpClient() {
        Class<PooledHTTPClientFactory> clazz = PooledHTTPClientFactory.class;
        synchronized (PooledHTTPClientFactory.class) {
            if (httpClient != null) {
                try {
                    httpClient.close();
                    httpClient = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (monitor != null) {
                try {
                    monitor.shutdown();
                    monitor = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) {
    }
}

