/*
 * Decompiled with CFR 0.152.
 */
package com.xjyb.core.poll;

import com.xjyb.core.poll.PooledHTTPClientFactory;
import com.xjyb.exception.DataTransferException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import xjyb.org.apache.http.Header;
import xjyb.org.apache.http.HttpEntity;
import xjyb.org.apache.http.client.ClientProtocolException;
import xjyb.org.apache.http.client.methods.CloseableHttpResponse;
import xjyb.org.apache.http.client.methods.HttpPost;
import xjyb.org.apache.http.client.utils.HttpClientUtils;
import xjyb.org.apache.http.conn.ConnectTimeoutException;
import xjyb.org.apache.http.conn.ConnectionPoolTimeoutException;
import xjyb.org.apache.http.conn.HttpHostConnectException;
import xjyb.org.apache.http.entity.ContentType;
import xjyb.org.apache.http.entity.StringEntity;
import xjyb.org.apache.http.impl.client.CloseableHttpClient;
import xjyb.org.apache.http.message.BasicHeader;
import xjyb.org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostRequest(String url, String jsonStr) throws DataTransferException {
        String string;
        String result = null;
        CloseableHttpClient httpClient = PooledHTTPClientFactory.getHttpClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            StringEntity s2 = new StringEntity(jsonStr, ContentType.create("application/json", StandardCharsets.UTF_8));
            httpPost.setEntity(s2);
            response = httpClient.execute(httpPost);
            if (response != null) {
                int statusCode = response.getStatusLine().getStatusCode();
                if (200 != statusCode) {
                    throw new DataTransferException("0101001002006", "\u4e0e\u524d\u7f6e\u8def\u7531\u901a\u4fe1\u5931\u8d25\uff1a\u8fd4\u56de\u7684HTTP\u72b6\u6001\u7801\u4e3a" + statusCode);
                }
                HttpEntity resEntity = response.getEntity();
                if (resEntity != null) {
                    result = EntityUtils.toString(resEntity, StandardCharsets.UTF_8);
                }
            }
            string = result;
        }
        catch (ClientProtocolException e) {
            try {
                throw new DataTransferException("0101001002001", "\u524d\u7f6e\u8def\u7531URL\u914d\u7f6e\u9519\u8bef\uff1a\u5408\u6cd5URL\u8def\u5f84\u5e94\u4ee5http://\u5f00\u5934\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u524d\u7f6e\u8def\u7531URL", e);
                catch (IOException e2) {
                    if (e2 instanceof ConnectionPoolTimeoutException) {
                        throw new DataTransferException("0101001002005", "\u524d\u7f6e\u8def\u7531\u8fde\u63a5\u5931\u8d25\uff1a\u4ece\u8fde\u63a5\u6c60\u4e2d\u83b7\u53d6\u94fe\u63a5\u8d85\u65f6\uff0c\u8bf7\u9002\u5f53\u589e\u52a0maxTotal\u548cdefaultMaxPerRoute\u53c2\u6570\uff01", e2);
                    }
                    if (e2 instanceof ConnectTimeoutException) {
                        throw new DataTransferException("0101001002002", "\u524d\u7f6e\u8def\u7531\u8fde\u63a5\u5931\u8d25\uff1a\u76ee\u6807URL\u3010" + url + "\u3011\u5efa\u7acb\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u60c5\u51b5\u6216\u8005\u9002\u5f53\u589e\u52a0connectTimeout\u53c2\u6570\uff01", e2);
                    }
                    if (e2 instanceof SocketTimeoutException) {
                        throw new DataTransferException("0101001002003", "\u524d\u7f6e\u8def\u7531\u8fd4\u56de\u8d85\u65f6\uff1a\u76ee\u6807URL\u3010" + url + "\u3011\u8bfb\u53d6\u8fd4\u56de\u6570\u636e\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\u60c5\u51b5\u6216\u8005\u9002\u5f53\u589e\u52a0socketTimeout\u53c2\u6570\uff01", e2);
                    }
                    if (e2 instanceof HttpHostConnectException) {
                        throw new DataTransferException("0101001002004", "\u524d\u7f6e\u8def\u7531\u8fde\u63a5\u5931\u8d25\uff1a\u76ee\u6807URL\u3010" + url + "\u3011\u65e0\u6cd5\u8fde\u63a5\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u60c5\u51b5\u6216\u8005\u76ee\u6807\u670d\u52a1\u662f\u5426\u53ef\u4ee5\u8bbf\u95ee\uff01", e2);
                    }
                    throw new DataTransferException("0101001002006", e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly(response);
        return string;
    }

    static Header[] assemblyHeader(Map<String, String> headers) {
        Header[] allHeader = new BasicHeader[headers.size()];
        int i = 0;
        for (String str : headers.keySet()) {
            allHeader[i] = new BasicHeader(str, headers.get(str));
            ++i;
        }
        return allHeader;
    }
}

