/*
 * Decompiled with CFR 0.152.
 */
package com.uccs;

import com.owca.jce.provider.BouncyCastleProvider;
import com.uccs.AbstractBusinessHandler;
import com.xjyb.exception.InvalidArgumentException;
import com.xjyb.exception.NullArgumentException;
import com.xjyb.util.SecureCommonUtil;
import java.security.Provider;
import java.security.Security;
import java.util.regex.Pattern;
import xjyb.com.alibaba.fastjson.JSONException;
import xjyb.com.alibaba.fastjson.JSONObject;

public class CertUtilsImpl
extends AbstractBusinessHandler {
    private CertUtilsImpl() {
    }

    public static final CertUtilsImpl getInstance() {
        return Holder.INSTANCE;
    }

    public String initP10(String dn, String publicKey) {
        SecureCommonUtil.requireNonNull(dn, "dn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(publicKey, "publicKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.checkDn(dn);
        String reqDocHash = this.secureService.p10GeneratorHash(dn, publicKey);
        JSONObject dataJson = new JSONObject();
        dataJson.put("hash", (Object)reqDocHash);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String generaterP10(String dn, String publicKey, String sm2Sign) {
        SecureCommonUtil.requireNonNull(dn, "dn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(publicKey, "publicKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(sm2Sign, "sm2Sign\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String p10 = this.secureService.p10GeneratorString(dn, publicKey, sm2Sign);
        JSONObject dataJson = new JSONObject();
        dataJson.put("p10", (Object)p10);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String hashCalc(String reqDoc, String cert) {
        SecureCommonUtil.requireNonNull(reqDoc, "reqDoc\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(cert, "cert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String reqDocHash = this.secureService.calcHash(reqDoc, this.secureService.getPubKey(cert));
        JSONObject dataJson = new JSONObject();
        dataJson.put("hash", (Object)reqDocHash);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String getEncData(String p12Cert, String oriData) {
        SecureCommonUtil.requireNonNull(p12Cert, "p12Cert\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(oriData, "oriData\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            JSONObject json = JSONObject.parseObject(oriData);
            SecureCommonUtil.requireNonNull(json.getString("reqSignerName"), "oriData\u4e2dreqSignerName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if (json.getString("anywriteScript") == null && json.getString("anywriteImage") == null && json.getString("fingerPrint") == null) {
                throw new NullArgumentException("anywriteScript\u3001anywriteImage\u3001fingerPrint\u4e0d\u80fd\u5168\u90e8\u4e3a\u7a7a\uff0c\u81f3\u5c11\u9009\u5176\u4e00\uff01");
            }
        }
        catch (JSONException e) {
            throw new InvalidArgumentException("oriData\u683c\u5f0f\u5fc5\u987b\u4e3ajson\u5b57\u7b26\u4e32\uff01", e);
        }
        String encData = this.secureService.envelopedData(p12Cert, oriData);
        Security.removeProvider("BC");
        Security.addProvider((Provider)new BouncyCastleProvider());
        JSONObject dataJson = new JSONObject();
        dataJson.put("encData", (Object)encData);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String genKeyPairs() {
        String[] genKeyPairs = this.secureService.getGenKeyPairs();
        JSONObject dataJson = new JSONObject();
        dataJson.put("publicKey", (Object)genKeyPairs[0]);
        dataJson.put("privateKey", (Object)genKeyPairs[1]);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String signHash(String privateKey, String hash) {
        SecureCommonUtil.requireNonNull(privateKey, "privateKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(hash, "hash\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String signHash = this.secureService.getSignHash(privateKey, hash);
        JSONObject dataJson = new JSONObject();
        dataJson.put("sm2Sign", (Object)signHash);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String genPkcs7(String newP10, String cst, String privateKey) {
        SecureCommonUtil.requireNonNull(newP10, "newP10\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(cst, "cst\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(privateKey, "privateKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String genPkcs7 = this.secureService.getGenPkcs7(newP10, cst, privateKey);
        JSONObject dataJson = new JSONObject();
        dataJson.put("pkcs7", (Object)genPkcs7);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String decryptPrivateKey(String signCertPrivateKey, String encPrivateKey) {
        SecureCommonUtil.requireNonNull(signCertPrivateKey, "signCertPrivateKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        SecureCommonUtil.requireNonNull(encPrivateKey, "encPrivateKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String encCertPrivateKey = this.secureService.getDecryptPrivateKey(signCertPrivateKey, encPrivateKey);
        JSONObject dataJson = new JSONObject();
        dataJson.put("encCertPrivateKey", (Object)encCertPrivateKey);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String createTsRequest(String requestType, String hashAlgorithm, String inData) {
        SecureCommonUtil.requireNonNull(requestType, "requestType\u4e0d\u80fd\u4e3a\u7a7a");
        SecureCommonUtil.requireNonNull(hashAlgorithm, "hashAlgorithm\u4e0d\u80fd\u4e3a\u7a7a");
        SecureCommonUtil.requireNonNull(inData, "inData\u4e0d\u80fd\u4e3a\u7a7a");
        if (requestType != null && !"0".equals(requestType) && !"1".equals(requestType)) {
            throw new InvalidArgumentException("requestType\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + requestType);
        }
        if (!(hashAlgorithm == null || "0".equals(hashAlgorithm) || "3".equals(hashAlgorithm) || "4".equals(hashAlgorithm))) {
            throw new InvalidArgumentException("hashAlgorithm\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,3,4\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + hashAlgorithm);
        }
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, inData);
        if (!boo) {
            throw new InvalidArgumentException("inData\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        String timestampRequest = this.secureService.getCreateTsRequest(requestType, hashAlgorithm, this.secureService.calcHash(inData));
        JSONObject dataJson = new JSONObject();
        dataJson.put("timestampRequest", (Object)timestampRequest);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String verifyTsValidity(String timestampResponse, String hashAlgorithm, String signAlgorithm) {
        SecureCommonUtil.requireNonNull(timestampResponse, "timestampResponse\u4e0d\u80fd\u4e3a\u7a7a");
        SecureCommonUtil.requireNonNull(hashAlgorithm, "hashAlgorithm\u4e0d\u80fd\u4e3a\u7a7a");
        SecureCommonUtil.requireNonNull(signAlgorithm, "signAlgorithm\u4e0d\u80fd\u4e3a\u7a7a");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, timestampResponse);
        if (!boo) {
            throw new InvalidArgumentException("timestampResponse\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        if (!(hashAlgorithm == null || "0".equals(hashAlgorithm) || "3".equals(hashAlgorithm) || "4".equals(hashAlgorithm))) {
            throw new InvalidArgumentException("hashAlgorithm\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,3,4\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + hashAlgorithm);
        }
        if (signAlgorithm != null && !"1".equals(signAlgorithm) && !"2".equals(signAlgorithm)) {
            throw new InvalidArgumentException("signAlgorithm\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30101,2\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + signAlgorithm);
        }
        String isVerified = this.secureService.getVerifyTsValidity(timestampResponse, hashAlgorithm, signAlgorithm);
        JSONObject dataJson = new JSONObject();
        dataJson.put("isVerified", (Object)isVerified);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String getTsInfo(String timestampResponse) {
        SecureCommonUtil.requireNonNull(timestampResponse, "timestampResponse\u4e0d\u80fd\u4e3a\u7a7a");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, timestampResponse);
        if (!boo) {
            throw new InvalidArgumentException("timestampResponse\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        JSONObject dataJson = new JSONObject();
        try {
            String[] getTsInfo = this.secureService.getTsInfo(timestampResponse);
            dataJson.put("issuerName", (Object)getTsInfo[0]);
            dataJson.put("time", (Object)getTsInfo[1]);
        }
        catch (Exception e) {
            JSONObject reJson = new JSONObject();
            reJson.put("status", (Object)"0101001001002");
            reJson.put("message", (Object)"\u8bf7\u786e\u8ba4\u8f93\u5165\u53c2\u6570\u662f\u5426\u6b63\u786e");
            return reJson.toJSONString();
        }
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String getTsDetail(String timestampResponse, String itemNumber) {
        SecureCommonUtil.requireNonNull(timestampResponse, "timestampResponse\u4e0d\u80fd\u4e3a\u7a7a");
        SecureCommonUtil.requireNonNull(itemNumber, "itemNumber\u4e0d\u80fd\u4e3a\u7a7a");
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        boolean boo = Pattern.matches(base64Pattern, timestampResponse);
        if (!boo) {
            throw new InvalidArgumentException("timestampResponse\u4e0d\u662fbase64\u683c\u5f0f\uff01");
        }
        if (!(itemNumber == null || "0".equals(itemNumber) || "1".equals(itemNumber) || "2".equals(itemNumber) || "3".equals(itemNumber) || "4".equals(itemNumber) || "5".equals(itemNumber) || "6".equals(itemNumber) || "7".equals(itemNumber) || "8".equals(itemNumber) || "9".equals(itemNumber) || "10".equals(itemNumber) || "11".equals(itemNumber))) {
            throw new InvalidArgumentException("itemNumber\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1,2,3,4,5,6,7,8,9,10,11\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + itemNumber);
        }
        JSONObject dataJson = new JSONObject();
        try {
            String itemValue = this.secureService.getTsDetail(timestampResponse, itemNumber);
            dataJson.put("itemValue", (Object)itemValue);
        }
        catch (Exception e) {
            JSONObject reJson = new JSONObject();
            reJson.put("status", (Object)"0101001001002");
            reJson.put("message", (Object)"\u8bf7\u786e\u8ba4\u8f93\u5165\u53c2\u6570\u662f\u5426\u6b63\u786e");
            return reJson.toJSONString();
        }
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)"0");
        reJson.put("message", (Object)"success");
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    public String getSignTime(String signture) {
        SecureCommonUtil.requireNonNull(signture, "signture\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        String signTime = null;
        String status = "0";
        String msg = "success";
        try {
            signTime = this.secureService.getSignTime(signture);
        }
        catch (Exception e) {
            System.out.println("111");
            status = "0101001001002";
            msg = "\u8bf7\u68c0\u67e5\u7b7e\u540d\u683c\u5f0f\u662f\u5426\u6b63\u786e!";
        }
        JSONObject dataJson = new JSONObject();
        dataJson.put("signTime", (Object)signTime);
        JSONObject reJson = new JSONObject();
        reJson.put("status", (Object)status);
        reJson.put("message", (Object)msg);
        reJson.put("data", (Object)dataJson.toJSONString());
        return reJson.toJSONString();
    }

    private static class Holder {
        private static final CertUtilsImpl INSTANCE = new CertUtilsImpl();

        private Holder() {
        }
    }
}

