/*
 * Decompiled with CFR 0.152.
 */
package com.uccs;

import com.uccs.AppContext;
import com.uccs.KeyInfo;
import com.xjyb.ca.SecureService;
import com.xjyb.config.PasswordServiceConfig;
import com.xjyb.core.command.RequestCommand;
import com.xjyb.model.BusReturnData;
import com.xjyb.model.RcvRouteData;
import com.xjyb.model.SendRouteData;
import com.xjyb.util.SecureCommonUtil;
import java.util.Arrays;
import xjyb.com.alibaba.fastjson.JSONObject;

abstract class AbstractBusinessHandler {
    protected final SecureService secureService = AppContext.getInstance().getSecureService();
    protected final String appId;
    protected final String preId;

    protected AbstractBusinessHandler() {
        PasswordServiceConfig config = PasswordServiceConfig.getInstance();
        this.appId = config.getAppid();
        this.preId = config.getPreid();
    }

    protected String dealBussiness(String url, String transId, String busData, RequestCommand requestCommand) {
        AppContext appContext = AppContext.getInstance();
        KeyInfo currKey = appContext.getCurrKey();
        byte[] deriveKeyGroup = this.secureService.decryptKey(currKey.getMasterKey(), transId);
        byte[] key1 = Arrays.copyOfRange(deriveKeyGroup, 0, 16);
        byte[] iv1 = Arrays.copyOfRange(deriveKeyGroup, 16, 32);
        byte[] key2 = Arrays.copyOfRange(deriveKeyGroup, 32, 48);
        byte[] iv2 = Arrays.copyOfRange(deriveKeyGroup, 48, 64);
        System.out.println("\u52a0\u5bc6\u524ddata\u6570\u636e\u3010" + busData + "\u3011");
        busData = this.secureService.encryptByEnck(key2, busData, iv2);
        String sendMac = this.secureService.encryptByMak(key2, busData, iv2);
        SendRouteData sendRouteData = new SendRouteData(this.appId, this.preId, transId, currKey.getKeyVersion(), busData, sendMac);
        RcvRouteData resRouteData = requestCommand.request(url, sendRouteData);
        BusReturnData busReturnData = new BusReturnData();
        busReturnData.setTransId(resRouteData.getTransId());
        busReturnData.setStatus(resRouteData.getStatus());
        if (SecureCommonUtil.equals("0", resRouteData.getStatus())) {
            busReturnData.setMessage(resRouteData.getMessage());
            resRouteData.checkDataNonNull().checkMacNonNull();
            boolean macFlag = this.secureService.verifyMAC(key1, iv1, resRouteData.getData(), resRouteData.getMac());
            resRouteData.checkMacEquals(macFlag);
            String res = this.secureService.decryptByEnck(key1, resRouteData.getData(), iv1);
            busReturnData.setData(res);
        } else {
            busReturnData.setMessage(resRouteData.getMessage());
        }
        return JSONObject.toJSONString(busReturnData);
    }

    protected String dealBussinessWithoutData(String url, String transId, String busData, RequestCommand requestCommand) {
        AppContext appContext = AppContext.getInstance();
        KeyInfo currKey = appContext.getCurrKey();
        byte[] deriveKeyGroup = this.secureService.decryptKey(currKey.getMasterKey(), transId);
        byte[] key2 = Arrays.copyOfRange(deriveKeyGroup, 32, 48);
        byte[] iv2 = Arrays.copyOfRange(deriveKeyGroup, 48, 64);
        System.out.println("\u52a0\u5bc6\u524ddata\u6570\u636e\u3010" + busData + "\u3011");
        busData = this.secureService.encryptByEnck(key2, busData, iv2);
        String sendMac = this.secureService.encryptByMak(key2, busData, iv2);
        SendRouteData sendRouteData = new SendRouteData(this.appId, this.preId, transId, currKey.getKeyVersion(), busData, sendMac);
        RcvRouteData resRouteData = requestCommand.request(url, sendRouteData);
        BusReturnData busReturnData = new BusReturnData();
        busReturnData.setTransId(resRouteData.getTransId());
        busReturnData.setStatus(resRouteData.getStatus());
        busReturnData.setMessage(resRouteData.getMessage());
        return JSONObject.toJSONString(busReturnData);
    }
}

