/*
 * Decompiled with CFR 0.152.
 */
package com.pansoft.xbrl.xbrljson.convert;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.pansoft.xbrl.xbrljson.config.XbrlJsonConfigMgr;
import com.pansoft.xbrl.xbrljson.config.model.XbrlJsonConfig;
import com.pansoft.xbrl.xbrljson.convert.XbrlObjectCreator;
import com.pansoft.xbrl.xbrljson.model.Xbrl;
import com.pansoft.xbrl.xbrljson.outputer.XbrlOutputer;
import com.pansoft.xbrl.xbrljson.outputer.impl.BaseXbrlOutputer;
import com.pansoft.xbrl.xbrljson.util.StringUtil;
import java.util.logging.Logger;

public class JsonToXbrl {
    private static Logger log = Logger.getLogger(JsonToXbrl.class.toString());
    private XbrlOutputer xbrlOutputer = new BaseXbrlOutputer();

    public Xbrl createXbrlData(String jsonValue, String configId) {
        if (StringUtil.isBlank(jsonValue)) {
            return null;
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject(jsonValue, Feature.OrderedField);
            return this.createXbrlData(jsonObject, configId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Xbrl createXbrlData(JSONObject jsonObject, String configId) {
        if (jsonObject == null) {
            return null;
        }
        if (StringUtil.isBlank(configId)) {
            return null;
        }
        XbrlJsonConfig configObject = XbrlJsonConfigMgr.getInstance().getConfigObject(configId);
        if (configObject == null) {
            log.info("\u6ca1\u6709\u627e\u5230\u914d\u7f6e\u6587\u4ef6\u4fe1\u606f\uff0c\u914d\u7f6e\u7f16\u53f7[" + configId + "]");
            return null;
        }
        Xbrl retXbrl = null;
        retXbrl = XbrlObjectCreator.getInstance().createXbrlData(configObject, jsonObject);
        return retXbrl;
    }

    public String convertXbrlXml(String jsonValue, String configId) throws Exception {
        if (StringUtil.isBlank(jsonValue)) {
            return null;
        }
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
        JSONObject jsonObject = JSONObject.parseObject(jsonValue, Feature.OrderedField);
        return this.convertXbrlXml(jsonObject, configId);
    }

    public String convertXbrlXml(JSONObject jsonObject, String configId) throws Exception {
        Xbrl xbrlData = this.createXbrlData(jsonObject, configId);
        if (xbrlData == null) {
            throw new Exception("\u751f\u6210xbrl\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u6587\u4ef6");
        }
        if (this.xbrlOutputer != null) {
            return this.xbrlOutputer.getXbrlXml(xbrlData);
        }
        return null;
    }

    public void createXbrlFile(String jsonValue, String configId, String savePath, String fileName) throws Exception {
        if (StringUtil.isBlank(jsonValue)) {
            return;
        }
        JSONObject jsonObject = JSONObject.parseObject(jsonValue, Feature.OrderedField);
        this.createXbrlFile(jsonObject, configId, savePath, fileName);
    }

    public void createXbrlFile(JSONObject jsonObject, String configId, String savePath, String fileName) throws Exception {
        Xbrl xbrlData = this.createXbrlData(jsonObject, configId);
        if (xbrlData == null) {
            throw new Exception("\u751f\u6210xbrl\u6570\u636e\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u6587\u4ef6");
        }
        if (this.xbrlOutputer != null) {
            this.xbrlOutputer.exportXbrl(xbrlData, savePath, fileName, false);
        }
    }

    public XbrlOutputer getXbrlOutputer() {
        return this.xbrlOutputer;
    }

    public void setXbrlOutputer(XbrlOutputer xbrlOutputer) {
        this.xbrlOutputer = xbrlOutputer;
    }
}

