/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.xbrl.factory;

import api.VoucherFileInfo;
import api.VoucherFileUtil;
import com.alibaba.fastjson.JSONObject;
import com.ctjsoft.voucher.common.enums.VoucherTypeEnum;
import com.ctjsoft.voucher.common.pojo.accounting.AccountingEntityInformation;
import com.ctjsoft.voucher.common.pojo.receiver.IReceiver;
import com.ctjsoft.voucher.common.utils.JsonUtil;
import java.io.File;

public class ReceiverUtil {
    public static String generateXbrl(IReceiver receiver, AccountingEntityInformation accountingEntityInformation) {
        try {
            String json = JsonUtil.combinedJson(receiver, accountingEntityInformation);
            String xbrl = VoucherFileUtil.json2Xbrl(json, receiver.getVoucherType().name());
            System.out.println(xbrl);
            return xbrl;
        }
        catch (Exception ex) {
            throw new RuntimeException("\u901a\u8fc7\u63a5\u6536\u7aef\u4e1a\u52a1\u5bf9\u8c61\u548c\u4f1a\u8ba1\u4fe1\u606f\u751f\u6210\u7535\u5b50\u51ed\u8bc1\u63a5\u6536\u7aef\u7ed3\u6784\u5316\u6570\u636exbrl\u5185\u5bb9 err=" + ex.getMessage());
        }
    }

    public static VoucherFileInfo generateXbrlFile(IReceiver receiver, AccountingEntityInformation accountingEntityInformation, String receiverXmlFileName) {
        String outFilePath = System.getProperty("java.io.tmpdir") + File.separator + receiverXmlFileName;
        try {
            String json = JsonUtil.combinedJson(receiver, accountingEntityInformation);
            VoucherFileUtil.json2File(json, receiver.getVoucherType().name(), receiverXmlFileName);
            VoucherFileInfo vi = new VoucherFileInfo();
            vi.setVoucherType(receiver.getVoucherType().name());
            vi.setXbrlFilePath(outFilePath);
            System.out.println(vi);
            return vi;
        }
        catch (Exception ex) {
            throw new RuntimeException("generateXbrlFile \u901a\u8fc7\u63a5\u6536\u7aef\u4e1a\u52a1\u5bf9\u8c61\u548c\u4f1a\u8ba1\u4fe1\u606f\u751f\u6210\u7535\u5b50\u51ed\u8bc1\u63a5\u6536\u7aef\u7ed3\u6784\u5316\u6570\u636exbrl\u5185\u5bb9 err=" + ex.getMessage());
        }
    }

    public static String generateReceiverFileName(String issuerVoucherFilePath) {
        return issuerVoucherFilePath.replace("issuer", "receiver").substring(issuerVoucherFilePath.lastIndexOf("/") + 1);
    }

    public static IReceiver filledRequired(IReceiver receiver, JSONObject jo) {
        receiver.filledRequired(jo);
        return receiver;
    }

    public static boolean voucherTypeMatch(String voucherType, VoucherTypeEnum voucherTypeEnum) {
        String voucherTypePrefix = voucherTypeEnum.prefix();
        System.out.println("voucherType=" + voucherType + "  voucherTypePrefix:" + voucherTypePrefix);
        return voucherType.startsWith(voucherTypePrefix);
    }
}

