/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.verification.impl;

import com.ctjsoft.voucher.util.SignUtil;
import com.ctjsoft.voucher.verification.VoucherVerifier;
import com.google.common.primitives.Bytes;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.COSFilterInputStream;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLTaggedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfVerifier
implements VoucherVerifier {
    private static final Logger log = LoggerFactory.getLogger(PdfVerifier.class);

    @Override
    public boolean verify(String pdfFile) {
        boolean pdfVerifyResult = false;
        try {
            PDDocument document = PDDocument.load(new File(pdfFile));
            List<PDSignature> signatures = document.getSignatureDictionaries();
            String contents = signatures.get(0).getCOSObject().getNameAsString("Contents");
            log.info("pdf verify contents={}", (Object)contents);
            byte[] signedValueBytes = Base64.getDecoder().decode(contents);
            ASN1Sequence seq = ASN1Sequence.getInstance(signedValueBytes);
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)seq.getObjectAt(0);
            log.info("pdf verify oid={}", (Object)oid);
            DLTaggedObject signDataTag = (DLTaggedObject)seq.getObjectAt(1);
            DLSequence signDataSequence = (DLSequence)signDataTag.getObject().toASN1Primitive();
            DLTaggedObject certTag = (DLTaggedObject)signDataSequence.getObjectAt(1);
            DLSequence certSequence = (DLSequence)certTag.getObject().toASN1Primitive();
            X509Certificate x509 = SignUtil.parseX509Certificate(certSequence.getEncoded());
            log.info("x509.version={}", (Object)x509);
            byte[] sm2DigestBytes = signDataSequence.getObjectAt(5).toASN1Primitive().getEncoded();
            byte[] serverInfoBytes = signDataSequence.getObjectAt(4).toASN1Primitive().getEncoded();
            byte[] serverInfoSm3Digest = SignUtil.sm3Digest(serverInfoBytes);
            Path signedPath = Paths.get(pdfFile, new String[0]);
            byte[] pdfFileBytes = Files.readAllBytes(signedPath);
            for (PDSignature pdSignature : signatures) {
                log.info("Byte range : {}", (Object)Arrays.toString(pdSignature.getByteRange()));
                COSFilterInputStream fis = new COSFilterInputStream(pdfFileBytes, pdSignature.getByteRange());
                Throwable throwable = null;
                try {
                    byte[] bytes = fis.toByteArray();
                    byte[] originalBytes = SignUtil.sm3Digest(bytes);
                    byte[] combinedBytes = Bytes.concat(originalBytes, serverInfoSm3Digest);
                    pdfVerifyResult = SignUtil.verifySM2Signature(combinedBytes, sm2DigestBytes, x509);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fis == null) continue;
                    if (throwable != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
        }
        catch (Exception ex) {
            log.error("pdf verify err={}", (Object)ex.getMessage(), (Object)ex);
            throw new RuntimeException("\u975e\u7a0e\u9a8c\u7b7e\u51fa\u9519:" + ex.getMessage());
        }
        log.info("pdf verify result={}", (Object)pdfVerifyResult);
        if (!pdfVerifyResult) {
            throw new RuntimeException("\u975e\u7a0e\u9a8c\u7b7e\u5931\u8d25:pdfVerifyResult=" + pdfVerifyResult);
        }
        return pdfVerifyResult;
    }
}

