/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.verification.impl;

import com.ctjsoft.voucher.ofd.OfdParser;
import com.ctjsoft.voucher.ofd.pojo.OFD;
import com.ctjsoft.voucher.ofd.pojo.OFDSignature;
import com.ctjsoft.voucher.util.SignUtil;
import com.ctjsoft.voucher.util.VerifyUtil;
import com.ctjsoft.voucher.verification.context.VoucherVerifyContext;
import com.ctjsoft.voucher.verification.impl.AbstractVoucherVerifier;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdVerifier
extends AbstractVoucherVerifier {
    private static final Logger log = LoggerFactory.getLogger(OfdVerifier.class);
    private static Consumer<OFDSignature.Reference> referenceFileCheck = x -> {
        String base64 = SignUtil.sm3DigestBase64(x.$FileData);
        boolean checkValueEquals = x.CheckValue.equals(base64);
        log.info("---->4\uff0e\u6839\u636e\u6458\u8981\u7b97\u6cd5\u5206\u522b\u5bf9\u4fdd\u62a4\u6587\u4ef6\u8fdb\u884c\u6458\u8981\u8ba1\u7b97\uff0c\u5e76\u4e0eSignature.xml\u8bb0\u5f55\u7684\u6458\u8981\u6bd4\u5bf9checkValueEquals\uff1d[{},refFile={}],.base64={},CheckValue={}", checkValueEquals, x.FileRef, base64, x.CheckValue);
        if (!checkValueEquals) {
            log.warn("Failure: 4\uff0e\u6839\u636e\u6458\u8981\u7b97\u6cd5\u5206\u522b\u5bf9\u4fdd\u62a4\u6587\u4ef6\u8fdb\u884c\u6458\u8981\u8ba1\u7b97\uff0c\u5e76\u4e0eSignature.xml\u8bb0\u5f55\u7684\u6458\u8981\u6bd4\u5bf9.base64={},CheckValue={}", (Object)base64, (Object)x.CheckValue);
            throw new RuntimeException("\u6587\u4ef6\u6821\u9a8c\u5931\u8d25:\u6458\u8981\u503c\u4e0d\u4e00\u81f4\uff0e\u6839\u636e\u6458\u8981\u7b97\u6cd5\u5206\u522b\u5bf9\u4fdd\u62a4\u6587\u4ef6\u8fdb\u884c\u6458\u8981\u8ba1\u7b97\uff0c\u5e76\u4e0eSignature.xml\u8bb0\u5f55\u7684\u6458\u8981\u6bd4\u5bf9.file=" + x.FileRef + " base64=" + base64 + " CheckValue=" + x.CheckValue);
        }
    };

    @Override
    protected void verifyFile(VoucherVerifyContext context) {
        this.verifyReferenceFileInSignatureXml(context);
        this.generateSignatureXmlSM3Digest(context);
    }

    private void generateSignatureXmlSM3Digest(VoucherVerifyContext context) {
    }

    private void verifyReferenceFileInSignatureXml(VoucherVerifyContext context) {
        OFD ofd = context.getOfd();
        if (ofd.getOfdSignatures() == null || ofd.getOfdSignatures().getOfdSignature() == null || ofd.getOfdSignatures().getOfdSignature().getSignedInfo() == null || ofd.getOfdSignatures().getOfdSignature().getSignedInfo().References == null) {
            return;
        }
        ofd.getOfdSignatures().getOfdSignature().getSignedInfo().References.Reference.forEach(referenceFileCheck);
    }

    @Override
    protected VoucherVerifyContext init(String ofdFile) throws Exception {
        OFD ofd = OfdParser.parse(ofdFile);
        VoucherVerifyContext context = new VoucherVerifyContext();
        context.setOfd(ofd);
        context.setOfdFile(ofdFile);
        return context;
    }

    @Override
    protected void verifySignature(VoucherVerifyContext context) {
        log.info("----->ofd signature verify....start ");
        if (this.isSeal(context)) {
            this.verifySeal(context);
        } else {
            this.verifySign(context);
        }
        log.info("----->ofd signature verify....end");
    }

    private void verifySeal(VoucherVerifyContext context) {
        byte[] sourceData = context.getOfd().getOfdSignatures().getOfdSignature().$SignatureXml;
        byte[] signData = context.getOfd().getOfdSignatures().getOfdSignature().$SignedValueDat;
        boolean success = VerifyUtil.electronicSealSignatureDataVerify(sourceData, signData);
        log.info("verifySeal \u7b7e\u7ae0\u9a8c\u8bc1 \u7ed3\u679c:{}", (Object)success);
    }

    private void verifySign(VoucherVerifyContext context) {
        byte[] sourceData = context.getOfd().getOfdSignatures().getOfdSignature().$SignatureXml;
        byte[] signData = context.getOfd().getOfdSignatures().getOfdSignature().$SignedValueDat;
        boolean success = VerifyUtil.encryptedSignatureMessageVerify(sourceData, signData);
        log.info("verifySign \u7b7e\u540d\u9a8c\u8bc1\u7ed3\u679c:{}", (Object)success);
    }

    private boolean isSeal(VoucherVerifyContext context) {
        boolean isPkcs7 = SignUtil.isPkcs7SignedData(context.getOfd().getOfdSignatures().getOfdSignature().$SignedValueDat);
        return !isPkcs7;
    }
}

