/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.util;

import com.ctjsoft.voucher.signature.context.CertListTypeEnum;
import com.ctjsoft.voucher.signature.context.ElectronicSealSignatureVerifyContext;
import com.ctjsoft.voucher.signature.exceptions.SealException;
import com.ctjsoft.voucher.signature.seal.SeSeal;
import com.ctjsoft.voucher.signature.seal.SesEsPropertyInfo;
import com.ctjsoft.voucher.signature.seal.SesSignature;
import com.ctjsoft.voucher.signature.seal.TbsSign;
import com.ctjsoft.voucher.util.SignUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.factory.SignatureServiceFactory;
import com.ygsoft.abc.mapp.ygca.gwcw.service.ISignatureService;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyUtil {
    private static final Logger log = LoggerFactory.getLogger(VerifyUtil.class);
    private static final String SIGNED_DATA_OID = "1.2.156.10197.6.1.4.2.2";

    public static boolean vatVerify(byte[] signatrureXml, byte[] signedValueDat) {
        ISignatureService signatureService = SignatureServiceFactory.getInstance();
        String signedBase64 = new String(signedValueDat);
        boolean success = signatureService.verify(signatrureXml, signedBase64);
        log.info("\u589e\u503c\u7a0e\u7535\u5b50\u53d1\u7968-\u5206\u522b\u4f20\u5165\u4e24\u4e2a\u6587\u4ef6 \u9a8c\u8bc1:" + success);
        return success;
    }

    public static boolean vatZipVerify(byte[] zipData) {
        ISignatureService signatureService = SignatureServiceFactory.getInstance();
        boolean success = signatureService.verifyZip(zipData);
        log.info("\u589e\u503c\u7a0e\u7535\u5b50\u53d1\u7968-\u5355\u4e2azip\u6587\u4ef6 \u9a8c\u8bc1:" + success);
        return success;
    }

    public static boolean encryptedSignatureMessageVerify(byte[] signatrureXml, byte[] signedValueDat) {
        try {
            byte[] result = SignUtil.sm3Digest(signatrureXml);
            DEROctetString signatureXmlDigest = new DEROctetString(result);
            log.info("6.\u5bf9\u6574\u4e2aSignature.xml\u6587\u4ef6\u751f\u6210SM3\u6458\u8981:" + signatureXmlDigest);
            boolean isPkcs7 = SignUtil.isPkcs7SignedData(signedValueDat);
            if (!isPkcs7) {
                return false;
            }
            ASN1Sequence seq = ASN1Sequence.getInstance(signedValueDat);
            DLTaggedObject tag = (DLTaggedObject)seq.getObjectAt(1);
            SignedData signedData = SignedData.getInstance(tag.getObject());
            SignerInfo si = SignerInfo.getInstance(signedData.getSignerInfos().getObjectAt(0));
            ASN1Set attributes = si.getAuthenticatedAttributes();
            DLSequence attrDigest = (DLSequence)attributes.getObjectAt(2);
            DLSet dset = (DLSet)attrDigest.getObjectAt(1);
            DEROctetString originalDataDigest = (DEROctetString)dset.getObjectAt(0);
            log.info("7\uff0e\u8bfb\u53d6SignedValue.dat \u4ece\u7b7e\u540d\u5c5e\u6027\u503c\u4e2d\u83b7\u53d6\u539f\u6587\u6458\u8981\u503c:" + originalDataDigest);
            boolean digestMatch = signatureXmlDigest.equals(originalDataDigest);
            log.info("8\uff0e\u6bd4\u5bf96\u4ea7\u751f\u7684\u6458\u8981\u503c\u4e0e7\u89e3\u6790\u7684\u539f\u6587\u6458\u8981\u503c\u662f\u5426\u4e00\u81f4:" + digestMatch);
            log.info("---->TODO 9.\u5bf97\u7b7e\u540d\u5c5e\u6027\u503c\u8fdb\u884c\u6458\u8981\u548c\u9884\u5904\u7406\u83b7\u53d6\u6458\u8981\u9884\u5904\u7406\u503c\uff1b");
            log.info("10.\u6839\u636e7\u8fd4\u56de\u7684\u7ed3\u679c\u7b7e\u540d\u503c\u3001\u516c\u94a5\u8bc1\u4e66\u30019\u8fd4\u56de\u7684\u6458\u8981\u9884\u5904\u7406\u503c\u8fdb\u884c\u7b7e\u540d\u9a8c\u8bc1\uff0c\u82e5\u9a8c\u8bc1\u6210\u529f\u8868\u793a\u7248\u5f0f\u6587\u4ef6\u6709\u6548:");
            ASN1Set certificate = signedData.getCertificates();
            X509Certificate x509 = SignUtil.parseX509Certificate(certificate.getObjectAt(0).toASN1Primitive().getEncoded());
            log.info("x509.version=" + x509.getVersion());
            boolean vs2 = SignUtil.verifySM2Signature(si.getAuthenticatedAttributes().getEncoded(), si.getEncryptedDigest().getOctets(), x509);
            log.info("10.\u7ed3\u679c=" + vs2);
            return vs2;
        }
        catch (Exception ex) {
            log.error("\u52a0\u5bc6\u7b7e\u540d\u6d88\u606f\u9a8c\u8bc1\uff08\u7535\u5b50\u7b7e\u540d,PKCS#7 signedData\u7b7e\u540d\u6570\u636e\u7c7b\u578b\u9a8c\u8bc1\uff09 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("\u52a0\u5bc6\u7b7e\u540d\u6d88\u606f\u9a8c\u8bc1\uff08\u7535\u5b50\u7b7e\u540d,PKCS#7 signedData\u7b7e\u540d\u6570\u636e\u7c7b\u578b\u9a8c\u8bc1\uff09 err=" + ex.getMessage());
        }
    }

    public static boolean electronicSealSignatureDataVerify(byte[] signatureXml, byte[] signedValueDat) {
        if (signatureXml == null) {
            throw new SealException("electronicSealSignatureDataVerify \u539f\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        if (signedValueDat == null) {
            throw new SealException("electronicSealSignatureDataVerify \u7b7e\u540d\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        try {
            ElectronicSealSignatureVerifyContext essContext = new ElectronicSealSignatureVerifyContext(signatureXml, signedValueDat);
            VerifyUtil.electronicSealSignatureDataVerify(essContext);
            VerifyUtil.sealCorrectnessVerify(essContext);
            VerifyUtil.signatureValueVerify(essContext);
            VerifyUtil.certSealMatchVerify(essContext);
            VerifyUtil.signatureCertVerify(essContext);
            VerifyUtil.signatureTimeVerify(essContext);
            VerifyUtil.originalDataVerify(essContext);
            VerifyUtil.timeStampVerify(essContext);
            return true;
        }
        catch (Exception ex) {
            log.error("signedValueDatVerifyAir \u7535\u5b50\u7b7e\u7ae0\u9a8c\u7b7eerr={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("signedValueDatVerifyAir \u7535\u5b50\u7b7e\u7ae0\u9a8c\u7b7eerr=" + ex.getMessage());
        }
    }

    private static void signatureTimeVerify(ElectronicSealSignatureVerifyContext essContext) {
        SesSignature sesSignature = essContext.getSesSignature();
        try {
            log.info("X509 notBefore={}, notAfter={} sesSignature.toSign.timeInfo.data={}", essContext.getX509().getNotBefore(), essContext.getX509().getNotAfter(), sesSignature.getToSign().getTimeInfo().getDate());
            ASN1GeneralizedTime timeInfo = sesSignature.getToSign().getTimeInfo();
            String vs = timeInfo.getTimeString();
            log.info("timeInfo={}", (Object)timeInfo.getTimeString());
            if (!vs.startsWith("20")) {
                String vs2 = "20" + vs;
                timeInfo = new ASN1GeneralizedTime(vs2);
            }
            log.info("timeInfo.data={}", (Object)timeInfo.getDate());
            essContext.getX509().checkValidity(timeInfo.getDate());
        }
        catch (CertificateExpiredException ex) {
            log.error("7.3.f \u9a8c\u8bc1\u7b7e\u7ae0\u65f6\u95f4\u7684\u6709\u6548\u6027\u3002\u8bc1\u4e66\u8fc7\u671f err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("7.3.f \u9a8c\u8bc1\u7b7e\u7ae0\u65f6\u95f4\u7684\u6709\u6548\u6027:\u8bc1\u4e66\u8fc7\u671f,err=" + ex.getMessage());
        }
        catch (CertificateNotYetValidException ex) {
            log.error("7.3.f \u9a8c\u8bc1\u7b7e\u7ae0\u65f6\u95f4\u7684\u6709\u6548\u6027\u3002\u8bc1\u4e66\u672a\u751f\u6548\u3000 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("7.3.f \u9a8c\u8bc1\u7b7e\u7ae0\u65f6\u95f4\u7684\u6709\u6548\u6027:\u8bc1\u4e66\u672a\u751f\u6548,err=" + ex.getMessage());
        }
        catch (ParseException ex) {
            log.error("7.3.f \u9a8c\u8bc1\u7b7e\u7ae0\u65f6\u95f4\u7684\u6709\u6548\u6027\u3002\u89e3\u6790\u5f02\u5e38\u3000 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("7.3.f \u9a8c\u8bc1\u7b7e\u7ae0\u65f6\u95f4\u7684\u6709\u6548\u6027:\u89e3\u6790\u5f02\u5e38,err=" + ex.getMessage());
        }
    }

    private static void signatureCertVerify(ElectronicSealSignatureVerifyContext essContext) {
        try {
            SesSignature sesSignature = essContext.getSesSignature();
            X509Certificate x509 = SignUtil.parseX509Certificate(sesSignature.getCert().getOctets());
            log.info("x509.version={}", (Object)x509.getVersion());
            x509.checkValidity();
            log.info("7.3.e.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027\u3002PASS");
        }
        catch (CertificateExpiredException ex) {
            log.error("7.3.e.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027\u3002\u8bc1\u4e66\u8fc7\u671f err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("7.3.e.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027:\u8bc1\u4e66\u8fc7\u671f,err=" + ex.getMessage());
        }
        catch (CertificateNotYetValidException ex) {
            log.error("7.3.e.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027\u3002\u8bc1\u4e66\u672a\u751f\u6548\u3000 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("7.3.e.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027:\u8bc1\u4e66\u672a\u751f\u6548,err=" + ex.getMessage());
        }
        catch (CertificateException ex) {
            log.error("7.3.e.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027\u3002\u8bc1\u4e66\u5f02\u5e38\u3000 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("7.3.e.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027:\u8bc1\u4e66\u5f02\u5e38,err=" + ex.getMessage());
        }
    }

    private static void sealCorrectnessVerify(ElectronicSealSignatureVerifyContext essContext) {
        try {
            SeSeal eseal = essContext.getSesSignature().getToSign().getEseal();
            byte[] toSignByte = eseal.getSealInfoBytes();
            byte[] signByte = eseal.getSignedValue().getBytes();
            boolean validSignature = SignUtil.verifySM2Signature(toSignByte, signByte, essContext.getX509());
            log.info("6.3.b.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7b7e\u540d\u503c\u662f\u5426\u6b63\u786e \u7ed3\u679c={}", (Object)validSignature);
            if (!validSignature) {
                log.error("6.3.b.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7b7e\u540d\u503c\u662f\u5426\u6b63\u786e \u7ed3\u679c= FAILURE");
            }
            X509Certificate x509 = SignUtil.parseX509Certificate(eseal.getCert().getOctets());
            x509.checkValidity();
            log.info("6.3.c \u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u5236\u7ae0\u8005\u8bc1\u4e66\u7684\u6709\u6548\u6027 PASS");
            ASN1GeneralizedTime validStart = eseal.getESealInfo().getProperty().getValidStart();
            ASN1GeneralizedTime validEnd = eseal.getESealInfo().getProperty().getValidEnd();
            String vs = validStart.getTimeString();
            String ve = validEnd.getTimeString();
            log.info("vs={},ve={},vst={},vet={}", vs, ve, validStart.getTime(), validEnd.getTime());
            if (!vs.startsWith("20")) {
                String vs2 = "20" + vs;
                String ve2 = "20" + ve;
                validStart = new ASN1GeneralizedTime(vs2);
                validEnd = new ASN1GeneralizedTime(ve2);
            }
            VerifyUtil.valid(validStart.getDate(), validEnd.getDate());
            log.info("6.3.d \u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7684\u6709\u6548\u671f PASS");
        }
        catch (CertificateExpiredException ex) {
            log.error("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u3002\u8bc1\u4e66\u8fc7\u671f err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0:\u8bc1\u4e66\u8fc7\u671f,err=" + ex.getMessage());
        }
        catch (CertificateNotYetValidException ex) {
            log.error("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u3002\u8bc1\u4e66\u672a\u751f\u6548\u3000 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0:\u8bc1\u4e66\u672a\u751f\u6548,err=" + ex.getMessage());
        }
        catch (CertificateException ex) {
            log.error("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u3002\u8bc1\u4e66\u5f02\u5e38\u3000 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0:\u8bc1\u4e66\u5f02\u5e38,err=" + ex.getMessage());
        }
        catch (ParseException ex) {
            log.error("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u3002\u89e3\u6790\u5f02\u5e38\u3000 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("6.3.\u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0:\u89e3\u6790\u5f02\u5e38,err=" + ex.getMessage());
        }
    }

    public static void valid(Date notBefore, Date notAfter) {
        log.info("6.3.d \u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7684\u6709\u6548\u671f notBefore={},notAfter={}", (Object)notBefore, (Object)notAfter);
        Date now = new Date();
        if (notBefore.after(now)) {
            throw new RuntimeException("6.3.d \u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7684\u6709\u6548\u671f NotBefore: " + notBefore.toString());
        }
        if (notAfter.before(now)) {
            throw new RuntimeException("6.3.d \u9a8c\u8bc1\u7535\u5b50\u5370\u7ae0\u7684\u6709\u6548\u671f NotAfter: " + notAfter.toString());
        }
    }

    private static void timeStampVerify(ElectronicSealSignatureVerifyContext essContext) {
        log.info("h.\u9a8c\u8bc1\u65f6\u95f4\u6233\u7684\u6709\u6548\u6027");
        if (essContext.getSesSignature().getTimeStamp() == null) {
            log.info(" h.1.\u5982\u679c\u7535\u5b50\u7b7e\u7ae0\u4e2d\u5305\u542b\u65f6\u95f4\u6233.\u4e0d\u5305\u542b\u3002");
            return;
        }
        log.info("h.\u9a8c\u8bc1\u65f6\u95f4\u6233\u7684\u6709\u6548\u6027timeStamp=" + essContext.getSesSignature().getTimeStamp());
    }

    private static void certSealMatchVerify(ElectronicSealSignatureVerifyContext essContext) {
        boolean certsMatch = false;
        try {
            SesSignature sesSignature = essContext.getSesSignature();
            SesEsPropertyInfo sesEsPropertyInfo = sesSignature.getToSign().getEseal().getESealInfo().getProperty();
            if (CertListTypeEnum.CERT.toString().equals(sesEsPropertyInfo.getCertListType().toString())) {
                DERBitString essCert = new DERBitString(sesSignature.getCert().getEncoded());
                log.info("\u7b7e\u7ae0\u8005\u8bc1\u4e66:" + essCert);
                DERBitString sealCert = new DERBitString(sesEsPropertyInfo.getCerts().getObjectAt(0).toASN1Primitive().getEncoded());
                log.info("\u5370\u7ae0\u4e2d\u8bc1\u4e66:" + sealCert);
                certsMatch = essCert.equals(sealCert);
                log.debug("c.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u7684\u5339\u914d\u6027={}", (Object)certsMatch);
            } else {
                byte[] makerCertBytes = sesSignature.getCert().getEncoded();
                byte[] sealCertBytes = sesEsPropertyInfo.getCerts().getObjectAt(0).toASN1Primitive().getEncoded();
                certsMatch = Arrays.equals(makerCertBytes, sealCertBytes);
                log.debug("c.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u7684\u6742\u51d1\u503c\u5339\u914d\u6027={}", (Object)certsMatch);
            }
        }
        catch (SealException ex) {
            log.error("c.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u7684\u5339\u914d\u6027 SealException err={}", (Object)ex.getMessage(), (Object)ex);
            throw ex;
        }
        catch (Exception ex) {
            log.error("c.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u7684\u5339\u914d\u6027 err={}", (Object)ex.getMessage(), (Object)ex);
        }
        if (!certsMatch) {
            throw new SealException("c.\u9a8c\u8bc1\u7b7e\u7ae0\u8005\u8bc1\u4e66\u4e0e\u7535\u5b50\u5370\u7ae0\u7684\u5339\u914d\u6027:false");
        }
    }

    private static void originalDataVerify(ElectronicSealSignatureVerifyContext essContext) {
        try {
            byte[] source = essContext.getSignatrureXml();
            SesSignature sesSignature = essContext.getSesSignature();
            TbsSign tbsSign = sesSignature.getToSign();
            byte[] result = SignUtil.sm3Digest(source);
            boolean isOriginalDataValid = Arrays.equals(result, tbsSign.getDataHash().getBytes());
            log.info("f.\u9a8c\u8bc1\u539f\u6587\u6742\u51d1={}", (Object)isOriginalDataValid);
            if (!isOriginalDataValid) {
                throw new SealException("f.\u9a8c\u8bc1\u539f\u6587\u6742\u51d1:false");
            }
        }
        catch (Exception ex) {
            log.error("originalDataVerify f.\u9a8c\u8bc1\u539f\u6587\u6742\u51d1\uff1a\u5c06\u5f85\u9a8c\u8bc1\u539f\u6587\u8fdb\u884c\u6742\u51d1\u8fd0\u7b97\uff0c\u5f62\u6210\u5f85\u9a8c\u8bc1\u539f\u6587\u6742\u51d1\u503c\uff0c\u4e0e\u4ece\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u4e2d\u63d0\u53d6\u7684\u539f\u6587\u6742\u51d1\u503c\u8fdb\u884c\u4e8c\u8fdb\u5236\u5bf9\u6bd4\u3002 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("signatureValueVerify f.\u9a8c\u8bc1\u539f\u6587\u6742\u51d1\uff1a\u5c06\u5f85\u9a8c\u8bc1\u539f\u6587\u8fdb\u884c\u6742\u51d1\u8fd0\u7b97\uff0c\u5f62\u6210\u5f85\u9a8c\u8bc1\u539f\u6587\u6742\u51d1\u503c\uff0c\u4e0e\u4ece\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u4e2d\u63d0\u53d6\u7684\u539f\u6587\u6742\u51d1\u503c\u8fdb\u884c\u4e8c\u8fdb\u5236\u5bf9\u6bd4\u3002 err=" + ex.getMessage());
        }
    }

    private static void signatureValueVerify(ElectronicSealSignatureVerifyContext essContext) {
        try {
            byte[] toSignByte = essContext.getSesSignature().getToSignAsn1().getEncoded();
            byte[] signByte = essContext.getSesSignature().getSignature().getBytes();
            boolean validSignature = SignUtil.verifySM2Signature(toSignByte, signByte, essContext.getX509());
            log.info("b.\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u7b7e\u540d\u503c\u662f\u5426\u6b63\u786e={}", (Object)validSignature);
            if (!validSignature) {
                log.error("b.\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u7b7e\u540d\u503c\u4e0d\u6b63\u786e:FAILURE");
            }
        }
        catch (Exception ex) {
            log.error("signatureValueVerify b.\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u7b7e\u540d\u503c\u662f\u5426\u6b63\u786e\uff1a\u6839\u636e\u6b65\u9aa4a.\u89e3\u6790\u6240\u5f97\u7684\u7b7e\u7ae0\u4fe1\u606f\u3001\u7b7e\u7ae0\u8005\u8bc1\u4e66\u548c\u7b7e\u540d\u7b97\u6cd5\u6807\u8bc6\uff0c\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u7b7e\u540d\u503c\u3002 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("signatureValueVerify b.\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u7b7e\u540d\u503c\u662f\u5426\u6b63\u786e\uff1a\u6839\u636e\u6b65\u9aa4a.\u89e3\u6790\u6240\u5f97\u7684\u7b7e\u7ae0\u4fe1\u606f\u3001\u7b7e\u7ae0\u8005\u8bc1\u4e66\u548c\u7b7e\u540d\u7b97\u6cd5\u6807\u8bc6\uff0c\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u7b7e\u540d\u503c\u3002err=" + ex.getMessage());
        }
    }

    private static void electronicSealSignatureDataVerify(ElectronicSealSignatureVerifyContext context) {
        log.info("===>a.\u9a8c\u8bc1\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u683c\u5f0f\u7684\u6b63\u786e\u6027\uff1a\u6839\u636e\u56fd\u6807\u7535\u5b50\u7b7e\u7ae0\u3001\u7b7e\u7ae0\u4fe1\u606f\u6570\u636e\u7ed3\u6784\u7684\u5b9a\u4e49\u9a8c\u8bc1\u683c\u5f0f\u6b63\u786e\u6027\u3002");
        context.parseSignedValueDat();
        context.parseX509();
        log.info("===>a.\u901a\u8fc7");
    }
}

