/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.util;

import com.google.common.base.Preconditions;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Sm2Util {
    public static ECPrivateKeyParameters privateKeyToParams(String algorithm, byte[] key) throws InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException {
        Preconditions.checkNotNull(key, "key must be not null !");
        PrivateKey privateKey = Sm2Util.generatePrivateKey(algorithm, key);
        return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter(privateKey);
    }

    public static PrivateKey generatePrivateKey(String algorithm, byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Preconditions.checkNotNull(algorithm, "algorithm must be not null !");
        Preconditions.checkNotNull(key, "key must be not null !");
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
        algorithm = Sm2Util.getAlgorithmAfterWith(algorithm);
        return Sm2Util.getKeyFactory(algorithm).generatePrivate(keySpec);
    }

    public static ECPublicKeyParameters publicKeyToParams(String algorithm, byte[] key) throws InvalidKeyException, InvalidKeySpecException, NoSuchAlgorithmException {
        Preconditions.checkNotNull(key, "key must be not null !");
        PublicKey publicKey = Sm2Util.generatePublicKey(algorithm, key);
        return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter(publicKey);
    }

    public static PublicKey generatePublicKey(String algorithm, byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Preconditions.checkNotNull(algorithm, "algorithm must be not null !");
        Preconditions.checkNotNull(key, "key must be not null !");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(key);
        algorithm = Sm2Util.getAlgorithmAfterWith(algorithm);
        return Sm2Util.getKeyFactory(algorithm).generatePublic(keySpec);
    }

    private static String getAlgorithmAfterWith(String algorithm) {
        Preconditions.checkNotNull(algorithm, "algorithm must be not null !");
        if ("ECDSA".equalsIgnoreCase(algorithm) || "SM2".equalsIgnoreCase(algorithm)) {
            algorithm = "EC";
        }
        return algorithm;
    }

    private static KeyFactory getKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        BouncyCastleProvider provider = new BouncyCastleProvider();
        return KeyFactory.getInstance(algorithm, provider);
    }

    public static byte[] encrypt(byte[] data, byte[] publicKey) throws Exception {
        ParametersWithRandom pubKeyParameters = new ParametersWithRandom(Sm2Util.publicKeyToParams("SM2", publicKey));
        SM2Engine engine = new SM2Engine();
        engine.init(true, pubKeyParameters);
        return engine.processBlock(data, 0, data.length);
    }

    public static byte[] decrypt(byte[] data, byte[] privateKey) throws Exception {
        ECPrivateKeyParameters privateKeyParameters = Sm2Util.privateKeyToParams("SM2", privateKey);
        SM2Engine engine = new SM2Engine();
        engine.init(false, privateKeyParameters);
        byte[] byteDate = engine.processBlock(data, 0, data.length);
        return byteDate;
    }

    public static byte[] sign(byte[] data, byte[] privateKey) throws Exception {
        SM2Signer signer = new SM2Signer();
        ParametersWithRandom param = new ParametersWithRandom(Sm2Util.privateKeyToParams("SM2", privateKey));
        signer.init(true, param);
        signer.update(data, 0, data.length);
        return signer.generateSignature();
    }

    public static boolean verify(byte[] data, byte[] sign, byte[] publicKey) throws Exception {
        SM2Signer signer = new SM2Signer();
        ECPublicKeyParameters param = Sm2Util.publicKeyToParams("SM2", publicKey);
        signer.init(false, param);
        signer.update(data, 0, data.length);
        return signer.verifySignature(sign);
    }

    public static KeyPair generateSm2KeyPair() {
        try {
            ECGenParameterSpec sm2Spec = new ECGenParameterSpec("sm2p256v1");
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC", new BouncyCastleProvider());
            SecureRandom random = new SecureRandom();
            kpg.initialize(sm2Spec, random);
            KeyPair keyPair = kpg.generateKeyPair();
            return keyPair;
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210\u5bc6\u94a5\u5bf9\u5931\u8d25");
        }
    }

    public static void main(String[] args) throws Exception {
        KeyPair keyPair = Sm2Util.generateSm2KeyPair();
        String plaintext = "test";
        String ciphertext = Base64.getEncoder().encodeToString(Sm2Util.encrypt(plaintext.getBytes("utf-8"), keyPair.getPublic().getEncoded()));
        String signature = Base64.getEncoder().encodeToString(Sm2Util.sign(plaintext.getBytes("utf-8"), keyPair.getPrivate().getEncoded()));
        System.out.println("ciphertext: " + ciphertext);
        System.out.println("signature: " + signature);
        plaintext = new String(Sm2Util.decrypt(Base64.getDecoder().decode(ciphertext), keyPair.getPrivate().getEncoded()), "utf-8");
        boolean result = Sm2Util.verify(plaintext.getBytes("utf-8"), Base64.getDecoder().decode(signature), keyPair.getPublic().getEncoded());
        System.out.println("plaintext: " + plaintext);
        System.out.println("verify result: " + result);
    }
}

