/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.signature.seal;

import com.ctjsoft.voucher.signature.seal.SeSeal;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;

public class TbsSign
extends ASN1Object {
    private ASN1Integer version;
    private SeSeal eseal;
    private ASN1GeneralizedTime timeInfo;
    private DERBitString dataHash;
    private DERIA5String propertyInfo;
    private DERIA5String extDatas;

    private TbsSign(ASN1Sequence var1) {
        Enumeration var2 = var1.getObjects();
        this.version = (ASN1Integer)var2.nextElement();
        this.eseal = SeSeal.getInstance(var2.nextElement());
        this.timeInfo = (ASN1GeneralizedTime)var2.nextElement();
        this.dataHash = (DERBitString)var2.nextElement();
        this.propertyInfo = (DERIA5String)var2.nextElement();
        if (var2.hasMoreElements()) {
            this.extDatas = (DERIA5String)var2.nextElement();
        }
    }

    public static TbsSign getInstance(ASN1Encodable var0) {
        if (var0 instanceof TbsSign) {
            return (TbsSign)var0;
        }
        return var0 != null ? new TbsSign(ASN1Sequence.getInstance(var0)) : null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.eseal);
        vector.add(this.timeInfo);
        vector.add(this.dataHash);
        vector.add(this.propertyInfo);
        vector.add(this.extDatas);
        return new DERSequence(vector);
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public SeSeal getEseal() {
        return this.eseal;
    }

    public ASN1GeneralizedTime getTimeInfo() {
        return this.timeInfo;
    }

    public DERBitString getDataHash() {
        return this.dataHash;
    }

    public DERIA5String getPropertyInfo() {
        return this.propertyInfo;
    }

    public DERIA5String getExtDatas() {
        return this.extDatas;
    }

    public void setVersion(ASN1Integer version) {
        this.version = version;
    }

    public void setEseal(SeSeal eseal) {
        this.eseal = eseal;
    }

    public void setTimeInfo(ASN1GeneralizedTime timeInfo) {
        this.timeInfo = timeInfo;
    }

    public void setDataHash(DERBitString dataHash) {
        this.dataHash = dataHash;
    }

    public void setPropertyInfo(DERIA5String propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public void setExtDatas(DERIA5String extDatas) {
        this.extDatas = extDatas;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbsSign)) {
            return false;
        }
        TbsSign other = (TbsSign)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ASN1Integer this$version = this.getVersion();
        ASN1Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        SeSeal this$eseal = this.getEseal();
        SeSeal other$eseal = other.getEseal();
        if (this$eseal == null ? other$eseal != null : !((Object)this$eseal).equals(other$eseal)) {
            return false;
        }
        ASN1GeneralizedTime this$timeInfo = this.getTimeInfo();
        ASN1GeneralizedTime other$timeInfo = other.getTimeInfo();
        if (this$timeInfo == null ? other$timeInfo != null : !((Object)this$timeInfo).equals(other$timeInfo)) {
            return false;
        }
        DERBitString this$dataHash = this.getDataHash();
        DERBitString other$dataHash = other.getDataHash();
        if (this$dataHash == null ? other$dataHash != null : !((Object)this$dataHash).equals(other$dataHash)) {
            return false;
        }
        DERIA5String this$propertyInfo = this.getPropertyInfo();
        DERIA5String other$propertyInfo = other.getPropertyInfo();
        if (this$propertyInfo == null ? other$propertyInfo != null : !((Object)this$propertyInfo).equals(other$propertyInfo)) {
            return false;
        }
        DERIA5String this$extDatas = this.getExtDatas();
        DERIA5String other$extDatas = other.getExtDatas();
        return !(this$extDatas == null ? other$extDatas != null : !((Object)this$extDatas).equals(other$extDatas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TbsSign;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ASN1Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        SeSeal $eseal = this.getEseal();
        result = result * 59 + ($eseal == null ? 43 : ((Object)$eseal).hashCode());
        ASN1GeneralizedTime $timeInfo = this.getTimeInfo();
        result = result * 59 + ($timeInfo == null ? 43 : ((Object)$timeInfo).hashCode());
        DERBitString $dataHash = this.getDataHash();
        result = result * 59 + ($dataHash == null ? 43 : ((Object)$dataHash).hashCode());
        DERIA5String $propertyInfo = this.getPropertyInfo();
        result = result * 59 + ($propertyInfo == null ? 43 : ((Object)$propertyInfo).hashCode());
        DERIA5String $extDatas = this.getExtDatas();
        result = result * 59 + ($extDatas == null ? 43 : ((Object)$extDatas).hashCode());
        return result;
    }

    public String toString() {
        return "TbsSign(version=" + this.getVersion() + ", eseal=" + this.getEseal() + ", timeInfo=" + this.getTimeInfo() + ", dataHash=" + this.getDataHash() + ", propertyInfo=" + this.getPropertyInfo() + ", extDatas=" + this.getExtDatas() + ")";
    }
}

