/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.signature.seal;

import com.ctjsoft.voucher.signature.seal.TbsSign;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SesSignature
extends ASN1Object {
    private TbsSign toSign;
    private ASN1Sequence toSignAsn1;
    private DEROctetString cert;
    private ASN1ObjectIdentifier signatureAlgID;
    private DERBitString signature;
    private DERBitString timeStamp;

    public SesSignature(ASN1Sequence var1) {
        this.toSign = TbsSign.getInstance(var1.getObjectAt(0));
        this.toSignAsn1 = (ASN1Sequence)var1.getObjectAt(0);
        this.cert = (DEROctetString)var1.getObjectAt(1);
        this.signatureAlgID = (ASN1ObjectIdentifier)var1.getObjectAt(2);
        this.signature = (DERBitString)var1.getObjectAt(3);
        if (var1.size() == 5) {
            this.timeStamp = (DERBitString)var1.getObjectAt(4);
        }
    }

    public static SesSignature getInstance(Object var0) {
        if (var0 instanceof SesSignature) {
            return (SesSignature)var0;
        }
        return var0 != null ? new SesSignature(ASN1Sequence.getInstance(var0)) : null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.toSign);
        vector.add(this.toSignAsn1);
        vector.add(this.cert);
        vector.add(this.signatureAlgID);
        vector.add(this.signature);
        vector.add(this.timeStamp);
        return new DERSequence(vector);
    }

    public TbsSign getToSign() {
        return this.toSign;
    }

    public ASN1Sequence getToSignAsn1() {
        return this.toSignAsn1;
    }

    public DEROctetString getCert() {
        return this.cert;
    }

    public ASN1ObjectIdentifier getSignatureAlgID() {
        return this.signatureAlgID;
    }

    public DERBitString getSignature() {
        return this.signature;
    }

    public DERBitString getTimeStamp() {
        return this.timeStamp;
    }

    public void setToSign(TbsSign toSign) {
        this.toSign = toSign;
    }

    public void setToSignAsn1(ASN1Sequence toSignAsn1) {
        this.toSignAsn1 = toSignAsn1;
    }

    public void setCert(DEROctetString cert) {
        this.cert = cert;
    }

    public void setSignatureAlgID(ASN1ObjectIdentifier signatureAlgID) {
        this.signatureAlgID = signatureAlgID;
    }

    public void setSignature(DERBitString signature) {
        this.signature = signature;
    }

    public void setTimeStamp(DERBitString timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SesSignature)) {
            return false;
        }
        SesSignature other = (SesSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TbsSign this$toSign = this.getToSign();
        TbsSign other$toSign = other.getToSign();
        if (this$toSign == null ? other$toSign != null : !((Object)this$toSign).equals(other$toSign)) {
            return false;
        }
        ASN1Sequence this$toSignAsn1 = this.getToSignAsn1();
        ASN1Sequence other$toSignAsn1 = other.getToSignAsn1();
        if (this$toSignAsn1 == null ? other$toSignAsn1 != null : !((Object)this$toSignAsn1).equals(other$toSignAsn1)) {
            return false;
        }
        DEROctetString this$cert = this.getCert();
        DEROctetString other$cert = other.getCert();
        if (this$cert == null ? other$cert != null : !((Object)this$cert).equals(other$cert)) {
            return false;
        }
        ASN1ObjectIdentifier this$signatureAlgID = this.getSignatureAlgID();
        ASN1ObjectIdentifier other$signatureAlgID = other.getSignatureAlgID();
        if (this$signatureAlgID == null ? other$signatureAlgID != null : !((Object)this$signatureAlgID).equals(other$signatureAlgID)) {
            return false;
        }
        DERBitString this$signature = this.getSignature();
        DERBitString other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature)) {
            return false;
        }
        DERBitString this$timeStamp = this.getTimeStamp();
        DERBitString other$timeStamp = other.getTimeStamp();
        return !(this$timeStamp == null ? other$timeStamp != null : !((Object)this$timeStamp).equals(other$timeStamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SesSignature;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TbsSign $toSign = this.getToSign();
        result = result * 59 + ($toSign == null ? 43 : ((Object)$toSign).hashCode());
        ASN1Sequence $toSignAsn1 = this.getToSignAsn1();
        result = result * 59 + ($toSignAsn1 == null ? 43 : ((Object)$toSignAsn1).hashCode());
        DEROctetString $cert = this.getCert();
        result = result * 59 + ($cert == null ? 43 : ((Object)$cert).hashCode());
        ASN1ObjectIdentifier $signatureAlgID = this.getSignatureAlgID();
        result = result * 59 + ($signatureAlgID == null ? 43 : ((Object)$signatureAlgID).hashCode());
        DERBitString $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        DERBitString $timeStamp = this.getTimeStamp();
        result = result * 59 + ($timeStamp == null ? 43 : ((Object)$timeStamp).hashCode());
        return result;
    }

    public String toString() {
        return "SesSignature(toSign=" + this.getToSign() + ", toSignAsn1=" + this.getToSignAsn1() + ", cert=" + this.getCert() + ", signatureAlgID=" + this.getSignatureAlgID() + ", signature=" + this.getSignature() + ", timeStamp=" + this.getTimeStamp() + ")";
    }
}

