/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.signature.seal;

import com.ctjsoft.voucher.signature.seal.SesSealInfo;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SeSeal
extends ASN1Object {
    private SesSealInfo eSealInfo;
    private byte[] sealInfoBytes;
    private DEROctetString cert;
    private ASN1ObjectIdentifier signAlgID;
    private DERBitString signedValue;

    private SeSeal(ASN1Sequence var1) {
        Enumeration var2 = var1.getObjects();
        Object sealInfoObject = var2.nextElement();
        this.eSealInfo = SesSealInfo.getInstance(sealInfoObject);
        try {
            this.sealInfoBytes = ASN1Sequence.getInstance(sealInfoObject).getEncoded();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.cert = (DEROctetString)var2.nextElement();
        this.signAlgID = (ASN1ObjectIdentifier)var2.nextElement();
        this.signedValue = (DERBitString)var2.nextElement();
    }

    public static SeSeal getInstance(Object var0) {
        if (var0 instanceof SeSeal) {
            return (SeSeal)var0;
        }
        return var0 != null ? new SeSeal(ASN1Sequence.getInstance(var0)) : null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.eSealInfo);
        vector.add(this.cert);
        vector.add(this.signAlgID);
        vector.add(this.signedValue);
        return new DERSequence(vector);
    }

    public SesSealInfo getESealInfo() {
        return this.eSealInfo;
    }

    public byte[] getSealInfoBytes() {
        return this.sealInfoBytes;
    }

    public DEROctetString getCert() {
        return this.cert;
    }

    public ASN1ObjectIdentifier getSignAlgID() {
        return this.signAlgID;
    }

    public DERBitString getSignedValue() {
        return this.signedValue;
    }

    public void setESealInfo(SesSealInfo eSealInfo) {
        this.eSealInfo = eSealInfo;
    }

    public void setSealInfoBytes(byte[] sealInfoBytes) {
        this.sealInfoBytes = sealInfoBytes;
    }

    public void setCert(DEROctetString cert) {
        this.cert = cert;
    }

    public void setSignAlgID(ASN1ObjectIdentifier signAlgID) {
        this.signAlgID = signAlgID;
    }

    public void setSignedValue(DERBitString signedValue) {
        this.signedValue = signedValue;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeSeal)) {
            return false;
        }
        SeSeal other = (SeSeal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SesSealInfo this$eSealInfo = this.getESealInfo();
        SesSealInfo other$eSealInfo = other.getESealInfo();
        if (this$eSealInfo == null ? other$eSealInfo != null : !((Object)this$eSealInfo).equals(other$eSealInfo)) {
            return false;
        }
        if (!Arrays.equals(this.getSealInfoBytes(), other.getSealInfoBytes())) {
            return false;
        }
        DEROctetString this$cert = this.getCert();
        DEROctetString other$cert = other.getCert();
        if (this$cert == null ? other$cert != null : !((Object)this$cert).equals(other$cert)) {
            return false;
        }
        ASN1ObjectIdentifier this$signAlgID = this.getSignAlgID();
        ASN1ObjectIdentifier other$signAlgID = other.getSignAlgID();
        if (this$signAlgID == null ? other$signAlgID != null : !((Object)this$signAlgID).equals(other$signAlgID)) {
            return false;
        }
        DERBitString this$signedValue = this.getSignedValue();
        DERBitString other$signedValue = other.getSignedValue();
        return !(this$signedValue == null ? other$signedValue != null : !((Object)this$signedValue).equals(other$signedValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SeSeal;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SesSealInfo $eSealInfo = this.getESealInfo();
        result = result * 59 + ($eSealInfo == null ? 43 : ((Object)$eSealInfo).hashCode());
        result = result * 59 + Arrays.hashCode(this.getSealInfoBytes());
        DEROctetString $cert = this.getCert();
        result = result * 59 + ($cert == null ? 43 : ((Object)$cert).hashCode());
        ASN1ObjectIdentifier $signAlgID = this.getSignAlgID();
        result = result * 59 + ($signAlgID == null ? 43 : ((Object)$signAlgID).hashCode());
        DERBitString $signedValue = this.getSignedValue();
        result = result * 59 + ($signedValue == null ? 43 : ((Object)$signedValue).hashCode());
        return result;
    }

    public String toString() {
        return "SeSeal(eSealInfo=" + this.getESealInfo() + ", sealInfoBytes=" + Arrays.toString(this.getSealInfoBytes()) + ", cert=" + this.getCert() + ", signAlgID=" + this.getSignAlgID() + ", signedValue=" + this.getSignedValue() + ")";
    }
}

