/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.signature.context;

import com.ctjsoft.voucher.signature.exceptions.SealException;
import com.ctjsoft.voucher.signature.seal.SesSignature;
import com.ctjsoft.voucher.util.SignUtil;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicSealSignatureVerifyContext {
    private static final Logger log = LoggerFactory.getLogger(ElectronicSealSignatureVerifyContext.class);
    private byte[] signatrureXml;
    private byte[] signedValueDat;
    private SesSignature sesSignature;
    private X509Certificate x509;

    public ElectronicSealSignatureVerifyContext(byte[] signedValueDat) {
        this.signedValueDat = signedValueDat;
    }

    public ElectronicSealSignatureVerifyContext(byte[] signatrureXml, byte[] signedValueDat) {
        this.signatrureXml = signatrureXml;
        this.signedValueDat = signedValueDat;
    }

    public void parseSignedValueDat() {
        ASN1Sequence seq = ASN1Sequence.getInstance(this.signedValueDat);
        try {
            this.sesSignature = SesSignature.getInstance(seq);
        }
        catch (Exception ex) {
            log.error("parseSignedValueDat \u4ece\u7535\u5b50\u7b7e\u7ae0\u7684\u6570\u636e\u6587\u4ef6SignedValue.dat\u4e2d\u89e3\u6790\u51fa\u7535\u5b50\u7b7e\u7ae0 \u6570\u636e\u683c\u5f0f\u9519\u8beferr={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("parseSignedValueDat \u4ece\u7535\u5b50\u7b7e\u7ae0\u7684\u6570\u636e\u6587\u4ef6SignedValue.dat\u4e2d\u89e3\u6790\u51fa\u7535\u5b50\u7b7e\u7ae0 \u6570\u636e\u683c\u5f0f\u9519\u8beferr=" + ex.getMessage());
        }
    }

    public void parseX509() {
        try {
            DEROctetString oct = this.getSesSignature().getCert();
            this.x509 = SignUtil.parseX509Certificate(oct.getOctets());
            System.out.println("x509.version=" + this.x509.getVersion());
        }
        catch (Exception ex) {
            log.error("parseX509 \u89e3\u6790X.509\u8bc1\u4e66 err={}", (Object)ex.getMessage(), (Object)ex);
            throw new SealException("parseX509 \u89e3\u6790X.509\u8bc1\u4e66  err:" + ex.getMessage());
        }
    }

    public byte[] getSignatrureXml() {
        return this.signatrureXml;
    }

    public byte[] getSignedValueDat() {
        return this.signedValueDat;
    }

    public SesSignature getSesSignature() {
        return this.sesSignature;
    }

    public X509Certificate getX509() {
        return this.x509;
    }

    public void setSignatrureXml(byte[] signatrureXml) {
        this.signatrureXml = signatrureXml;
    }

    public void setSignedValueDat(byte[] signedValueDat) {
        this.signedValueDat = signedValueDat;
    }

    public void setSesSignature(SesSignature sesSignature) {
        this.sesSignature = sesSignature;
    }

    public void setX509(X509Certificate x509) {
        this.x509 = x509;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElectronicSealSignatureVerifyContext)) {
            return false;
        }
        ElectronicSealSignatureVerifyContext other = (ElectronicSealSignatureVerifyContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getSignatrureXml(), other.getSignatrureXml())) {
            return false;
        }
        if (!Arrays.equals(this.getSignedValueDat(), other.getSignedValueDat())) {
            return false;
        }
        SesSignature this$sesSignature = this.getSesSignature();
        SesSignature other$sesSignature = other.getSesSignature();
        if (this$sesSignature == null ? other$sesSignature != null : !((Object)this$sesSignature).equals(other$sesSignature)) {
            return false;
        }
        X509Certificate this$x509 = this.getX509();
        X509Certificate other$x509 = other.getX509();
        return !(this$x509 == null ? other$x509 != null : !((Object)this$x509).equals(other$x509));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElectronicSealSignatureVerifyContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getSignatrureXml());
        result = result * 59 + Arrays.hashCode(this.getSignedValueDat());
        SesSignature $sesSignature = this.getSesSignature();
        result = result * 59 + ($sesSignature == null ? 43 : ((Object)$sesSignature).hashCode());
        X509Certificate $x509 = this.getX509();
        result = result * 59 + ($x509 == null ? 43 : ((Object)$x509).hashCode());
        return result;
    }

    public String toString() {
        return "ElectronicSealSignatureVerifyContext(signatrureXml=" + Arrays.toString(this.getSignatrureXml()) + ", signedValueDat=" + Arrays.toString(this.getSignedValueDat()) + ", sesSignature=" + this.getSesSignature() + ", x509=" + this.getX509() + ")";
    }
}

