/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.ofd;

import com.ctjsoft.voucher.ofd.pojo.OFD;
import com.ctjsoft.voucher.ofd.pojo.OFDSignature;
import com.ctjsoft.voucher.ofd.pojo.OFDSignatures;
import com.ctjsoft.voucher.ofd.util.OfdUtil;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdParser {
    private static final Logger log = LoggerFactory.getLogger(OfdParser.class);

    public static OFD parse(String file) throws Exception {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry = zipFile.getEntry("OFD.xml");
            OFD ofd = OfdUtil.xmlToObject(zipFile.getInputStream(entry), OFD.class);
            ZipEntry signaturesEntry = zipFile.getEntry(OfdUtil.getPath(ofd.getDocBody().getSignatures()));
            OFDSignatures ofdSignatures = OfdUtil.xmlToObject(zipFile.getInputStream(signaturesEntry), OFDSignatures.class);
            ofd.setOfdSignatures(ofdSignatures);
            String signatureXmlFullPath = ofd.getSignatureXmlFullPath();
            log.info("--->signatureFullPath={}", (Object)signatureXmlFullPath);
            ZipEntry signatureEntry = zipFile.getEntry(signatureXmlFullPath);
            OFDSignature ofdSignature = OfdUtil.xmlToObject(zipFile.getInputStream(signatureEntry), OFDSignature.class);
            ofdSignatures.setOfdSignature(ofdSignature);
            byte[] signatureXmlBytes = OfdUtil.getBytes(zipFile.getInputStream(signatureEntry));
            ofdSignature.$SignatureXml = signatureXmlBytes;
            if (ofdSignature.getSignedInfo() != null && ofdSignature.getSignedInfo().References != null) {
                for (OFDSignature.Reference reference : ofdSignature.getSignedInfo().References.Reference) {
                    String path = reference.FileRef;
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    reference.$FileData = OfdUtil.getBytes(zipFile.getInputStream(zipFile.getEntry(path)));
                }
            }
            String signatureDatPath = ofd.getSignatureDatFullPath(signatureXmlFullPath);
            ofdSignature.$SignedValueDat = OfdUtil.getBytes(zipFile.getInputStream(zipFile.getEntry(signatureDatPath)));
            OFD oFD = ofd;
            return oFD;
        }
    }

    public static OFD parseOfdFromFile(String file) throws Exception {
        try (ZipFile zipFile = new ZipFile(file);){
            OFD ofd;
            ZipEntry entry = zipFile.getEntry("OFD.xml");
            OFD oFD = ofd = OfdUtil.xmlToObject(zipFile.getInputStream(entry), OFD.class);
            return oFD;
        }
    }
}

