/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.common.pojo.receiver;

import com.alibaba.fastjson.JSONObject;
import com.ctjsoft.voucher.common.enums.VoucherTypeEnum;
import com.ctjsoft.voucher.common.pojo.receiver.IReceiver;
import com.google.gson.annotations.SerializedName;
import java.math.BigDecimal;
import lombok.NonNull;

public class TlfReceiver
implements IReceiver {
    @SerializedName(value="UniqueCodeOfInvoice")
    private String uniqueCodeOfInvoice;
    @SerializedName(value="NameOfSeller")
    private String nameOfSeller;
    @SerializedName(value="TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller")
    private String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
    @SerializedName(value="TotalAmountExcludingTax")
    private String totalAmountExcludingTax;
    @SerializedName(value="TotalTaxAmount")
    private String totalTaxAmount;
    @SerializedName(value="TaxIncludedAmountInFigures")
    private String taxIncludedAmountInFigures;
    @SerializedName(value="DateOfIssue")
    private String dateOfIssue;
    @SerializedName(value="WhetherInvoiceHasBeenFactoredSoldOrSecuritized")
    private Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized;
    @SerializedName(value="WhetherInvoiceIsRedInvoice")
    private boolean whetherInvoiceIsRedInvoice;
    @SerializedName(value="WhetherInvoiceHasBeenChecked")
    @NonNull
    private Boolean whetherInvoiceHasBeenChecked;
    @SerializedName(value="WhetherInvoiceUsageHasBeenConfirmed")
    @NonNull
    private Boolean whetherInvoiceUsageHasBeenConfirmed;
    @SerializedName(value="UsageConfirmation")
    @NonNull
    private String usageConfirmation;
    @SerializedName(value="PeriodOfUsageConfirmation")
    @NonNull
    private String periodOfUsageConfirmation;
    @SerializedName(value="WhetherInvoiceHasBeenBooked")
    @NonNull
    private Boolean whetherInvoiceHasBeenBooked;
    @SerializedName(value="WhetherInvoiceHasBeenPaid")
    private boolean whetherInvoiceHasBeenPaid;
    @SerializedName(value="NumberOfBankElectronicReceipt")
    private String numberOfBankElectronicReceipt;
    @SerializedName(value="WhetherInputVatHasBeenTransferredOut")
    @NonNull
    private Boolean whetherInputVatHasBeenTransferredOut;
    @SerializedName(value="AmountOfTransferredOutInputVat")
    @NonNull
    private BigDecimal amountOfTransferredOutInputVat;

    @Override
    public VoucherTypeEnum getVoucherType() {
        return VoucherTypeEnum.inv_tlf_receiver;
    }

    @Override
    public void filledRequired(JSONObject jo) {
        this.uniqueCodeOfInvoice = jo.getString("CodeOfInvoice") + jo.getString("NumberOfInvoice");
        if (jo.getString("CodeOfOriginalInvoice") != null || jo.getString("NumberOfOriginalInvoice") != null || jo.getString("ReasonOfRushRed") != null) {
            this.whetherInvoiceIsRedInvoice = true;
        }
        this.nameOfSeller = jo.getString("NameOfSeller");
        this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = jo.getString("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller");
        this.totalAmountExcludingTax = jo.getString("TotalAmountExcludingTax");
        this.totalTaxAmount = jo.getString("TotalTaxAmount");
        this.taxIncludedAmountInFigures = jo.getString("TaxIncludedAmountInFigures");
        this.dateOfIssue = jo.getString("DateOfIssue");
        this.whetherInvoiceHasBeenFactoredSoldOrSecuritized = false;
    }

    TlfReceiver(String uniqueCodeOfInvoice, String nameOfSeller, String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller, String totalAmountExcludingTax, String totalTaxAmount, String taxIncludedAmountInFigures, String dateOfIssue, Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized, boolean whetherInvoiceIsRedInvoice, @NonNull Boolean whetherInvoiceHasBeenChecked, @NonNull Boolean whetherInvoiceUsageHasBeenConfirmed, @NonNull String usageConfirmation, @NonNull String periodOfUsageConfirmation, @NonNull Boolean whetherInvoiceHasBeenBooked, boolean whetherInvoiceHasBeenPaid, String numberOfBankElectronicReceipt, @NonNull Boolean whetherInputVatHasBeenTransferredOut, @NonNull BigDecimal amountOfTransferredOutInputVat) {
        if (whetherInvoiceHasBeenChecked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
        }
        if (whetherInvoiceUsageHasBeenConfirmed == null) {
            throw new NullPointerException("whetherInvoiceUsageHasBeenConfirmed is marked non-null but is null");
        }
        if (usageConfirmation == null) {
            throw new NullPointerException("usageConfirmation is marked non-null but is null");
        }
        if (periodOfUsageConfirmation == null) {
            throw new NullPointerException("periodOfUsageConfirmation is marked non-null but is null");
        }
        if (whetherInvoiceHasBeenBooked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
        }
        if (whetherInputVatHasBeenTransferredOut == null) {
            throw new NullPointerException("whetherInputVatHasBeenTransferredOut is marked non-null but is null");
        }
        if (amountOfTransferredOutInputVat == null) {
            throw new NullPointerException("amountOfTransferredOutInputVat is marked non-null but is null");
        }
        this.uniqueCodeOfInvoice = uniqueCodeOfInvoice;
        this.nameOfSeller = nameOfSeller;
        this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
        this.totalAmountExcludingTax = totalAmountExcludingTax;
        this.totalTaxAmount = totalTaxAmount;
        this.taxIncludedAmountInFigures = taxIncludedAmountInFigures;
        this.dateOfIssue = dateOfIssue;
        this.whetherInvoiceHasBeenFactoredSoldOrSecuritized = whetherInvoiceHasBeenFactoredSoldOrSecuritized;
        this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
        this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
        this.whetherInvoiceUsageHasBeenConfirmed = whetherInvoiceUsageHasBeenConfirmed;
        this.usageConfirmation = usageConfirmation;
        this.periodOfUsageConfirmation = periodOfUsageConfirmation;
        this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
        this.whetherInvoiceHasBeenPaid = whetherInvoiceHasBeenPaid;
        this.numberOfBankElectronicReceipt = numberOfBankElectronicReceipt;
        this.whetherInputVatHasBeenTransferredOut = whetherInputVatHasBeenTransferredOut;
        this.amountOfTransferredOutInputVat = amountOfTransferredOutInputVat;
    }

    public static TlfReceiverBuilder builder() {
        return new TlfReceiverBuilder();
    }

    public static class TlfReceiverBuilder {
        private String uniqueCodeOfInvoice;
        private String nameOfSeller;
        private String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
        private String totalAmountExcludingTax;
        private String totalTaxAmount;
        private String taxIncludedAmountInFigures;
        private String dateOfIssue;
        private Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized;
        private boolean whetherInvoiceIsRedInvoice;
        private Boolean whetherInvoiceHasBeenChecked;
        private Boolean whetherInvoiceUsageHasBeenConfirmed;
        private String usageConfirmation;
        private String periodOfUsageConfirmation;
        private Boolean whetherInvoiceHasBeenBooked;
        private boolean whetherInvoiceHasBeenPaid;
        private String numberOfBankElectronicReceipt;
        private Boolean whetherInputVatHasBeenTransferredOut;
        private BigDecimal amountOfTransferredOutInputVat;

        TlfReceiverBuilder() {
        }

        public TlfReceiverBuilder uniqueCodeOfInvoice(String uniqueCodeOfInvoice) {
            this.uniqueCodeOfInvoice = uniqueCodeOfInvoice;
            return this;
        }

        public TlfReceiverBuilder nameOfSeller(String nameOfSeller) {
            this.nameOfSeller = nameOfSeller;
            return this;
        }

        public TlfReceiverBuilder taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller(String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller) {
            this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
            return this;
        }

        public TlfReceiverBuilder totalAmountExcludingTax(String totalAmountExcludingTax) {
            this.totalAmountExcludingTax = totalAmountExcludingTax;
            return this;
        }

        public TlfReceiverBuilder totalTaxAmount(String totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            return this;
        }

        public TlfReceiverBuilder taxIncludedAmountInFigures(String taxIncludedAmountInFigures) {
            this.taxIncludedAmountInFigures = taxIncludedAmountInFigures;
            return this;
        }

        public TlfReceiverBuilder dateOfIssue(String dateOfIssue) {
            this.dateOfIssue = dateOfIssue;
            return this;
        }

        public TlfReceiverBuilder whetherInvoiceHasBeenFactoredSoldOrSecuritized(Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized) {
            this.whetherInvoiceHasBeenFactoredSoldOrSecuritized = whetherInvoiceHasBeenFactoredSoldOrSecuritized;
            return this;
        }

        public TlfReceiverBuilder whetherInvoiceIsRedInvoice(boolean whetherInvoiceIsRedInvoice) {
            this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
            return this;
        }

        public TlfReceiverBuilder whetherInvoiceHasBeenChecked(@NonNull Boolean whetherInvoiceHasBeenChecked) {
            if (whetherInvoiceHasBeenChecked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
            return this;
        }

        public TlfReceiverBuilder whetherInvoiceUsageHasBeenConfirmed(@NonNull Boolean whetherInvoiceUsageHasBeenConfirmed) {
            if (whetherInvoiceUsageHasBeenConfirmed == null) {
                throw new NullPointerException("whetherInvoiceUsageHasBeenConfirmed is marked non-null but is null");
            }
            this.whetherInvoiceUsageHasBeenConfirmed = whetherInvoiceUsageHasBeenConfirmed;
            return this;
        }

        public TlfReceiverBuilder usageConfirmation(@NonNull String usageConfirmation) {
            if (usageConfirmation == null) {
                throw new NullPointerException("usageConfirmation is marked non-null but is null");
            }
            this.usageConfirmation = usageConfirmation;
            return this;
        }

        public TlfReceiverBuilder periodOfUsageConfirmation(@NonNull String periodOfUsageConfirmation) {
            if (periodOfUsageConfirmation == null) {
                throw new NullPointerException("periodOfUsageConfirmation is marked non-null but is null");
            }
            this.periodOfUsageConfirmation = periodOfUsageConfirmation;
            return this;
        }

        public TlfReceiverBuilder whetherInvoiceHasBeenBooked(@NonNull Boolean whetherInvoiceHasBeenBooked) {
            if (whetherInvoiceHasBeenBooked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
            return this;
        }

        public TlfReceiverBuilder whetherInvoiceHasBeenPaid(boolean whetherInvoiceHasBeenPaid) {
            this.whetherInvoiceHasBeenPaid = whetherInvoiceHasBeenPaid;
            return this;
        }

        public TlfReceiverBuilder numberOfBankElectronicReceipt(String numberOfBankElectronicReceipt) {
            this.numberOfBankElectronicReceipt = numberOfBankElectronicReceipt;
            return this;
        }

        public TlfReceiverBuilder whetherInputVatHasBeenTransferredOut(@NonNull Boolean whetherInputVatHasBeenTransferredOut) {
            if (whetherInputVatHasBeenTransferredOut == null) {
                throw new NullPointerException("whetherInputVatHasBeenTransferredOut is marked non-null but is null");
            }
            this.whetherInputVatHasBeenTransferredOut = whetherInputVatHasBeenTransferredOut;
            return this;
        }

        public TlfReceiverBuilder amountOfTransferredOutInputVat(@NonNull BigDecimal amountOfTransferredOutInputVat) {
            if (amountOfTransferredOutInputVat == null) {
                throw new NullPointerException("amountOfTransferredOutInputVat is marked non-null but is null");
            }
            this.amountOfTransferredOutInputVat = amountOfTransferredOutInputVat;
            return this;
        }

        public TlfReceiver build() {
            return new TlfReceiver(this.uniqueCodeOfInvoice, this.nameOfSeller, this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller, this.totalAmountExcludingTax, this.totalTaxAmount, this.taxIncludedAmountInFigures, this.dateOfIssue, this.whetherInvoiceHasBeenFactoredSoldOrSecuritized, this.whetherInvoiceIsRedInvoice, this.whetherInvoiceHasBeenChecked, this.whetherInvoiceUsageHasBeenConfirmed, this.usageConfirmation, this.periodOfUsageConfirmation, this.whetherInvoiceHasBeenBooked, this.whetherInvoiceHasBeenPaid, this.numberOfBankElectronicReceipt, this.whetherInputVatHasBeenTransferredOut, this.amountOfTransferredOutInputVat);
        }

        public String toString() {
            return "TlfReceiver.TlfReceiverBuilder(uniqueCodeOfInvoice=" + this.uniqueCodeOfInvoice + ", nameOfSeller=" + this.nameOfSeller + ", taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller=" + this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller + ", totalAmountExcludingTax=" + this.totalAmountExcludingTax + ", totalTaxAmount=" + this.totalTaxAmount + ", taxIncludedAmountInFigures=" + this.taxIncludedAmountInFigures + ", dateOfIssue=" + this.dateOfIssue + ", whetherInvoiceHasBeenFactoredSoldOrSecuritized=" + this.whetherInvoiceHasBeenFactoredSoldOrSecuritized + ", whetherInvoiceIsRedInvoice=" + this.whetherInvoiceIsRedInvoice + ", whetherInvoiceHasBeenChecked=" + this.whetherInvoiceHasBeenChecked + ", whetherInvoiceUsageHasBeenConfirmed=" + this.whetherInvoiceUsageHasBeenConfirmed + ", usageConfirmation=" + this.usageConfirmation + ", periodOfUsageConfirmation=" + this.periodOfUsageConfirmation + ", whetherInvoiceHasBeenBooked=" + this.whetherInvoiceHasBeenBooked + ", whetherInvoiceHasBeenPaid=" + this.whetherInvoiceHasBeenPaid + ", numberOfBankElectronicReceipt=" + this.numberOfBankElectronicReceipt + ", whetherInputVatHasBeenTransferredOut=" + this.whetherInputVatHasBeenTransferredOut + ", amountOfTransferredOutInputVat=" + this.amountOfTransferredOutInputVat + ")";
        }
    }
}

