/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.common.pojo.receiver;

import com.alibaba.fastjson.JSONObject;
import com.ctjsoft.voucher.common.enums.VoucherTypeEnum;
import com.ctjsoft.voucher.common.pojo.receiver.IReceiver;
import com.google.gson.annotations.SerializedName;
import lombok.NonNull;

public class NtrevReceiver
implements IReceiver {
    @SerializedName(value="EINVOICE_ID")
    private String eInvoiceId;
    @SerializedName(value="BILL_DATE")
    private String billDate;
    @SerializedName(value="PAID_AMT")
    private String paidAmt;
    @SerializedName(value="WhetherInvoiceIsRedInvoice")
    @NonNull
    private Boolean whetherInvoiceIsRedInvoice;
    @SerializedName(value="WhetherInvoiceHasBeenChecked")
    @NonNull
    private Boolean whetherInvoiceHasBeenChecked;
    @SerializedName(value="WhetherInvoiceHasBeenBooked")
    @NonNull
    private Boolean whetherInvoiceHasBeenBooked;

    @Override
    public VoucherTypeEnum getVoucherType() {
        return VoucherTypeEnum.ntrev_gpm_receiver;
    }

    @Override
    public void filledRequired(JSONObject jo) {
        this.eInvoiceId = jo.getJSONObject("HEADER").getString("EINVOICE_ID");
        if (this.billDate == null) {
            this.billDate = jo.getJSONObject("EINVOICE_DATA").getJSONObject("MAIN").getString("BILL_DATE");
        }
        if (this.paidAmt == null) {
            this.paidAmt = jo.getJSONObject("EINVOICE_DATA").getJSONObject("MAIN").getString("PAID_AMT");
        }
    }

    NtrevReceiver(String eInvoiceId, String billDate, String paidAmt, @NonNull Boolean whetherInvoiceIsRedInvoice, @NonNull Boolean whetherInvoiceHasBeenChecked, @NonNull Boolean whetherInvoiceHasBeenBooked) {
        if (whetherInvoiceIsRedInvoice == null) {
            throw new NullPointerException("whetherInvoiceIsRedInvoice is marked non-null but is null");
        }
        if (whetherInvoiceHasBeenChecked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
        }
        if (whetherInvoiceHasBeenBooked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
        }
        this.eInvoiceId = eInvoiceId;
        this.billDate = billDate;
        this.paidAmt = paidAmt;
        this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
        this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
        this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
    }

    public static NtrevReceiverBuilder builder() {
        return new NtrevReceiverBuilder();
    }

    public static class NtrevReceiverBuilder {
        private String eInvoiceId;
        private String billDate;
        private String paidAmt;
        private Boolean whetherInvoiceIsRedInvoice;
        private Boolean whetherInvoiceHasBeenChecked;
        private Boolean whetherInvoiceHasBeenBooked;

        NtrevReceiverBuilder() {
        }

        public NtrevReceiverBuilder eInvoiceId(String eInvoiceId) {
            this.eInvoiceId = eInvoiceId;
            return this;
        }

        public NtrevReceiverBuilder billDate(String billDate) {
            this.billDate = billDate;
            return this;
        }

        public NtrevReceiverBuilder paidAmt(String paidAmt) {
            this.paidAmt = paidAmt;
            return this;
        }

        public NtrevReceiverBuilder whetherInvoiceIsRedInvoice(@NonNull Boolean whetherInvoiceIsRedInvoice) {
            if (whetherInvoiceIsRedInvoice == null) {
                throw new NullPointerException("whetherInvoiceIsRedInvoice is marked non-null but is null");
            }
            this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
            return this;
        }

        public NtrevReceiverBuilder whetherInvoiceHasBeenChecked(@NonNull Boolean whetherInvoiceHasBeenChecked) {
            if (whetherInvoiceHasBeenChecked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
            return this;
        }

        public NtrevReceiverBuilder whetherInvoiceHasBeenBooked(@NonNull Boolean whetherInvoiceHasBeenBooked) {
            if (whetherInvoiceHasBeenBooked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
            return this;
        }

        public NtrevReceiver build() {
            return new NtrevReceiver(this.eInvoiceId, this.billDate, this.paidAmt, this.whetherInvoiceIsRedInvoice, this.whetherInvoiceHasBeenChecked, this.whetherInvoiceHasBeenBooked);
        }

        public String toString() {
            return "NtrevReceiver.NtrevReceiverBuilder(eInvoiceId=" + this.eInvoiceId + ", billDate=" + this.billDate + ", paidAmt=" + this.paidAmt + ", whetherInvoiceIsRedInvoice=" + this.whetherInvoiceIsRedInvoice + ", whetherInvoiceHasBeenChecked=" + this.whetherInvoiceHasBeenChecked + ", whetherInvoiceHasBeenBooked=" + this.whetherInvoiceHasBeenBooked + ")";
        }
    }
}

