/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.common.pojo.receiver;

import com.alibaba.fastjson.JSONObject;
import com.ctjsoft.voucher.common.enums.VoucherTypeEnum;
import com.ctjsoft.voucher.common.pojo.receiver.IReceiver;
import com.google.gson.annotations.SerializedName;
import lombok.NonNull;

public class InvOrdReceiver
implements IReceiver {
    @SerializedName(value="UniqueCodeOfInvoice")
    private String uniqueCodeOfInvoice;
    @SerializedName(value="NameOfSeller")
    private String nameOfSeller;
    @SerializedName(value="TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller")
    private String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
    @SerializedName(value="TotalAmountExcludingTax")
    private String totalAmountExcludingTax;
    @SerializedName(value="TotalTaxAmount")
    private String totalTaxAmount;
    @SerializedName(value="TaxIncludedAmountInFigures")
    private String taxIncludedAmountInFigures;
    @SerializedName(value="DateOfIssue")
    private String dateOfIssue;
    @SerializedName(value="WhetherInvoiceHasBeenFactoredSoldOrSecuritized")
    private Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized;
    @SerializedName(value="ContractNumber")
    private String contractNumber;
    @SerializedName(value="MatchingStateBetweenBusinessDocumentsAndVatEInvoice")
    private String matchingStateBetweenBusinessDocumentsAndVatEInvoice;
    @SerializedName(value="DepreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets")
    private String depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets;
    @SerializedName(value="WhetherInvoiceIsRedInvoice")
    private boolean whetherInvoiceIsRedInvoice;
    @SerializedName(value="WhetherInvoiceHasBeenChecked")
    @NonNull
    private Boolean whetherInvoiceHasBeenChecked;
    @SerializedName(value="WhetherInvoiceHasBeenBooked")
    @NonNull
    private Boolean whetherInvoiceHasBeenBooked;
    @SerializedName(value="WhetherInvoiceHasBeenPaid")
    private boolean whetherInvoiceHasBeenPaid;
    @SerializedName(value="NumberOfBankElectronicReceipt")
    private String numberOfBankElectronicReceipt;

    @Override
    public VoucherTypeEnum getVoucherType() {
        return VoucherTypeEnum.inv_ord_receiver;
    }

    @Override
    public void filledRequired(JSONObject jo) {
        this.uniqueCodeOfInvoice = jo.getOrDefault((Object)"CodeOfInvoice", "").toString() + jo.getString("NumberOfInvoice");
        if (jo.getString("CodeOfOriginalInvoice") != null || jo.getString("NumberOfOriginalInvoice") != null || jo.getString("ReasonOfRushRed") != null) {
            this.whetherInvoiceIsRedInvoice = true;
        }
        this.nameOfSeller = jo.getString("NameOfSeller");
        this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = jo.getString("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller");
        this.totalAmountExcludingTax = jo.getString("TotalAmountExcludingTax");
        this.totalTaxAmount = jo.getString("TotalTaxAmount");
        this.taxIncludedAmountInFigures = jo.getString("TaxIncludedAmountInFigures");
        this.dateOfIssue = jo.getString("DateOfIssue");
        this.whetherInvoiceHasBeenFactoredSoldOrSecuritized = false;
        if (jo.getJSONObject("Header") != null) {
            this.uniqueCodeOfInvoice = jo.getJSONObject("Header").getString("EIid");
        }
    }

    InvOrdReceiver(String uniqueCodeOfInvoice, String nameOfSeller, String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller, String totalAmountExcludingTax, String totalTaxAmount, String taxIncludedAmountInFigures, String dateOfIssue, Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized, String contractNumber, String matchingStateBetweenBusinessDocumentsAndVatEInvoice, String depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets, boolean whetherInvoiceIsRedInvoice, @NonNull Boolean whetherInvoiceHasBeenChecked, @NonNull Boolean whetherInvoiceHasBeenBooked, boolean whetherInvoiceHasBeenPaid, String numberOfBankElectronicReceipt) {
        if (whetherInvoiceHasBeenChecked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
        }
        if (whetherInvoiceHasBeenBooked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
        }
        this.uniqueCodeOfInvoice = uniqueCodeOfInvoice;
        this.nameOfSeller = nameOfSeller;
        this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
        this.totalAmountExcludingTax = totalAmountExcludingTax;
        this.totalTaxAmount = totalTaxAmount;
        this.taxIncludedAmountInFigures = taxIncludedAmountInFigures;
        this.dateOfIssue = dateOfIssue;
        this.whetherInvoiceHasBeenFactoredSoldOrSecuritized = whetherInvoiceHasBeenFactoredSoldOrSecuritized;
        this.contractNumber = contractNumber;
        this.matchingStateBetweenBusinessDocumentsAndVatEInvoice = matchingStateBetweenBusinessDocumentsAndVatEInvoice;
        this.depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets = depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets;
        this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
        this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
        this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
        this.whetherInvoiceHasBeenPaid = whetherInvoiceHasBeenPaid;
        this.numberOfBankElectronicReceipt = numberOfBankElectronicReceipt;
    }

    public static InvOrdReceiverBuilder builder() {
        return new InvOrdReceiverBuilder();
    }

    public static class InvOrdReceiverBuilder {
        private String uniqueCodeOfInvoice;
        private String nameOfSeller;
        private String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
        private String totalAmountExcludingTax;
        private String totalTaxAmount;
        private String taxIncludedAmountInFigures;
        private String dateOfIssue;
        private Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized;
        private String contractNumber;
        private String matchingStateBetweenBusinessDocumentsAndVatEInvoice;
        private String depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets;
        private boolean whetherInvoiceIsRedInvoice;
        private Boolean whetherInvoiceHasBeenChecked;
        private Boolean whetherInvoiceHasBeenBooked;
        private boolean whetherInvoiceHasBeenPaid;
        private String numberOfBankElectronicReceipt;

        InvOrdReceiverBuilder() {
        }

        public InvOrdReceiverBuilder uniqueCodeOfInvoice(String uniqueCodeOfInvoice) {
            this.uniqueCodeOfInvoice = uniqueCodeOfInvoice;
            return this;
        }

        public InvOrdReceiverBuilder nameOfSeller(String nameOfSeller) {
            this.nameOfSeller = nameOfSeller;
            return this;
        }

        public InvOrdReceiverBuilder taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller(String taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller) {
            this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller = taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller;
            return this;
        }

        public InvOrdReceiverBuilder totalAmountExcludingTax(String totalAmountExcludingTax) {
            this.totalAmountExcludingTax = totalAmountExcludingTax;
            return this;
        }

        public InvOrdReceiverBuilder totalTaxAmount(String totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
            return this;
        }

        public InvOrdReceiverBuilder taxIncludedAmountInFigures(String taxIncludedAmountInFigures) {
            this.taxIncludedAmountInFigures = taxIncludedAmountInFigures;
            return this;
        }

        public InvOrdReceiverBuilder dateOfIssue(String dateOfIssue) {
            this.dateOfIssue = dateOfIssue;
            return this;
        }

        public InvOrdReceiverBuilder whetherInvoiceHasBeenFactoredSoldOrSecuritized(Boolean whetherInvoiceHasBeenFactoredSoldOrSecuritized) {
            this.whetherInvoiceHasBeenFactoredSoldOrSecuritized = whetherInvoiceHasBeenFactoredSoldOrSecuritized;
            return this;
        }

        public InvOrdReceiverBuilder contractNumber(String contractNumber) {
            this.contractNumber = contractNumber;
            return this;
        }

        public InvOrdReceiverBuilder matchingStateBetweenBusinessDocumentsAndVatEInvoice(String matchingStateBetweenBusinessDocumentsAndVatEInvoice) {
            this.matchingStateBetweenBusinessDocumentsAndVatEInvoice = matchingStateBetweenBusinessDocumentsAndVatEInvoice;
            return this;
        }

        public InvOrdReceiverBuilder depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets(String depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets) {
            this.depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets = depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets;
            return this;
        }

        public InvOrdReceiverBuilder whetherInvoiceIsRedInvoice(boolean whetherInvoiceIsRedInvoice) {
            this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
            return this;
        }

        public InvOrdReceiverBuilder whetherInvoiceHasBeenChecked(@NonNull Boolean whetherInvoiceHasBeenChecked) {
            if (whetherInvoiceHasBeenChecked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
            return this;
        }

        public InvOrdReceiverBuilder whetherInvoiceHasBeenBooked(@NonNull Boolean whetherInvoiceHasBeenBooked) {
            if (whetherInvoiceHasBeenBooked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
            return this;
        }

        public InvOrdReceiverBuilder whetherInvoiceHasBeenPaid(boolean whetherInvoiceHasBeenPaid) {
            this.whetherInvoiceHasBeenPaid = whetherInvoiceHasBeenPaid;
            return this;
        }

        public InvOrdReceiverBuilder numberOfBankElectronicReceipt(String numberOfBankElectronicReceipt) {
            this.numberOfBankElectronicReceipt = numberOfBankElectronicReceipt;
            return this;
        }

        public InvOrdReceiver build() {
            return new InvOrdReceiver(this.uniqueCodeOfInvoice, this.nameOfSeller, this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller, this.totalAmountExcludingTax, this.totalTaxAmount, this.taxIncludedAmountInFigures, this.dateOfIssue, this.whetherInvoiceHasBeenFactoredSoldOrSecuritized, this.contractNumber, this.matchingStateBetweenBusinessDocumentsAndVatEInvoice, this.depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets, this.whetherInvoiceIsRedInvoice, this.whetherInvoiceHasBeenChecked, this.whetherInvoiceHasBeenBooked, this.whetherInvoiceHasBeenPaid, this.numberOfBankElectronicReceipt);
        }

        public String toString() {
            return "InvOrdReceiver.InvOrdReceiverBuilder(uniqueCodeOfInvoice=" + this.uniqueCodeOfInvoice + ", nameOfSeller=" + this.nameOfSeller + ", taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller=" + this.taxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller + ", totalAmountExcludingTax=" + this.totalAmountExcludingTax + ", totalTaxAmount=" + this.totalTaxAmount + ", taxIncludedAmountInFigures=" + this.taxIncludedAmountInFigures + ", dateOfIssue=" + this.dateOfIssue + ", whetherInvoiceHasBeenFactoredSoldOrSecuritized=" + this.whetherInvoiceHasBeenFactoredSoldOrSecuritized + ", contractNumber=" + this.contractNumber + ", matchingStateBetweenBusinessDocumentsAndVatEInvoice=" + this.matchingStateBetweenBusinessDocumentsAndVatEInvoice + ", depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets=" + this.depreciationMethodsOfFixedAssetsAndAmortizationMethodsOfIntangibleAssets + ", whetherInvoiceIsRedInvoice=" + this.whetherInvoiceIsRedInvoice + ", whetherInvoiceHasBeenChecked=" + this.whetherInvoiceHasBeenChecked + ", whetherInvoiceHasBeenBooked=" + this.whetherInvoiceHasBeenBooked + ", whetherInvoiceHasBeenPaid=" + this.whetherInvoiceHasBeenPaid + ", numberOfBankElectronicReceipt=" + this.numberOfBankElectronicReceipt + ")";
        }
    }
}

