/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.common.pojo.receiver;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.ctjsoft.voucher.common.enums.VoucherTypeEnum;
import com.ctjsoft.voucher.common.pojo.receiver.IReceiver;
import com.google.gson.annotations.SerializedName;
import lombok.NonNull;

public class AtrReceiver
implements IReceiver {
    @SerializedName(value="ElectronicInvoiceAirTransportReceiptNumber")
    @JSONField(name="ElectronicInvoiceAirTransportReceiptNumber")
    private String electronicInvoiceAirTransportReceiptNumber;
    @SerializedName(value="Fare")
    private String fare;
    @SerializedName(value="IssueParty")
    private String issueParty;
    @SerializedName(value="IssueDate")
    private String issueDate;
    @SerializedName(value="WhetherReceiptIsRedReceipt")
    @JSONField(name="WhetherReceiptIsRedReceipt")
    private boolean whetherInvoiceIsRedInvoice;
    @SerializedName(value="WhetherInvoiceHasBeenChecked")
    @JSONField(name="WhetherInvoiceHasBeenChecked")
    @NonNull
    private Boolean whetherInvoiceHasBeenChecked;
    @SerializedName(value="WhetherInvoiceHasBeenBooked")
    @JSONField(name="WhetherInvoiceHasBeenBooked")
    @NonNull
    private Boolean whetherInvoiceHasBeenBooked;
    @SerializedName(value="WhetherInvoiceHasBeenDeducted")
    @JSONField(name="WhetherInvoiceHasBeenDeducted")
    @NonNull
    private Boolean whetherInvoiceHasBeenDeducted;
    @SerializedName(value="TaxPeriodOfInvoiceDeduction")
    @JSONField(name="TaxPeriodOfInvoiceDeduction")
    @NonNull
    private String taxPeriodOfInvoiceDeduction;

    @Override
    public VoucherTypeEnum getVoucherType() {
        return VoucherTypeEnum.atr_receiver;
    }

    @Override
    public void filledRequired(JSONObject jo) {
        this.electronicInvoiceAirTransportReceiptNumber = jo.getString("ElectronicInvoiceAirTransportReceiptNumber");
        if (jo.getString("NumberOfOriginalReceipt") != null || jo.getString("OriginalElectronicInvoiceAirTransportReceiptNumber") != null || jo.getString("ReasonOfRushRed") != null) {
            this.whetherInvoiceIsRedInvoice = true;
        }
        this.fare = jo.getString("Fare");
        this.issueParty = jo.getString("IssueParty");
        this.issueDate = jo.getString("IssueDate");
    }

    AtrReceiver(String electronicInvoiceAirTransportReceiptNumber, String fare, String issueParty, String issueDate, boolean whetherInvoiceIsRedInvoice, @NonNull Boolean whetherInvoiceHasBeenChecked, @NonNull Boolean whetherInvoiceHasBeenBooked, @NonNull Boolean whetherInvoiceHasBeenDeducted, @NonNull String taxPeriodOfInvoiceDeduction) {
        if (whetherInvoiceHasBeenChecked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
        }
        if (whetherInvoiceHasBeenBooked == null) {
            throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
        }
        if (whetherInvoiceHasBeenDeducted == null) {
            throw new NullPointerException("whetherInvoiceHasBeenDeducted is marked non-null but is null");
        }
        if (taxPeriodOfInvoiceDeduction == null) {
            throw new NullPointerException("taxPeriodOfInvoiceDeduction is marked non-null but is null");
        }
        this.electronicInvoiceAirTransportReceiptNumber = electronicInvoiceAirTransportReceiptNumber;
        this.fare = fare;
        this.issueParty = issueParty;
        this.issueDate = issueDate;
        this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
        this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
        this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
        this.whetherInvoiceHasBeenDeducted = whetherInvoiceHasBeenDeducted;
        this.taxPeriodOfInvoiceDeduction = taxPeriodOfInvoiceDeduction;
    }

    public static AtrReceiverBuilder builder() {
        return new AtrReceiverBuilder();
    }

    public static class AtrReceiverBuilder {
        private String electronicInvoiceAirTransportReceiptNumber;
        private String fare;
        private String issueParty;
        private String issueDate;
        private boolean whetherInvoiceIsRedInvoice;
        private Boolean whetherInvoiceHasBeenChecked;
        private Boolean whetherInvoiceHasBeenBooked;
        private Boolean whetherInvoiceHasBeenDeducted;
        private String taxPeriodOfInvoiceDeduction;

        AtrReceiverBuilder() {
        }

        public AtrReceiverBuilder electronicInvoiceAirTransportReceiptNumber(String electronicInvoiceAirTransportReceiptNumber) {
            this.electronicInvoiceAirTransportReceiptNumber = electronicInvoiceAirTransportReceiptNumber;
            return this;
        }

        public AtrReceiverBuilder fare(String fare) {
            this.fare = fare;
            return this;
        }

        public AtrReceiverBuilder issueParty(String issueParty) {
            this.issueParty = issueParty;
            return this;
        }

        public AtrReceiverBuilder issueDate(String issueDate) {
            this.issueDate = issueDate;
            return this;
        }

        public AtrReceiverBuilder whetherInvoiceIsRedInvoice(boolean whetherInvoiceIsRedInvoice) {
            this.whetherInvoiceIsRedInvoice = whetherInvoiceIsRedInvoice;
            return this;
        }

        public AtrReceiverBuilder whetherInvoiceHasBeenChecked(@NonNull Boolean whetherInvoiceHasBeenChecked) {
            if (whetherInvoiceHasBeenChecked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenChecked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenChecked = whetherInvoiceHasBeenChecked;
            return this;
        }

        public AtrReceiverBuilder whetherInvoiceHasBeenBooked(@NonNull Boolean whetherInvoiceHasBeenBooked) {
            if (whetherInvoiceHasBeenBooked == null) {
                throw new NullPointerException("whetherInvoiceHasBeenBooked is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenBooked = whetherInvoiceHasBeenBooked;
            return this;
        }

        public AtrReceiverBuilder whetherInvoiceHasBeenDeducted(@NonNull Boolean whetherInvoiceHasBeenDeducted) {
            if (whetherInvoiceHasBeenDeducted == null) {
                throw new NullPointerException("whetherInvoiceHasBeenDeducted is marked non-null but is null");
            }
            this.whetherInvoiceHasBeenDeducted = whetherInvoiceHasBeenDeducted;
            return this;
        }

        public AtrReceiverBuilder taxPeriodOfInvoiceDeduction(@NonNull String taxPeriodOfInvoiceDeduction) {
            if (taxPeriodOfInvoiceDeduction == null) {
                throw new NullPointerException("taxPeriodOfInvoiceDeduction is marked non-null but is null");
            }
            this.taxPeriodOfInvoiceDeduction = taxPeriodOfInvoiceDeduction;
            return this;
        }

        public AtrReceiver build() {
            return new AtrReceiver(this.electronicInvoiceAirTransportReceiptNumber, this.fare, this.issueParty, this.issueDate, this.whetherInvoiceIsRedInvoice, this.whetherInvoiceHasBeenChecked, this.whetherInvoiceHasBeenBooked, this.whetherInvoiceHasBeenDeducted, this.taxPeriodOfInvoiceDeduction);
        }

        public String toString() {
            return "AtrReceiver.AtrReceiverBuilder(electronicInvoiceAirTransportReceiptNumber=" + this.electronicInvoiceAirTransportReceiptNumber + ", fare=" + this.fare + ", issueParty=" + this.issueParty + ", issueDate=" + this.issueDate + ", whetherInvoiceIsRedInvoice=" + this.whetherInvoiceIsRedInvoice + ", whetherInvoiceHasBeenChecked=" + this.whetherInvoiceHasBeenChecked + ", whetherInvoiceHasBeenBooked=" + this.whetherInvoiceHasBeenBooked + ", whetherInvoiceHasBeenDeducted=" + this.whetherInvoiceHasBeenDeducted + ", taxPeriodOfInvoiceDeduction=" + this.taxPeriodOfInvoiceDeduction + ")";
        }
    }
}

