/*
 * Decompiled with CFR 0.152.
 */
package com.ctjsoft.voucher.api.impl;

import api.VoucherFileInfo;
import api.VoucherFileUtil;
import api.tools.PdfVoucherType;
import api.tools.PdfXbrlUtil;
import com.alibaba.fastjson.JSONObject;
import com.bosssoft.tool.util.PdfExtractor;
import com.ctjsoft.voucher.api.ElectronicVoucherService;
import com.ctjsoft.voucher.common.enums.VoucherTypeEnum;
import com.ctjsoft.voucher.common.pojo.accounting.AccountingEntityInformation;
import com.ctjsoft.voucher.common.pojo.einvoice.EInvoice;
import com.ctjsoft.voucher.common.pojo.receiver.IReceiver;
import com.ctjsoft.voucher.common.utils.EinvoiceUtil;
import com.ctjsoft.voucher.common.utils.FileUtil;
import com.ctjsoft.voucher.ofd.OfdParser;
import com.ctjsoft.voucher.ofd.pojo.OFD;
import com.ctjsoft.voucher.verification.VoucherVerifier;
import com.ctjsoft.voucher.verification.VoucherVerifierFactory;
import com.ctjsoft.voucher.xbrl.factory.ReceiverUtil;
import com.pansoft.xbrl.xbrljson.convert.JsonToXbrl;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElectronicVoucherServiceImpl
implements ElectronicVoucherService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicVoucherServiceImpl.class);

    @Override
    public void verify(String filePath) {
        VoucherVerifier vv = VoucherVerifierFactory.getVerifierByFile(filePath);
        boolean checkResult = vv.verify(filePath);
        log.info("verify:checkResult={}", (Object)checkResult);
        if (!checkResult) {
            throw new RuntimeException("verify \u9a8c\u7b7e\u5931\u8d25 checkResult= " + checkResult);
        }
    }

    @Override
    public VoucherFileInfo extractXBRL(String filePath) {
        FileUtil.checkFileType(filePath);
        try {
            if (FileUtil.isXml(filePath)) {
                FileInputStream fis = new FileInputStream(filePath);
                EInvoice ei = EinvoiceUtil.xmlToObject(fis, EInvoice.class);
                if (ei == null) {
                    throw new RuntimeException("\u4e0d\u662f\u6709\u6548\u7684\u6570\u7535\u7968xml\u6587\u4ef6");
                }
                VoucherFileInfo vi = new VoucherFileInfo();
                vi.setVoucherType("inv_ord_issuer");
                vi.setXbrlFilePath(filePath);
                return vi;
            }
            if (FileUtil.isOfd(filePath)) {
                boolean isAei = false;
                OFD ofd = OfdParser.parseOfdFromFile(filePath);
                if (ofd.getDocBody().getDocInfo().getCustomDatas() != null && (isAei = ofd.getDocBody().getDocInfo().getCustomDatas().getCustomData().stream().filter(x -> "\u53d1\u7968\u53f7\u7801".equals(x.getName())).anyMatch(x -> x.getValue().length() == 20))) {
                    Map<String, String> ofdXmlMap = ofd.getDocBody().getDocInfo().getCustomDatas().getCustomData().stream().collect(Collectors.toMap(OFD.CustomData::getName, OFD.CustomData::getValue));
                    log.info("extractXBRLFromOFD:\u5168\u7535\u53d1\u7968 ofdXmlMap={}", (Object)ofdXmlMap);
                    JSONObject jo = this.createAeiJson(ofdXmlMap);
                    JsonToXbrl jx = new JsonToXbrl();
                    String fileName = "inv_ord_issuer_" + filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf(".")) + ".xml";
                    String outFilePath = System.getProperty("java.io.tmpdir") + File.separator + fileName;
                    jx.createXbrlFile(jo, "inv_ord_issuer", System.getProperty("java.io.tmpdir"), fileName);
                    VoucherFileInfo vi = new VoucherFileInfo();
                    vi.setVoucherType("inv_ord_issuer");
                    vi.setXbrlFilePath(outFilePath);
                    return vi;
                }
                log.info("extractXBRLFromOFD:\u662f\u5426\u5168\u7535\u53d1\u7968={}", (Object)isAei);
                VoucherFileInfo vi = VoucherFileUtil.extractXBRLFromOFD(filePath);
                log.info("extractXBRLFromOFD:vi={}", (Object)vi);
                return vi;
            }
            if (FileUtil.isPdf(filePath)) {
                PdfVoucherType pdfVoucherType = PdfXbrlUtil.extractVoucherTypeFromPDF(filePath);
                log.info("pdf\u7684\u7968\u636e\u7c7b\u578b pdfVoucherType:vi={}", (Object)pdfVoucherType);
                if (PdfVoucherType.NO_TAX_INCOME == pdfVoucherType) {
                    log.info("1.\u5148\u6309\u975e\u7a0e\u6765\u89e3\u6790 ");
                    VoucherFileInfo vi = VoucherFileUtil.extractXBRLFromPDF(filePath);
                    log.info("\u6309\u975e\u7a0e\u6765\u89e3\u6790 extractXBRLFromPDF:vi={}", (Object)vi);
                    return vi;
                }
                if (PdfVoucherType.DIGITAL_INVOICE == pdfVoucherType) {
                    log.info("2.\u6570\u7535\u7968pdf\u89e3\u6790....");
                    throw new RuntimeException("\u6570\u7535\u7968pdf\u89e3\u6790\u5b8c\u5584\u4e2d....");
                }
                if (PdfVoucherType.CZ_EI == pdfVoucherType) {
                    log.info("3.\u6309\u8d22\u653f\u7535\u5b50\u7968\u636e\u6765\u89e3\u6790... ");
                    File file = new File(filePath);
                    byte[] xmlBytes = PdfExtractor.mainXml(Files.readAllBytes(file.toPath()));
                    if (xmlBytes.length <= 0) {
                        throw new RuntimeException("\u6309\u8d22\u653f\u7535\u5b50\u7968\u636e\u6765\u89e3\u6790\u5931\u8d25....");
                    }
                    log.info("\u8d22\u653f\u7535\u5b50\u7968\u636e\u6765\u89e3\u6790\u6210\u529f");
                    String tmpXbrlFile = PdfXbrlUtil.writeToTempFile(xmlBytes);
                    VoucherFileInfo vi = new VoucherFileInfo();
                    vi.setVoucherType(VoucherTypeEnum.czei.name());
                    vi.setXbrlFilePath(tmpXbrlFile);
                    return vi;
                }
                throw new RuntimeException("pdf\u89e3\u6790\u5931\u8d25,\u4e0d\u652f\u6301\u7684pdf\u6587\u4ef6\u7c7b\u578b");
            }
            VoucherFileInfo vi = VoucherFileUtil.extractXBRLFromZIP(filePath);
            log.info("extractXBRLFromZIP:vi={}", (Object)vi);
            return vi;
        }
        catch (Exception e) {
            log.error("extractXBRL err={}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("extractXBRL err:" + e.getMessage());
        }
    }

    private JSONObject createAeiJson(Map<String, String> ofdXmlMap) {
        JSONObject jo = new JSONObject();
        jo.put("UniqueCodeOfInvoice", (Object)ofdXmlMap.getOrDefault("\u53d1\u7968\u53f7\u7801", "-"));
        jo.put("NumberOfInvoice", (Object)ofdXmlMap.getOrDefault("\u53d1\u7968\u53f7\u7801", "-"));
        jo.put("DateOfIssue", (Object)ofdXmlMap.getOrDefault("\u5f00\u7968\u65e5\u671f", "-"));
        JSONObject j1 = new JSONObject();
        j1.put("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfPurchaser", (Object)ofdXmlMap.getOrDefault("\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", "-"));
        JSONObject j2 = new JSONObject();
        j2.put("TaxpayerIdentificationNumberUnifiedSocialCreditCodeOfSeller", (Object)ofdXmlMap.getOrDefault("\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", "-"));
        JSONObject j3 = new JSONObject();
        j3.put("TotalTaxAmount", (Object)ofdXmlMap.getOrDefault("\u5408\u8ba1\u7a0e\u989d", "0.00"));
        j3.put("TaxIncludedAmountInFigures", (Object)ofdXmlMap.getOrDefault("\u5408\u8ba1\u91d1\u989d", "0.00"));
        jo.put("BasicInformationOfPurchaserAbstract", (Object)j1);
        jo.put("BasicInformationOfSellerAbstract", (Object)j2);
        jo.put("InformationOfTaxableGoodsOrServicesAbstract", (Object)j3);
        return jo;
    }

    @Override
    public VoucherFileInfo generateXBRL(VoucherFileInfo issuerVoucherFileInfo, IReceiver receiver, AccountingEntityInformation accountingEntityInformation) {
        try {
            if (receiver.getVoucherType() == VoucherTypeEnum.bkrs) {
                log.info("\u7535\u5b50\u5bf9\u8d26\u5355\u4e0d\u5206\u5f00\u5177\u7aef\u4e0e\u63a5\u6536\u7aef");
                return issuerVoucherFileInfo;
            }
            if (receiver.getVoucherType() == VoucherTypeEnum.czei) {
                log.info("\u8d22\u653f\u7535\u5b50\u7968\u636e\u5206\u7c7b\u6807\u51c6\u4fee\u8ba2\u4e2d....");
                return issuerVoucherFileInfo;
            }
            if (!ReceiverUtil.voucherTypeMatch(issuerVoucherFileInfo.getVoucherType(), receiver.getVoucherType())) {
                throw new RuntimeException("\u7c7b\u578b\u4e0d\u5339\u914d.\u5f00\u5177\u7aef\u89e3\u6790\u7684xbrl\u7c7b\u578b:" + issuerVoucherFileInfo.getVoucherType() + "\u3000\u63a5\u6536\u7aef\u751f\u6210\u7684xbrl\u7c7b\u578b:" + (Object)((Object)receiver.getVoucherType()));
            }
            String xmlContent = com.pansoft.xbrl.xbrljson.util.FileUtil.readFile(issuerVoucherFileInfo.getXbrlFilePath());
            String receiverXmlFileName = ReceiverUtil.generateReceiverFileName(issuerVoucherFileInfo.getXbrlFilePath());
            log.info("receiverXmlFileName={}", (Object)receiverXmlFileName);
            JSONObject jo = VoucherFileUtil.xml2Json(xmlContent);
            IReceiver filledRequiredReceiver = ReceiverUtil.filledRequired(receiver, jo);
            VoucherFileInfo vi = ReceiverUtil.generateXbrlFile(filledRequiredReceiver, accountingEntityInformation, receiverXmlFileName);
            log.info("generateXBRL vi:{}", (Object)vi);
            return vi;
        }
        catch (Exception e) {
            log.error("generateXBRL err={}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("generateXBRL err:" + e.getMessage());
        }
    }

    @Override
    public VoucherFileInfo generateXBRL(String filePath, IReceiver receiver, AccountingEntityInformation accountingEntityInformation) {
        VoucherFileInfo issuerVoucherFileInfo = this.extractXBRL(filePath);
        return this.generateXBRL(issuerVoucherFileInfo, receiver, accountingEntityInformation);
    }

    @Override
    public boolean isAei(String filePath) {
        boolean isAei = false;
        try {
            OFD ofd;
            if (FileUtil.isOfd(filePath) && (ofd = OfdParser.parseOfdFromFile(filePath)).getDocBody().getDocInfo().getCustomDatas() != null) {
                isAei = ofd.getDocBody().getDocInfo().getCustomDatas().getCustomData().stream().filter(x -> "\u53d1\u7968\u53f7\u7801".equals(x.getName())).anyMatch(x -> x.getValue().length() == 20);
            }
            if (FileUtil.isXml(filePath)) {
                log.info("isAei xml\u683c\u5f0f\u6d4b\u8bd5");
                FileInputStream fis = new FileInputStream(filePath);
                EInvoice ei = EinvoiceUtil.xmlToObject(fis, EInvoice.class);
                if (ei != null) {
                    log.info("isAei xml\u683c\u5f0f\u6d4b\u8bd5:true");
                    return true;
                }
            }
        }
        catch (Exception e) {
            log.error("isAei err={}", (Object)e.getMessage(), (Object)e);
        }
        return isAei;
    }
}

