/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.tsp.cms;

import cn.org.bjca.gaia.asn1.ASN1String;
import cn.org.bjca.gaia.asn1.cms.Attributes;
import cn.org.bjca.gaia.asn1.cms.MetaData;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.operator.DigestCalculator;
import java.io.IOException;

class MetaDataUtil {
    private final MetaData metaData;

    MetaDataUtil(MetaData metaData) {
        this.metaData = metaData;
    }

    void initialiseMessageImprintDigestCalculator(DigestCalculator calculator) throws CMSException {
        if (this.metaData != null && this.metaData.isHashProtected()) {
            try {
                calculator.getOutputStream().write(this.metaData.getEncoded("DER"));
            }
            catch (IOException e) {
                throw new CMSException("unable to initialise calculator from metaData: " + e.getMessage(), e);
            }
        }
    }

    String getFileName() {
        if (this.metaData != null) {
            return this.convertString(this.metaData.getFileName());
        }
        return null;
    }

    String getMediaType() {
        if (this.metaData != null) {
            return this.convertString(this.metaData.getMediaType());
        }
        return null;
    }

    Attributes getOtherMetaData() {
        if (this.metaData != null) {
            return this.metaData.getOtherMetaData();
        }
        return null;
    }

    private String convertString(ASN1String s2) {
        if (s2 != null) {
            return s2.toString();
        }
        return null;
    }
}

