/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.math.linearalgebra;

import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2Matrix;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2Vector;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2mField;
import cn.org.bjca.gaia.pqc.math.linearalgebra.Permutation;
import cn.org.bjca.gaia.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.security.SecureRandom;

public final class GoppaCode {
    private GoppaCode() {
    }

    public static GF2Matrix createCanonicalCheckMatrix(GF2mField field, PolynomialGF2mSmallM gp) {
        int j;
        int i;
        int m3 = field.getDegree();
        int n = 1 << m3;
        int t = gp.getDegree();
        int[][] hArray = new int[t][n];
        int[][] yz = new int[t][n];
        for (int j2 = 0; j2 < n; ++j2) {
            yz[0][j2] = field.inverse(gp.evaluateAt(j2));
        }
        for (i = 1; i < t; ++i) {
            for (j = 0; j < n; ++j) {
                yz[i][j] = field.mult(yz[i - 1][j], j);
            }
        }
        for (i = 0; i < t; ++i) {
            for (j = 0; j < n; ++j) {
                for (int k = 0; k <= i; ++k) {
                    hArray[i][j] = field.add(hArray[i][j], field.mult(yz[k][j], gp.getCoefficient(t + k - i)));
                }
            }
        }
        int[][] result = new int[t * m3][n + 31 >>> 5];
        for (j = 0; j < n; ++j) {
            int q = j >>> 5;
            int r = 1 << (j & 0x1F);
            for (int i2 = 0; i2 < t; ++i2) {
                int e = hArray[i2][j];
                for (int u = 0; u < m3; ++u) {
                    int b = e >>> u & 1;
                    if (b == 0) continue;
                    int ind = (i2 + 1) * m3 - u - 1;
                    int[] nArray = result[ind];
                    int n2 = q;
                    nArray[n2] = nArray[n2] ^ r;
                }
            }
        }
        return new GF2Matrix(n, result);
    }

    public static MaMaPe computeSystematicForm(GF2Matrix h2, SecureRandom sr) {
        GF2Matrix sInv;
        GF2Matrix hp;
        Permutation p;
        int n = h2.getNumColumns();
        GF2Matrix s2 = null;
        boolean found = false;
        do {
            p = new Permutation(n, sr);
            hp = (GF2Matrix)h2.rightMultiply(p);
            sInv = hp.getLeftSubMatrix();
            try {
                found = true;
                s2 = (GF2Matrix)sInv.computeInverse();
            }
            catch (ArithmeticException ae) {
                found = false;
            }
        } while (!found);
        GF2Matrix shp = (GF2Matrix)s2.rightMultiply(hp);
        GF2Matrix m3 = shp.getRightSubMatrix();
        return new MaMaPe(sInv, m3, p);
    }

    public static GF2Vector syndromeDecode(GF2Vector syndVec, GF2mField field, PolynomialGF2mSmallM gp, PolynomialGF2mSmallM[] sqRootMatrix) {
        int n = 1 << field.getDegree();
        GF2Vector errors = new GF2Vector(n);
        if (!syndVec.isZero()) {
            PolynomialGF2mSmallM syndrome = new PolynomialGF2mSmallM(syndVec.toExtensionFieldVector(field));
            PolynomialGF2mSmallM t = syndrome.modInverse(gp);
            PolynomialGF2mSmallM tau = t.addMonomial(1);
            tau = tau.modSquareRootMatrix(sqRootMatrix);
            PolynomialGF2mSmallM[] ab = tau.modPolynomialToFracton(gp);
            PolynomialGF2mSmallM a2 = ab[0].multiply(ab[0]);
            PolynomialGF2mSmallM b2 = ab[1].multiply(ab[1]);
            PolynomialGF2mSmallM xb2 = b2.multWithMonomial(1);
            PolynomialGF2mSmallM a2plusXb2 = a2.add(xb2);
            int headCoeff = a2plusXb2.getHeadCoefficient();
            int invHeadCoeff = field.inverse(headCoeff);
            PolynomialGF2mSmallM elp = a2plusXb2.multWithElement(invHeadCoeff);
            for (int i = 0; i < n; ++i) {
                int z = elp.evaluateAt(i);
                if (z != 0) continue;
                errors.setBit(i);
            }
        }
        return errors;
    }

    public static class MatrixSet {
        private GF2Matrix g;
        private int[] setJ;

        public MatrixSet(GF2Matrix g2, int[] setJ) {
            this.g = g2;
            this.setJ = setJ;
        }

        public GF2Matrix getG() {
            return this.g;
        }

        public int[] getSetJ() {
            return this.setJ;
        }
    }

    public static class MaMaPe {
        private GF2Matrix s;
        private GF2Matrix h;
        private Permutation p;

        public MaMaPe(GF2Matrix s2, GF2Matrix h2, Permutation p) {
            this.s = s2;
            this.h = h2;
            this.p = p;
        }

        public GF2Matrix getFirstMatrix() {
            return this.s;
        }

        public GF2Matrix getSecondMatrix() {
            return this.h;
        }

        public Permutation getPermutation() {
            return this.p;
        }
    }
}

