/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pqc.crypto.mceliece;

import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPairGenerator;
import cn.org.bjca.gaia.crypto.CryptoServicesRegistrar;
import cn.org.bjca.gaia.crypto.KeyGenerationParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceKeyGenerationParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McElieceParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McEliecePrivateKeyParameters;
import cn.org.bjca.gaia.pqc.crypto.mceliece.McEliecePublicKeyParameters;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2Matrix;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GF2mField;
import cn.org.bjca.gaia.pqc.math.linearalgebra.GoppaCode;
import cn.org.bjca.gaia.pqc.math.linearalgebra.Permutation;
import cn.org.bjca.gaia.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import cn.org.bjca.gaia.pqc.math.linearalgebra.PolynomialRingGF2m;
import java.security.SecureRandom;

public class McElieceKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.1";
    private McElieceKeyGenerationParameters mcElieceParams;
    private int m;
    private int n;
    private int t;
    private int fieldPoly;
    private SecureRandom random;
    private boolean initialized = false;

    private void initializeDefault() {
        McElieceKeyGenerationParameters mcParams = new McElieceKeyGenerationParameters(CryptoServicesRegistrar.getSecureRandom(), new McElieceParameters());
        this.initialize(mcParams);
    }

    private void initialize(KeyGenerationParameters param) {
        this.mcElieceParams = (McElieceKeyGenerationParameters)param;
        this.random = param.getRandom();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
        this.m = this.mcElieceParams.getParameters().getM();
        this.n = this.mcElieceParams.getParameters().getN();
        this.t = this.mcElieceParams.getParameters().getT();
        this.fieldPoly = this.mcElieceParams.getParameters().getFieldPoly();
        this.initialized = true;
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        if (!this.initialized) {
            this.initializeDefault();
        }
        GF2mField field = new GF2mField(this.m, this.fieldPoly);
        PolynomialGF2mSmallM gp = new PolynomialGF2mSmallM(field, this.t, 'I', this.random);
        PolynomialRingGF2m ring = new PolynomialRingGF2m(field, gp);
        PolynomialGF2mSmallM[] sqRootMatrix = ring.getSquareRootMatrix();
        GF2Matrix h2 = GoppaCode.createCanonicalCheckMatrix(field, gp);
        GoppaCode.MaMaPe mmp = GoppaCode.computeSystematicForm(h2, this.random);
        GF2Matrix shortH = mmp.getSecondMatrix();
        Permutation p1 = mmp.getPermutation();
        GF2Matrix shortG = (GF2Matrix)shortH.computeTranspose();
        GF2Matrix gPrime = shortG.extendLeftCompactForm();
        int k = shortG.getNumRows();
        GF2Matrix[] matrixSandInverse = GF2Matrix.createRandomRegularMatrixAndItsInverse(k, this.random);
        Permutation p2 = new Permutation(this.n, this.random);
        GF2Matrix g2 = (GF2Matrix)matrixSandInverse[0].rightMultiply(gPrime);
        g2 = (GF2Matrix)g2.rightMultiply(p2);
        McEliecePublicKeyParameters pubKey = new McEliecePublicKeyParameters(this.n, this.t, g2);
        McEliecePrivateKeyParameters privKey = new McEliecePrivateKeyParameters(this.n, k, field, gp, p1, p2, matrixSandInverse[1]);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

